;
; iface.asm
;
; The Firmware PC Extended (TFPCX)
;
; Copyright (C) 1997  Rene Stange, DG0FT, <stange@berlin.snafu.de>
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; 09111998 PE1DNN
;          Modified to make it compilable for MSVC++ 1.5
; 01061998 PE1DNN
;          Added BPQ Receive Callback function

; ***************************************************************************

;       .model  small,c
        .model  small

; *** Equates ***************************************************************

VERSION    = 273h
HOSTBUF    = 512
BUFTNCBUSY = 88

; *** Externals *************************************************************

        extrn   _reset_intr     : proc
        extrn   _level_x        : proc
        extrn   _bpq_rx         : proc

        extrn   _hibuf          : byte
        extrn   _hobuf          : byte
        extrn   _hihead         : word
        extrn   _hohead         : word
        extrn   _hotail         : word

	extrn   _defInt         : byte
        extrn   _l1ports        : byte
        extrn   _rxinfo         : byte
        extrn   _txinfo         : byte
        extrn   _linknmbr       : word
        extrn   _nmbfre         : word
        extrn   __psp           : word

; *** Data ******************************************************************

        .data

rand_num dw     0               ; current value

; *** Code ******************************************************************

        .code

; *** TFPC Interface ********************************************************

        public  _iface_tfpc
_iface_tfpc label far

        jmp     short L1

        db      'XN5NX'

L1:     sti
        push    bx
        push    ds
        push    cx
        push    dx
        push    es
        mov     bx,DGROUP
        mov     ds,bx
        cld

        cmp     ah,1
        je      state
        cmp     ah,2
        je      input
        cmp     ah,3
        je      output

extend: cmp     ah,0fbh
        je      getpar
        cmp     ah,0fch
        je      trxinf
        cmp     ah,0fdh
        je      bufchk
        cmp     ah,0feh
        je      getver
        cmp     ah,0ffh
        je      unload

        mov     ax,0ffffh       ; invalid
        jmp     short exit

state:  mov     ax,_hotail
        cmp     ax,_hohead       ; prevent buffer overrun
        jne     L2
        call    _level_x
        mov     ax,_hotail
        sub     ax,_hohead
        je      exit
L2:     mov     ax,1
        jmp     short exit

input:  mov     bx,_hotail
        and     bx,HOSTBUF-1
        mov     al,_hobuf[bx]
        mov     ah,0
        inc     _hotail
        jmp     short exit

output: mov     bx,_hihead
        and     bx,HOSTBUF-1
        mov     _hibuf[bx],al
        inc     _hihead
        call    _level_x         ; process character
        mov     ah,0            ; DRSI: no input character
        jmp     short exit

getpar: mov     al,_l1ports
        mov     ah,byte ptr _linknmbr
        jmp     short exit

trxinf: mov     al,_rxinfo
        mov     ah,_txinfo
        jmp     short exit

bufchk: cmp     _nmbfre,BUFTNCBUSY
        mov     ax,0
        jb      exit
        inc     al
        jmp     short exit

getver: mov     ax,VERSION
        jmp     short exit

unload: call    _reset_intr
        mov     ax,__psp

exit:   pop     es
        pop     dx
        pop     cx
        pop     ds
        pop     bx
        iret

; *** DRSI Interface ********************************************************

        public  _iface_drsi
_iface_drsi label far

        push    bx              ; DRSI specific header
        push    ds
        mov     bx,DGROUP
        mov     ds,bx
        test    ah,ah
        jz      drsiin          ; offset must be 20h

L3:     sti
        push    cx
        push    dx
        push    es
        cld

        cmp     ah,1
        je      output          ; see TFPC interface
        jmp     extend

        org     L3+20h          ; see above

drsiin: sti
        push    cx
        push    dx
        push    es
        cld

        mov     ax,_hotail
        cmp     ax,_hohead       ; prevent buffer overrun
        jne     L4
        call    _level_x
        mov     ax,_hotail
        sub     ax,_hohead
        je      exit

L4:     mov     bx,_hotail
        and     bx,HOSTBUF-1
        mov     al,_hobuf[bx]
        mov     ah,1
        inc     _hotail
        jmp     short exit

; *** Call TFPCX ************************************************************

        public  @call_tfpcx
@call_tfpcx proc near         ; _fastcall

        mov     bl,_defInt
        mov     byte ptr cs:intr,bl
        jmp     short L5        ; clear prefetch queue
L5:     int     0
intr    equ     $-1
        ret

@call_tfpcx endp

; *** Chain *****************************************************************

        public  _chain
_chain proc

        sti
        add     sp,2            ; discard return address
        pop     cx              ; get offset to jump to
        pop     ax              ; get segment
        mov     sp,bp           ; restore SP to point on entry in handler
        xchg    cx,[bp+16]      ; put offset to jump to on stack, get CX
        xchg    ax,[bp+18]      ; put segment, get AX
        pop     es              ; restore saved registers
        pop     ds
        pop     di
        pop     si
        pop     bp
        add     sp,2            ; SP need not to be restored
        pop     bx
        pop     dx
        retf                    ; jump to old handler

_chain endp

; *** Set Stack *************************************************************

        public  _set_stk
_set_stk proc

        pop     bx              ; return address
        pop     ax              ; new stack offset
        pop     cx              ; new stack segment
        mov     dx,ss           ; get old stack segment
        cli
        mov     ss,cx           ; set new stack segment
        xchg    ax,sp           ; set new stack offset and get old one
        sti
        sub     sp,4            ; caller discards arguments from stack
        jmp     bx

_set_stk endp

; *** Random ****************************************************************

	public  _random
_random proc

        mov     ax,rand_num
        test    ah,48h
        jpo     L6
        stc
L6:     rcl     ah,1
        mov     dl,al
        rcr     al,1
        and     ah,7fh
        test    dl,11h
        jpo     L7
	or      ah,80h
L7:     mov     rand_num,ax
        xor     al,ah           ; return value in al
        ret

_random endp

; *** Multi Tasker **********************************************************

	public  _mtasker
_mtasker proc

	mov     ah,30h          ; get DOS version
        int     21h
        cmp     al,20           ; version 20 = OS/2 2.0
        je      L8

        mov     ax,1600h        ; check Windows 3.x Enhanced Mode
        int     2fh
        and     ax,7fh          ; 00h/80h -> no Windows
L8:     ret

_mtasker endp

; *** BPQ RX Callback *******************************************************

	public  _bpq_rx_callback
_bpq_rx_callback proc far
        pushf                   ; push flags so we can use an
                                ; 'interrupt' function in 'C'
        push  cs
        call  _bpq_rx           ; 'far' call to the recieve function
        ret
_bpq_rx_callback endp

; ***************************************************************************

        end
