/******************************************************************/
/****************************** INFO ******************************/
/******************************************************************/
/* Example program [C++] for New Packet Generation v1.03          */
/*                                                                */
/* Author : Robin van Nooy (NL1CGS)                               */
/* Date   : Friday, 6 March 1998                                  */
/* E-mail : cygnes@cygnes.demon.nl                                */
/*                                                                */
/* I guess it should also work with any other C-compiler, but     */
/* I haven't had any time. I tested this one with Borland C++ 3.1 */
/* My C skills aren't great, so this program could use some       */
/* optimization.                                                  */
/******************************************************************/

/******************************************************************/
/***************************** Includes ***************************/
/******************************************************************/
#include <mem.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <sys\stat.h>
#include <dos.h>
#include <alloc.h>

/******************************************************************/
/************************** Structures ****************************/
/******************************************************************/
     /* All these structures are all pascal-records, that's */
     /* why there aren't any null-terminated strings        */


 /************************** FrameBlock **************************/
 /* Parameter 7 is the address of this structure. You can check  */
 /* out what the user submitted as parameters to the program     */
 /****************************************************************/
struct FrameBlock { unsigned      framelength;
		    unsigned char Buffer[257];
		  } fb;

 /***************************** TncRec ***************************/
 /* Structure that is used to give commands to NPG               */
 /****************************************************************/
struct TncRec  { unsigned char channel;
		 unsigned char tnccommand_length;
		 char          tnccommand[80];
	       };

 /**************************** UserRec ***************************/
 /* Structure that is used to send feedback to the user          */
 /****************************************************************/
struct UserRec { unsigned char channel;
		 unsigned char mode; /*  0 = Do Nothing with File    */
				     /*  1 = Kill File after execute */
				     /*  2 = Send 'FileName' as text */
				     /*  3 = Send Frame block        */
				     /*  4 = Show Frame block        */
		 unsigned char filename_length;
		 char          filename[80];
	       };


/******************************************************************/
/************************** Functions *****************************/
/******************************************************************/

 /********************* Convert array to frame *******************/
 /* Converts memory found at a pointer to the FrameBlock         */
 /****************************************************************/
void convert_array_to_frame(char *p)
{
  fb.framelength = p[0]+(p[1]*256);
  strncpy(fb.Buffer,p+2,256);
  fb.Buffer[fb.framelength] = '\0';
}

/******************************************************************/
/************************ Main Program ****************************/
/******************************************************************/
int main(int argc,  char *argv[])
{ /* reserve some variables */
   int     i = 0;     /* counter                              */
   int     f_handle;  /* file handle, for output to USERS.NPU */
   FILE    *f_text;   /* file handle, for output to user      */

   UserRec users;     /* structure with data for user         */

   char    segmnt[7], /* temporary segment                    */
	   ofst  [7]; /* temporary offset                     */
  char     p[260];    /* temporary frameblock                 */
  char    *p2;        /* pointer for conversion address       */
  unsigned long s=0,  /* segment                              */
		o=0;  /* offset                               */

		      /* parameter descriptions               */
  char    *description[8]={"Exe-file","Mycall","Usercall",
			   "Level","Executed","Channel",
			   "Info","Parameters"};


  _fmode = O_BINARY;  /* set file-mode to binary */
  /* open/create a file (permission to read and write) */
  /* File will be used to store UserRec                */
  if ((f_handle = creat("users.npu", S_IREAD|S_IWRITE))==-1)
  {
    perror("Error:"); /* couldn't create file */
    return 0;
  }

  /* open/create a file for writing             */
  /* File will be used to store output for user */
  if ((f_text = fopen("temp.txt", "w+"))==NULL)
  {
    perror("Error:");
    return 0;
  }

  /* Show program info */
  fprintf(f_text,"C++ example program for NPG v1.03\r\n\r\n");

  /* Make a bar */
  for (i=0;i<80;i++) fprintf(f_text,"-");

  /* Skip a line */
  fprintf(f_text,"\r\n");

  /* Display parameters with their descriptions */
  for (i=0;i<argc;i++)
  { if (i < 8) fprintf(f_text,"  %-11s = ",description[i]);
	  else fprintf(f_text,"  %-11s = ",description[7]);
    fprintf(f_text,"%-15s [param. %2i]\r\n",argv[i],i);
  };

  /* convert parameter 7 to a numeric address */
  strnset(segmnt,0,10);
  p2 = strchr(argv[7], ':');
  strncpy(segmnt, argv[7], p2-argv[7]);
  segmnt[p2-argv[7]]='\0';
  strcpy(ofst, p2+1);
  o = atol(ofst);
  s = atol(segmnt);

  /* Move data from the address to an array */
  movedata(s, o,(unsigned)FP_SEG(p),(unsigned)FP_OFF(p),sizeof(FrameBlock));

  /* Convert the array to the FrameBlock                        */
  /* Sorry, my C isn't that good, someway it should be possible */
  /* to move that data immediately to the frame block, I tried  */
  /* several ways, but neither of them did work                 */
  convert_array_to_frame(p);

  /* show frame length */
  fprintf(f_text,"  Frame len.  = %i\r\n",fb.framelength);
  /* show frame data   */
  fprintf(f_text,"  Frame Data  = '%s'\r\n",fb.Buffer);

  /* Make a bar */
  for (i=0;i<80;i++) fprintf(f_text,"-");

  /* Skip a line */
  fprintf(f_text,"\r\n");

  /* init userrec */
  users.channel  = atoi(argv[5]); /* channel to send the data to            */
  users.mode     = 1;             /* send file and erase file after sending */
  strcpy(users.filename,"temp.txt"); /* set file to send */
  users.filename_length = strlen(users.filename); /* set filename length */
  write(f_handle,&users,sizeof(users));           /* write data to file  */


  /* close both files */
  close(f_handle);
  fclose(f_text);

  /* return value 2 -> send output to user, and quit program */
  return 2;
}
/* End of program */