* PSK31.ASM
* 31.25 baud PEK modem
* With serial interface
* Written by Andrew Senior, G0TJZ.
* Release 2, 8th April 1999
*  Changes since release 1:
*   Feeds rx amplitude at bit centres to host
*   Bitsync now works off amplitude not log(amplitude)
*   Experimental new receive filter (lower ISI)
* Please report any bugs to the author first!
*

	 .mmregs

TA      .set    25              ; SCAF clock = 200 kHz
RA      .set    25
TAp     .set    31
RAp     .set    31
TB      .set    25              ; Fs = 8 KHz
RB      .set    25
AIC_CMD .set    19h
;AIC_CMD .set    1Dh             ; Use AUX in

; Data locations
	

ifil1st .set    0100h   ; 1st I-channel LPF (64 taps)
ifil1en .set    013Fh
itemp   .set    0140h

ifil2st .set    0165h   ; 2nd I-channel LPF (64 taps)
ifil2en .set    01A4h

qfil1st .set    01A6h   ; 1st Q-channel LPF (64 taps)
qfil1en .set    01E5h
qtemp   .set    01E6h

qfil2st .set    020Bh   ; 2nd Q-channel LPF (64 taps)
qfil2en .set    024Ah

	.ds     0300h
* PEK demodulator data
rxphase .word   0               ; Receive oscillator phase
rxfreq  .word   8192            ; Oscillator frequency = 1000 Hz
; MSB indicates subtract, remainder is offset to add/subtract
actab   .word   0               ;  0.0 + arctan
	.word   0A000h          ;  4000h - arctan
	.word   08000h          ;  0.0 - arctan
	.word   06000h          ;  C000h + arctan
	.word   0C000h          ;  1.0 - arctan
	.word   02000h          ;  0.5 + arctan
	.word   04000h          ; -1.0 + arctan
	.word   0E000h          ; -0.5 - arctan
inphase .word   0               ; inphase component
quadrat .word   0               ; quadrature component
octant  .word   0               ; octant for arctan
arctan  .word   0               ; partial arctan result
temp    .word   0               ; temporary storage
atcof1  .word   2B20h ; arctan linear coeff
atcof2  .word   0B20h ; arctan squarelaw coeff
saphase .word   0               ; 16x datarate clock
nowphas .word   0               ; Signal phase this bit
oldphas .word   0               ; Signal phase last bit
ampbuf  .space  256             ; Rx amplitude array
bitclok .word   07000h               ; Rx bit clock phase
power   .word   0		; Power-of-2 in square-root
srcof0  .q15    0.266666667	; Square-root coefficients
srcof2  .q15    -0.266666667
rxampl  .word   0               ; Current rx amplitude
ampcof2	.word	2048		; Constant for bitsync gain correction
bsfact  .q15    0.06            ; Bitsync feedback factor
ampsum	.word	0		; Sum-of-amplitudes in bitsync

* PEK modulator data
txphase .word   0               ; Transmit oscillator phase
txfreq  .word   8192            ; Frequency = 1000 Hz
txsig   .word   0               ; Tx output signal buffer
daphase .word   0               ; Datarate clock (31.25 Hz)
txoldi  .word   0               ; Old tx I component
txnewi  .word   0               ; New tx I component
txiscl  .word   0               ; Cosine-shape scaling factor (I)
txibias .word   0               ; Cosine-shape bias (I)
txoldq  .word   0               ; Old tx Q component
txnewq  .word   0               ; New tx Q component
txqscl  .word   0               ; Cosine-shape scaling factor (Q)
txqbias .word   0               ; Cosine-shape bias (Q)
txicomp .word   0               ; Shaped Tx I-component
txqcomp .word   0               ; Shaped Tx Q-component
txsin   .word   0               ; Tx oscillator sine
txcos   .word   0               ; Tx oscillator cosine
txphptr .word   0               ; Tx phase shift accumulator
ampmask .word   0               ; Tx amplitude mask
tnewsym .word   0               ; New symbol to send flag
txsymb  .word   0               ; Next symbol to send

* Asynchronous comms data
TXSREG  .WORD   0               ; Tx data (shift) register
ATBTPHS .WORD   0               ; Tx bit clock phase
ARSTATE .WORD   0               ; Rx routine state
ARBTPHS .WORD   0               ; Rx bit clock phase
BITCNT  .WORD   0               ; Rx bit counter
RXREG   .WORD   0               ; Rx data register
RXBUF   .WORD   0               ; Rx data buffer
RXDRDY  .WORD   0               ; Rx data ready flag
BITRATE .WORD   16384           ; Bit clock phase increment

; Serial protocol control data
rxtemp  .word   0               ; Temp storage in main prog
shift16 .word   0               ; Register for assembling 16-bit word

; Asynchronous comms routine states
SPCWT   .SET    1
SPCCK   .SET    2
RCVDAT  .SET    3

; Lookup tables, etc.
sintab  .set    1000h           ; 256-point sine lookup table
tabend  .set    10FFh           ; end of table
lpfcof1 .set    1100h           ; 64 I/Q low-pass filter coefficients (1st LPF)
lpfcof2 .set    1140h           ; 64 I/Q low-pass filter coefficients (2nd LPF)


	.ds     1000h
	.listoff
	.include "sintab.inc"
	.include "sblpf1.inc"   ; 64-tap filter
        .include "zipsk31.inc"  ; 64-tap filter
        .liston

; Coefficients for bitsync "filter"
; Don't edit the next line, or the assembler swallows it!
ampcof  .q15    -0.097545161
        .q15    -0.093796555
        .q15    -0.086443400
        .q15    -0.075768274
        .q15    -0.062181416
        .q15    -0.046204960
        .q15    -0.028452874
        .q15    -0.009607360
        .q15     0.009607360
        .q15     0.028452874
        .q15     0.046204960
        .q15     0.062181416
        .q15     0.075768274
        .q15     0.086443400
        .q15     0.093796555
        .q15     0.097545161
hbufst  .space  240             ; Buffer for serial data to host
hbufen  .word   0

* Set up the ISR vectors

	.ps     080ah
rint    B       receive       ;0A; Serial port receive interrupt RINT.
xint    B       transmit      ;0C; Serial port transmit interrupt XINT.

* TMS320C5X INITIALIZATION 

	.ps 0a00h
	.entry
START:  setc    INTM                    ; Disable interrupts
	ldp     #0                      ; Set data page pointer
	opl     #0834h,PMST
	lacc    #0                      ; Zero wait states
	samm    CWSR
	samm    IOWSR
	samm    PDWSR
	clrc    CNF                     ; Map DARAM B0 into data space

	call    SET_AIC                 ; initialize AIC and enable interrupts
	 
	clrc    OVM
	spm     1                       ; PM = 1
	setc    SXM                     ; Enable sign extension
	splk    #010h,IMR               ; Activate RINT only

        lar     AR3,#hbufst             ; AR3 is host buffer input ptr
        lar     AR4,#hbufst             ; AR4 is output ptr
        splk    #hbufst,CBSR1
        splk    #hbufst,CBSR2
        splk    #hbufen,CBER1
        splk    #hbufen,CBER2
        splk    #0CBh,CBCR              ; CB1 uses AR3, CB2 uses AR4

; Configure asynchronous comms

	SETC    XF                      ; Mark state
	LDP     #rxphase
	SPLK    #SPCWT,ARSTATE          ; Waiting for start bit
	SPLK    #0,RXDRDY               ; No data received yet

        clrc    INTM                    ; Enable interrupts (go, go, go!)
*
* Data format Host->DSP
* 00000APP: A=tx amplitude, PP=phase shift
* 0100DDDD: D=4 bits to merge into 16-bit value
* 10000000: Transfer 16-bit value to rx frequency
* 11000000: Transfer 16-bit value to tx frequency

dawait  call    getbyte         ; Get byte from PC
        sacl    rxtemp          ; Store data portion
        ldp     #0
        sach    AR2             ; Command code into AR2
        ldp     #rxphase
        mar     *,AR2           ; Switch to AR2
        banz    cmd_1,*-
        b       dodata          ; Cmd=0 => symbol to transmit
cmd_1   banz    cmd_2,*-
        b       make16          ; Cmd=1 => add 4 bits to 16-bit reg
cmd_2   banz    cmd_3,*-
        b       setrxfr         ; Cmd=2 => set rx frequency
cmd_3   banz    dawait,*-
        b       settxfr         ; Cmd=3 => set tx frequency

dodata  lacl    rxtemp          ; Get data
        sacl    txsymb,3        ; Store in tx buffer
        splk    #1,tnewsym      ; Set new symbol flag
	b       dawait

make16  lacl    rxtemp          ; Get data
        bsar    10              ; Get into 4 LSBs of accu
        sacl    rxtemp
        lacc    shift16,4       ; Get shift register and shift it
        or      rxtemp          ; Merge in new data
        sacl    shift16         ; Store updated register
        b       dawait
        
setrxfr lacl    shift16         ; Transfer shift reg...
        sacl    rxfreq          ; ...to rx frequency control
        b       dawait

settxfr lacl    shift16         ; Transfer shift reg...
        sacl    txfreq          ; ...to tx frequency control
        b       dawait

getbyte bit     RXDRDY,15       ; Wait for data ready flag
	bcnd    getbyte,NTC
        lacc    RXBUF,10        ; Load byte into high/low accu
	splk    #0,RXDRDY       ; Clear flag
	ret     
	
;------- end of main program ----------;

receive mar     *,AR0
	ldp     #rxphase
	lamm    DRR             ; Get latest sample
	samm    TREG0           ; Store in T
	lacc    rxphase         ; Get current osc phase
	add     rxfreq          ; Update it
	sacl    rxphase         ; Store updated phase
	bsar    8               ; Extract MS byte
	and     #00FFh
	sacl    temp            ; Save for later
	add     #sintab,0       ; Acc = sin lookup address
	samm    AR0             ; AR0 = sin address
	lacc    temp
	add     #64             ; Offset for cos
	and     #00FFh
	add     #sintab,0       ; Acc = cos lookup address
	samm    AR1             ; AR1 = cos address
	mpy     *,AR1           ; P = T * sin(wt)
;        ldp     #ifil1st       Assembler chews this up (V1.10)
        ldp     #2
	sph     ifil1st         ; Store in 1st I filter
	mpy     *               ; P = T * cos(wt)
;        ldp     #qfil1st       Assembler chews this up (V1.10)
        ldp     #3
	sph     qfil1st         ; Store in 1st Q filter
; Now do 1st I channel filter
	zap
	lar     AR1,#ifil1en    ; AR1 -> last tap
	rpt     #63             ; 64 taps
	macd    lpfcof1,*-      ; Do the filter
	apac
;        ldp     #ifil2st       Assembler chews this up (even V1.10)
        ldp     #2
	sach    ifil2st         ; Store I result in 2nd filter
; Now do 1st Q channel filter
	zap
	lar     AR1,#qfil1en
	rpt     #63
	macd    lpfcof1,*-
	apac
;        ldp     #qfil2st      Assembler doesn't like this (even V1.10)
        ldp     #4
	sach    qfil2st        ; Store Q result in 2nd filter

; See if it's time to run 31.25 Hz processes
	ldp     #rxphase
	lacl    daphase         ; Get data clock phase
	add     #1              ; Increment
	and     #0FFh           ; Modulo 256 (8000/256=31.25)
        sacl    daphase         ; Store new phase
        cc      datime,EQ       ; If phase=0, do processes

* Generate output waveform
; Lookup cosine value for shaping function
	ldp     #rxphase
        lacl    daphase         ; Get dataclock phase
        sfr                     ; Divide by 2 (0..127)
        add     #64             ; Offset for cosine lookup
	and     #0FFh           ; Modulo 256
        add     #sintab,0       ; Form cosine lookup address
        tblr    txicomp         ; Get cosine value
        tblr    txqcomp
; Compute tx I component
        lt      txiscl          ; T=scale factor
        mpy     txicomp         ; P=cosine*scale
        pac                     ; Acc=cosine*scale
        add     txibias,16      ; Acc=cosine*scale+bias
        sach    txicomp         ; Store tx I component
        lt      txicomp
        mpy     #7FFFh          ; scale down slightly
        sph     txicomp
; Compute tx Q component
        lt      txqscl          ; T=scale factor
        mpy     txqcomp         ; P=cosine*scale
        pac                     ; Acc=cosine*scale
        add     txqbias,16      ; Acc=cosine*scale+bias
        sach    txqcomp         ; Store tx I component
        lt      txqcomp
        mpy     #7FFFh          ; scale down slightly
        sph     txqcomp
; Now form output PEK signal
	ldp     #rxphase
	lacl    txphase         ; Get current osc phase
	add     txfreq          ; Update it
	sacl    txphase         ; Store updated phase
	bsar    8               ; Extract MS byte
	and     #00FFh
        sacl    temp            ; Store for later
	add     #sintab,0       ; Accu = sine lookup address
        tblr    txsin           ; Fetch the waveform value to txsin
        lt      txsin           ; T = tx sine wave
        mpy     txicomp         ; P = txI * tx sine wave
        sph     txsin
        lacl    temp            ; Get MS byte of phase
        add     #64             ; Offset for cosine
        and     #0FFh
        add     #sintab,0       ; Form cosine lookup address
        tblr    txcos           ; Fetch waveform to txcos
        lt      txcos           ; T = tx cosine wave
        mpy     txqcomp         ; P = txQ * tx cosine wave
        sph     txcos
        lacc    txsin           ; Accu=txsin
        add     txcos           ; Accu=txsin+txcos
        and     #0FFFCh
	sacl    txsig           ; Store for local echo
        samm    DXR             ; Output it

; See if it's time to run 500 Hz processes
	ldp     #rxphase
	lacl    saphase         ; Get counter value
	add     #1              ; Increment
	and     #0Fh            ; Modulo 16 (8000/16=500)
	sacl    saphase         ; Store new count
	cc      satime,EQ       ; If counter=0, do processes

; Run asynchronous comms routines
        call    ASYTX
	call    ASYRX
	rete

* Start of 500 Hz (16x datarate) processes

; Now do 2nd I channel filter
satime  mar     *,AR1
	zap
	lar     AR1,#ifil2en
	rpt     #63             ; 64 taps
	macd    lpfcof2,*-
	apac
	ldp     #inphase
	sach    inphase         ; Store result for arctan
; Now do 2nd Q channel filter
	zap
	lar     AR1,#qfil2en
	rpt     #63
	macd    lpfcof2,*-
	apac
	ldp     #quadrat
	sach    quadrat         ; Store result for arctan

; Compute sqr(amplitude)=sqr(I)+sqr(Q)
        zap                     ; Acc=0
        sqra    inphase         ; Acc=0, P=sqr(I)
        sqra    quadrat         ; Acc=sqr(I), P=sqr(Q)
        apac                    ; Acc=sqr(I)+sqr(Q)
; Now find amplitude by computing the square-root
; First we find the power of 2 part of the value
sqrt    bcnd    srdone,EQ       ; Skip if Acc=0
        lar     AR1,#0          ; Initialise power to 0
        rpt     #30             ; Count negative powers of 2
        norm    *+
        sacb                    ; Store residue [0.5,1[ in AccB
        lamm    AR1             ; Get power
        sfr                     ; Divide by 2, LSB into carry
        sacl    power           ; Save the divided power
        lacb                    ; Fetch back the residue
        xc      1,C             ; If the power was odd (carry set)...
         sfr                    ; Divide by two, into the range [0.25,0.5[
        sach    temp            ; Get residue into temp...
        lt      temp            ; ...and into T
; Now do quadratic approximation to square-root on residue
        lacc    srcof0,16       ; Acc = srcof0
        add     temp,16         ; Acc = residue + srcof0
        sacb                    ; AccB = residue + srcof0
        mpy     temp            ; P = residue^2
        ltp     srcof2          ; Acc = residue^2, T = srcof2
        sach    temp            ; temp = residue^2
        mpy     temp            ; P = srcof2*residue^2
        pac                     ; Acc = srcof2*residue^2
        addb                    ; Acc = srcof2*residue^2 + residue + srcof0
        sacb                    ; Transfer result to AccB
; Finally, multiply by the divided power of 2
        lacc    power           ; Get the power
        bcnd    powzero,EQ      ; Skip if power was zero
        sub     #1              ; Decrement it
        sacl    power           ; Save it
        lacb                    ; Get the result back
        rpt     power           ; Scale down according to power
        sfr
        b       srdone
powzero lacb                    ; Just fetch back the result
srdone  sach    rxampl          ; Save the amplitude

; Now do rx bit clock synchronisation
        lacl    bitclok         ; Get bit clock phase
        bsar    12              ; Extract 4 MS bits
        add     #ampbuf,0       ; Form address in amplitude array
        samm    BMAR            ; Transfer to BMAR
        nop
        bldd    rxampl,BMAR     ; Transfer latest amplitude into array
        lar     AR1,#ampbuf     ; Point to start of array
        zap
        rpt     #15
        mac     ampcof,*+       ; Do bitsync "filter"
        apac
        sfr                     ; Scale down by factor of 2
        sach    temp            ; Store result
; Find the sum of the amplitudes in order to correct the loop gain
        lar     AR1,#ampbuf     ; Point to start of array again
        zap
        lt      ampcof2         ; T = scaling constant
        rpt     #15
        mpya    *+              ; Find sum of amplitudes in array
        apac
        sach    ampsum          ; Store result
; Now divide filter output by sum-of-amplitudes to correct gain
        lacc    ampsum
        bcnd    dodiv,NEQ       ; Only divide if ampsum is non-zero
        lacc    temp,16
        b       docorr
dodiv   lacc    temp,16         ; Get output
        abs                     ; Make positive
        rpt     #14             ; Divide by sum-of-amplitudes
        subc    ampsum
        sacl    ampsum          ; Store quotient temporarily---
        bit     temp,#0         ; Test sign of filter output  | 
        lacc    ampsum,16       ;    to bring it into AccH <---
        xc      1,TC            ; If filter output was negative...
        neg                     ; ...negate the quotient
        sach    temp            ; Save result
        lt      bsfact          ; T = gain control
        mpy     temp            ; Scale the error signal
        pac                     ; Get into Acc
docorr  add     #2000h,15       ; Add bit clock increment
        clrc    C
        add     bitclok,16      ; Add current bit clock phase
        sach    bitclok         ; Store corrected bit clock phase
        bcnd    sadone,NC       ; If no carry, then not at bit centre
        
* Get here at centres of received bits
; Compute sqr(amplitude)=sqr(I)+sqr(Q)
bitctr  zap                     ; Acc=0
        sqra    inphase         ; Acc=0, P=sqr(I)
        sqra    quadrat         ; Acc=sqr(I), P=sqr(Q)
        apac                    ; Acc=sqr(I)+sqr(Q)
; Now find log(amplitude)
log     bcnd    logdone,EQ      ; Skip if Acc=0
        lar     AR1,#31         ; Load 3 dB counter
        rpt     #30             ; Count 3 dB steps
        norm    *-
        sfl                     ; Eliminate sign bit (0)
        sfl                     ; Eliminate always '1' bit
        clrc    SXM             ; Do logical shift
        bsar    6               ; Shift remainder down
        setc    SXM
        sacb                    ; Store in AccB
        sar     AR1,temp        ; Save 3 dB count...
        lacc    temp,16         ; ...and load it...
        rpt     #9              ; ...into bits 30..26 of Acc
        sfl
        addb                    ; Interpolate with remainder
logdone sach    rxampl          ; Store result

* Now do arctan routine
* This code adapted from 320C26 code written by G4BMK
* from algorithm by G3PLX.
doatan  ldp     #6
	setc    SXM
; Now compute the OCTANT in AR1 (current Aux.Reg.)
	lar     AR1,#0          ; Octant = zero
	lacc    inphase         ; test inphase
	bcnd    oct2,GEQ
	neg                     ; Negate accumulator
	sacl    inphase         ; - restore in 'inphase'
	adrk    #4              ; Add 4 to octant
oct2    lacc    quadrat
	bcnd    oct4,GEQ
	neg
	sacl    quadrat         ; negate quadrature
	adrk    #2              ; add 2 to octant
oct4    sub     inphase         ; acc = quadrature - inphase
	bcnd    oct6,LEQ        ; skip if inphase >= quadrature
	adrk    #1              ; add 1 to octant
	lacl    inphase         ; swap inphase<>quadrat
	add     quadrat,16
	sach    inphase
	sacl    quadrat
oct6    sar     AR1,octant      ; save resultant octant

; Now divide quadrature by inphase
; At this stage they are both positive values and quadrature < inphase
; Fractional division. See C2x manual, Pg 5-59
	lacc    quadrat,16      ; Get numerator into Acc-Hi
	rpt     #14             ; (15-bit shift)
	subc    inphase         ; conditional subtract of denominator
	sacl    temp            ; Acc-lo contains quotient (tangent)
	samm    TREG0           ; tangent into T as well
	lacc    #0              ; clear Acc
	mpy     temp            ; P = sqr(tan)
	mpya    atcof1          ; P = atcof1*tan, Acc = sqr(tan)
	sach    temp            ; temp = sqr(tan)
	ltp     temp            ; T = sqr(tan), Acc = atcof1*tan
	mpy     atcof2          ; P = atcof2*sqr(tan)
	spac                    ; Acc = atcof1*tan - atcof2*sqr(tan)
	sach    arctan          ; Store arctan
; Pick up an action word from table indexed by octant
	lacc    #actab          ; Form address of entry
	add     octant
	samm    BMAR
	nop                     ; Pipeline protection
	bldd    BMAR,temp       ; Read table entry into temp
	lacc    temp,16         ; load it into Acc-Hi
	sfl                     ; shift sign bit into carry
	bcnd    atan2,C         ; branch if 'twas -ve
	add     arctan,16
	b       atan4
atan2   sub     arctan,16
; 16-bit phase now in AccH
atan4   and     #0FF00h,16      ; mask to 8 bits
        sach    nowphas         ; Store current phase
        lacc    nowphas         ; Get into low accu
        sub     oldphas         ; Find phase difference
        and     #0FF00h         ; Mask to 8 bits        
        bsar    8               ; Shift down to bottom
        sacb                    ; Save a copy in AccB
        mar     *,AR3
        and     #00FCh          ; Mask off bottom two bits
        sacl    *+              ; Send first byte to host (PPPPPP00)
        lacb                    ; Bring original diff phase byte back
        and     #3h             ; Chop off top 6 bits
        sfl                     ; Shift up two bits
        sfl
        or      #1h             ; Insert sequence number (byte=0000PP01)
        sacb                    ; Put back in AccB
        lacl    rxampl          ; Get rx amplitude
        bsar    7               ; Shift out LS byte
        and     #0F0h           ; Mask off bottom 4 bits
        orb                     ; Merge with phase data
        sacl    *+              ; Send 2nd byte to host (AAAAPP01)
        lacl    rxampl          ; Get rx amplitude again
        bsar    7               ; Shift out LS byte
        and     #0Fh            ; Chop off top 4 bits
        sfl                     ; Shift up two bits
        sfl
        or      #2h             ; Insert sequence number
        sacl    *+,0,AR1        ; Send final byte to host (00AAAA10)
        lacl    nowphas         ; Update old phase
        sacl    oldphas
sadone  ret

* Datarate processes

datime  bit     tnewsym,15      ; Test if there's a new symbol to send
        bcnd    dadone,NTC      ; Continue if not
        lacc    txsymb,1        ; Get new symbol data
        sach    ampmask         ; Store on/off keying mask
        add     txphptr,8       ; Add current phase to symbol
        and     #0FF00h         ; Mask off rubbish
        bsar    8               ; Shift down to LS byte
        sacl    txphptr         ; Store new phase
        splk    #0,tnewsym      ; Clear new symbol flag
; Generate I channel parameters
dadone  lacl    txnewi          ; Copy new I to old I
	sacl    txoldi
        lacl    txphptr         ; Get sin/cos pointer
        add     #64             ; Offset for cosine
        and     #0FFh           ; Modulo 256
        add     #sintab,0       ; Form cosine lookup address
        tblr    txnewi          ; Lookup new I component
        lacc    txnewi          ; Get I component
        and     ampmask         ; Mask with amplitude mask
        sacl    txnewi
        lacc    txnewi          ; Acc=newI
        sfr                     ; Acc=0.5*newI
        sacb                    ; AccB=0.5*newI
        lacc    txoldi          ; Acc=oldI
        sfr                     ; Acc=0.5*oldI
        sbb                     ; Acc=0.5*oldI-0.5*newI
        sacl    txiscl          ; Store scale factor
        lacc    txoldi          ; Acc=oldI
        sfr                     ; Acc=0.5*oldI
        addb                    ; Acc=0.5*oldI+0.5*newI
        sacl    txibias         ; Store bias
; Generate Q channel parameters
        lacl    txnewq          ; Copy new Q to old Q
        sacl    txoldq
        lacl    txphptr         ; Get pointer from above
        add     #sintab,0       ; Form sine lookup address
        tblr    txnewq          ; Lookup new Q component
        lacc    txnewq          ; Get Q component
        and     ampmask         ; Mask with amplitude mask
        sacl    txnewq
        lacc    txnewq          ; Acc=newQ
        sfr                     ; Acc=0.5*newQ
        sacb                    ; AccB=0.5*newQ
        lacc    txoldq          ; Acc=oldQ
        sfr                     ; Acc=0.5*oldQ
        sbb                     ; Acc=0.5*oldQ-0.5*newQ
        sacl    txqscl          ; Store scale factor
        lacc    txoldq          ; Acc=oldQ
        sfr                     ; Acc=0.5*oldQ
        addb                    ; Acc=0.5*oldQ+0.5*newQ
        sacl    txqbias         ; Store bias
        mar     *,AR3
        splk    #3,*+,AR1       ; Send sync signal to host (00000011)
	ret


transmit
	rete

*** Asynchronous communications routines ***

*
* Asynchronous comms TX routine
*
ASYTX   CLRC    C
	LACC    ATBTPHS,16      ; Get bit clock phase
        ADD     BITRATE,16
	SACH    ATBTPHS         ; Save new phase
	BCND    ASYTX_1,C       ; If bit time, call routine
	RET

ASYTX_1 LACC    TXSREG          ; Get shift reg.
	BCND    ASYTX_2,NEQ     ; Branch if non-zero
ASYTX_4 LAMM    AR3             ; Get buffer input pointer
        SACB
        LAMM    AR4             ; Get buffer output pointer
        SBB                     ; Subtract pointers
        BCND    ASYTX_3,EQ      ; Branch if buffer empty
        MAR     *,AR4
        LACL    *+,AR1          ; Get word to send from buffer
ASYTX_5 OR      #100h           ; Add stop bit
	SFL                     ; Add start bit
ASYTX_2 SFR                     ; Shift out LSB into C
        SACL    TXSREG          ; Store shift reg.
	BCND    ASYTX_3,C       ; Branch if LSB was 1
	CLRC    XF              ; Send space
	RET                     ; Done
ASYTX_3 SETC    XF              ; Send mark
	RET                     ; Done


*
* Asynchronous comms rx routine
*
ASYRX   CPL     #SPCWT,ARSTATE
	BCND    SPC_WT,TC
	CLRC    C
	LACC    ARBTPHS,16      ; Get bit clock phase
        ADD     BITRATE,16
	SACH    ARBTPHS         ; Store new phase
	BCND    ARBTTIM,C       ; Branch if bit time
	RET

* Called to check for a possible start bit
SPC_WT  BCND    ASYRX_1,BIO     ; Test line state
	RET                     ; Return if mark
ASYRX_1 SPLK    #32768,ARBTPHS  ; Re-init bit clock
	SPLK    #SPCCK,ARSTATE  ; Go to space check state
	RET

* Called at bit centres
ARBTTIM CPL     #SPCCK,ARSTATE
	BCND    SPC_CK,TC
	CPL     #RCVDAT,ARSTATE
	BCND    RCV_DAT,TC
	RET

* Called to check if start-bit is real
SPC_CK  BCND    ASYRX_2,BIO     ; Test line state
	SPLK    #SPCWT,ARSTATE  ; If mark, return to waiting
	RET
ASYRX_2 SPLK    #0,ARBTPHS      ; Re-init bit clock
	SPLK    #RCVDAT,ARSTATE ; Start receiving data
	SPLK    #9,BITCNT       ; Init bit counter
	SPLK    #0,RXREG        ; Zero shift reg.
	RET

* Called to receive a byte
RCV_DAT LACL    RXREG           ; Get shift register
	CLRC    SXM             ; Don't sign extend on shift
	SFR                     ; Shift regisiter right
	SETC    SXM
	BCND    ASYRX_3,BIO     ; Test line state
	OR      #100h           ; If mark, insert a '1'
ASYRX_3 SACL    RXREG           ; Store updated reg.
	LACL    BITCNT          ; Get bit counter
	SUB     #1              ; Decrement
	SACL    BITCNT          ; Store new count
	BCND    ASYRX_4,EQ      ; Branch if zero
	RET
ASYRX_4 LACL    RXREG           ; Get shift reg.
	AND     #0FFh           ; Mask off stop bit
	SACL    RXBUF           ; Store rx'd byte
	SPLK    #1,RXDRDY       ; Set data ready flag
	SPLK    #SPCWT,ARSTATE  ; Wait for next start bit
	RET             
	
* Initialise the AIC

SET_AIC splk    #1,PRD          ; divide by 2 to give 10 MHz on TOUT
	splk    #20h,TCR        ; Reset the timer
	splk    #08h,SPC        ; Set FSM and reset serial port
	splk    #0C8h,SPC       ; Set FSM and take port out of reset
	lacc    #80h
	sacl    GREG            ; Config. 8000h-FFFFh as global mem
	mar     *,AR0
	lar     AR0,#0FFFFh
	rpt     #10000          ; Keep BR low for 0.5ms to reset AIC
	lacc    *,0,AR0
	sach    GREG            ; Cancel global memory
	splk    #20h,IMR        ; Unmask XINT only
	clrc    INTM            ; Enable interrupts
	clrc    SXM
	lacc    #0              ; Setup TA and RA registers
	add     #RA,2
	add     #TA,9
	call    aic2nd
	lacc    #1              ; Setup TA' and RA' registers
	add     #RAp,2          
	add     #TAp,9
	call    aic2nd
	lacc    #2              ; Setup TB and RB registers
	add     #RB,2
	add     #TB,9
	call    aic2nd
	lacc    #3              ; Setup control register
	add     #AIC_CMD,2
	call    aic2nd
	setc    SXM
	setc    INTM            ; Mask interrupts
	ret

aic2nd  sach    DXR
	idle
	add     #6,15           ; Dummy to get 2ndary comms cycle
	sach    DXR             ; Send dummy
	idle                    ; Wait until finished sending
	sacl    DXR             ; Send command
	idle                    ; Wait again
	lacc    #0
	sacl    DXR
	idle
	ret

	.end

