;Note: This is a modified version of Peter's original PSK31 pgm
;for the EasyDSP type of interface. You should - on your own interest -
;not start with  t h i s  source if you are going to make changes on
;your own for a interface other than EasyDSP


;31 baud PSK for 56002evm.
;by G3PLX  August 1996
;QPSK version November 1997
;if you have modification suggestions for this program,
;please pass them back to the author FIRST.
;peter.martinez@btinternet.com
;Peter Martinez
;High Blakebank Farm
;Underbarrow
;Kendal
;Cumbria LA8 8BN
;United Kingdom

        include 'Pioequ.asm'
        include 'Pcodequ.asm'


; macro for diagnose LED handling
dialed	macro	mode
	b\mode	#14,x:M_PBD
	endm

; macro for command LED handling
cmdled	macro	mode
	b\mode	#13,x:M_PBD
	endm

; macro for calculating the square of a value
; input in reg output in reg
sqr     macro  reg
        move   reg,x0
        mpy    x0,x0,reg
        endm

; macro for calculating the square root
; Input in a, Output in a
sqrt    macro
        move   a1,y1
        move   a0,y0
        clr    b                          ; init root and guess
        move   #$400000,x1                ; init bit to test
        move   #$400000,x0
        do     #23,_endrt
        mpy    -x0,x0,a                   ; square and negate the guess
        add    y,a                        ; compare to double precision input
        tge    x0,b                       ; update root if input >= guess
        tfr    x1,a                       ; get bit to test
        asr    a                          ; shift to next bit to test
        add    b,a  a,x1                  ; form new guess
        move   a,x0                       ; save new guess
_endrt  move   b,a
        endm

; macro for first order low pass IIR filter, input in acc, output in acc
lpass   macro   acc,value
        jmp     <_mstart
_store  dc      0
_mstart move    #value,x1
	move	acc,x0
	mpy	x0,x1,acc   #(1.0-value),x0
	move		    p:_store,x1
	macr	x0,x1,acc
	move		    acc,p:_store
        endm


debug           =       0   ;set to 1 to blink headphone for sync testing

ctlwd0          equ     nopreamp+highpass+samprate8+stereo+data16
;remove for more rx gain---^
ctlwd1          equ     immed3state+xtal1select+bits64+codecmaster

outputset       equ        lineouton+(leftattn*0)+(rightattn*0)
;increase this value for less transmit output--------^

inputset        equ        (15*monitorattn)+(leftgain*0)+(rightgain*0)

baud    equ     19200      ;SCI baudrate to PC
decsize equ     32         ;size of receive decimation filter
filsize equ     64         ;receive filter 128mS long at 500Hz
outsize equ     256        ;serial output buffer size
sample  equ     8000.00    ;system sample rate
sintab  equ     $100       ;address of sine table in ROM
syngain equ     0.002      ;bit sync loop gain constant
slowio  equ     $FFC0        

;data format from PC to evm
; 00000TSS       process TSS for transmission. T=txon
;                SS=phase shift 00=0 01=90, 10=180, 11=270
;                Must be in sync with 'EVM ready' signal
; 01DDDDDD       shift DDDDDD left into lsb-end of 24-bit stack
; 10XXXXXX       put 24-bit stack into rxfreq
; 11XXXXXX       put 24-bit stack into txfreq

;data format from evm to PC
;PPPPPPPP        8-bit receive channel differential phase (P<>0) (at 31.25 Hz)
;00000000        Escape code: next byte is-
; 00000000       Channel phase=$00
; 00000001       Signal 'EVM ready' for next tx symbol

;X and Y relocated by request   pm 8/97
        org     X:$18   ;codec receive timeslots
rslot0  dc      0       ;left audio from codec
rslot1  dc      0       ;right audio from codec
rslot2  dc      0       ;output level settings: bit 15 is busy flag
rslot3  dc      0       ;input level settings: bit 21 is overrange flag

ctlset  dc      ctlwd0  ;initialisation values for codec control mode
        dc      ctlwd1
        dc      0
        dc      0

        org     Y:$18   ;codec transmit timeslots
tslot0  dc      0       ;left audio
tslot1  dc      0       ;right audio
tslot2  dc      0       ;output level settings
tslot3  dc      0       ;input level settings: bit 21 is overrange enable

dtaset  dc      0       ;initialisation values for codec data mode
        dc      0
        dc      outputset
        dc      inputset
lastY   =       *

        org     L:lastY  ;oscillators
rxosc   ds      1        ;X:=freq Y:=phase
rsincos ds      1        ;X:=cos  Y:=sin
txosc   ds      1        ;X:=freq Y:=phase
tsincos ds      1        ;X:=cos  Y:=sin
hposc   ds      1        ;X:=freq Y:=phase
hsincos ds      1        ;X:=cos  Y:=sin
rxIQ    ds      1        ;filtered receive I and Q for headphone output
txIQ    dc      0        ;transmit I(X:) and Q(Y:) values +/-1
nexttx  dc      0        ;0, +1, or -1 for next tx bit  I,Q
lasttx  dc      0        ;0, +1, or -1 for previous tx bit I,Q
irqad   ds	5
lastL   =       *

        org     X:rxosc     ;initial values for oscillator frequencies
rxfreq  dc      1000.0/sample*2     ;rx freq   (PC can change it)
        org     X:txosc
txfreq  dc      1000.0/sample*2     ;tx freq   (PC can change it)
        org     X:hposc
hpfreq  dc      1000.0/sample*2      ;headphone freq (stays at 1 kHz)

        org     X:lastL
timeslot dc      0                  ;counts 0,1,2,3 at 32kHz
txdata   dc      0                  ;bit22:txon, bits21,20: phase shift
outhd    dc      0                  ;phase to send to PC (lsb=new phase)
nstack   dc      0                  ;stack for building Q24s from nybbles
bitclock dc      0                  ;counts $000000-$FFFFFF at 31.25 Hz
rand     dc      $123456            ;seed for random test generator
lastph   dc      0                  ;rx phase 32mS ago

;jump table for bytes from PC (index=bits 6,5,4 of PC byte)
jmptab   dc      txdat              ;put bits 0,1 into txbuf
         dc      push4              ;push bits 3,2,1,0 left into stack
         dc      dorxf              ;pop stack into rxfreq
         dc      dotxf              ;pop stack into txfreq

ampfil   dsm     16                 ;filter for waveform amplitudes
lastX   =       *

         org    Y:lastL
atncof   dc     -8.69245892963590E-0002   ;power series coeffs for arctan
         dc      3.36924589284536E-0001
pattern  dc     $000000          ;octant 0         bit23: 1=subtract 0=add
         dc     $A00000          ;       1    bits 22,21: quadrant offset
         dc     $800000          ;       7
         dc     $600000          ;       6
         dc     $C00000          ;       3
         dc     $200000          ;       2
         dc     $400000          ;       4
         dc     $E00000          ;       5
le_gain  dc     0
le_att   dc     0
t_out    dc     lineouton+(leftattn*0)
t_inp    dc     (15*monitorattn)+(rightattn*0)
delay	 dc	8000
flags    dc	0

          org     p:$0008
irq       bset	  #0,y:flags
	  nop
	  rti

          org    P:$000C
          jsr    <ssirx               ;SSI rcv data default handler
          nop
          jsr    <ssirx               ;ssi rcv data error handler
          nop

          org     P:$0020
;codec interrupt handler uses no registers!
ssirx     bchg    #0,X:timeslot       ;toggle bit0
          jcs    <oddslot             ;skip if it was 1
evenslot  btst    #1,X:timeslot       ;test bit1
          jcs    <slot2               ;skip if it was 1
slot0     movep   X:M_RX,X:rslot0     ;get left input from codec
          movep   Y:t_out,X:M_TX      ;put output setting to codec
          rti
oddslot   bchg    #1,X:timeslot       ;toggle bit1
          jcs    <slot3               ;skip if it was 1
slot1     movep   X:M_RX,X:rslot1     ;get right input from codec
          movep   Y:t_inp,X:M_TX      ;put input settings to codec
          rti
slot2     movep   X:M_RX,X:rslot2     ;get output settings from codec
          movep   Y:tslot0,X:M_TX     ;put left audio out to codec
          rti
slot3     movep   X:M_RX,X:rslot3     ;get input settings from codec
          movep   Y:tslot1,X:M_TX     ;put right audio out to codec
          rti

        org     P:$40
        
start   bclr	#0,y:flags
        ori     #3,MR           ;disable interrupts
        bset    #2,OMR          ;turn ROMs on
        clr     A
        movep   #$1C0005,X:M_PCTL ;40 Mhz, disable clock output
        movep   #$000F,X:M_BCR    ;slow memory in y i/o
	movep   #$4303,X:M_CRA    ;40MHz/16 = 2.5MHz SCLK, WL=16 bits, 4W/F
        movep   #$BB30,X:M_CRB    ;rie,re,te, tie not needed
        movep   #$14,X:M_PCDDR    ;setup pc4, pc2 as outputs for SSI
	movep   #$01E3,X:M_PCC    ;Turn on ssi,sci
        movep   #0,X:M_PBC        ;set portB to general purpose
        movep   #$60FF,X:M_PBDDR  ;set pb0-pb7, pb13, pb14 as outputs
        bclr    #0,X:M_PBD        ;ptt line off
        movep   #$0302,X:M_SCR    ;set SCR async, 8-bit
        movep   #35,X:M_SCCR      ;set baudrate, internal clocks
	movep   A1,X:M_PCD        ;codec control mode, hit codec reset
	do      #500,_endel       ;50mS delay
	 rep     #2000            ; (100 us delay)
          nop
_endel  bset    #4,X:M_PCD        ;reset off
        movep   #$2006,X:M_IPR    ;IPR=2 for ssi, IPR=1 for irq a with neg edge
        move    #ctlset,R1        ;source=codec control-settings
        move    #tslot0,R2        ;destn=transmit slots
        do      #4,_eset
         move   X:(R1)+,X0        ;move them
         move   X0,Y:(R2)+
_eset   andi    #$FC,MR           ;SSI interrupt will now fire
waitfr  wait
        jclr    #2,X:M_SR,waitfr  ;wait for rx frame sync
        move    A1,X:timeslot     ;synchronise the timeslot pointer
wait0   wait
        jset    #18,X:rslot0,wait0   ;wait for CLB=0
        bset    #18,Y:tslot0         ;set CLB=1
wait1   wait
        jclr    #18,X:rslot0,wait1   ;wait for CLB=1
        move   #dtaset,R1            ;source=codec data-settings
        move   #tslot0,R2            ;destn=transmit slots
        do      #4,_eset
         move   Y:(R1)+,A            ;move them
         move   A1,Y:(R2)+
_eset   movep   #$BB00,X:M_CRB       ;set SCLK,FS to input
	bset    #2,X:M_PCD           ;switch to data mode
        bset    #0,X:rslot0          ;mark left audio (ssirx clears it)
;done codec setup
;set up data addressing
        move    #$FF,M0              ;size of sine table
                                     ;R0 used on the fly
        move    #filter,R1           ;main receive filter ptr
        move    #filsize-1,M1        ;size of main receive filter
        move    #0,R2                ;just counts 0..255 at 8 kHz
        move    #$FF,M2              ;counter modulo  (32mS cycle)
        move    #decfil,R3           ;decimation filter ptr
        move    #decsize-1,M3        ;decimation filter modulo
                                     ;R4 used on the fly
        move    #$FFFF,M4            ;linear addressing all the time
        move    #monfil,R5           ;headphone interpolation filter
        move    #15,M5               ;headphone interpolation filter modulo
        move    #outbuf,R6           ;head pointer for SCI output buffer
        move    R6,R7                ;tail pointer for SCI output buffer
        move    #outsize-1,M6        ;size of SCI output buffer
        move    M6,M7

	dialed	clr
	cmdled	clr
        jsr	gainatt		     ;get gain and att settings from eeprom

;this is the main loop
main    wait                         ;cool down until something happens
        jset    #0,X:rslot0,main     ;loop until new left audio input
	jset	#0,y:flags,start

;get here at 8 kHz
        move    #rxosc,R4                ;point to receive oscillator
        jsr     oscill                   ;do receive oscillator
        jsr     oscill                   ;do transmit oscillator
        jsr     oscill                   ;do headphone oscillator
        move    X:rslot0,X0              ;get left input
        move    L:rsincos,Y              ;get rx osc sine/cosine
        mpyr    X0,Y1,A                  ;mix cos with input
        mpyr    X0,Y0,B       (R2)+      ;mix sine with input: count 31.25Hz
        move    AB,L:(R3)+               ;store I/Q in decimation filter
	sqr	a
	sqr	b
	add	b,a
	sqrt
	move	#0.95,b
	cmp	b,a
	jle	levelok
	cmdled	set
	jmp	levend
levelok	cmdled	clr
levend  clr	a
        move	y:delay,a0
	dec	a
	move	a0,y:delay
	jne	weiter
	move	#8000,a0
	move	a0,y:delay
	dialed	chg
weiter  bset    #0,X:rslot0              ;mark left audio input as done
        move    R2,B                     ;test for 31.25Hz process
        tst     B
        jne    <txwave

;here at 31.25Hz to fetch next tx bit
txbit   clr     A       #1,X0            ;set escape and sync codes
        move    A1,X:(R6)+               ;put them in the output buffer
        move    X0,X:(R6)+               ;to tell PC to send another bit
        move    X:txdata,X1              ;get txdata to send
        move    A,X:txdata     ;clear txdata for tx-off if nothing more
;        jsr     random            ;fetch random bit in carry
;        ror     B
;        jsr     random
;        ror     B
;        ror     B
;        ror     B
;        move    B,X1
;        bset    #20,X1
        move    L:nexttx,AB
        move    AB,L:lasttx              ;move new txIQ to old
        jset    #20,X1,txbit1            ;skip if bit2=1 (carrier on)
        clr     A                        ;amp=0 for carrier off
        clr     B
        jmp    <txbit2
txbit1  tst     A       #$7FFFFF,X0      ;see if last txI was zero
        jne    <txbit2                   ;skip if no
        tst     B                        ;check if last txQ was zero
        teq     X0,A                     ;set amplitude = +1.0
txbit2  jclr    #18,X1,txbit3
        neg     A                        ;90,270: swap -I>Q, Q>I
        tfr     A,B    B,A
txbit3  jclr    #19,X1,txbit4
        neg     A                        ;180,270: -I>I, -Q>Q
        neg     B
txbit4  move    AB,L:nexttx              ;put out I,Q values for next txbit

;now do transmit envelope at 8 kHz
txwave  move    R2,B                     ;get counter
        asr     B           #>$140,X0    ;divide count by 2
        add     X0,B                     ;point into cosine table
        move    B1,R0                    ;move to address register
        move    #$7FFFFF,Y0              ;set Y0=1.0  (pipeline)
        move    Y:(R0),A                 ;get cosine value from ROM
        asr     A           #0.5,X0      ;divide by 2
        add     X0,A                     ;0.5*(1+sin(count/2))=r/cos for last bit
        move    A1,A                     ;normalise A
        neg     A         A,X0           ;0.5*(-1-sin((count/2): save last
        add     Y0,A      X:lasttx,X1    ;0.5*(1-sin(count/2))
        move    A,Y0                     ;Y0=raised-cosine for next bit
        mpy     X0,X1,A   X:nexttx,Y1
        macr    Y0,Y1,A   Y:lasttx,X1    ;form composite I amplitude
        mpy     X0,X1,B   Y:nexttx,Y1
        macr    Y0,Y1,B   A,X0           ;form composite Q amplitude
        move    AB,L:txIQ                ;save resultant I,Q (-1.0 to +1.0)
        or      X0,B                     ;test if I and Q both zero
        jeq    <pttoff                   ;go turn ptt off if zero
ptton   bset    #0,X:M_PBD
        jmp    <ptt
pttoff  bclr    #0,X:M_PBD
ptt:
        move    L:tsincos,Y             ;get tx sine wave
        move    L:txIQ,X
        mpy     X0,Y0,A                 ;form tx waveform
        macr    X1,Y1,A
        move    A,Y:tslot0               ;tx waveform out

;here do headphone output at 8 kHz
        move    L:rxIQ,A                 ;get I and Q from rx filter
        move    A10,L:(R5)+              ;put into interpolation filter
        clr     A      L:(R5)+,X         ;clear Isum: get first I/Q
        clr     B      #1.00/16,Y0       ;clear Qsum: set constant coeff
        do      #15,_efil                ;calculate interpolation filter o/p
         mac    X1,Y0,A   X:(R5),X1
         mac    X0,Y0,B   Y:(R5)+,X0
_efil   macr    X1,Y0,A
        macr    X0,Y0,B   A,X1           ;interpolated I and Q now in A and B
        move    L:hsincos,Y              ;get cos(hpfreq) and sin(hpfreq)
        mpy     X1,Y1,A   B,X0           ;multiply rxI, get rxQ
        macr    X0,Y0,A                  ;mpy rxQ and add
        move    A1,Y:tslot1              ;output rx audio to right headphone

;process data from output buffer to SCI to PC
        jclr   #1,X:M_SSR,hout2         ;skip if SCI tx busy
        move   R6,A
        move   R7,X0
        cmp    X0,A                     ;test if anything in buffer to send
        jeq   <hout2
        movep  X:(R7)+,X:M_STXH         ;send it and bump the ptr
hout2

;process data from SCI input
        jclr    #2,X:M_SSR,hdone         ;skip if no byte waiting
        movep   X:M_SRXH,A0              ;get byte from SCI
        move     #>3,X0
        rep     #2
         asl    A                        ;move commandbits into A1
        and      X0,A    #jmptab,N4      ;mask command bits, setup jumptable
        move     A1,R4
        nop
        move    X:(R4+N4),R4             ;get address from jump table
        nop
        jmp     (R4)                     ;do the command, data in 4msb of A0

;command=0, put data for transmit
txdat   move    A0,X:txdata
        jmp    <hdone

;command=1, shift data into 24-bit stack
push4   move    X:nstack,A1              ;get nybble stack
        rep     #6
         asl    A                        ;shift new nybble into it
        move    A1,X:nstack              ;put new nybble stack away
        jmp    <hdone

;command=2, copy stack to rx frequency
dorxf   move    X:nstack,A
        move    A,X:rxfreq
        jmp    <hdone

;command=3, copy stack to tx frequency
dotxf   move     X:nstack,A
        move     A,X:txfreq
hdone                                    ;command=else

        move    R2,B                ;test for 500Hz processes
        move    #>15,X0
        and     X0,B      #>8,X0       ;mask to 0..15
        cmp     X0,B                   ;test for count=8
        jne     main                   ;skip if not((count mod 16)=8)

;here at 500Hz interleaved between 31.25Hz processes
;receive decimation filter calculation
        clr     A        #deccofs,R4
        clr     B
        move    X:(R4)+,X0              ;get 1st coeff
        move    L:(R3)+,Y               ;get I/Q
        do      #decsize-1,rxf0
         mac    X0,Y1,A  X:(R3),Y1
         mac    X0,Y0,B  Y:(R3)+,Y0  X:(R4)+,X0
rxf0    macr    X0,Y1,A
        macr    X0,Y0,B     
        move    AB,L:(R1)+         ;decimation filter output into main filter

        clr     A        #coeffs,R4
        clr     B
        move    X:(R4)+,X0                       ;get 1st coeff
        move    L:(R1)+,Y                        ;get I/Q
        do      #filsize-1,rxf1                  ;do main filter
         mac    X0,Y1,A  X:(R1),Y1               ;do Istep
         mac    X0,Y0,B  Y:(R1)+,Y0 X:(R4)+,X0   ;do Qstep
rxf1    macr   X0,Y1,A                           ;do last macs
        macr   X0,Y0,B                           ;and round off
        move   AB,L:rxIQ                         ;save for later
        move   A,X0                      ;move I
        mpy    X0,X0,A     B,X0          ;sqr(I), move Q
        mac    X0,X0,A                   ;sqr(I)+sqr(Q)
        jeq    <zero                     ;skip logarithm if zero
        move    #31,R0
        rep     #31                      ;set -93dB endstop
         norm   R0,A                     ;count 3db steps into R0
        asl     A
        asl     A                        ;shift linear interpolation up
        move    R0,A2                    ;copy 3dB count
        rep     #6
         asr    A                        ;A1=sig level 0=0db, $7FFFFF=96dB
zero    move    A1,X1
        move    X:bitclock,X0            ;get bitclock
        mpy     X0,#20,B                 ;shift 4msb to 4lsb
        move    #>15,Y0
        and     Y0,B       X0,A          ;mask to 0..15
        move    B1,N0                    ;move to offset reg
        move    #ampfil,R0               ;point to amplitude filter
        move    #syngain,X0              ;fetch sync loop gain
        move    X1,X:(R0+N0)             ;put current amplitude into filter
        move    X:(R0)+,X1
        rep     #8                       ;do first half of filter
         mac   +X0,X1,A     X:(R0)+,X1
        rep     #8                       ;do second half of filter
         mac   -X0,X1,A     X:(R0)+,X1
        rnd     A           #$100000,X0      ;round it; set 31.25Hz freq
        add     X0,A                         ;add freq to bitclock
        move    A1,X:bitclock                ;put frac(bitclock) back
        jec     main                         ;skip back if not bit-centre

;here at 31.25Hz in sync with received symbols
        move    L:rxIQ,AB                   ;refetch I and Q
     if debug
        move    #0,X0
        move    X0,X1                       ;set X=0
        move    X,L:rxIQ                    ;blink headphone for sync debug
     endif
;now calculate the phase angle from the I and Q values
arctan  move    #pattern,R4                 ;R4 will point to octant
        tst     A           #4,N4
        jpl    <atan1
        abs     A           (R4)+N4         ;if I<0  then add 4 to R4
atan1   tst     B           #2,N4
        jpl    <atan2
        abs     B           (R4)+N4         ;if Q<0 then add 2 to R4
atan2   cmp     A,B         A,X0
        jmi    <atan3
        tfr     X0,B        B,X0            ;if Q>I then swap..
        move    (R4)+                       ;and add 1 to R4
atan3   move    R4,N4                       ;save octant pointer in N4 temp
        move    #atncof,R4                  ;point to coefficients
        andi    #$FE,ccr                    ;clear carry bit
        rep     #24
         div    X0,B                        ;divide to get tangent
        move    B0,X1                       ;quotient to X1 =tan
        move    Y:(R4)+,X0                  ;get 2nd-order coefficient
        mpyr    X0,X1,A     Y:(R4),X0       ;k2*tan, fetch k1
        add     X0,A                        ;k2*tan+k1
        move    A,X0
        mpyr    X0,X1,A    N4,R4            ;(k2*tan+k1)*tan: get octant
        move    A1,X1
        move    Y:(R4),A                    ;get octant pattern/offset
        asl     A                           ;shift msb to carry
        jcc    <atan4
        sub     X1,A                        ;if C set then subtract from
        jmp    <atan5
atan4   add     X1,A                        ;if C clr then add to
atan5                                       ;4-quad phase value now in A1
        move   X:lastph,X1                  ;get phase from last bit
        sub    X1,A     A1,X:lastph         ;now-last
        neg    A       #$FF,X1              ;last-now; set hibyte mask

;feed diff phase value to output at 31.25Hz
        and     X1,A                        ;test for zero byte value
        jne     nesc
        move    A1,X:(R6)+                  ;if zero, double it
nesc    move    A1,X:(R6)+
        jmp     main

;this subroutine, called at 8 kHz, runs the oscillator that R4 is pointing
;at and returns it's cos and sin values in L:(R4+1)        (tnx SP9VRC)
oscill  move	X:(R4),A                  ;get frequency
        move    Y:(R4),X0                 ;get current phase
	add	X0,A	    #>$80,X1      ;add frequency to phase
	move	A1,Y:(R4)+                ;save new phase
	mpy     X0,X1,A     #>$FF,X0      ;shift right 16, remainder to A0
        and     X0,A        #$100,X0      ;mask A1 to 8 lsb
	or      X0,A        #$40,N0       ;form sine ROM table address
	move    A1,R0                     ;move ROM address to R0
	move    A0,Y0                     ;move remainder to Y0
	jclr    #23,Y0,round
	move    (R0)+                     ;round up if Y0>$7FFFFF
round	move    Y:(R0+N0),X0              ;X0=coarse cosine
	move    Y:(R0),X1                 ;X1=coarse sine
	mpyr    X1,Y0,A    #PI/256.0,Y1   ;A=sin*rem
       	tfr     X0,A       A,X1           ;fetch cos, move sin*rem
	macr   -X1,Y1,A                   ;A=cos-sin*rem*pi/256 (=fine cos)
	mpyr    X0,Y0,B    Y:(R0),X1      ;B=cos*rem, read sin again
	tfr     X1,B       B,X1           ;fetch sin, move cos*rem
	macr    X1,Y1,B    A,X:(R4)       ;B=sin+cos*rem*pi/256 (=fine sine)
        move    B,Y:(R4)+                 ;save sine: next oscillator
        rts

poly	equ	$10800		    ; random number generator polynomial (x^17 + x^12 + 1)
random  move    X:rand,A
	lsr	A	    #>poly,X0	; generate a new random bit in carry
	jcc	<_rand
	eor	X0,A
_rand	move    A1,X:rand
        rts

; a few microseconds software delay
dly5m	do	#40,_romb4
	do	#40,_romb3
	nop
_romb3	nop
_romb4	rts

; serial clock for eeprom
clock   jsr     dly5m
        bset    #2,y:slowio
        jsr     dly5m
        bclr    #2,y:slowio
        jsr     dly5m
        rts

; clocks a "1" into eeprom
hi      bset   #1,y:slowio
        jsr    clock
        rts

; clocks a "0" into eeprom
lo      bclr   #1,y:slowio
        jsr    clock
        rts

; Reads radio port and sets gain and attenuation accordingly
gainatt move    y:slowio,y1
        move    #0,x0
        bset    #17,x0
        bset    #2,x0               ; test
        move    x0,y:slowio         ; adress for radio read
        move    y:slowio,a          ; get radio's index
        lsl     a
        move    #>6,x0
        and     x0,a                ; mask other bits
        move    a,x0                ; and store it in x0
        move    #0,x1
        move    x1,y:slowio         ; test
        bset    #16,x1
        move    x1,y:slowio         ; enable eeprom
        jsr     dly5m
        jsr     hi                  ; clock a header one into eeprom
        jsr     hi                  ; clock first bit of opcode 10 into eeprom
        jsr     lo                  ; clock second bit of opcode into eeprom
        jsr     lo
        jsr     lo
        jsr     lo
        jsr     lo                  ; clock 4 adress bits (=0) into eeprom
        jsclr   #2,x0,lo
        jsset   #2,x0,hi            ; transfer ms adress bit to eeprom
        jsclr   #1,x0,lo
        jsset   #1,x0,hi            ; transfer middle adress bit to eeprom
        jsclr   #0,x0,lo
        jsset   #0,x0,hi            ; transfer ls adress bit to eeprom
        move    #0,x0               ; init x0
bit7    jsr     lo
        jclr    #0,y:slowio,bit6
        bset    #7,x0
bit6    jsr     lo
        jclr    #0,y:slowio,bit5
        bset    #6,x0
bit5    jsr     lo
        jclr    #0,y:slowio,bit4
        bset    #5,x0
bit4    jsr     lo
        jclr    #0,y:slowio,bit3
        bset    #4,x0
bit3    jsr     lo
        jclr    #0,y:slowio,bit2
        bset    #3,x0
bit2    jsr     lo
        jclr    #0,y:slowio,bit1
        bset    #2,x0
bit1    jsr     lo
        jclr    #0,y:slowio,bit0
        bset    #1,x0
bit0    jsr     lo
        jclr    #0,y:slowio,bend
        bset    #0,x0
bend    move    #0,x1
        move    x1,y:slowio         ; disable all slowio
        move    x0,y:le_gain
        jsr     dly5m
        move    #0,x0               ; now do the same for the second adress
        bset    #17,x0
        bset    #2,x0
        move    x0,y:slowio         ; adress for radio read
        move    y:slowio,a          ; get radio's index
        lsl     a
        move    #>6,x0
        and     x0,a                ; mask other bits
        move    #>1,x0
        or      x0,a
        move    a,x0                ; and store it in x0
        move    #0,x1
        move    x1,y:slowio         ; test
        bset    #16,x1
        move    x1,y:slowio         ; enable eeprom
        jsr     dly5m
        jsr     hi                  ; clock a header one into eeprom
        jsr     hi                  ; clock first bit of opcode 10 into eeprom
        jsr     lo                  ; clock second bit of opcode into eeprom
        jsr     lo
        jsr     lo
        jsr     lo
        jsr     lo                  ; clock 4 adress bits (=0) into eeprom
        jsclr   #2,x0,lo
        jsset   #2,x0,hi            ; transfer ms adress bit to eeprom
        jsclr   #1,x0,lo
        jsset   #1,x0,hi            ; transfer middle adress bit to eeprom
        jsclr   #0,x0,lo
        jsset   #0,x0,hi            ; transfer ls adress bit to eeprom
        move    #0,x0               ; init x0
bit71   jsr     lo
        jclr    #0,y:slowio,bit61
        bset    #7,x0
bit61   jsr     lo
        jclr    #0,y:slowio,bit51
        bset    #6,x0
bit51   jsr     lo
        jclr    #0,y:slowio,bit41
        bset    #5,x0
bit41   jsr     lo
        jclr    #0,y:slowio,bit31
        bset    #4,x0
bit31   jsr     lo
        jclr    #0,y:slowio,bit21
        bset    #3,x0
bit21   jsr     lo
        jclr    #0,y:slowio,bit11
        bset    #2,x0
bit11   jsr     lo
        jclr    #0,y:slowio,bit01
        bset    #1,x0
bit01   jsr     lo
        jclr    #0,y:slowio,bend1
        bset    #0,x0
bend1   move    #0,x1
        move    x1,y:slowio         ; disable slowio
        move    x0,y:le_att
        clr     a
        move    y:t_out,a1
        move    #>$C00000,x0
        and     x0,a
        move    a1,x0
        move    y:le_att,a1
        rep     #16
        lsl     a
        or      x0,a
        move    a1,y:t_out
        clr     a
        move    y:t_inp,a1
        move    #>$F0F000,x0
        and     x0,a
        move    a1,x0
        move    y:le_gain,a1
        rep     #16
        lsl     a
        or      x0,a
        move    a1,y:t_inp
        move    y1,y:slowio
        rts

lastP   =       *

      if @cvi(lastP)>$200
        org    L:lastP           ;make sure we are above the program
      else
        org    L:$200            ;..and above the ROM
      endif

monfil   dsm    16               ;interpolation filter for headphone output

decfil   dsm    decsize          ;decimation I/Q filters
lastL    =      *

         org    X:lastL
deccofs  equ *          ;triangular decimation filter (96db down at +/-500Hz)
count    set     0
total    =       @cvf(decsize)*@cvf(decsize)/2
         dup     decsize
       if count<16
         dc      @cvf(2*count+1)/total
       else
         dc      @cvf(2*(decsize-count)-1)/total
       endif
count    set     count+1
       endm
lastX    =      *

         org    L:lastX
filter   dsm    filsize        ;main receive I/Q filters
lastL    =      *
         org    X:lastL
coeffs   equ    *
PI       equ    3.14159265358979323846

s0       equ    0.5            ;DFT factors for main filter
s1       equ    1.15           ;>=64dB at >=31.25 Hz
s2       equ    0.7931
s3       equ    0.1567
s4       equ    0.00049
s5       equ    0.0005

time     =     -0.5*@cvf(filsize)+0.5
count    set    0
	 dup    filsize
angle    =      2*PI*time/@cvf(filsize)
coeff    =      s0+s1*@cos(angle)+s2*@cos(2.0*angle)+s3*@cos(3.0*angle)+s4*@cos(4.0*angle)+s5*@cos(5.0*angle)
time     =      time+1.0
	 dc     2*coeff/filsize
count    set    count+1
	 endm
lastL    =      *

         org    X:lastL
outbuf   dsm    outsize       ;rx and sync data to PC

        end     start
