//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <mmsystem.h>
#include <math.h>
#include <conio.h>
#include <io.h>

#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"

#define CARDFREQ 8000
#define TWOPI 6.2831852
#define HALFPI 1.5707963
#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr
#define NCHARS 47     // no. of chars in our morse code cipher
#define NINBUFS 8
#define NOUTBUFS 2
#define MAXSAMS 8192  // maximum possible for array config
#define BUFSIZE 4096  // 2048 short int samples


void inputStart(unsigned int freq); // start and stop input audio functions
void inputClose();
void outputStart(unsigned int freq); // start and stop output audio functions
void outputClose();
void sendInBuffs(void);
void sendOutBuffs(void);
void gencwid(float f);
void openComPort(void); // open the com port and set DTR/RTS high
void transOutputBuf(void);
void blackDispIm2(void);     // to clear scope display
void blackDispIm3(void);
void TxButtonOn(void);
void TxButtonOff(void);
void sendCwId(void); // to open up cwid routine
void transchar(unsigned char c); // to translate char into twotone morse
void prepareToneBlocks(unsigned int f); // Ready tone blocks for O/P
void prepareTestBlocks(void); // Calculate out all test blocks
void calcOpBlock(unsigned int num);  // Calculate OP block for midfreq
void getSlope(void); // to alter display sens
void speedSetUp(void); // set up for one of the three speeds
void setFilterBot(unsigned int freq);// to convert freq. to array limits
void setFilterTop(unsigned int freq);//       ""           "
//void outputChange();// change card O/P parameters

void CALLBACK WaveInProc(HWAVEIN inHandle, UINT uMsg, DWORD
dwInstance, DWORD dwParam1, DWORD dwParam2);
void CALLBACK WaveOutProc(HWAVEOUT outHandle, UINT uMsg, DWORD
dwInstance, DWORD dwParam1, DWORD dwParam2);

HANDLE hCom;   // handle for comport
DCB dcb; // device control block for com port


void fft(float compl[], unsigned int nn); //  fft number crunching
void revfft(float compl[], unsigned int nn); // reverse fft number crunching


// variables for wave in functions
MMRESULT result;
WAVEFORMATEX waveInFormat;
HWAVEIN inHandle;
WAVEHDR waveInHeader[NINBUFS];

// variables for wave out functions
WAVEFORMATEX waveOutFormat;
HWAVEOUT outHandle;
WAVEHDR waveOutHeader[NOUTBUFS];
DWORD waveOutBufSize;

// I/O file pointers
FILE *out;
FILE *in;

unsigned int sfreq;  // sampling freq
unsigned int nsamples; // no. of samples in FFT etc
unsigned int ns2; // above / 2 to save recalc.

// constants to be calculated for raised cosine functions
float windcon1[MAXSAMS]; // for first reception filter/waterfall
float windcon2[MAXSAMS];
float windcon3[MAXSAMS/2]; // for 2nd FFT tone selection

float rcos1[100]; // raised cosine function for shaping cwid

float modfreqNar[9] = {-32., -24., -16., -8., 0., 8., 16., 24., 32};
float modfreqWid[9] = {-64., -48., -32., -16., 0., 16., 32., 48., 64.};
float modfreq[9];
float faverage[4];
unsigned int fcount;


char cqtext[100];  // macro texts built up here
char qrztext[40];

char membuf[256];  // for reading short text file
char buf[80]; // general character buffer
char tempo[2];// for 1 char string

TRect From1Rect, To1Rect; // for scrolling of fft display
HDC Im1hand, Im2hand, Im3hand;
bool cwIdSet;  // signal to O/P routine to O/P cwid
bool inputStarted;  // to indicate if any blocks back from soundcard
bool soundCardStarted; // what it says
bool compon;   // whether any comport enabled
bool txon;  // true if in tx mode
bool testOn; // program runs on test input
bool afcOn;  // automatic frequency control
bool autoSync; // manual or automatic sync. start with true
bool pOn; // to allow switching print to screen off
bool outputCalled; // if call back says buffer available
bool firstTime;  // for setupspeed to know if default freq to be used
bool s1;  // to indicate  2nd series for ? " =
bool bypass; // io flag for bypassing print routine

// variables used in tune up routine
bool tuneUp;     // if flagged
float tuneUpCounter; // used in calc of sine data
float tuneUpSubvalue; // saves recalc in calc of sine data
unsigned int tuneUpBlockCounter; //to count no of blocks to O/P

int afcCounter; // enough here and we shift frequency of passband

// variables for CW id O/P
short int cwconv[128000];  // sine wave data of call sign
int cwBuffs;               // no. of 8192 size buffers in above
int bufcnt;                // to count our way through buffers
unsigned int bufmon;                //       "            "



unsigned int baudRate;   // 1,2 or 4

float greenSlope; // sensitivity of green FFT display
float slope;  // for adjusting intensity of waterfall
float twoPeakFactor; // to discriminate between 1 and 2 peak signals
float whiteDispFactor; // to adjust sens. of sync. disp.
unsigned int botLocn, topLocn; // filt lims in first (4096) array
unsigned int smallbotLocn, smalltopLocn;// filt lims in second array
unsigned int smallmidLocn; // in between the above two
unsigned int botFreq, topFreq, midFreq, botLimDisp, topLimDisp;
unsigned int midLimDisp;
unsigned int filteredStart;// sampling start point of filtered data
unsigned int opbuf[16];// enough for several soundcard buffersfull of o/p
unsigned int opptr; // array pointer for above



// variables to handle soundcard I/P
char inStor[8][BUFSIZE];// for holding I/P blocks
unsigned int ndataready[5];// no of block ready from I/P
unsigned int inbufcnt; // to point to ndataready[]
unsigned int idputcount, idtakecount, puttakediff;

// test message data
int tint[115] = {1,1,1,21,9,10,20,45,21,44,20,21,45,14,44,20,20,2,8,44,45,
24,10,13,13,45,17,19,10,15,21,45,16,22,21,45,21,9,44,45,24,9,16,13,44,45,
21,9,19,16,3,45,4,9,2,19,2,4,21,44,19,45,20,44,21,45,
1,2,3,4,5,44,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,
6,21,6,14,6,10    };
int tintcounter = 0;

int xClick, yClick; // store Image1 coordinates

unsigned int nyquist;  // for Nyquist freq (half sample freq)

// for operations on wavein data
short int workbuf[MAXSAMS]; // data taken from here to fft
float dat[2*MAXSAMS+1];  // data array for filtering fft(),
                         // +1 for not starting at 0
float dat2nd[MAXSAMS+1]; // ditto for peak determining fft()
float filtered[MAXSAMS]; // secondary data array
float temp[MAXSAMS/2]; // intermediate array

char callsign[15];
char comport[5];
char txdelay[5];

bool outdataAv[NOUTBUFS];

// storage areas for tone blocks for O/P
// short int for O/P at 8000Hz
short int  opBlock[45][MAXSAMS];
short int testBlock[45][MAXSAMS];

COLORREF cl[256];
unsigned int dataBlockOut;


// now follows global morse code cipher
char letts[47] = {51,0,21,18,31,15,7,3,1,0,16,24,28,30,5,10,33,17,22,12,
		  0,1,8,10,4,0,2,6,0,0,7,5,4,3,2,7,6,13,2,0,1,1,1,
		  3,9,11,12};
int length[47] = {6,0,6,5,5,5,5,5,5,5,5,5,5,5,6,5,6,5,6,6,0,2,4,4,3,1,
		  4,3,4,2,4,3,4,2,2,3,4,4,3,3,1,3,4,3,4,4,4};

// now the conversion to ciphered twotone

unsigned int ToneConv [45][2] =
                        { {5,5},// idle... no print
                          {4,5},// A
                          {1,2},// B
                          {1,3},// C
                          {1,4},// D
                          {4,6},// SHIFT (was E)
                          {1,5},// F
                          {1,6},// G
                          {1,7},// H
                          {3,7},// I
                          {1,8},// J
                          {2,3},// K
                          {2,4},// L
                          {2,8},// M
                          {2,5},// N
                          {5,6},// O
                          {2,6},// P
                          {2,9},// Q
                          {3,4},// R
                          {3,5},// S
                          {1,9},// T
                          {3,6},// U
                          {8,9},// V
                          {3,8},// W
                          {3,3},// X
                          {2,2},// Y
                          {1,1},// Z
                          {3,9},// 1
                          {4,7},// 2
                          {4,8},// 3
                          {4,9},// 4
                          {5,7},// 5
                          {5,8},// 6
                          {5,9},// 7
                          {6,7},// 8
                          {6,8},// 9
                          {6,9},// 0
                          {7,8},// ,
                          {7,9},// .
                          {8,8},// '
                          {7,7},// /
                          {6,6},// )
                          {4,4},// (
                          {9,9},// E
                          {2,7},// space
                          };


unsigned int channels[9][3] = { {2,5,8},
                                {10,13,16},
                                {17,21,24},
                                {26,29,32},
                                {34,37,40},
                                {43,46,49},
                                {51,54,57},
                                {59,62,65},
                                {66,70,73},
                                };

float chanWind[80] = {
   0.,0.,.125,.25,.5,1.,.5,.25,.125,  // 0 to 8
   0.,.125,.25,.5,1.,.5,.25,.125,     // 10 to 16
   0.,.125,.25,.5,1.,.5,.25,.125,     // 17 to 24
   0.,.125,.25,.5,1.,.5,.25,.125,     // 26 to 32
   0.,.125,.25,.5,1.,.5,.25,.125,     // 34 to 40
   0.,0.,.125,.25,.5,1.,.5,.25,.125,  // 43 to 49
   0.,.125,.25,.5,1.,.5,.25,.125,     // 51 to 57
   0.,.125,.25,.5,1.,.5,.25,.125,     // 59 to 65
   0.,.125,.25,.5,1.,.5,.25,.125, 

                      };
unsigned int maxNo[9];


float maxVal[9];
float fftValues[90];

 // conversion table straight
 unsigned char opChar[45] = {'\x0','A','B','C','D','\x0','F','G','H','I','J','K',
'L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','1',
'2','3','4','5','6','7','8','9','0',',','.','\x27','/',')','(','E',' '};
 // conversion table for opposite sideband
 unsigned char revChar[45] = {'\x0','O','V','.','0','E','7','4','1','I',
 'Q',',','9','M','6','A','3','J','8','5','T','2','B',' ','/','\x27','E',
 'H','U','P','G','S','N','F','R','L','D','K','C','Y','X',')','(','Z','W'};


TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void inputStart(unsigned int freq)
{
unsigned int index;
DWORD temp;

waveInFormat.wFormatTag = WAVE_FORMAT_PCM;
waveInFormat.nChannels = 1;
waveInFormat.nSamplesPerSec = freq;
waveInFormat.wBitsPerSample = 16;
temp = waveInFormat.nChannels * waveInFormat.wBitsPerSample;
temp = temp/8;
waveInFormat.nBlockAlign =(WORD) temp;
waveInFormat.nAvgBytesPerSec = waveInFormat.nSamplesPerSec *
waveInFormat.nBlockAlign;
waveInFormat.cbSize = 0;

result = waveInOpen(&inHandle, WAVE_MAPPER, &waveInFormat,
(DWORD)WaveInProc,0, CALLBACK_FUNCTION);
if(result)
  {
      MessageBox(NULL,
      "Cannot Open Audio Input Device",
      "G3PPT Throb2000 Program",
      MB_ICONEXCLAMATION | MB_OK);
       return;
  }

//allocate input buffer memory
waveInHeader[0].lpData = (char*)VirtualAlloc(0,
BUFSIZE*NINBUFS, MEM_COMMIT, PAGE_READWRITE);

// set up each of the headers
for(index=0;index<=NINBUFS-1;index++)
{
 waveInHeader[index].dwUser = index; // for handling
                                        // routine to identify buffer
 waveInHeader[index].lpData = waveInHeader[0].lpData + BUFSIZE*index;
 waveInHeader[index].dwBufferLength = BUFSIZE;
}

// send in all of the input buffers
 sendInBuffs();

// let it rip
waveInStart(inHandle);
}
//-----------------------------------------------------------------------------
void inputClose(void)
{
int i;
// now tidy up everything to close down
   waveInStop(inHandle);
   waveInReset(inHandle);
   for(i=0;i<=NINBUFS-1;i++)
    {
      waveInUnprepareHeader(inHandle, &waveInHeader[i],
      sizeof(WAVEHDR));
    }

// Free Wave Buffers

VirtualFree(waveInHeader[0].lpData,BUFSIZE * NINBUFS, MEM_FREE);
waveInClose(inHandle);



}


//---------------------------------------------------------------------------
void outputStart(unsigned int freq)
{
DWORD temp;
int i;
waveOutFormat.wFormatTag = WAVE_FORMAT_PCM;
waveOutFormat.nChannels = 1;
waveOutFormat.nSamplesPerSec = freq;
waveOutFormat.wBitsPerSample = 16;
temp = waveInFormat.nChannels * waveInFormat.wBitsPerSample;
temp = temp/8;
waveOutFormat.nBlockAlign =(WORD) temp;
waveOutFormat.nAvgBytesPerSec = waveOutFormat.nSamplesPerSec *
waveOutFormat.nBlockAlign;
waveOutFormat.cbSize = 0;

result = waveOutOpen(&outHandle, WAVE_MAPPER, &waveOutFormat,
(DWORD)WaveOutProc,0, CALLBACK_FUNCTION);
if(result)
  {
      MessageBox(NULL,
      "Cannot Open Audio Output Device",
      "G3PPT Throb2000 Program",
      MB_ICONEXCLAMATION | MB_OK);
       return;
  }

waveOutBufSize = nsamples * 2;//BUFSIZE;

waveOutHeader[0].lpData = (char*)VirtualAlloc(0,
waveOutBufSize*NOUTBUFS, MEM_COMMIT, PAGE_READWRITE);
waveOutHeader[0].dwBufferLength = waveOutBufSize;
waveOutHeader[0].dwUser = 0; // for handling routine to identify buffer

for(i=1;i<=NOUTBUFS-1;i++)
 {
  waveOutHeader[i].lpData = waveOutHeader[i-1].lpData + waveOutBufSize;
  waveOutHeader[i].dwBufferLength  = waveOutBufSize;
  waveOutHeader[i].dwUser =  i; // for handling routine to identify buffer
 }

 // start output with idle data
 sendOutBuffs();
}
//-----------------------------------------------------------------------------
void outputClose(void)
{
int i;
// now tidy up everything to close down
   waveOutReset(outHandle);

   for(i=0;i<=NOUTBUFS-1;i++)
   {
    waveOutUnprepareHeader(outHandle, &waveOutHeader[i],
    sizeof(WAVEHDR));
   }

// Free Wave Buffers

VirtualFree(waveOutHeader[0].lpData,BUFSIZE * NOUTBUFS, MEM_FREE);

waveOutClose(outHandle);
}
//------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{

   if(access("PPTTTONE.INI",0) != 0)
    {
      MessageBox(NULL,
      "No Configuration File !\nRun Set Up if you want to Transmit",
      "G3PPT Throb2000 Program",
      MB_ICONEXCLAMATION | MB_OK);
      strcpy(callsign,"");
      strcpy(comport,"NONE");
      RadioGroup1->ItemIndex = 4;
    }
   else
    {
     in = fopen("PPTTTONE.INI", "rt");
     fscanf( in, "%s %s %s", callsign, comport, txdelay);
     fclose(in);
     sprintf(qrztext, "%s %s  %s %s", "  QRZ QRZ QRZ DE " ,
            callsign, callsign, "KKK");
     sprintf(cqtext, "%s %s %s %s %s %s", "  CQ CQ CQ CQ CQ DE ",
             callsign, callsign, callsign, callsign, " AR PSE KKKKK");
    }

  s1 = false;
  firstTime = true;
  soundCardStarted = false;
  speedSetUp(); // set up for default speed
  inputStart(sfreq);  // start audio I/P
  soundCardStarted = true;
}
//---------------------------------------------------------------------------
void sendInBuffs(void)
// send the wave buffers for input routine
{
int i;

// Prepare and send the WAVEHDRS

for(i=0;i<=NINBUFS-1;i++)
  {
   waveInPrepareHeader(inHandle, &waveInHeader[i],sizeof(WAVEHDR));
   waveInAddBuffer(inHandle,&waveInHeader[i],sizeof(WAVEHDR));
  }
}

//-----------------------------------------------------------------------
void CALLBACK WaveInProc(HWAVEIN inHandle, UINT uMsg, DWORD
dwInstance, DWORD dwParam1, DWORD dwParam2)
{
WAVEHDR *wve;

if(uMsg == MM_WIM_DATA)
 {
   // find out which buffer has come back
   wve = (WAVEHDR*) dwParam1; // pointer to buffer
   inputStarted = true;
   ndataready[inbufcnt] = (unsigned int) (wve->dwUser+1);

   // only increase data pointer if < 4 in queue
   if(inbufcnt < 3)
     inbufcnt++;
 }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
// main RX timer
unsigned int i,k,j, pixcount, biggestNo, biggestNo2, biggestChan;
unsigned int j1, j2, from, to, posMin1, posMin2;
unsigned int biggestChan2;
float t1, t2, t3, t4, t5, biggest, biggest2;
float  fmin1, fmin2;
int plotto;
short int *p;
short int tdat;
bool overLoadFlag;

   if (inputStarted == false)
     return;
   // see if enough buffers are in
   if((idputcount - idtakecount) < puttakediff)
     return;

   Timer1->Enabled = false;// stop it while we work
   overLoadFlag = false;




   if(testOn == false) // deal with live data
    {
     //set pointers to block of I/P data
     p = (short int*) inStor[idtakecount & 7];

    }
   else  // test routine so point to test block
    {
     p = (short int*) &testBlock[tint[tintcounter]-1];
     tintcounter++;
     if(tintcounter == 115)
      tintcounter = 0;
    }



    // scroll waterfall display
   Im1hand = Image1->Canvas->Handle;
   Image1->Canvas->CopyMode = cmSrcCopy;
   Image1->Canvas->CopyRect(To1Rect,Image1->Canvas, From1Rect);


   //move data along nsamples/2
   memmove(&workbuf[0],&workbuf[ns2], ns2*(sizeof (short int)));


   // now put new data in second half
   // take every other value for decim making sampling rate 4000Hz
   for (i=ns2;i<=nsamples-1; i++)
    {
      workbuf[i] = *p++;
      p++;
    }


    // set up complex array for fft routine
   for(i=1;i<=nsamples;i++)
    {
      tdat = workbuf[i-1];
      if((tdat > 32500) || (tdat < -32500))
        overLoadFlag = true;  // Audio I/P Overload detected
      dat[i*2-1] = ((float) tdat) * windcon1[i];
      dat[i*2] = 0.;
    }

   fft(dat, nsamples);  // go do FFT on nsamplesworth of data

    if(overLoadFlag == false)
     {
        // display spectrum from 800 to 1111 Hz

      for(pixcount = 1;pixcount<=320;pixcount++)
      {
        switch (RadioGroup3->ItemIndex){
         case 0: {     // 1 Baud
                  t1 = dat[pixcount*4+3277];
	              t2 = dat[pixcount*4+3278];
                  t3 = dat[pixcount*4+3279];
                  t4 = dat[pixcount*4+3280];
                  t5 =  sqrt(t1*t1 + t2*t2) + sqrt(t3*t3 + t4*t4);
                  break;
                  }
         case 1:  {    // 2 Baud
                  t1 = dat[pixcount*2+1639];
	              t2 = dat[pixcount*2+1640];
                  t5 =  sqrt(t1*t1 + t2*t2);
                  break;
                  }

         case 2:  {   // 4 Baud
                  t1 = dat[pixcount+819];
	              t2 = dat[pixcount+820];
                  t5 =  sqrt(t1*t1 + t2*t2);
                  break;
                  }
        }
         plotto = (int) (t5 * slope);

         if(plotto<0)
          plotto = 0;
         if(plotto > 255)
          plotto = 255;
         plotto = 255-plotto; // plot white -->  black

        Im1hand = Image1->Canvas->Handle;
        SetPixel(Im1hand,pixcount -1,19,cl[plotto]);
       }
        // put band edge markers in
       SetPixel(Im1hand,botLimDisp-1,19,clRed);
       SetPixel(Im1hand,topLimDisp-1,19,clRed);
       SetPixel(Im1hand,midLimDisp-1,19,clAqua);
     }
     else  // do overload indication
     {
      for(pixcount = 1;pixcount<=320;pixcount++)
       SetPixel(Im1hand,pixcount-1,19,clRed);
      overLoadFlag = false;
     }
      // remove unwanted bins for filtering
      // also eliminate nagative frequencies

      for (i=1; i<=botLocn-1;i++)
       dat[i] = 0.;
      for (i=topLocn+1;i<=2*nsamples;i++)
       dat[i] = 0.;

      //get filtered waveform back
      revfft(dat, nsamples);

      // move real data out of complex arrray
      // into RHS of filtered[]
      //  First find maximum value in block
        t3=0.01;
        for(i=nsamples/4,k=0;i<=nsamples/4*3-1;i++,k++)
         {
          temp[k] =  dat[i*2-1];
          if(temp[k] > t3)
            t3 = temp[k];
         }

     // now normalise  with respect to the maximum
       t3 =  t3/40.;
       for(i=0;i<=ns2-1;i++)
       temp[i] = temp[i]/t3 ;

       // shift previous data along to 1st half af array
       memmove(&filtered[0], &filtered[ns2],ns2*sizeof(float));
       // and shift new data into RHS
       memmove(&filtered[ns2], &temp[0], ns2 * sizeof(float));


      // display a subset of filtered[] on CRT display
      // for manual synch.
      // Do it in two halves to get the minimum in each half for sync.
      blackDispIm2();
      Im2hand = Image2->Canvas->Handle;
      Image2->Canvas->Pen->Color = clWhite;

      j1 = nsamples/128;   // j1 is 64 or 32 for 1 or 2 baud resp.
      fmin1 = fmin2 = 10000.; //
      for(i=0;i<=63;i++)
       {
          t1 = 0.;
          j = i * j1;
          for(k=0;k<=j1-1;k=k+5)
           {
            j2 = j+k;
            t1 = t1 + filtered[j2]*filtered[j2]+ filtered[j2+1]
            *filtered[j2+1];
           }
          faverage[fcount++] = t1;
          fcount = fcount & 3;
          t1 = (faverage[0] + faverage[1] + faverage[2] + faverage[3])/4.;


          t1 = t1 * whiteDispFactor;
          if(t1 < fmin1)
            {
             fmin1 = t1;
             posMin1 = i;
            }

        Image2->Canvas->MoveTo(i,64);
        Image2->Canvas->LineTo(i,64 -(int)t1);
       }
      for(i=64;i<=127;i++)
       {
          t1 = 0.;
          j = i * j1;
          for(k=0;k<=j1-1;k=k+5)
           {
            j2 = j+k;
            t1 = t1 + filtered[j2]*filtered[j2]+ filtered[j2+1]
            *filtered[j2+1];
           }
          faverage[fcount++] = t1;
          fcount = fcount & 3;
          t1 = (faverage[0] + faverage[1] + faverage[2] + faverage[3])/4.;


          t1 = t1 * whiteDispFactor;

          if(t1 < fmin2)
            {
             fmin2 = t1;
             posMin2 = i;
            }
        Image2->Canvas->MoveTo(i,64);
        Image2->Canvas->LineTo(i,64 -(int)t1);
       }

      j = posMin2- posMin1;

      // alter the sample start point automatically if flagged
      if(autoSync == true)
       {
        if((j < 68)&& (j > 60) && (posMin1 > 0))
         filteredStart = (posMin1* nsamples)/128;
       }


      // mark beginning of  sampling block
      Image2->Canvas->MoveTo(filteredStart/j1,0);
      Image2->Canvas->Pen->Color = clRed;
      Image2->Canvas->LineTo(filteredStart/j1,63);
      Image2->Canvas->Pen->Color = clGreen;

  // set whole of area to 0. Then we can do FFT of higher resolution
  // with a shaped block of data padded out with 0.
  memset(&dat2nd[0],0,(MAXSAMS+1)*sizeof(float));

  for(i=filteredStart,k=1,j=0;i<=filteredStart+ns2-1;i++,j++,k=k+2)
   {
      dat2nd[k] = filtered[i]*windcon3[j];
      dat2nd[k+1] = 0.;
   }

  if(baudRate == 4)
   fft(dat2nd,2048);
  else
   fft(dat2nd,4096);

  blackDispIm3();
  Form1->Image3->Canvas->Pen->Color = clGreen;

  if(baudRate == 1)
   {
    from = smallbotLocn;
    to = smalltopLocn;
   }
  if(baudRate == 2)
   {
    from = botLocn;
    to = topLocn;
   }
  if(baudRate == 4)
   {
    from = botLocn;
    to = topLocn;
   }

  // copy passband square power channel values
  for(i=from,k=0;i<=to;i=i+2,k++)
  {
     t3 = sqrt(dat2nd[i]*dat2nd[i] + dat2nd[i+1]*dat2nd[i+1]);

     fftValues[k] = t3;

     Form1->Image3->Canvas->MoveTo((i-from+1)/2,0);
     Form1->Image3->Canvas->LineTo((i-from+1)/2,
     (int)(t3*greenSlope));
  }

   // now see which tone decodes are max
   for(i=0;i<=8;i++)
    {
     maxVal[i] = 0.;
     // find max value this channel
     for(k=channels[i][0]; k<=channels[i][2]; k++)
      {
       if(fftValues[k] > maxVal[i])
        {
         maxVal[i] = fftValues[k];
         maxNo[i] = k;
        }
      }
    }
// now find greatest tone out of the 7 channels

 biggest = 0.;
 for(i=0;i<=8;i++)
  {
   if(maxVal[i] > biggest)
    {
      biggest = maxVal[i];
      biggestNo = maxNo[i];
      biggestChan = i;
    }
  }
  if(biggestNo < channels[biggestChan][1])// freq too high
    afcCounter++;
  else
   if(biggestNo > channels[biggestChan][1])// freq too low
    afcCounter--;

// now find second biggest

 biggest2 = 0.;
 for(i=0;i<=8;i++)
  {
   if(i == biggestChan)
     continue;
   if(maxVal[i] > biggest2)
    {
      biggest2 = maxVal[i];
      biggestNo2 = maxNo[i];
      biggestChan2 = i;
    }
  }
 // look for the single tones

 if( biggest > twoPeakFactor * biggest2)
   {
     biggest2 = biggest;
     biggestNo2 = biggestNo;
     biggestChan2 = biggestChan;
   }
 // if necessary swap so lowest value of pair comes first
 if(biggestChan > biggestChan2)
  {
    i = biggestChan;
    biggestChan = biggestChan2;
    biggestChan2 = i;
  }
 // now decode character
 // deal first with shift series
  if(s1 == true) // if previous char was shift
   {
     if(((biggestChan+1) == 1) && ((biggestChan2+1) == 9))
         tempo[0] = '?';
     else
      if(((biggestChan+1) == 2) && ((biggestChan2+1) == 8))
         tempo[0] = '@';
      else
       if(((biggestChan+1) == 3) && ((biggestChan2+1) == 7))
         tempo[0] = '=';
      s1 = false;
      bypass = true;
      Memo1->SetSelTextBuf(tempo);
      // now plot thge same for the other sideband
      Memo2->SetSelTextBuf(tempo);

   }


  if(((biggestChan+1) == 5) && ((biggestChan2+1) ==5))
   bypass = true; // idle char do not print

  if(((biggestChan+1) == 4) && ((biggestChan2+1) == 6))
   {
    s1 = true;   // set shift flag for next char
    bypass = true;
   }

  if(bypass != true)
    {
     for(i=0;i<=44;i++)
     {
       if((ToneConv[i][0] == biggestChan + 1) &&
          (ToneConv[i][1] == biggestChan2 + 1))
          {
           tempo[0] = opChar[i];
           break;
          }
     }


      // print character if flagged
       if(pOn == true)
        {
         Memo1->SetSelTextBuf(tempo);

         // now plot the equivalent for the other sideband
         tempo[0] = revChar[i];
         Memo2->SetSelTextBuf(tempo);
        }
    }
    bypass = false;



   if(afcOn == true)
     {
       if(afcCounter > 5)
        {
         afcCounter = 0;
         midFreq--;
         prepareToneBlocks(midFreq);
        }
       else
        if(afcCounter < -5)
        {
         afcCounter = 0;
         midFreq++;
         prepareToneBlocks(midFreq);
        }
     }
  
  idtakecount = idtakecount + puttakediff;

  Timer1->Enabled = true;// allow timer again
}

//---------------------------------------------------------------------------
void fft(float compl[], unsigned int nn) // do the actual fft number crunching
{
unsigned int n,mmax,m,j,istep,i;
float wtemp,wr,wpr,wpi,wi,theta;
float tempr,tempi;

// Fast Fourier routine from Numerical Recipes in C: The Art of Scientific
// Computing (ISBN 0-521-43108-5) 1988-1992 CUP
// pages 504-510


// First is bit reversal section of routine

   n = nn<<1;
   j=1;
   for(i=1;i<=n;i+=2)
      {
	 if(j > i)
	    {
	       SWAP(compl[j],compl[i]);
	       SWAP(compl[j+1],compl[i+1]);
	    }

	 m = n>>1;
	 while((m >= 2) && (j > m))
	    {
	       j -= m;
	       m >>= 1;
	    }
	j += m;
      }

// Here begins the Danielson-Lanczos section
   mmax = 2;
   while(n > mmax)
      {
	 istep = mmax << 1;
	 theta = TWOPI/mmax;
	 wtemp = sin(0.5*theta);
	 wpr = -2.0*wtemp*wtemp;
	 wpi = sin(theta);
	 wr = 1.0;
	 wi = 0.0;
	 for(m=1;m<mmax;m+=2)
	    {
	       for(i=m;i<=n;i+=istep)
		  {
		     j = i+mmax;
		     tempr = wr * compl[j] -wi * compl[j+1];
		     tempi = wr * compl[j+1] + wi * compl[j];
		     compl[j] = compl[i] - tempr;
		     compl[j+1] = compl[i+1] - tempi;
		     compl[i] += tempr;
		     compl[i+1] += tempi;
		  }
	       wr = (wtemp=wr) * wpr - wi *wpi +wr;
	       wi = wi * wpr + wtemp * wpi +wi;
	    }
	 mmax = istep;
      }
}
//---------------------------------------------------------------------------
void revfft(float compl[], unsigned int nn) // do the actual fft number crunching
{
unsigned int n,mmax,m,j,istep,i;
float wtemp,wr,wpr,wpi,wi,theta;
float tempr,tempi;

// Fast Fourier routine from Numerical Recipes in C: The Art of Scientific
// Computing (ISBN 0-521-43108-5) 1988-1992 CUP
// pages 504-510


// First is bit reversal section of routine

   n = nn<<1;
   j=1;
   for(i=1;i<=n;i+=2)
      {
	 if(j > i)
	    {
	       SWAP(compl[j],compl[i]);
	       SWAP(compl[j+1],compl[i+1]);
	    }

	 m = n>>1;
	 while((m >= 2) && (j > m))
	    {
	       j -= m;
	       m >>= 1;
	    }
	j += m;
      }

// Here begins the Danielson-Lanczos section
   mmax = 2;
   while(n > mmax)
      {
	 istep = mmax << 1;
	 theta = -1. * TWOPI/mmax;
	 wtemp = sin(0.5*theta);
	 wpr = -2.0*wtemp*wtemp;
	 wpi = sin(theta);
	 wr = 1.0;
	 wi = 0.0;
	 for(m=1;m<mmax;m+=2)
	    {
	       for(i=m;i<=n;i+=istep)
		  {
		     j = i+mmax;
		     tempr = wr * compl[j] -wi * compl[j+1];
		     tempi = wr * compl[j+1] + wi * compl[j];
		     compl[j] = compl[i] - tempr;
		     compl[j+1] = compl[i+1] - tempi;
		     compl[i] += tempr;
		     compl[i+1] += tempi;
		  }
	       wr = (wtemp=wr) * wpr - wi *wpi +wr;
	       wi = wi * wpr + wtemp * wpi +wi;
	    }
	 mmax = istep;
      }


}
//----------------------------------------------------------------------
void setFilterBot(unsigned int freq)// to convert freq. to array limits
{
  botLocn = ((long int) (freq * nsamples))/nyquist;
  // if even force to odd to fit 1st part of real array pair
  if((botLocn & 1) == 0)
    botLocn = botLocn-1;
  smallbotLocn  = ((long int) (freq * nsamples/2))/nyquist;
  if((smallbotLocn & 1) == 0)
    smallbotLocn = smallbotLocn-1;
  }
//-----------------------------------------------------------------------

void setFilterTop(unsigned int freq)// to conv. freq to array limits
{
  topLocn = ((long int) (freq * nsamples))/nyquist;
  // if odd force to even to point to second part of real array pair
  if((topLocn & 1) == 1)
    topLocn = topLocn + 1;
  smalltopLocn = ((long int) (freq * nsamples/2))/nyquist;
  if((smalltopLocn & 1) == 1)
    smalltopLocn = smalltopLocn + 1;
  }
//------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
 // Exit command from File Menu
 Close();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::About1Click(TObject *Sender)
{
MessageBox( NULL ,"Throb2.5  A 9 Tone Transmission Program\n"
"Written by Lionel Sear G3PPT\n"
"September 2000","Information",MB_OK);
}
//-------------------------------------------------------------------------
void __fastcall TForm1::Help1Click(TObject *Sender)
{
//Application->HelpCommand(HELP_CONTENTS, 0);
WinExec("explorer.exe throb25.htm", SW_SHOWMAXIMIZED );
}
//---------------------------------------------------------------------------
 void blackDispIm2(void)     // to clear scope display
{
 Form1->Image2->Canvas->Brush->Color = clBlack;
 Form1->Image2->Canvas->Rectangle(0,0,
                                 Form1->Image2->Width,
                                 Form1->Image2->Height);

}
void __fastcall TForm1::Image1MouseUp(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
unsigned int displayFreq;
displayFreq = 802 +  (311 * X) /(Image1->Width);
prepareToneBlocks(displayFreq);
}
//--------------------------------------------------------------------------- //---------------------------------------------------------------------------
 void blackDispIm3(void)     // to clear scope display
{
 Form1->Image3->Canvas->Brush->Color = clBlack;
 Form1->Image3->Canvas->Rectangle(0,0,
                                 Form1->Image3->Width,
                                 Form1->Image3->Height);

}
void __fastcall TForm1::Image2MouseUp(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  if((X <  64) && (Button == mbLeft))
      filteredStart = X * nsamples/128;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetUp1Click(TObject *Sender)
{
Form1->Panel1->Enabled = true;
Form1->Panel1->Visible = true;
Form1->Memo3->Clear();
Form1->Memo3->SetSelTextBuf(callsign);
Form1->FocusControl(Memo3);
if(strcmp(comport,"COM1")==0)
   Form1->RadioGroup1->ItemIndex = 0;
if(strcmp(comport,"COM2")==0)
   Form1->RadioGroup1->ItemIndex = 1;
if(strcmp(comport,"COM3")==0)
   Form1->RadioGroup1->ItemIndex = 2;
if(strcmp(comport,"COM4")==0)
   Form1->RadioGroup1->ItemIndex = 3;
if(strcmp(comport,"NONE")==0)
   Form1->RadioGroup1->ItemIndex = 4;

if(strcmp(txdelay, "NONE") == 0)
   Form1->RadioGroup2->ItemIndex = 0;
if(strcmp(txdelay, "ON") == 0)
   Form1->RadioGroup2->ItemIndex = 1;




   }
//---------------------------------------------------------------------------
void __fastcall TForm1::BitBtn1Click(TObject *Sender)
{
FILE *in;
Form1->Panel1->Enabled = false;
Form1->Panel1->Visible = false;

if(Memo3->GetTextLen() == 0)
{
 Memo3->SetSelTextBuf("NOCALL");
 Memo3->SetSelTextBuf(" ");
}
// now see if com port to be used
if(RadioGroup1->ItemIndex == -1)
   strcpy(buf,"NONE");
if(RadioGroup1->ItemIndex == 0)
   strcpy(buf,"COM1");
if(RadioGroup1->ItemIndex == 1)
   strcpy(buf,"COM2");
if(RadioGroup1->ItemIndex == 2)
   strcpy(buf,"COM3");
if(RadioGroup1->ItemIndex == 3)
   strcpy(buf,"COM4");
if(RadioGroup1->ItemIndex == 4)
   strcpy(buf,"NONE");

Memo3->SetSelTextBuf(" ");
Memo3->SetSelTextBuf(buf);

   // now see if TX delay to be used
if(RadioGroup2->ItemIndex == -1)
   strcpy(buf,"NONE");
if(RadioGroup2->ItemIndex == 0)
   strcpy(buf,"NONE");
if(RadioGroup2->ItemIndex == 1)
   strcpy(buf, "ON");

Memo3->SetSelTextBuf(" ");
Memo3->SetSelTextBuf(buf);

// update
Memo3->Lines->SaveToFile("PPTTTONE.INI");
     in = fopen("PPTTTONE.INI", "rt");
     fscanf( in, "%s %s", callsign, comport, txdelay);
     fclose(in);

     sprintf(qrztext, "%s %s %s%s", "  QRZ QRZ QRZ DE ",
            callsign, callsign, " KKK");
     sprintf(cqtext, "%s %s %s %s %s %s", "  CQ CQ CQ CQ CQ DE ",
             callsign, callsign, callsign, callsign, " AR PSE KKKKK");


// if called open com port
if(strcmp(comport, "NONE")!= 0)
 {
 if(compon == true)  // if one already open  close it
  {
   compon = false;
   CloseHandle(hCom);
  }
openComPort();

 }
Form1->FocusControl(Memo4);// get keyboard awareness back
}
//----------------------------------------------------------------------
// O/P CW Ident
void gencwid(float f)
{
unsigned int ns; // no. of samples in letter section
unsigned int i,k,i1; // counters
int t;
unsigned char c;
float part;  // build up combination of frequencies here
char cs[14]; // temp holding for call-sign string
float lengel;
float bf;    // float of CWBASEFREQ
float fns;   // float of ns
float tp;   // float of tp
float basesamplerate = 8000.;
int ctr;
   ctr = 0;
   bf = f;
   tp = TWOPI;


      memset(cwconv, 0, 128000 * sizeof(short int));

      strcpy(cs,"DE ");
      strcat(cs,callsign);
      for(k=1;k<=strlen(cs);k++) //for each char in callsign
	 {

	    c = cs[k-1];
	    if (c == ' ')
	       {
		     //  write zero as inter word delay
		  lengel = 0.4; // element time in secs
		  ns = (int)(lengel*basesamplerate);     // (int) number of samplings
		  for(i1=1;i1<=ns;i1++)
		       cwconv[ctr++] = 0;

		  continue;
	       }

	   c =(unsigned char)((int) c - 44); /* convert from ASCII value to array */
	   for(i=length[c];i>=1;i--) // no. of dits and dahs in char
	      {
		 t = pow(2,i-1);
		 if((letts[c] & t) == 0)    // it is dit
		    {
		       lengel = 0.067; // element time in secs
		       fns = lengel*basesamplerate;  // (float) number of samplings
		       ns = (int)(fns);     // (int) number of samplings



		       for(i1=1;i1<=ns;i1++)
			  {
			     part = sin((float)i1/fns*(tp*lengel*bf));
			     // now tailor if beginning or end of element
			     // to avoid transients
			     if(i1<=100)
				part = part * rcos1[i1-1];
			     if((ns-i1)<=100)
				part = part * rcos1[ns - i1-1];
			      cwconv[ctr++] =(short int) (30000.0*part);
			  }
		    }
		 else            // it is dah
		    {
		       lengel = 0.2; // element time in secs
		       fns = lengel*basesamplerate;  // (float) number of samplings
		       ns = (int)(fns);     // (int) number of samplings


		       for(i1=1;i1<=ns;i1++)
			  {
			     part = sin((float)i1/fns*(tp*lengel*bf));
			     // now tailor if beginning or end of element
			     // to avoid transients
			     if(i1<=100)
				  part = part * rcos1[i1-1];
			     if((ns-i1)<=100)
				  part = part * rcos1[ns - i1-1];
			     cwconv[ctr++] =(short int) (30000.0 * part);
			  }
		    }
		     //  write zero as inter bit delay
		 lengel = 0.067; // element time in secs
		 fns = lengel*basesamplerate;  // (float) number of samplings
		 ns = (int)(fns);     // (int) number of samplings


		 for(i1=1;i1<=ns;i1++)
		     cwconv[ctr++] = 0;

	      }
		     //  write zero as inter char delay
	      lengel = 0.2; // element time in secs
	      fns = lengel*basesamplerate;  // (float) number of samplings
	      ns = (int)(fns);     // (int) number of samplings


	      for(i1=1;i1<=ns;i1++)
		   cwconv[ctr++] = 0;
	 }

   cwBuffs = ctr/2048 + 1; // no. of buffers to O/P callsign

}
//---------------------------------------------------------------------------
void openComPort(void) // open the com port and set DTR/RTS high
{
          hCom = CreateFile(comport,
          GENERIC_READ | GENERIC_WRITE,
          0,    /* comm devices must be opened w/exclusive-access */
          NULL, /* no security attrs */
          OPEN_EXISTING, /* comm devices must use OPEN_EXISTING */
          0,    /* not overlapped I/O */
          NULL  /* hTemplate must be NULL for comm devices */
          );

          if (hCom == INVALID_HANDLE_VALUE)
          {
           MessageBox(NULL,"Cannot open COM Port",
           "G3PPT SlowFeld Program",
           MB_ICONEXCLAMATION | MB_OK);
          }
          // now set for DTR/RTS off
          GetCommState(hCom, &dcb);
          dcb.fDtrControl = DTR_CONTROL_DISABLE;
          dcb.fRtsControl = RTS_CONTROL_DISABLE;
          SetCommState (hCom, &dcb);
          compon = true;
}

void __fastcall TForm1::BitBtn2Click(TObject *Sender)
{
Form1->FocusControl(Memo4);// get keyboard awareness back
Form1->Panel1->Enabled = false;
Form1->Panel1->Visible = false;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo3KeyPress(TObject *Sender, char &Key)
{
Key =(unsigned char) toupper(Key);
	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo4KeyPress(TObject *Sender, char &Key)
{
Key =(unsigned char) toupper(Key);
	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
if (Button1->Caption == "Tx ON")
 {
   Button1->Caption = "Tx OFF";
   TxButtonOn();
 }
else
 {
   Button1->Caption = "Tx ON";
   TxButtonOff();



 }
}
//---------------------------------------------------------------------------
void TxButtonOn(void)
{
 txon = true;
 Form1->FocusControl(Form1->Memo4);// get keyboard awareness back
 opptr = 0; // pointer to o.p buffer

 Form1->Timer2->Enabled = true;   // on with TX timer
 Form1->Timer1->Enabled = false;  // off with RX timer
 Form1->Timer3->Enabled = false;  // off with RX data timer

 Form1->Button3->Enabled = true;  // enable cwid  button
 Form1->Button9->Enabled = true;  // enable TuneUp button
 Form1->Button2->Enabled = false; // disable unwanted buttons
 Form1->Button4->Enabled = false;
 Form1->Button5->Enabled = false;
 Form1->SetUp1->Enabled = false;
 Form1->Button6->Enabled = false;


 //Form1->Button7->Enabled = true;
 //Form1->Button8->Enabled = true;

 Form1->RadioGroup3->Enabled = false;// no speed change whilst in TX

 inputClose();

 outputStart(sfreq);

 if(compon == true)// operate PTT
  {
   GetCommState(hCom, &dcb);
   dcb.fRtsControl = RTS_CONTROL_ENABLE;
   SetCommState (hCom, &dcb);
  }
}
//------------------------------------------------------------------------
void TxButtonOff(void)
{
unsigned int i;
txon = false; // flag callback we are in rx
Form1->FocusControl(Form1->Memo4);// get keyboard awareness back

outputClose();

Form1->Timer2->Enabled = false;  // stop TX timer

Form1->Button3->Enabled = false;  // disable cwid
Form1->Button9->Enabled = false;  // disable TuneUp
Form1->Button2->Enabled = true;
Form1->Button4->Enabled = true;
Form1->Button5->Enabled = true;
Form1->RadioGroup3->Enabled = true;
Form1->Button6->Enabled = true;
Form1->SetUp1->Enabled = true;

//Form1->Button7->Enabled = false;
//Form1->Button8->Enabled = false;

Form1->Timer1->Enabled = true; //turn on main RX timer
Form1->Timer3->Enabled = true; //turn on RX data timer

Form1->Memo4->Clear();

for(i=0;i<=3;i++)
 faverage[i] = 0.;
fcount = 0;

inbufcnt = 0;
for(i=0;i<=4;i++)
  ndataready[i] = 0;

inputStart(sfreq);


if(compon == true)
 {// switch off PTT
  GetCommState(hCom, &dcb);
  dcb.fRtsControl = RTS_CONTROL_DISABLE;
  SetCommState (hCom, &dcb);
 }
}
//------------------------------------------------------------------------

void CALLBACK WaveOutProc(HWAVEOUT outHandle, UINT uMsg, DWORD
dwInstance, DWORD dwParam1, DWORD dwParam2)
{
 DWORD bufno;
 WAVEHDR *wve;
 if(txon == false)
    return;
if(uMsg == WOM_DONE)
 {
   // find out which buffer has come back
   wve = (WAVEHDR*) dwParam1; // pointer to buffer
   bufno = wve->dwUser;       // dereference it
   outdataAv[bufno] = true;
 }
}

//----------------------------------------------------------------------
// to move output data to waveheader
// and then return waveheader to soundcard
void transOutputBuf(void)
{
unsigned int i;
int tlen;
char tbuf[2];
short int* opp;

waveOutPrepareHeader(outHandle, &waveOutHeader[dataBlockOut],
 sizeof(WAVEHDR));

// now move buffer full of data into short int array
if(tuneUp == true)
 {
  opp = (short int*) waveOutHeader[dataBlockOut].lpData;
  for(i=0;i<=nsamples-1;i++)
    *opp++ = (short int)(sin(tuneUpCounter++ * tuneUpSubvalue)*30000);

  tuneUpBlockCounter++;
  if(tuneUpBlockCounter >= 6 * baudRate)
   {
    tuneUp = false;
    Form1->Button9->Enabled = true;
    Form1->Button3->Enabled = true;
   }

 }
else
{
if(cwIdSet == true)// in process of O/P cwid
 {
  memmove(waveOutHeader[dataBlockOut].lpData,&cwconv[bufmon*nsamples],
  nsamples * 2);// BUFSIZE);
  //memmove(waveOutHeader[dataBlockOut].lpData,&cwconv[bufmon*BUFSIZE/2],
  // BUFSIZE);


  bufmon++;// point to next buffer full of cwid data
   if(bufmon > (bufcnt* baudRate/4))// finished sending cwident ?
    { // yes
     cwIdSet = false;
     Form1->Button1->Enabled = true;
     Form1->Button3->Enabled = true;
     Form1->Button9->Enabled = true;
     Form1->FocusControl(Form1->Memo4);// get keyboard awareness back
    }
 }
else // no cwid or tune up so send data or idle tone
 {
  if(opbuf[0] == 0) // no data,  send idling tone
    memmove(waveOutHeader[dataBlockOut].lpData, &opBlock[0], nsamples * 2);
  else
    {
      if(opbuf[0] != 1)
       calcOpBlock(opbuf[0]-1);



      memmove(waveOutHeader[dataBlockOut].lpData, &opBlock[opbuf[0]-1],
                    nsamples * 2);
      memmove(&opbuf[0],&opbuf[1], 15*sizeof(unsigned int));
      // pointer down to 0 but not beyond
      if(opptr != 0)
        opptr--;
    }
 }
 }

// prepare and add buffer back into routine
waveOutWrite(outHandle,&waveOutHeader[dataBlockOut],sizeof(WAVEHDR));


if(opptr <= 4)
{//   return; // plenty in O/P buffer yet
// now see if there is a char to convert

// get 1st char on Memo1 screen
Form1->Memo4->SelStart = 0;
Form1->Memo4->SelLength = 1;
Form1->Memo4->GetSelTextBuf(tbuf,2);  // into char buffer
Form1->Memo4->CutToClipboard();      // delete from screen
tlen = Form1->Memo4->GetTextLen();   // now get cursor to end of text
Form1->Memo4->SelStart = tlen;
if(tbuf[0] != 0)// if no actual input in buffer
 {
  transchar(tbuf[0]);   // char available so convert it
  Form1->Memo5->PasteFromClipboard();// and echo to transmitted screen
 }


}

outdataAv[dataBlockOut] = false;
dataBlockOut++;
if(dataBlockOut == NOUTBUFS)
 dataBlockOut = 0;
Form1->Timer2->Enabled = true; // enable further transfers

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
   sendCwId();
}
//---------------------------------------------------------------------------
void sendCwId(void) // to open up cwid routine
{
  if(strcmp(callsign,"NOCALL") == 0)
   {
    MessageBox(NULL,"No Callsign !\nRun Set Up if you want to Transmit",
    "G3PPT SlowFeld Program",
     MB_ICONEXCLAMATION | MB_OK);
    return;
   }
  bufcnt = cwBuffs;
  bufmon = 0;
  cwIdSet = true;
  Form1->Button3->Enabled = false;// disable further calls this button
  Form1->Button9->Enabled = false;// disable tune up
  Form1->FocusControl(Form1->Memo4);// get keyboard awareness back
}
//----------------------------------------------------------------------
void sendOutBuffs(void)
{
int i;
 // send out buffers with idle sig for audio O/P
 // Prepare the WAVEHDRS

 for(i=0;i<=NOUTBUFS-1;i++)
  {
   if((strcmp(txdelay,"ON") == 0) && (i == 0))
    {
     waveOutPrepareHeader(outHandle, &waveOutHeader[i],sizeof(WAVEHDR));
     memset(waveOutHeader[i].lpData, 0, sizeof(short int)* nsamples * 2);
     waveOutWrite(outHandle,&waveOutHeader[i],sizeof(WAVEHDR));
    }
   else
   {
     waveOutPrepareHeader(outHandle, &waveOutHeader[i],sizeof(WAVEHDR));
     memmove(waveOutHeader[i].lpData, &opBlock[0], nsamples * 2);
     waveOutWrite(outHandle,&waveOutHeader[i],sizeof(WAVEHDR));
   }
  }

}
//----------------------------------------------------------------------------
// translate character into THROB
void transchar(unsigned char c)
{
unsigned int k; // counter
bool found;

     found = false;
     if(c == '?')
      {
       opbuf[opptr++] = 6;
       opbuf[opptr++] = 21;
       return;
      }
     if(c == '@')
      {
       opbuf[opptr++] = 6;
       opbuf[opptr++] = 14;
       return;
      }
      if(c == '=')
       {
        opbuf[opptr++] = 6;
        opbuf[opptr++] = 10;
        return;
       }




     for (k=0;k<=44;k++)
      {
      if(c == opChar[k])
        {
         found = true;
         break;
        }
      }
     if(found == false)
       return;

     opbuf[opptr++] = (unsigned int) k + 1;

}
//------------------------------------------------------------------------
void prepareToneBlocks(unsigned int f)   // Calc tone blocks for O/P
{
 midFreq = f;
 if(baudRate == 4)
  {
    botFreq = f - 72;
    setFilterBot(botFreq);
    topFreq = f + 72;
    setFilterTop(topFreq);
  }
 else
  {
    botFreq = f - 36;
    setFilterBot(botFreq);
    topFreq = f + 36;
    setFilterTop(topFreq);
  }

 botLimDisp = ((botFreq-800) * 320)/311;
 topLimDisp = ((topFreq-800) * 320)/311;
 midLimDisp = ((midFreq-800) * 320)/311;

 // Calculate the idling tone for immediate use
 // Others calculated when called
 calcOpBlock(0);

 // gen cw id for midFreq
 gencwid((float)midFreq);
 // set to have tune up tone on midfreq
 tuneUpSubvalue = TWOPI * ((float)(midFreq))/CARDFREQ;

}
//--------------------------------------------------------------------------
void __fastcall TForm1::Image1MouseMove(TObject *Sender, TShiftState Shift,
	int X, int Y)
{
unsigned int displayFreq;
displayFreq = 802 +  (311 * X) /(Image1->Width);
itoa(displayFreq,buf,10);
Label7->Caption = buf;
Panel2->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormMouseMove(TObject *Sender, TShiftState Shift, int X,
	int Y)
{
Panel2->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
if(Button2->Caption == "Test On")
 {
  Button2->Caption = "Test Off";
  testOn = true;
  tintcounter = 0;
 }
else
 {
  Button2->Caption = "Test On";
  testOn = false;
 }

}
//---------------------------------------------------------------------------
void prepareTestBlocks(void) //  for test blocks at 900 Hz
{
unsigned int k,i;
float ftemp, tempcon1, tempcon2;



 for(k=0;k<=44;k++)
 {
   tempcon1 = TWOPI * (900. +  modfreq[ToneConv[k][0]-1])/8000.;
   tempcon2 = TWOPI * (900. +  modfreq[ToneConv[k][1]-1])/8000.;


   for(i=0;i<=nsamples-1;i++)
    {
      ftemp = .5 * sin((float)i * tempcon1);
      ftemp = ftemp + .5 * sin((float)i * tempcon2);
      ftemp = ftemp * windcon2[i];
      testBlock[k][i] = (short int)(ftemp*30000);
    }
 }




}
//-----------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
 if(Button4->Caption == "AFC Off")
   {
     Button4->Caption = "AFC On";
     afcOn = false;
     Label8->Visible = false;
   }
 else
 if(Button4->Caption == "AFC On")
   {
     Button4->Caption = "AFC Off";
     afcOn = true;
     afcCounter = 0;
     Label8->Visible = true;
   }


}
//---------------------------------------------------------------------------
void calcOpBlock(unsigned int num)  // Calculate OP block for midfreq
{
unsigned int i;
float ftemp, freq, tempcon1, tempcon2;
//float modfreq[9] = {-32., -24., -16., -8., 0., 8., 16., 24., 32.};

   freq = (float) midFreq;

   tempcon1 = TWOPI * (freq +  modfreq[ToneConv[num][0]-1])/8000.;
   tempcon2 = TWOPI * (freq +  modfreq[ToneConv[num][1]-1])/8000.;


   for(i=0;i<=nsamples-1;i++)
    {
      ftemp = .5 * sin((float)i * tempcon1);
      ftemp = ftemp + .5 * sin((float)i * tempcon2);
      ftemp = ftemp * windcon2[i];
      opBlock[num][i] = (short int)(ftemp*30000);
    }
}
//----------------------------------------------------------------------------
void __fastcall TForm1::Button5Click(TObject *Sender)
{
  if(Button5->Caption == "Print Off" )
   {
    Button5->Caption = "Print On";
    pOn = false;
   }
  else
   {
    Button5->Caption = "Print Off";
    pOn = true;
   }
}
//---------------------------------------------------------------------------
void getSlope(void) // to alter display sens
{
 switch (Form1->TrackBar1->Position){
 case 5: {
           slope = 40.;
           break;
         }
 case 4: {
           slope = 20.;
           break;
         }
 case 3: {
           slope = 10.;
           break;
         }
 case 2: {
           slope = 1.;
           break;
         }
 case 1: {
           slope = .5;
           break;
         }
}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
  getSlope();
  Form1->FocusControl(Form1->Memo4);// get keyboard awareness back

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer2Timer(TObject *Sender)
{ // to transfer O/P data if available
  if(outdataAv[dataBlockOut] == true)
  {
   Timer2->Enabled = false;
   transOutputBuf();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button6Click(TObject *Sender)
{
 if(Button6->Caption == "AutoSync Off")
   {
     Button6->Caption = "AutoSync On";
     Label11->Visible = false;
     autoSync = false;
   }
 else
 if(Button6->Caption == "AutoSync On")
   {
     Button6->Caption = "AutoSync Off";
     autoSync = true;
     Label11->Visible = true;
   }

}
//---------------------------------------------------------------------------
void speedSetUp(void) // set up for one of the three speeds
{
 unsigned int i, ns5, nsdiff;
 float temp;

   // working constants concerning no. of samples

   if(soundCardStarted == true)
     waveInStop(inHandle);

   if(Form1->RadioGroup3->ItemIndex == 0)  // Speed 1 Baud
    {
     nsamples = 8192;
     filteredStart = 2048;
     baudRate = 1;
     twoPeakFactor = 2.;
     whiteDispFactor = .003;
     puttakediff = 4; // 4 I/P buffers for each char
     // select wide tones for fast speed
     for(i=0;i<=8;i++)
       modfreq[i] = modfreqNar[i];
    }
   if(Form1->RadioGroup3->ItemIndex == 1)  // Speed 2 Baud
    {
     nsamples = 4096;
     filteredStart = 1024;
     baudRate = 2;
     twoPeakFactor = 2.;
     whiteDispFactor = .006;
     puttakediff = 2; // 2 I/P buffers for each char
     for(i=0;i<=8;i++)
       modfreq[i] = modfreqNar[i];

 }
   if(Form1->RadioGroup3->ItemIndex == 2)  // Speed 4 Baud
    {
     nsamples = 2048;
     filteredStart = 512;
     baudRate = 4;
     twoPeakFactor = 2.;
     whiteDispFactor = .01;
     puttakediff = 1;// 1 I/P buffer / char
     for(i=0;i<=8;i++)
       modfreq[i] = modfreqWid[i];
}

   ns2 = nsamples/2;
   inbufcnt = 0;
   for(i=0;i<=4;i++)
     ndataready[i] = 0;

   if(baudRate == 1)
     greenSlope = .0005;
   if(baudRate == 2)
     greenSlope = .001;
   if(baudRate == 4)
     greenSlope = .002;

   idputcount = 0;
   idtakecount = 0;
   afcOn = true;    // start with AFC
   autoSync = true; // start with automatic sync

   tempo[1] = 0; // set termination of 1 char string
   txon = false;
   outputCalled = false;

   sfreq = CARDFREQ;
   nyquist = CARDFREQ/4;

   blackDispIm2(); // scope screen
   blackDispIm3();



  // slope for intensity of waterfall display
  getSlope();

  // Organise rects to update  fft display
  From1Rect = Rect(0,1,Form1->Image1->Width,Form1->Image1->Height);
  To1Rect = Rect(0,0,Form1->Image1->Width,Form1->Image1->Height-1);



  // prepare gray scales for setpixel
  for(i=0;i<=255;i++)
   cl[i] = i + i*256 +i*65536;


   // Calculate raised cosine consts for cwid shaping
  for(i=0;i<=99;i++)
      rcos1[i] = 0.5*(1-cos(TWOPI*((float)(i+1))/200.));

 if((baudRate == 1)||(baudRate == 2)) // semi Raised cosine window
  {
    ns5 = nsamples/5;
    for(i=0;i<=ns5*2;i++)
     windcon2[i] =  (0.5 * (1 - cos(TWOPI *((float)(i))/((float)(ns5*2)))));

     // take trailing half of above and put it at the end
    nsdiff = (nsamples*3)/5;
    for(i=nsamples/5;i<=ns5*2+1;i++)
      windcon2[i+nsdiff] = windcon2[i];

    // also set up the small O/P window trailing edge
    // middle bit from 1/4 to 3/4 is set at 1
    for(i=nsamples/6;i<=(nsamples*5)/6;i++)
      windcon2[i] = 1.;
  }
 else  // fastest speed so full raised cosine for max resolution
  {
   for(i=0;i<=nsamples-1;i++)
     windcon2[i] =
      (0.5 * (1 - cos(TWOPI *((float)(i))/((float)nsamples))));

   }

  //raised cosine window for 2nd FFT calc on ns2 samples
  // it is half the size so take every other 1
  for(i=0;i<=ns2-1;i++)
   windcon3[i] = windcon2[i*2]*3;


  //raised cosine window // including /32768
  // to normalise input at 1 for full 16 bit soundcard I/P
  for(i=1;i<=ns2;i++)
   windcon1[i] =
     (0.5 * (1 - cos(TWOPI *((float)(i))/((float)ns2))))/32768.;

  // take trailing half of above and put it at the end

  for(i=nsamples/4;i<=ns2+1;i++)
   windcon1[i+ns2] = windcon1[i];
  temp = 1./32768.;

  // middle bit from 1/4 to 3/4 is set at 1
  for(i=nsamples/4;i<=nsamples/4*3-1;i++)
   windcon1[i] = temp;

   if (firstTime == true)
    {
     prepareToneBlocks(1000);   // Calc tone blocks for O/P
     firstTime = false;        // Initially at 1000Hz
    }
   else
    prepareToneBlocks(midFreq);

   prepareTestBlocks();



   tuneUp = false;


   dataBlockOut = 0;
   inputStarted = false;


   for(i=0;i<=NOUTBUFS-1;i++)
      outdataAv[i] = false;

   Form1->Button1->Enabled = true;   // TX On Button
   Form1->Button3->Enabled = false;  // CW I/D Button
   Form1->Button9->Enabled = false;  // Tune Up button

   Form1->FocusControl(Form1->Memo4);// get keyboard awareness back

   pOn = true; // start with printing on

   if(soundCardStarted == true)
    {
      sendInBuffs();
      waveInStart(inHandle);
    }
}
//-----------------------------------------------------------------------
void __fastcall TForm1::RadioGroup3Click(TObject *Sender)
{
  speedSetUp(); // change speed
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer3Timer(TObject *Sender)
{ // move a buffer of I/P data to circ buffer
unsigned int i;


  if(ndataready[0] == 0)
   return;      // if nothing ready

  Timer3->Enabled = false;

  memmove(&inStor[idputcount & 7],waveInHeader[ndataready[0] -1].lpData,
  BUFSIZE);
  idputcount++;


  // return input buffer to system
  waveInPrepareHeader(inHandle, &waveInHeader[ndataready[0]-1],sizeof(WAVEHDR));
  waveInAddBuffer(inHandle,&waveInHeader[ndataready[0]-1],sizeof(WAVEHDR));

   // shift dataready pointers down 1, 0 comes in from ndataready[4]
  for(i=1;i<=4;i++)
    ndataready[i-1] = ndataready[i];

  inbufcnt--;
  Timer3->Enabled = true;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo1Click(TObject *Sender)
{
Memo2->Width = 58;
Memo2->Left = 407;
Memo1->Width = 406;
// the next puts the cursor at the end
Memo1->SelectAll();
Memo1->CutToClipboard();
Memo1->Clear();
Memo1->PasteFromClipboard();


}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo2Click(TObject *Sender)
{
  Memo1->Width = 58;
  Memo2->Left = 59;
  Memo2->Width = 406;
  Memo2->SelectAll();
  Memo2->CutToClipboard();
  Memo2->Clear();
  Memo2->PasteFromClipboard();


}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button8Click(TObject *Sender)
{
Memo4->SetSelTextBuf(qrztext);
Form1->FocusControl(Form1->Memo4);// get keyboard awareness back

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button7Click(TObject *Sender)
{
Memo4->SetSelTextBuf(cqtext);
Form1->FocusControl(Form1->Memo4);// get keyboard awareness back

}
//---------------------------------------------------------------------------



void __fastcall TForm1::Button9Click(TObject *Sender)
{
  tuneUp = true;
  tuneUpCounter = 0;
  tuneUpBlockCounter = 0;
  Button9->Enabled = false; // disable further calls this button
  Button3->Enabled = false; // disable CW I/D
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo6KeyPress(TObject *Sender, char &Key)
{
Key =(unsigned char) toupper(Key);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button10Click(TObject *Sender)
{
  if(Memo6->GetTextLen() == 0)
    return; // if no callsign entered
  Memo4->SetSelTextBuf(" ");
  Memo6->SelectAll();
  Memo6->CopyToClipboard();
  Memo4->PasteFromClipboard();
  Memo4->SetSelTextBuf(" DE ");
  Memo4->SetSelTextBuf(callsign);
  Form1->FocusControl(Form1->Memo4);// get keyboard awareness back


}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button11Click(TObject *Sender)
{
  if(Memo6->GetTextLen() == 0)
    return; // if no callsign entered
  Memo4->SetSelTextBuf(" ");
  Memo6->SelectAll();
  Memo6->CopyToClipboard();
  Memo4->PasteFromClipboard();
  Memo4->SetSelTextBuf(" DE ");
  Memo4->SetSelTextBuf(callsign);
  Memo4->SetSelTextBuf(" AR PSE KKK");
  Form1->FocusControl(Form1->Memo4);// get keyboard awareness back


}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button12Click(TObject *Sender)
{
unsigned int counter, c;

   if(access("1.TXT",0) != 0)
    {
      MessageBox(NULL,
      "1.TXT File Not Available",
      "G3PPT Throb Program V2.5",
      MB_ICONEXCLAMATION | MB_OK);
      return;
    }
   counter = 0;
   in = fopen("1.TXT", "rt");
   while((counter < 255) && (!feof(in)))
     {
        c =  fgetc(in);
        if((isalpha(c)) || (isalnum(c)) || (c == ' '))
           membuf[counter++] = (char) c;
     }

   membuf[counter] = 0;
   fclose(in);
 Memo4->SetSelTextBuf(membuf);
 Form1->FocusControl(Form1->Memo4);// get keyboard awareness back


}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button13Click(TObject *Sender)
{
unsigned int counter, c;

   if(access("2.TXT",0) != 0)
    {
      MessageBox(NULL,
      "2.TXT File Not Available",
      "G3PPT Throb Program V2.5",
      MB_ICONEXCLAMATION | MB_OK);
      return;
    }
   counter = 0;
   in = fopen("2.TXT", "rt");
   while((counter < 255) && (!feof(in)))
     {
        c =  fgetc(in);
        if((isalpha(c)) || (isalnum(c)) || (c == ' '))
           membuf[counter++] = (char) c;
     }

   membuf[counter] = 0;
   fclose(in);
 Memo4->SetSelTextBuf(membuf);


 Form1->FocusControl(Form1->Memo4);// get keyboard awareness back

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button14Click(TObject *Sender)
{
unsigned int counter, c;

   if(access("3.TXT",0) != 0)
    {
      MessageBox(NULL,
      "3.TXT File Not Available",
      "G3PPT Throb Program V2.5",
      MB_ICONEXCLAMATION | MB_OK);
      return;
    }
   counter = 0;
   in = fopen("3.TXT", "rt");
   while((counter < 255) && (!feof(in)))
     {
        c =  fgetc(in);
        if((isalpha(c)) || (isalnum(c)) || (c == ' '))
           membuf[counter++] = (char) c;
     }

   membuf[counter] = 0;
   fclose(in);
 Memo4->SetSelTextBuf(membuf);

 Form1->FocusControl(Form1->Memo4);// get keyboard awareness back
}
//---------------------------------------------------------------------------
