head	1.4;
access;
symbols;
locks;
comment	@ * @;


1.4
date	93.05.06.10.07.08;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.05.01.08.19.36;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.08.13.20.38;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.02.01.13.03.52;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.4
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* ARP commands
 * Copyright 1991, Phil Karn, KA9Q
 */
#include <stdio.h>
#include <ctype.h>
#include "global.h"
#include "mbuf.h"
#include "timer.h"
#include "enet.h"
#include "ax25.h"
#include "arp.h"
#include "netuser.h"
#include "cmdparse.h"
#include "commands.h"

static int doarpadd(int argc,char *argv[],void *p);
static int doarpdrop(int argc,char *argv[],void *p);
static int doarpflush(int argc,char *argv[],void *p);
static void dumparp(void);

static struct cmds Arpcmds[] = {
	"add", doarpadd, 0, 4,
	"arp add <hostid> ether|ax25|netrom|arcnet <ether addr|callsign>",

	"drop", doarpdrop, 0, 3,
	"arp drop <hostid> ether|ax25|netrom|arcnet",

	"flush", doarpflush, 0, 0,
	NULLCHAR,

	"publish", doarpadd, 0, 4,
	"arp publish <hostid> ether|ax25|netrom|arcnet <ether addr|callsign>",

	NULLCHAR,
};
char *Arptypes[] = {
	"NET/ROM",
	"10 Mb Ethernet",
	"3 Mb Ethernet",
	"AX.25",
	"Pronet",
	"Chaos",
	"",
	"Arcnet",
	"Appletalk"
};

int
doarp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	if(argc < 2){
		dumparp();
		return 0;
	}
	return subcmd(Arpcmds,argc,argv,p);
}
static
doarpadd(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 hardware;
	int32 addr;
	char *hwaddr;
	struct arp_tab *ap;
	struct arp_type *at;
	int pub = 0;

	if(argv[0][0] == 'p')	/* Is this entry published? */
		pub = 1;
	if((addr = resolve(argv[1])) == 0){
		printf(Badhost,argv[1]);
		return 1;
	}
	/* This is a kludge. It really ought to be table driven */
	switch(tolower(argv[2][0])){
	case 'n':	/* Net/Rom pseudo-type */
		hardware = ARP_NETROM;
		break;
	case 'e':	/* "ether" */
		hardware = ARP_ETHER;
		break;		
	case 'a':	/* "ax25" */
		switch(tolower(argv[2][1])) {
		case 'x':
			hardware = ARP_AX25;
			break;
		case 'r':
			hardware = ARP_ARCNET;
			break;
		default:
			printf("unknown hardware type \"%s\"\n",argv[2]);
			return -1;
		}
		break;
	case 'm':	/* "mac appletalk" */
		hardware = ARP_APPLETALK;
		break;
	default:
		printf("unknown hardware type \"%s\"\n",argv[2]);
		return -1;
	}
	/* If an entry already exists, clear it */
	if((ap = arp_lookup(hardware,addr)) != NULLARP)
		arp_drop(ap);

	at = &Arp_type[hardware];
	if(at->scan == NULLFP){
		printf("Attach device first\n");
		return 1;
	}
	/* Allocate buffer for hardware address and fill with remaining args */
	hwaddr = mallocw(at->hwalen);
	/* Destination address */
	(*at->scan)(hwaddr,argv[3]);
	ap = arp_add(addr,hardware,hwaddr,pub);	/* Put in table */
	free(hwaddr);				/* Clean up */
	stop_timer(&ap->timer);			/* Make entry permanent */
	set_timer(&ap->timer,0L);
	return 0;
}
/* Remove an ARP entry */
static
doarpdrop(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 hardware;
	int32 addr;
	struct arp_tab *ap;

	if((addr = resolve(argv[1])) == 0){
		printf(Badhost,argv[1]);
		return 1;
	}
	/* This is a kludge. It really ought to be table driven */
	switch(tolower(argv[2][0])){
	case 'n':
		hardware = ARP_NETROM;
		break;
	case 'e':	/* "ether" */
		hardware = ARP_ETHER;
		break;		
	case 'a':	/* "ax25" */
		switch(tolower(argv[2][1])) {
		case 'x':
			hardware = ARP_AX25;
			break;
		case 'r':
			hardware = ARP_ARCNET;
			break;
		default:
			hardware = 0;
			break;
		}
		break;
	case 'm':	/* "mac appletalk" */
		hardware = ARP_APPLETALK;
		break;
	default:
		hardware = 0;
		break;
	}
	if((ap = arp_lookup(hardware,addr)) == NULLARP)
		return -1;
	arp_drop(ap);
	return 0;	
}
/* Flush all automatic entries in the arp cache */
static int
doarpflush(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct arp_tab *ap;
	struct arp_tab *aptmp;
	int i;

	for(i=0;i<HASHMOD;i++){
		for(ap = Arp_tab[i];ap != NULLARP;ap = aptmp){
			aptmp = ap->next;
			if(dur_timer(&ap->timer) != 0)
				arp_drop(ap);
		}
	}
	return 0;
}

/* Dump ARP table */
static void
dumparp()
{
	register int i;
	register struct arp_tab *ap;
	char e[128];

	printf("received %u badtype %u bogus addr %u reqst in %u replies %u reqst out %u\n",
	 Arp_stat.recv,Arp_stat.badtype,Arp_stat.badaddr,Arp_stat.inreq,
	 Arp_stat.replies,Arp_stat.outreq);

	printf("IP addr         Type           Time Q Addr\n");
	for(i=0;i<HASHMOD;i++){
		for(ap = Arp_tab[i];ap != (struct arp_tab *)NULL;ap = ap->next){
			printf("%-16s",inet_ntoa(ap->ip_addr));
			printf("%-15s",smsg(Arptypes,NHWTYPES,ap->hardware));
			printf("%-5ld",read_timer(&ap->timer)/1000L);
			if(ap->state == ARP_PENDING)
				printf("%-2u",len_q(ap->pending));
			else
				printf("  ");
			if(ap->state == ARP_VALID){
				if(Arp_type[ap->hardware].format != NULL){
					(*Arp_type[ap->hardware].format)(e,ap->hw_addr);
				} else {
					e[0] = '\0';
				}
				printf("%s",e);
			} else {
				printf("[unknown]");
			}
			if(ap->pub)
				printf(" (published)");
			if(printf("\n") == EOF)
				return;
		}
	}
	return;
}
@


1.3
log
@src0501
@
text
@d16 4
a19 4
static int doarpadd __ARGS((int argc,char *argv[],void *p));
static int doarpdrop __ARGS((int argc,char *argv[],void *p));
static int doarpflush __ARGS((int argc,char *argv[],void *p));
static void dumparp __ARGS((void));
d66 1
a66 1
	int16 hardware;
d133 1
a133 1
	int16 hardware;
@


1.2
log
@src0308
@
text
@d76 1
a76 1
		tprintf(Badhost,argv[1]);
d96 1
a96 1
			tprintf("unknown hardware type \"%s\"\n",argv[2]);
d104 1
a104 1
		tprintf("unknown hardware type \"%s\"\n",argv[2]);
d113 1
a113 1
		tprintf("Attach device first\n");
d138 1
a138 1
		tprintf(Badhost,argv[1]);
d203 1
a203 1
	tprintf("received %u badtype %u bogus addr %u reqst in %u replies %u reqst out %u\n",
d207 1
a207 1
	tprintf("IP addr         Type           Time Q Addr\n");
d210 3
a212 3
			tprintf("%-16s",inet_ntoa(ap->ip_addr));
			tprintf("%-15s",smsg(Arptypes,NHWTYPES,ap->hardware));
			tprintf("%-5ld",read_timer(&ap->timer)/1000L);
d214 1
a214 1
				tprintf("%-2u",len_q(ap->pending));
d216 1
a216 1
				tprintf("  ");
d223 1
a223 1
				tprintf("%s",e);
d225 1
a225 1
				tprintf("[unknown]");
d228 2
a229 2
				tprintf(" (published)");
			if(tprintf("\n") == EOF)
@


1.1
log
@Initial revision
@
text
@d175 1
a175 1
int
@
