head	1.9;
access;
symbols;
locks;
comment	@ * @;


1.9
date	93.02.01.10.07.03;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	93.01.04.09.50.30;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.09.07.21.06.29;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.03.13.52.14;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.02.11.12.00;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.05.13.06.25.14;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.27.08.56.20;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.28.02.54.54;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.9
log
@Add casts to MD5Update() args
@
text
@/* System-dependent definitions of various files, spool directories, etc */
#include <stdio.h>
#include <ctype.h>
#include "global.h"
#include "netuser.h"
#include "files.h"
#include "md5.h"

#ifdef	MSDOS
char System[] = "MSDOS";
char *Startup = "/autoexec.net";	/* Initialization file */
char *Userfile = "/ftpusers";	/* Authorized FTP users and passwords */
char *Maillog = "/spool/mail.log";	/* mail log */
char *Mailspool = "/spool/mail";	/* Incoming mail */
char *Mailqdir = "/spool/mqueue";		/* Outgoing mail spool */
char *Mailqueue = "/spool/mqueue/*.wrk";	/* Outgoing mail work files */
char *Routeqdir = "/spool/rqueue";		/* queue for router */
char *Alias = "/alias";		/* the alias file */
char *Dfile = "/domain.txt";	/* Domain cache */
char *Fdir = "/finger";		/* Finger info directory */
char *Arealist = "/spool/areas";/* List of message areas */
char *Helpdir = "/spool/help";	/* Mailbox help file directory */
char *Rewritefile = "/spool/rewrite"; /* Address rewrite file */
char *Newsdir = "/spool/news";		/* News messages and NNTP data */
char *Popusers = "/popusers";		/* POP user and passwd file */
char *Signature = "/spool/signatur"; /* Mail signature file directory */
char *Forwardfile = "/spool/forward.bbs"; /* Mail forwarding file */
char *Historyfile = "/spool/history"; /* Message ID history file */
char *Tmpdir = "/tmp";
char Eol[] = "\r\n";
#define	SEPARATOR	"/"
#endif

#ifdef	UNIX
char System[] = "UNIX";
char *Startup = "./startup.net";	/* Initialization file */
char *Config = "./config.net";	/* Device configuration list */
char *Userfile = "./ftpusers";
char *Mailspool = "./mail";
char *Maillog = "./mail.log";	/* mail log */
char *Mailqdir = "./mqueue";
char *Mailqueue = "./mqueue/*.wrk";
char *Routeqdir = "./rqueue";		/* queue for router */
char *Alias = "./alias";	/* the alias file */
char *Dfile = "./domain.txt";	/* Domain cache */
char *Fdir = "./finger";		/* Finger info directory */
char *Arealist = "./areas";		/* List of message areas */
char *Helpdir = "./help";	/* Mailbox help file directory */
char *Rewritefile = "./rewrite"; /* Address rewrite file */
char *Newsdir = "./news";		/* News messages and NNTP data */
char *Popusers = "./popusers";		/* POP user and passwd file */
char *Signature = "./signatur"; /* Mail signature file directory */
char *Forwardfile = "./forward.bbs"; /* Mail forwarding file */
char *Historyfile = "./history"; /* Message ID history file */
Char *Tmpdir = "/tmp";
#define	SEPARATOR	"/"
char Eol[] = "\n";
#endif

#ifdef	AMIGA
char System[] = "AMIGA";
char *Startup = "TCPIP:net-startup";
char *Config = "TCPIP:config.net";	/* Device configuration list */
char *Userfile = "TCPIP:ftpusers";
char *Mailspool = "TCPIP:spool/mail";
char *Maillog = "TCPIP:spool/mail.log";
char *Mailqdir = "TCPIP:spool/mqueue";
char *Mailqueue = "TCPIP:spool/mqueue/#?.wrk";
char *Routeqdir = "TCPIP:spool/rqueue";		/* queue for router */
char *Alias = "TCPIP:alias";	/* the alias file */
char *Dfile = "TCPIP:domain.txt";	/* Domain cache */
char *Fdir = "TCPIP:finger";		/* Finger info directory */
char *Arealist = "TCPIP:spool/areas";	/* List of message areas */
char *Helpdir = "TCPIP:spool/help";	/* Mailbox help file directory */
char *Rewritefile = "TCPIP:spool/rewrite"; /* Address rewrite file */
char *Newsdir = "TCPIP:spool/news";	/* News messages and NNTP data */
char *Popusers = "TCPIP:/popusers";	/* POP user and passwd file */
char *Signature = "TCPIP:spool/signatur"; /* Mail signature file directory */
char *Forwardfile = "TCPIP:spool/forward.bbs"; /* Mail forwarding file */
char *Historyfile = "TCPIP:spool/history"; /* Message ID history file */
Char *Tmpdir = "TCPIP:tmp";
#define	SEPARATOR	"/"
char Eol[] = "\r\n";
#endif

#ifdef	MAC
char System[] = "MACOS";
char *Startup ="Mikes Hard Disk:net.start";
char *Config = "Mikes Hard Disk:config.net";	/* Device configuration list */
char *Userfile = "Mikes Hard Disk:ftpusers";
char *Mailspool = "Mikes Hard Disk:spool:mail:";
char *Maillog = "Mikes Hard Disk:spool:mail.log:";
char *Mailqdir = "Mikes Hard Disk:spool:mqueue:";
char *Mailqueue = "Mikes Hard Disk:spool:mqueue:*.wrk";
char *Routeqdir = "Mikes Hard Disk:spool/rqueue:";	/* queue for router */
char *Alias = "Mikes Hard Disk:alias";	/* the alias file */
char *Dfile = "Mikes Hard Disk:domain:txt";	/* Domain cache */
char *Fdir = "Mikes Hard Disk:finger";		/* Finger info directory */
char *Arealist = "Mikes Hard Disk:spool/areas";	/* List of message areas */
char *Helpdir = "Mikes Hard Disk:spool/help"; /* Mailbox help file directory */
char *Rewritefile = "Mikes Hard Disk:spool/rewrite"; /* Address rewrite file */
char *Newsdir = "Mikes Hard Disk:spool/news"; /* News messages and NNTP data */
char *Popusers = "Mikes Hard Disk:/popusers";	/* POP user and passwd file */
char *Signature = "Mikes Hard Disk:spool/signatur"; /* Mail signature file directory */
char *Forwardfile = "Mikes Hard Disk:spool/forward.bbs"; /* Mail forwarding file */
char *Historyfile = "Mikes Hard Disk:spool/history"; /* Message ID history file */
Char *Tmpdir = "Mikes Hard Disk:tmp";
#define	SEPARATOR	"/"
char Eol[] = "\r";
#endif

static char *rootdir = "";

/* Establish a root directory other than the default. Can only be called
 * once, at startup time
 */
void
initroot(root)
char *root;
{
	rootdir = strdup( root );

	Startup = rootdircat(Startup);
	Userfile = rootdircat(Userfile);
	Maillog = rootdircat(Maillog);
	Mailspool = rootdircat(Mailspool);
	Mailqdir = rootdircat(Mailqdir);
	Mailqueue = rootdircat(Mailqueue);
	Routeqdir = rootdircat(Routeqdir);
	Alias = rootdircat(Alias);
	Dfile = rootdircat(Dfile);
	Fdir = rootdircat(Fdir);
	Arealist = rootdircat(Arealist);
	Helpdir = rootdircat(Helpdir);
	Rewritefile = rootdircat(Rewritefile);
	Newsdir = rootdircat(Newsdir);
	Signature = rootdircat(Signature);
	Forwardfile = rootdircat(Forwardfile);
	Historyfile = rootdircat(Historyfile);
}

/* Concatenate root, separator and arg strings into a malloc'ed output
 * buffer, then remove repeated occurrences of the separator char
 */
char *
rootdircat(filename)
char *filename;
{
	char *out = filename;

	if ( strlen(rootdir) > 0 ) {
		char *separator = SEPARATOR;

		out = mallocw( strlen(rootdir)
				+ strlen(separator)
				+ strlen(filename) + 1);

		strcpy(out,rootdir);
		strcat(out,separator);
		strcat(out,filename);
		if(*separator != '\0'){
			char *p1, *p2;

			/* Remove any repeated occurrences */
			p1 = p2 = out;
			while(*p2 != '\0'){
				*p1++ = *p2++;
				while(p2[0] == p2[-1] && p2[0] == *separator)
					p2++;
			}
			*p1 = '\0';
		}
	}
	return out;
}

/* Read through FTPUSERS looking for user record
 * Returns line which matches username, or NULLCHAR when no match.
 * Each of the other variables must be copied before freeing the line.
 */
char *
userlookup(username,password,directory,permission,ip_address)
char *username;
char **password;
char **directory;
int   *permission;
int32 *ip_address;
{
	FILE *fp;
	char *buf;
	char *cp;

	if((fp = fopen(Userfile,READ_TEXT)) == NULLFILE)
		/* Userfile doesn't exist */
		return NULLCHAR;

	buf = mallocw(BUFSIZ);
	while ( fgets(buf,BUFSIZ,fp) != NULLCHAR ){
		if(*buf == '#')
			continue;	/* Comment */

		if((cp = strchr(buf,' ')) == NULLCHAR)
			/* Bogus entry */
			continue;
		*cp++ = '\0';		/* Now points to password */

		if( stricmp(username,buf) == 0 )
			break;		/* Found user */
	}
	if(feof(fp)){
		/* username not found in file */
		fclose(fp);
		free(buf);
		return NULLCHAR;
	}
	fclose(fp);

	if ( password != NULL )
		*password = cp;

	/* Look for space after password field in file */
	if((cp = strchr(cp,' ')) == NULLCHAR) {
		/* Invalid file entry */
		free(buf);
		return NULLCHAR;
	}
	*cp++ = '\0';	/* Now points to directory field */

	if ( directory != NULL )
		*directory = cp;

	if((cp = strchr(cp,' ')) == NULLCHAR) {
		/* Permission field missing */
		free(buf);
		return NULLCHAR;
	}
	*cp++ = '\0';	/* now points to permission field */

	if ( permission != NULL )
		*permission = (int)strtol( cp, NULLCHARP, 0 );

	if((cp = strchr(cp,' ')) == NULLCHAR) {
		/* IP address missing */
		if ( ip_address != NULL )
			*ip_address = 0L;
	} else {
		*cp++ = '\0';	/* now points at IP address field */
		if ( ip_address != NULL )
			*ip_address = resolve( cp );
	}
	return buf;
}

/* Subroutine for logging in the user whose name is name and password is pass.
 * The buffer path should be long enough to keep a line from the userfile.
 * If pwdignore is true, the password check will be overridden.
 * The return value is the permissions field or -1 if the login failed.
 * Path is set to point at the path field, and pwdignore will be true if no
 * particular password was needed for this user.
 */
int
userlogin(name,pass,path,len,pwdignore)
char *name;
char *pass;
char **path;
int len;			/* Length of buffer pointed at by *path */
int *pwdignore;
{
	char *buf;
	char *password;
	char *directory;
	int permission;
	int anonymous;
	char *cp;
	char hashpass[16];
	MD5_CTX md;

	if ( (buf = userlookup( name, &password, &directory,
			&permission, NULL )) == NULLCHAR ) {
		return -1;
	}

	anonymous = *pwdignore;
	if(strcmp(password,"*") == 0){
		anonymous = TRUE;	/* User ID is password-free */
	} else {
		if(readhex(hashpass,password,sizeof(hashpass)) != sizeof(hashpass)){
			/* Invalid hashed password in file */
			free(buf);
			return -1;
		}
		MD5Init(&md);
		MD5Update(&md,(unsigned char *)name,strlen(name));
		MD5Update(&md,(unsigned char *)pass,strlen(pass));
		MD5Final(&md);
		if(memcmp(&md.digest,hashpass,sizeof(hashpass)) != 0){
			/* Incorrect password given */
			free(buf);
			return -1;
		}
	}
	if ( strlen( directory ) + 1 > len ) {
		/* not enough room for path */
		free(buf);
		return -1;
	}

#if   defined(AMIGA)
	/*
	 * Well, on the Amiga, a file can be referenced by many names:
	 * device names (DF0:) or volume names (My_Disk:).  This hunk of code
	 * passed the pathname specified in the ftpusers file, and gets the
	 * absolute path copied into the user's buffer.  We really should just
	 * allocate the buffer and return a pointer to it, since the caller
	 * really doesn't have a good idea how long the path string is..
	 */
	if ( (directory = pathname("", directory)) != NULLCHAR ) {
		strcpy(*path, directory);
		free(directory);
	} else {
		**path = '\0';
	}
#else
	strcpy(*path,directory);
	/* Convert any backslashes to forward slashes, for backward
	 * compatibility with the old NET
	 */
	while((cp = strchr(*path,'\\')) != NULLCHAR)
		*cp = '/';
#endif
	free(buf);
	*pwdignore = anonymous;
	/* Finally return the permission bits */
	return permission;
}
/* MD5 hash plaintext passwords in user file */
void
usercvt()
{
	FILE *fp,*fptmp;
	char *buf;
	char hexbuf[16];
	int needsit = 0;
	int len,nlen,plen,i;
	char *pass;
	MD5_CTX md;

	if((fp = fopen(Userfile,READ_TEXT)) == NULLFILE)
		return;		/* Userfile doesn't exist */

	buf = mallocw(BUFSIZ);
	while(fgets(buf,BUFSIZ,fp) != NULLCHAR){
		rip(buf);
		len = strlen(buf);
		if(len == 0 || *buf == '#')
			continue;	/* Blank or comment line */

		if((nlen = strcspn(buf,Whitespace)) == len)
			continue;	/* No end to the name! */

		/* Skip whitespace between name and pass */
		for(pass=&buf[nlen];isspace(*pass);pass++)
			;
		if(*pass != '\0' && *pass != '*'
		 && readhex(hexbuf,pass,sizeof(hexbuf)) != 16){
			needsit = 1;
			break;
		}
	}
	if(!needsit){
		/* Everything is in order */
		fclose(fp);
		free(buf);
		return;
	}
	/* At least one entry needs its password hashed */
	rewind(fp);
	fptmp = tmpfile();
	while(fgets(buf,BUFSIZ,fp) != NULLCHAR){
		rip(buf);
		if((len = strlen(buf)) == 0 || *buf == '#'
		 || (nlen = strcspn(buf,Whitespace)) == len){
			/* Line is blank, a comment or unparseable;
			 * copy unchanged
			 */
			fputs(buf,fptmp);
			fputc('\n',fptmp);
			continue;
		}
		/* Skip whitespace between name and pass */
		for(pass=&buf[nlen];isspace(*pass);pass++)
			;

		if(*pass == '\0' || *pass == '*'
		 || (plen = strcspn(pass,Whitespace)) == strlen(pass)
		 || readhex(hexbuf,pass,sizeof(hexbuf)) == sizeof(hexbuf)){
			/* Other fields are missing, no password is required,
			 * or password is already hashed; copy unchanged
			 */
			fputs(buf,fptmp);
			fputc('\n',fptmp);
			continue;
		}
		MD5Init(&md);
		MD5Update(&md,(unsigned char *)buf,nlen);	/* Hash name */
		MD5Update(&md,(unsigned char *)pass,plen);	/* Hash password */
		MD5Final(&md);
		fwrite(buf,1,nlen,fptmp);	/* Write name */
		fputc(' ',fptmp);		/* and space */
		for(i=0;i<16;i++)	/* Write hashed password */
			fprintf(fptmp,"%02x",md.digest[i] & 0xff);
		fputs(&pass[plen],fptmp);	/* Write remainder of line */
		fputc('\n',fptmp);
	}
	/* Now copy the temp file back into the userfile */
	fclose(fp);
	rewind(fptmp);
	if((fp = fopen(Userfile,WRITE_TEXT)) == NULLFILE){
		printf("Can't rewrite %s\n",Userfile);
		free(buf);
		return;
	}
	while(fgets(buf,BUFSIZ,fptmp) != NULLCHAR)
		fputs(buf,fp);
	fclose(fp);
	fclose(fptmp);
	free(buf);
}
@


1.8
log
@Major change - passwords are now kept in /ftpusers in hashed
form. The input to the hash function is the concatenation of
the user's name and his plaintext password, without a space
between the two and without a trailing newline. The hash function
is MD-5, and the hex-ascii representation is stored in the password
field of the /ftpusers file entry.
The /ftpusers file is scanned at startup, and any plaintext passwords
found are automatically hashed. Comment lines and bogus lines are
unchanged.
@
text
@d293 2
a294 2
		MD5Update(&md,name,strlen(name));
		MD5Update(&md,pass,strlen(pass));
d405 2
a406 2
		MD5Update(&md,buf,nlen);	/* Hash name */
		MD5Update(&md,pass,plen);	/* Hash password */
@


1.7
log
@Add System[] variable
@
text
@d3 1
d7 1
d197 2
a198 2
	buf = mallocw(128);
	while ( fgets(buf,128,fp) != NULLCHAR ){
d275 3
d284 1
a284 1
	if ( strcmp(password,"*") == 0 )
d286 15
a300 5

	if(!anonymous && strcmp(password,pass) != 0) {
		/* Password required, but wrong one given */
		free(buf);
		return -1;
a301 1

d336 14
d351 78
@


1.6
log
@src0505
@
text
@d8 1
d33 1
d59 1
d85 1
@


1.5
log
@src0503
@
text
@d26 1
a26 1
char *Tmpdir = "/tmp/";		/* Note trailing slash */
d51 1
a51 1
Char *Tmpdir = "/tmp/";
d76 1
a76 1
Char *Tmpdir = "TCPIP:tmp/";
d101 2
a102 2
Char *Tmpdir = "Mikes Hard Disk:tmp/";
#define	SEPARATOR	":"
@


1.4
log
@src0531
@
text
@d26 1
d51 1
d76 1
d101 1
@


1.3
log
@src0420
@
text
@d22 1
d46 1
d70 1
d94 1
@


1.2
log
@src0318
@
text
@d232 4
a236 5
	*cp++ = '\0';	/* now points at IP address field */

	if ( ip_address != NULL )
		*ip_address = resolve( cp );

a260 1

@


1.1
log
@Initial revision
@
text
@d2 1
d4 1
a24 1
char *PPPhosts = "/ppphosts";	/* peer ID to IP address lookup table */
a47 1
char *PPPhosts = "./ppphosts";	/* peer ID to IP address lookup table */
a70 1
char *PPPhosts = "TCPIP:ppphosts";	/* peer ID to IP address lookup table */
a93 1
char *PPPhosts = "Mikes Hard Disk:ppphosts";	/* peer ID to IP address lookup table */
d98 1
a98 1
static char *strcatdup __ARGS((char *a,char *b,char *c));
d107 19
a125 18
	Startup = strcatdup(root,SEPARATOR,Startup);
	Userfile = strcatdup(root,SEPARATOR,Userfile);
	Maillog = strcatdup(root,SEPARATOR,Maillog);
	Mailspool = strcatdup(root,SEPARATOR,Mailspool);
	Mailqdir = strcatdup(root,SEPARATOR,Mailqdir);
	Mailqueue = strcatdup(root,SEPARATOR,Mailqueue);
	Routeqdir = strcatdup(root,SEPARATOR,Routeqdir);
	Alias = strcatdup(root,SEPARATOR,Alias);
	Dfile = strcatdup(root,SEPARATOR,Dfile);
	Fdir = strcatdup(root,SEPARATOR,Fdir);
	Arealist = strcatdup(root,SEPARATOR,Arealist);
	Helpdir = strcatdup(root,SEPARATOR,Helpdir);
	Rewritefile = strcatdup(root,SEPARATOR,Rewritefile);
	Newsdir = strcatdup(root,SEPARATOR,Newsdir);
	Signature = strcatdup(root,SEPARATOR,Signature);
	Forwardfile = strcatdup(root,SEPARATOR,Forwardfile);
	Historyfile = strcatdup(root,SEPARATOR,Historyfile);
	PPPhosts = strcatdup(root,SEPARATOR,PPPhosts);
d131 3
a133 3
static char *
strcatdup(a,b,c)
char *a,*b,*c;
d135 8
a142 1
	char *out,*p1,*p2;
d144 14
a157 11
	out = mallocw(strlen(a) + strlen(b) + strlen(c) + 1);
	strcpy(out,a);
	strcat(out,b);
	strcat(out,c);
	if(*b != '\0'){
		/* Remove any repeated occurrences of the separator char */
		p1 = p2 = out;
		while(*p2 != '\0'){
			*p1++ = *p2++;
			while(p2[0] == p2[-1] && p2[0] == b[0])
				p2++;
a158 1
		*p1 = '\0';
d161 150
@
