head	1.15;
access;
symbols;
locks;
comment	@ * @;


1.15
date	93.05.06.10.08.41;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	93.01.10.23.20.17;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.10.07.19.30.53;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.06.07.08.51.46;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.05.15.10.00.48;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.01.08.21.32;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.04.29.11.47.44;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.04.19.06.54.38;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.04.03.23.57.42;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.01.13.54.28;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.03.29.03.10.00;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.03.27.12.58.16;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.02.11.20.14.12;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.03.10.15.26;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.30.10.02.56;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.15
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Interface driver for the DRSI PCPA or the Eagle 8530 boards for the IBM PC
 * connected to a WA4DSY 56kbps modem. Uses polling-loop transfers with
 * interrupts disabled for maximum speed.
 *
 * This driver is a bit of a kludge. A DMA-driven card and driver (e.g.,
 * the PI) is much better, but this is better than nothing if all you have
 * is a "dumb" 8530 card.
 *
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include <dos.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "pktdrvr.h"
#include "netuser.h"
#include "hs.h"
#include "z8530.h"
#include "ax25.h"
#include "trace.h"
#include "pc.h"
#include "proc.h"
#include "devparam.h"

static void flushrx(uint16 data);
static void hdlcparam(struct hdlc *hp);
static void hexint(struct hdlc *hp);
static void hrxint(struct hdlc *hp);
static int hs_stop(struct iface *iface);
static int hs_raw(struct iface *iface,struct mbuf *bp);
static int32 hs_ctl(struct iface *,int cmd,int set,int32 val);
static void hstxoff(struct hdlc *hp);
static void hstxon(struct hdlc *hp);
static void htxint(struct hdlc *hp);
static void init_delay(void);
static void msdelay(void);

static struct hs Hs[NHS];
static INTERRUPT (*Hshandle[])() = { hs0vec };
static struct hdlc Hdlc[2*NHS];
static uint16 Nhs;

/* Master interrupt handler for the PC-100 card. All interrupts come
 * here first, then are switched out to the appropriate routine.
 */
INTERRUPT (far *(hsint)(dev))()
int dev;
{
	register char iv;
	uint16 hsbase;
	struct hs *hsp;
	register struct hdlc *hp;
	
	hsp = &Hs[dev];
	hsp->ints++;
	hsbase = hsp->addr;

#ifdef	foo
	outportb(hsbase+4,0x8+0x10);	/* HIT EAGLE INTACK */
	(void)inportb(hsbase+CHANA+CTL,R0);
	outportb(hsbase+4,0x8);		/***/
#endif

	/* Read interrupt status from channel A */
	while((iv = read_scc(hsbase+CHANA+CTL,R3)) != 0){
		if(iv & CHARxIP){
			/* Channel A Rcv Interrupt Pending */
			hp = &Hdlc[2*dev];
			hrxint(hp);
		} else if(iv & CHATxIP){
			/* Channel A Transmit Int Pending */
			hp = &Hdlc[2*dev];
			htxint(hp);
		} else if(iv & CHAEXT){
			/* Channel A External Status Int */
			hp = &Hdlc[2*dev];
			hexint(hp);
		} else if(iv & CHBRxIP){
			/* Channel B Rcv Interrupt Pending */
			hp = &Hdlc[(2*dev)+1];
			hrxint(hp);
		} else if(iv & CHBTxIP){
			/* Channel B Transmit Int Pending */
			hp = &Hdlc[(2*dev)+1];
			htxint(hp);
		} else if(iv & CHBEXT){
			/* Channel B External Status Int */
			hp = &Hdlc[(2*dev)+1];
			hexint(hp);
		}
		/* Reset interrupt pending state */
		write_scc(hp->ctl,R0,RES_H_IUS);
		outportb(hsbase+CHANA+CTL,0);	/* Restore pointer to 0 */
		outportb(hsbase+CHANB+CTL,0);	/* Restore pointer to 0 */
	}
	outportb(hsbase+CHANA+CTL,0);	/* Restore pointer to 0 */
	outportb(hsbase+CHANB+CTL,0);	/* Restore pointer to 0 */
	return hsp->chain ? hsp->save.vec : NULL;
}
/* HDLC SIO External/Status interrupts
 * The only one that can happen in this driver is a DCD change
 */
static void
hexint(hp)
register struct hdlc *hp;
{
	struct mbuf *rcvbuf;
	char *cp;
	int cnt,data;
	register int ctl;

	ctl = hp->ctl;
	data = hp->data;
	hp->exints++;

	/* Allocate a receive buffer */
	if((rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct iface *))) == NULLBUF){
		/* Alloc failed; refuse to proceed */
		hp->nomem++;
		write_scc(ctl,R3,ENT_HM|RxENABLE|RxCRC_ENAB|Rx8);
		write_scc(ctl,R0,RES_EXT_INT);
		return;
	}
	/* Allow space for descriptor on front */
	rcvbuf->data += sizeof(struct iface *);
	cnt = 0;

	/* Disable DCDIE bit so we can track changes in DCD */
	write_scc(ctl,R15,0);

	write_scc(ctl,R3,ENT_HM|RxENABLE|RxCRC_ENAB|Rx8);
	flushrx(data);
	while((cnt = rx8530(ctl,data,cp,hp->bufsiz)) != -1){
		if(cnt > 4){
			/* Good frame */
			hp->good++;
			/* Toss crc */
			rcvbuf->cnt = cnt - 1;
			net_route(hp->iface,rcvbuf);
			/* Replenish buffer */
			rcvbuf = alloc_mbuf(hp->bufsiz + sizeof(struct iface *));
		}
		/* Start new buffer */
		if(rcvbuf == NULLBUF)
			break;	/* alloc failed */
		rcvbuf->data +=  sizeof(struct iface *);
	}	
	write_scc(ctl,R0,RES_EXT_INT);
	write_scc(ctl,R15,DCDIE);	/* Re-enable DCD */
	write_scc(ctl,R3,ENT_HM|RxENABLE|RxCRC_ENAB|Rx8);

	/* Get rid of fragmentary buffer */
	free_p(rcvbuf);
}
static void
flushrx(data)
register uint16 data;
{
	register int i = 5;
	while(i-- != 0)
		(void)inportb(data);
}
/* HDLC receiver interrupt handler.
 * Not used in this driver
 */
static void
hrxint(hp)
register struct hdlc *hp;
{
}
/* HDLC transmit interrupt service routine
 * Not used in this driver
 */
static void
htxint(hp)
register struct hdlc *hp;
{
}

/* (re)Initialize HDLC controller parameters */
static void
hdlcparam(hp)
register struct hdlc *hp;
{
	register uint16 ctl;
	int i_state;

	/* Initialize 8530 channel for SDLC operation */
	ctl = hp->ctl;
	i_state = dirps();

#ifdef	foo
	switch(ctl & 2){
	case CHANA:
		write_scc(ctl,R9,CHRA);	/* Reset channel A */
		break;
	case CHANB:
		write_scc(ctl,R9,CHRB);	/* Reset channel B */
		break;
	}
	pause(1L);	/* Allow plenty of time for resetting */
#endif

	/* Deselect interrupts for now */
	write_scc(ctl,R1,0);
	write_scc(ctl,R15,0);

	/* X1 clock, SDLC mode, Sync modes enable, parity disable */
	write_scc(ctl,R4,X1CLK | SDLC | SYNC_ENAB);

	/* CRC preset 1, NRZ encoding, no active on poll, flag idle,
	 * flag on underrun, no loop mode, 8 bit sync
	 */
	write_scc(ctl,R10,CRCPS|NRZ);

	/* 8530 gets both tx and rx clock from modem.
	 * By default, TRxC = transmit clock, RTxC = receive clock
	 * (swapped 11 Feb 1990 to use new DRSI wiring) UNLESS
	 * the 'r' parameter is specified
	 */
	if(!hp->clkrev)
		write_scc(ctl,R11,RCRTxCP | TCTRxCP);
	else
		write_scc(ctl,R11,RCTRxCP | TCRTxCP);

	/* Note: baud rate generator not used */

	/* Null out SDLC start address */
	write_scc(ctl,R6,0);

	/* SDLC flag */
	write_scc(ctl,R7,FLAG);

	/* DTR On, 8 bit TX chars, no break, TX enable, SDLC CRC,
	 * RTS off, TxCRC enable
	 */
	write_scc(ctl,R5,DTR|Tx8|TxENAB|TxCRC_ENAB);

	/* 8 bit RX chars, auto enables off, no hunt mode, RxCRC enable,
	 * no address search, no inhibit sync chars, disable RX. Rx is
	 * started only by an actual DCD interrupt
	 */
	write_scc(ctl,R3,RxENABLE|RxCRC_ENAB|Rx8);

	/* Dummy interrupt vector
	 * (This probably isn't necessary)
	 */
	write_scc(ctl,R2,0);

	/* Enable only the external interrupts (modem interrupts) since
	 * polling is used for all actual tx/rx operations
	 */
	write_scc(ctl,R1,EXT_INT_ENAB);

	/* Enable only DCD interrupts */
	write_scc(ctl,R15,DCDIE);

	/* No reset, status low, master int enable, enable lower chain,
	 * no vector
	 */
	write_scc(ctl,R9,MIE|NV);

	restore(i_state);
}
/* Attach a high speed iterface to the system
 * argv[0]: hardware type, must be "hs"
 * argv[1]: I/O address, e.g., "0x380"
 * argv[2]: vector, e.g., "2"
 * argv[3]: mode, must be "ax25"
 * argv[4]: interface base label, e.g., "drsi0". Driver appends "a" and "b".
 * argv[5]: receiver packet buffer size in bytes
 * argv[6]: maximum transmission unit, bytes
 * argv[7]: keyup delay, milliseconds
 * argv[8]: persistence value, 0-255
 * argv[9]: "r" to reverse sense of clock leads (optional)
 */
int
hs_attach(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *if_hsa,*if_hsb;
	struct hdlc *hp;
	int dev;
	char *cp;

	if(Nhs >= NHS){
		printf("Too many hs controllers\n");
		return -1;
	}
	if(if_lookup(argv[4]) != NULLIF){
		printf("Interface %s already exists\n",argv[4]);
		return -1;
	}
	if(setencap(NULLIF,argv[3]) == -1){
		printf("Unknown encapsulation %s\n",argv[3]);
		return -1;
	}
	if(Mycall[0] == '\0'){
		printf("set mycall first\n");
		return -1;
	}		
	dev = Nhs++;

	/* Initialize hardware-level control structure */
	Hs[dev].addr = htoi(argv[1]);
	Hs[dev].vec = atoi(argv[2]);
	if(strchr(argv[2],'c') != NULLCHAR)
		Hs[dev].chain = 1;
	else
		Hs[dev].chain = 0;

	/* Save original interrupt vector */
	Hs[dev].save.vec = getirq(Hs[dev].vec);
	/* Set new interrupt vector */
	if(setirq(Hs[dev].vec,Hshandle[dev]) == -1){
		printf("IRQ %u out of range\n",Hs[dev].vec);
		Nhs--;
		return -1;
	}
	/* Create interface structures and fill in details */
	if_hsa = (struct iface *)callocw(1,sizeof(struct iface));
	if_hsb = (struct iface *)callocw(1,sizeof(struct iface));

	if_hsa->addr = if_hsb->addr = Ip_addr;
	if_hsa->name = mallocw(strlen(argv[4])+2);
	strcpy(if_hsa->name,argv[4]);
	strcat(if_hsa->name,"a");
	if_hsb->name = mallocw(strlen(argv[4])+2);
	strcpy(if_hsb->name,argv[4]);
	strcat(if_hsb->name,"b");
	if_hsb->mtu = if_hsa->mtu = atoi(argv[6]);
	if_hsa->dev = 2*dev;
	if_hsb->dev = 2*dev + 1;
	if_hsb->stop = if_hsa->stop = hs_stop;
	if_hsb->raw = if_hsa->raw = hs_raw;
	if_hsa->ioctl = if_hsb->ioctl = hs_ctl;

	setencap(if_hsa,argv[3]);
	setencap(if_hsb,argv[3]);
	if(if_hsb->hwaddr == NULLCHAR)
		if_hsb->hwaddr = mallocw(AXALEN);
	memcpy(if_hsb->hwaddr,Mycall,AXALEN);
	if(if_hsa->hwaddr == NULLCHAR)
		if_hsa->hwaddr = mallocw(AXALEN);
	memcpy(if_hsa->hwaddr,Mycall,AXALEN);
	if_hsa->next = if_hsb;
	if_hsb->next = Ifaces;
	Ifaces = if_hsa;

	write_scc(Hs[dev].addr+CHANA+CTL,R9,FHWRES);
	hp = &Hdlc[2*dev+1];
	hp->ctl = Hs[dev].addr + CHANB + CTL;
	hp->data = Hs[dev].addr + CHANB + DATA;
	hp->bufsiz = atoi(argv[5]);
	if(argc > 7)
		hp->txdelay = atol(argv[7]);
	else
		hp->txdelay = 15L;
	if(argc > 8)
		hp->p = atoi(argv[8]);
	else
		hp->p = 64;
	if(argc > 9 && argv[9][0] == 'r')
		hp->clkrev = 1;
	else
		hp->clkrev = 0;
	hp->iface = if_hsb;
	hdlcparam(hp);

	hp = &Hdlc[2*dev];
	hp->ctl = Hs[dev].addr + CHANA + CTL;
	hp->data = Hs[dev].addr + CHANA + DATA;
	hp->bufsiz = atoi(argv[5]);
	hp->txdelay = Hdlc[2*dev+1].txdelay;
	hp->p = Hdlc[2*dev+1].p;
	if(argc > 9 && argv[9][0] == 'r')
		hp->clkrev = 1;
	else
		hp->clkrev = 0;
	hp->iface = if_hsa;
	hdlcparam(hp);

	outportb(Hs[dev].addr + 4,0x08);	/*EAGLE INT GATE */
	/* Clear mask (enable interrupt) in 8259 interrupt controller */
	maskon(Hs[dev].vec);

	/* Initialize timing delay loop */
	init_delay();
	cp = if_name(if_hsa," tx");
	if_hsa->txproc = newproc(cp,512,if_tx,0,if_hsa,NULL,0);
	free(cp);
	cp = if_name(if_hsb," tx");
	if_hsb->txproc = newproc(cp,512,if_tx,0,if_hsb,NULL,0);
	free(cp);
	return 0;
}
static int
hs_stop(iface)
struct iface *iface;
{
	int dev;

	dev = iface->dev;
	if(dev & 1)
		return -1;	/* Valid only for the first device */
	dev >>= 1;	/* Convert back into hs number */

	/* Turn off interrupts */
	maskoff(Hs[dev].vec);

	/* Restore original interrupt vector */
	setirq(Hs[dev].vec,Hs[dev].save.vec);

	/* Force hardware reset */
	write_scc(Hs[dev].addr + CHANA+CTL,R9,FHWRES);
	return 0;
}
/* Send raw packet */
static int
hs_raw(iface,bp)
struct iface *iface;
struct mbuf *bp;
{

	struct hdlc *hp;
	struct mbuf *nbp;
	register uint16 cnt;
	register char *cp;
	uint16 ctl,data;

	dump(iface,IF_TRACE_OUT,bp);
	iface->rawsndcnt++;
	iface->lastsent = secclock();
	hp = &Hdlc[iface->dev];
	hp->txpkts++;

	ctl = hp->ctl;
	data = hp->data;

	cnt = len_p(bp);
	/* If buffer isn't contiguous (which is almost always
	 * the case) copy it to a new buffer for speed
	 */
	if(bp->next != NULLBUF){
		if((nbp = copy_p(bp,cnt)) == NULLBUF){
			hp->nomem++;
			free_p(bp);
			return -1;
		}
		free_p(bp);
		bp = nbp;
	}
	cp = bp->data;
	/* Turn transmitter on */
	hstxon(hp);
	/* Initialize transmitter CRC */
	write_scc(ctl,R0,RES_Tx_CRC);
	for(;;){
		/* Wait for the transmitter to become ready */
		while(!(inportb(ctl) & Tx_BUF_EMP))
			;
		if(cnt-- == 0)
			break;
		outportb(data,*cp++); /* Send the character */
	}
	write_scc(ctl,R0,RES_EOM_L);	/* Allow CRC generation */
	/* End of frame. Wait for TxEOM to go high, indicating start of
	 * CRC transmission. Note that we don't reset the transmit
	 * interrupt pending flag as one ordinarily would, since we're
	 * not using tx interrupts.
	 */
	while(!(inportb(ctl) & TxEOM))
		;

	free_p(bp);
	hstxoff(hp);	/* Shut down tx */
	/* Hold off to give other guy a chance to
	 * respond
	 */
	hp->deftime = msclock() + hp->txdelay + 500;
	return 0;
}

/* Turn on high speed transmitter. Does p-persistence, then sends a dummy
 * frame to allow for keyup delay. Returns with transmitter on and interrupts
 * disabled
 */
static void
hstxon(hp)
struct hdlc *hp;
{
	uint16 ctl;
	int i;
	long ca;
	int32 t;

	ctl = hp->ctl;

	/* Defer logic. Wait until deftime is in the past (so we
	 * defer to any overheard CTS messages) AND the p-persistence
	 * dice roll succeeds. The computation of ca allows for clock
	 * rollover (which happens every 49+ days).
	 */
	for(;;){
		t = msclock();
		ca = hp->deftime - t;
		if(ca > 0){
			pause(ca);
			continue;
		}
		hp->deftime = t;	/* Keep from getting too old */
		if((rand() & 0xff) > uchar(hp->p)){
			pause((long)MSPTICK);
			continue;
		}
		break;
	}
	/* Prevent distractions. In particular, block off the DCD interrupt
	 * so we don't hear our own carrier and hang in the interrupt handler!
	 * Note that simply disabling CPU interrupts isn't enough since
	 * the call to pause will block and the kernel will re-enable
	 * them.
	 */
	write_scc(ctl,R9,0);	/* Disable all SCC interrupts */
	disable();

	/* Turn on carrier, enable transmitter */
	write_scc(ctl,R5,TxCRC_ENAB | RTS | TxENAB | Tx8 | DTR);

	/* Delay for keyup interval */
	for(i=hp->txdelay;i != 0;i--)
		msdelay();

}
/* Turn transmitter off at the end of a series of frames */
static void
hstxoff(hp)
struct hdlc *hp;
{
	int cnt;
	uint16 ctl,data;

	ctl = hp->ctl;
	data = hp->data;
	/* To allow the SCC buffering to drain, we begin a dummy frame,
	 * then abort it
	 */
	for(cnt=5;cnt != 0;cnt--){
		while(!(inportb(ctl) & Tx_BUF_EMP))
			;
		outportb(data,0);
	}
	write_scc(ctl,R0,SEND_ABORT);

	/* Turn off carrier and disable transmitter */
	write_scc(ctl,R5,TxCRC_ENAB | Tx8 | DTR);
	/* Re-Enable SCC interrupts */
	write_scc(ctl,R9,MIE|NV);		
	enable();	/* Turn interrupts back on */
}

int
dohs(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register int i;
	register struct hdlc *hp;

	for(i=0;i<2*Nhs;i++){
		hp = &Hdlc[i];
		if(printf("port %d: txpkts %lu ints %lu rxpkts %lu rxbytes %lu nomem %lu toobig %lu crcerr %lu aborts %lu overrun %lu\n",
		 i,hp->txpkts,hp->exints,hp->good,hp->rxbytes,
		 hp->nomem,hp->toobig,hp->crcerr,hp->aborts,
		 hp->overrun) == EOF)
			break;
	}
	return 0;
}
static int32
hs_ctl(iface,cmd,set,val)
struct iface *iface;
int cmd;
int set;
int32 val;
{
	register struct hdlc *hp;
	int32 t,ca;

	hp = &Hdlc[iface->dev];
	switch(cmd){
	case PARAM_TXDELAY:	/* Tx keyup delay */
		if(set)
			hp->txdelay = val;
		return hp->txdelay;
	case PARAM_PERSIST:
		if(set)
			hp->p = val;
		return uchar(hp->p);
	case PARAM_MUTE:
		/* Mute transmitter for specified # of ms */
		if(set){
			if(val == -1){
				/* Special case for duration of a CTS */
				val = hp->txdelay + 500;
			}
			hp->deftime = msclock() + val;
		}
		t = msclock();
		ca = hp->deftime - t;
		if(ca < 0){
			hp->deftime = t;
			ca = 0;
		}
		return ca;
	}
	return -1;
}
#ifdef	notdef		/* replaced with assembler in 8530.asm */
/* Read data from the 8530 receiver.
 * Returns when either a good frame is received, or when carrier drops.
 * If a good frame is received, the length is returned; otherwise -1.
 */
int
rx8530(ctl,data,buf,bufsize)
uint16 ctl,data;
char *buf;
uint16 bufsize;
{
	int cnt = 0;
	register char status;
	char error;
	register char *cp = buf;

	for(;;){
		status = inportb(ctl);
		if(!(status & DCD)){
			cnt = -1;
			break;
		} else if(status & BRK_ABRT){
			cp = buf;
			cnt = 0;
		} else if(status & Rx_CH_AV){
			/* Receive character is ready, get it */
			*cp++ = inportb(data);
			if(++cnt > bufsize){
				/* Buffer overflow, start again */
				write_scc(ctl,R3,ENT_HM|RxENABLE|RxCRC_ENAB|Rx8);
				cp = buf;
				cnt = 0;
			}
		} else if((error = read_scc(ctl,R1)) & END_FR){
			if(!(error & CRC_ERR))
				break;	/* Good frame! */
			/* Bad frame, start again */
			cp = buf;
			cnt = 0;
		}
	}
	return cnt;
}
#endif

static int32 Del_const;

/* Find the value of Del_const that will cause one execution of mloop()
 * to take one millisecond
 */
static void
init_delay()
{
	int32 start,delay;
	register int i,j;
	int success = 0;

	/* Start with small value to make things tolerable on slow machines */
	Del_const = 10;
	printf("Del_const = %lu\n",Del_const);
	/* Limit the number of iterations in case we don't converge */
	for(i=0;i<5;i++){
		start = msclock();
		for(j=0;j<1000;j++)
			msdelay();
		delay = msclock()-start;
		printf("delay %lu\n",delay);
		if(delay == 0){
			/* Too fast for accurate measurement on coarse clk */	
			Del_const *= 10;
			printf("Del_const = %lu\n",Del_const);
			continue;
		}
		Del_const = (Del_const * 1000)/delay;
		printf("Del_const = %lu\n",Del_const);
		if(delay > 950 && delay < 1050){
			success = 1;
			break;	/* Within 1 tick - Close enough */
		}
	}
	if(!success)
		printf("HS: Warning: auto delay set failed\n");
}
/* Delay for one millisecond (once calibrated by init_delay()) */
static void
msdelay()
{
	int32 i;

	for(i=Del_const;i !=0;i--)
		;
}
@


1.14
log
@Go back to dirps/restore, remove pragma inline
@
text
@d26 12
a37 12
static void flushrx __ARGS((int16 data));
static void hdlcparam __ARGS((struct hdlc *hp));
static void hexint __ARGS((struct hdlc *hp));
static void hrxint __ARGS((struct hdlc *hp));
static int hs_stop __ARGS((struct iface *iface));
static int hs_raw __ARGS((struct iface *iface,struct mbuf *bp));
static int32 hs_ctl __ARGS((struct iface *,int cmd,int set,int32 val));
static void hstxoff __ARGS((struct hdlc *hp));
static void hstxon __ARGS((struct hdlc *hp));
static void htxint __ARGS((struct hdlc *hp));
static void init_delay __ARGS((void));
static void msdelay __ARGS((void));
d42 1
a42 1
static int16 Nhs;
d51 1
a51 1
	int16 hsbase;
d158 1
a158 1
register int16 data;
d186 1
a186 1
	register int16 ctl;
d430 1
a430 1
	register int16 cnt;
d432 1
a432 1
	int16 ctl,data;
d495 1
a495 1
	int16 ctl;
d544 1
a544 1
	int16 ctl,data;
d630 1
a630 1
int16 ctl,data;
d632 1
a632 1
int16 bufsize;
@


1.13
log
@Allow any encapsulation by using setencap()
@
text
@a0 1
#pragma inline
d187 1
d191 1
a191 1
	DISABLE();
d264 1
a264 1
	RESTORE();
@


1.12
log
@s920612
@
text
@d297 8
d341 8
a348 22
	if(strcmp(argv[3],"ax25") == 0){
		if(Mycall[0] == '\0'){
			printf("set mycall first\n");
			free((char *)if_hsa);
			free((char *)if_hsb);
			return -1;
		}		
		setencap(if_hsa,"AX25");
		setencap(if_hsb,"AX25");
		if(if_hsb->hwaddr == NULLCHAR)
			if_hsb->hwaddr = mallocw(AXALEN);
		memcpy(if_hsb->hwaddr,Mycall,AXALEN);
		if(if_hsa->hwaddr == NULLCHAR)
			if_hsa->hwaddr = mallocw(AXALEN);
		memcpy(if_hsa->hwaddr,Mycall,AXALEN);
	} else {
		printf("Mode %s unknown for interface %s\n",
			argv[3],argv[4]);
		free((char *)if_hsa);
		free((char *)if_hsb);
		return -1;
	}
@


1.11
log
@src0515
@
text
@d1 1
@


1.10
log
@src0501
@
text
@d19 1
a19 1
#include "8530.h"
@


1.9
log
@src0429a
@
text
@d289 1
a289 1
		tprintf("Too many hs controllers\n");
d293 1
a293 1
		tprintf("Interface %s already exists\n",argv[4]);
d310 1
a310 1
		tprintf("IRQ %u out of range\n",Hs[dev].vec);
d334 1
a334 1
			tprintf("set mycall first\n");
d348 1
a348 1
		tprintf("Mode %s unknown for interface %s\n",
d581 1
a581 1
		if(tprintf("port %d: txpkts %lu ints %lu rxpkts %lu rxbytes %lu nomem %lu toobig %lu crcerr %lu aborts %lu overrun %lu\n",
d709 1
a709 1
		tprintf("HS: Warning: auto delay set failed\n");
@


1.8
log
@src0419
@
text
@d118 1
a118 1
	if((rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct phdr))) == NULLBUF){
d125 2
a126 2
	/* Allow space for phdr descriptor on front */
	rcvbuf->data += sizeof(struct phdr);
d140 1
a140 1
			net_route(hp->iface,CL_AX25,rcvbuf);
d142 1
a142 1
			rcvbuf = alloc_mbuf(hp->bufsiz + sizeof(struct phdr));
d147 1
a147 1
		rcvbuf->data +=  sizeof(struct phdr);
a185 1
	char i_state;
d190 1
a190 1
	i_state = dirps();
d263 1
a263 1
	restore(i_state);
a325 1
	if_hsb->type = if_hsa->type = CL_AX25;
a328 1
	if_hsb->output = if_hsa->output = ax_output;
d339 2
a340 1
		if_hsb->send = if_hsa->send = ax_send;
d439 1
a439 1
	dump(iface,IF_TRACE_OUT,CL_AX25,bp);
d533 1
a533 1
	(void)dirps();		/* Return value is always 1 */
d567 1
a567 1
	restore(1);	/* Turn interrupts back on */
@


1.7
log
@src0403
@
text
@d287 1
d399 6
a404 3
	if_hsa->txproc = newproc("hs tx",512,if_tx,0,if_hsa,NULL,0);
	if_hsb->txproc = newproc("hs tx",512,if_tx,0,if_hsb,NULL,0);

@


1.6
log
@src0401
@
text
@d47 1
a47 2
void
hsint(dev)
d52 1
d55 3
a57 2
	Hs[dev].ints++;
	hsbase = Hs[dev].addr;
d99 1
d300 5
a304 1
	Hs[dev].vec = htoi(argv[2]);
@


1.5
log
@src0331
@
text
@a106 1
	struct phdr phdr;
d116 1
a116 1
	if((rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(phdr))) == NULLBUF){
d124 1
a124 1
	cp = rcvbuf->data + sizeof(phdr);
d137 2
a138 5
			rcvbuf->cnt = sizeof(phdr) + cnt - 1;
			phdr.iface = hp->iface;
			phdr.type = CL_AX25;
			memcpy(rcvbuf->data,(char *)&phdr,sizeof(phdr));
			enqueue(&Hopper,rcvbuf);
d140 1
a140 1
			rcvbuf = alloc_mbuf(hp->bufsiz + sizeof(phdr));
d145 1
a145 1
		cp = rcvbuf->data + sizeof(phdr);
@


1.4
log
@src0327
@
text
@a31 1
static void hs_tx __ARGS((int unused,void *hp1,void *a));
a375 1
	if_hsa->txproc = newproc("hs_tx",1024,hs_tx,0,hp,NULL,0);
a388 1
	if_hsb->txproc = newproc("hs_tx",1024,hs_tx,0,hp,NULL,0);
d396 2
a397 2
	if_hsa->sendproc = newproc("hs tx",512,if_tx,0,if_hsa,NULL,0);
	if_hsb->sendproc = newproc("hs tx",512,if_tx,0,if_hsb,NULL,0);
d430 4
a439 18
	enqueue(&hp->txq,bp);	/* Put on queue for hs_tx process */
	return 0;
}

/* High speed transmit process */
void
hs_tx(unused,hp1,a)
int unused;
void *hp1;
void *a;	/* Unused */
{
	struct mbuf *bp,*nbp;
	register int16 cnt;
	register char *cp;
	int16 ctl,data;
	int txon = 0;	/* Transmitter on/off state */
	struct hdlc *hp;
	int i;
a440 1
	hp = (struct hdlc *)hp1;
d444 7
a450 25
	for(;;){
		/* Wait for work */
		while(hp->txq == NULLBUF){
			if(txon){
				/* No more frames, shut down tx */
				hstxoff(hp);
				txon = 0;
				/* Hold off to give other guy a chance to
				 * respond
				 */
				hp->deftime = msclock() + hp->txdelay + 500;
			}
			pwait(&hp->txq);
		}
		bp = dequeue(&hp->txq);
		cnt = len_p(bp);
		/* If buffer isn't contiguous (which is almost always
		 * the case) copy it to a new buffer for speed
		 */
		if(bp->next != NULLBUF){
			if((nbp = copy_p(bp,cnt)) == NULLBUF){
				hp->nomem++;
				free_p(bp);
				continue;
			}
d452 1
a452 1
			bp = nbp;
d454 11
a464 28
		cp = bp->data;
		/* Turn transmitter on if necessary */
		if(!txon){
			hstxon(hp);
			txon = 1;
		} else {
			/* Else wait another txd for receiver to get ready again */
			for(i=hp->txdelay;i != 0;i--)
				msdelay();
		}
		/* Initialize transmitter CRC */
		write_scc(ctl,R0,RES_Tx_CRC);
		for(;;){
			/* Wait for the transmitter to become ready */
			while(!(inportb(ctl) & Tx_BUF_EMP))
				;
			if(cnt-- == 0)
				break;
			outportb(data,*cp++); /* Send the character */
		}
		write_scc(ctl,R0,RES_EOM_L);	/* Allow CRC generation */

		/* End of frame. Wait for TxEOM to go high, indicating start of
		 * CRC transmission. Note that we don't reset the transmit
		 * interrupt pending flag as one ordinarily would, since we're
		 * not using tx interrupts.
		 */
		while(!(inportb(ctl) & TxEOM))
d466 12
d479 7
a485 2
		free_p(bp);
	}
@


1.3
log
@src0221
@
text
@d399 3
@


1.2
log
@src0202
@
text
@d24 1
d33 1
d37 2
d221 3
a223 2
	 * TRxC = transmit clock, RTxC = receive clock
	 * (swapped 11 Feb 1990 to use new DRSI wiring)
d225 4
a228 1
	write_scc(ctl,R11,RCRTxCP | TCTRxCP);
d274 1
a274 1
 * argv[4]: interface label, e.g., "drsi0". 
d277 1
a277 1
 * argv[7]: keyup delay, clock ticks
d279 1
d318 6
a323 3
	if_hsa->name = strdup(argv[4]);
	if_hsb->name = strdup(argv[4]);
	if_hsb->name[strlen(argv[4]) - 1]++;	/* kludge */
d331 1
d366 1
a366 1
		hp->txdelay = 1L;
d371 4
d385 4
a388 1
	hp->iface = if_hsb;
d397 2
d453 1
d466 4
d492 4
d529 1
a529 1
	int16 ctl,data;
d531 2
a534 1
	data = hp->data;
d536 19
a554 4
	/* P-persistence. The slot time is fixed at one tick. */
	while((rand() & 0xff) > uchar(hp->p))
		pause((int32)MSPTICK);

d567 3
a569 7
	/* Delay by sending dummy frame */
	for(i=hp->txdelay;i != 0;i--){
		while(!(inportb(ctl) & Tx_BUF_EMP))
			;
		outportb(data,0);
	}
	write_scc(ctl,R0,RES_EOM_L);	/* Allow CRC generation */
a570 7
	/* End of frame. Wait for TxEOM to go high, indicating start of
	 * CRC transmission. Note that we don't reset the transmit interrupt
	 * pending flag as one ordinarily would, since we're not using tx
	 * interrupts.
	 */
	while(!(inportb(ctl) & TxEOM))
		;
d618 39
d702 47
@


1.1
log
@Initial revision
@
text
@d117 1
a146 1
		cnt = 0;
@
