head	1.7;
access;
symbols;
locks;
comment	@ * @;


1.7
date	93.05.06.10.08.57;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	93.01.10.23.21.00;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.01.08.21.44;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.07.14.05.21.46;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.04.23.10.54.04;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.04.20.10.13.00;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.02.01.13.04.46;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.7
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* IP-related user commands
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "internet.h"
#include "timer.h"
#include "netuser.h"
#include "iface.h"
#include "ip.h"
#include "cmdparse.h"
#include "commands.h"
#include "rip.h"

int32 Ip_addr;

static int doadd(int argc,char *argv[],void *p);
static int dodrop(int argc,char *argv[],void *p);
static int doflush(int argc,char *argv[],void *p);
static int doipaddr(int argc,char *argv[],void *p);
static int doipstat(int argc,char *argv[],void *p);
static int dolook(int argc,char *argv[],void *p);
static int dortimer(int argc,char *argv[],void *p);
static int dottl(int argc,char *argv[],void *p);
static int dumproute(struct route *rp);

static struct cmds Ipcmds[] = {
	"address",	doipaddr,	0,	0, NULLCHAR,
	"rtimer",	dortimer,	0,	0, NULLCHAR,
	"status",	doipstat,	0,	0, NULLCHAR,
	"ttl",		dottl,		0,	0, NULLCHAR,
	NULLCHAR,
};
/* "route" subcommands */
static struct cmds Rtcmds[] = {
	"add",		doadd,		0,	3,
	"route add <dest addr>[/<bits>] <if name> [gateway] [metric]",

	"addprivate",	doadd,		0,	3,
	"route addprivate <dest addr>[/<bits>] <if name> [gateway] [metric]",

	"drop",		dodrop,		0,	2,
	"route drop <dest addr>[/<bits>]",

	"flush",	doflush,	0,	0,
	NULLCHAR,

	"lookup",	dolook,		0,	2,
	"route lookup <dest addr>",

	NULLCHAR,
};

int
doip(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Ipcmds,argc,argv,p);
}
static int
doipaddr(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int32 n;

	if(argc < 2) {
		printf("%s\n",inet_ntoa(Ip_addr));
	} else if((n = resolve(argv[1])) == 0){
		printf(Badhost,argv[1]);
		return 1;
	} else
		Ip_addr = n;
	return 0;
}
static int
dortimer(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&ipReasmTimeout,"IP reasm timeout (sec)",argc,argv);
}
static int
dottl(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&ipDefaultTTL,"IP Time-to-live",argc,argv);
}


/* Display and/or manipulate routing table */
int
doroute(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register int i,bits;
	register struct route *rp;

	if(argc >= 2)
		return subcmd(Rtcmds,argc,argv,p);

	/* Dump IP routing table
	 * Dest            Len Interface    Gateway          Use
	 * 192.001.002.003 32  sl0          192.002.003.004  0
	 */
	printf(
"Dest            Len Interface    Gateway          Metric  P Timer  Use\n");

	for(bits=31;bits>=0;bits--){
		for(i=0;i<HASHMOD;i++){
			for(rp = Routes[bits][i];rp != NULLROUTE;rp = rp->next){
				if(dumproute(rp) == EOF)
					return 0;
			}
		}
	}
	if(R_default.iface != NULLIF)
		dumproute(&R_default);

	return 0;
}
/* Add an entry to the routing table
 * E.g., "add 1.2.3.4 ax0 5.6.7.8 3"
 */
static int
doadd(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;
	int32 dest,gateway;
	unsigned bits;
	char *bitp;
	int32 metric;
	char private;

	if(strncmp(argv[0],"addp",4) == 0)
		private = 1;
	else
		private = 0;
	if(strcmp(argv[1],"default") == 0){
		dest = 0;
		bits = 0;
	} else {
		/* If IP address is followed by an optional slash and
		 * a length field, (e.g., 128.96/16) get it;
		 * otherwise assume a full 32-bit address
		 */
		if((bitp = strchr(argv[1],'/')) != NULLCHAR){
			/* Terminate address token for resolve() call */
			*bitp++ = '\0';
			bits = atoi(bitp);
		} else
			bits = 32;

		if((dest = resolve(argv[1])) == 0){
			printf(Badhost,argv[1]);
			return 1;
		}
	}
	if((ifp = if_lookup(argv[2])) == NULLIF){
		printf("Interface \"%s\" unknown\n",argv[2]);
		return 1;
	}
	if(argc > 3){
		if((gateway = resolve(argv[3])) == 0){
			printf(Badhost,argv[3]);
			return 1;
		}
	} else {
		gateway = 0;
	}
	if (argc > 4)
		metric = atol(argv[4]);
	else
		metric = 1;

	if(rt_add(dest,bits,gateway,ifp,metric,0,private) == NULLROUTE)
		printf("Can't add route\n");
	return 0;
}
/* Drop an entry from the routing table
 * E.g., "drop 128.96/16
 */
static int
dodrop(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *bitp;
	unsigned bits;
	int32 n;

	if(strcmp(argv[1],"default") == 0){
		n = 0;
		bits = 0;
	} else {
		/* If IP address is followed by an optional slash and length field,
		 * (e.g., 128.96/16) get it; otherwise assume a full 32-bit address
		 */
		if((bitp = strchr(argv[1],'/')) != NULLCHAR){
			/* Terminate address token for resolve() call */
			*bitp++ = '\0';
			bits = atoi(bitp);
		} else
			bits = 32;

		if((n = resolve(argv[1])) == 0){
			printf(Badhost,argv[1]);
			return 1;
		}
	}
	return rt_drop(n,bits);
}
/* Force a timeout on all temporary routes */
static int
doflush(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct route *rp;
	struct route *rptmp;
	int i,j;
	
	if(R_default.timer.state == TIMER_RUN){
		rt_drop(0,0);	/* Drop default route */
	}
	for(i=0;i<HASHMOD;i++){
		for(j=0;j<32;j++){
			for(rp = Routes[j][i];rp != NULLROUTE;rp = rptmp){
				rptmp = rp->next;
				if(rp->timer.state == TIMER_RUN){
					rt_drop(rp->target,rp->bits);
				}
			}
		}
	}
	return 0;
}
/* Dump a routing table entry */
static int
dumproute(rp)
register struct route *rp;
{
	char *cp;

	if(rp->target != 0)
		cp = inet_ntoa(rp->target);
	else
		cp = "default";
	printf("%-16s",cp);
	printf("%-4u",rp->bits);
	printf("%-13s",rp->iface->name);
	if(rp->gateway != 0)
		cp = inet_ntoa(rp->gateway);
	else
		cp = "";
	printf("%-17s",cp);
	printf("%-8lu",rp->metric);
	printf("%c ",(rp->flags & RTPRIVATE) ? 'P' : ' ');
	printf("%-7lu",
	 read_timer(&rp->timer) / 1000L);
	return printf("%lu\n",rp->uses);
}

static int
dolook(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct route *rp;
	int32 addr;

	addr = resolve(argv[1]);
	if(addr == 0){
		printf("Host %s unknown\n",argv[1]);
		return 1;
	}
	if((rp = rt_lookup(addr)) == NULLROUTE){
		printf("Host %s (%s) unreachable\n",argv[1],inet_ntoa(addr));
		return 1;
	}
	dumproute(rp);
	return 0;
}

static int
doipstat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct reasm *rp;
	register struct frag *fp;
	int i;

	for(i=1;i<=NUMIPMIB;i++){
		printf("(%2u)%-20s%10lu",i,
		 Ip_mib[i].name,Ip_mib[i].value.integer);
		if(i % 2)
			printf("     ");
		else
			printf("\n");
	}
	if((i % 2) == 0)
		printf("\n");
	printf("Routing lookups: %lu, cache hits %lu (%lu%%)\n",
	 Rtlookups,Rtchits,
	 Rtlookups != 0 ? (Rtchits*100 + Rtlookups/2)/Rtlookups: 0);

	if(Reasmq != NULLREASM)
		printf("Reassembly fragments:\n");
	for(rp = Reasmq;rp != NULLREASM;rp = rp->next){
		printf("src %s",inet_ntoa(rp->source));
		printf(" dest %s",inet_ntoa(rp->dest));
		if(printf(" id %u pctl %u time %lu len %u\n",
		 rp->id,uchar(rp->protocol),read_timer(&rp->timer),
		 rp->length) == EOF)
			break;
		for(fp = rp->fraglist;fp != NULLFRAG;fp = fp->next){
			if(printf(" offset %u last %u\n",fp->offset,
			fp->last) == EOF)
				break;
		}
	}
	return 0;
}
@


1.6
log
@Display routing cache hit ratio
@
text
@d18 9
a26 9
static int doadd __ARGS((int argc,char *argv[],void *p));
static int dodrop __ARGS((int argc,char *argv[],void *p));
static int doflush __ARGS((int argc,char *argv[],void *p));
static int doipaddr __ARGS((int argc,char *argv[],void *p));
static int doipstat __ARGS((int argc,char *argv[],void *p));
static int dolook __ARGS((int argc,char *argv[],void *p));
static int dortimer __ARGS((int argc,char *argv[],void *p));
static int dottl __ARGS((int argc,char *argv[],void *p));
static int dumproute __ARGS((struct route *rp));
@


1.5
log
@src0501
@
text
@d320 3
@


1.4
log
@src0922
@
text
@d72 1
a72 1
		tprintf("%s\n",inet_ntoa(Ip_addr));
d74 1
a74 1
		tprintf(Badhost,argv[1]);
d115 1
a115 1
	tprintf(
d167 1
a167 1
			tprintf(Badhost,argv[1]);
d172 1
a172 1
		tprintf("Interface \"%s\" unknown\n",argv[2]);
d177 1
a177 1
			tprintf(Badhost,argv[3]);
d189 1
a189 1
		tprintf("Can't add route\n");
d220 1
a220 1
			tprintf(Badhost,argv[1]);
d263 3
a265 3
	tprintf("%-16s",cp);
	tprintf("%-4u",rp->bits);
	tprintf("%-13s",rp->iface->name);
d270 4
a273 4
	tprintf("%-17s",cp);
	tprintf("%-8lu",rp->metric);
	tprintf("%c ",(rp->flags & RTPRIVATE) ? 'P' : ' ');
	tprintf("%-7lu",
d275 1
a275 1
	return tprintf("%lu\n",rp->uses);
d289 1
a289 1
		tprintf("Host %s unknown\n",argv[1]);
d293 1
a293 1
		tprintf("Host %s (%s) unreachable\n",argv[1],inet_ntoa(addr));
d311 1
a311 1
		tprintf("(%2u)%-20s%10lu",i,
d314 1
a314 1
			tprintf("     ");
d316 1
a316 1
			tprintf("\n");
d319 1
a319 1
		tprintf("\n");
d322 1
a322 1
		tprintf("Reassembly fragments:\n");
d324 3
a326 3
		tprintf("src %s",inet_ntoa(rp->source));
		tprintf(" dest %s",inet_ntoa(rp->dest));
		if(tprintf(" id %u pctl %u time %lu len %u\n",
d331 1
a331 1
			if(tprintf(" offset %u last %u\n",fp->offset,
@


1.3
log
@src0423
@
text
@d16 2
@


1.2
log
@src0420
@
text
@a43 3
	"encapsulate",	doadd,		0,	3,
	"route encapsulate <dest addr>[/<bits>] <if name> [gateway] [metric]",

d114 1
a114 1
"Dest            Len Interface    Gateway          Metric  PE Timer  Use\n");
d143 1
a143 1
	char private,encap;
a148 8
	if(strncmp(argv[0],"enc",3) == 0){
		if(argc < 4){
			tprintf("must specify gateway\n");
			return 1;
		}
		encap = 1;
	} else
		encap = 0;
d186 2
a187 1
	rt_add(dest,bits,gateway,ifp,metric,0,private,encap);
d270 1
a270 2
	tprintf("%c%c ",(rp->flags & RTPRIVATE) ? 'P' : ' ',
	 (rp->flags & RTENCAP) ? 'E' : ' ');
@


1.1
log
@Initial revision
@
text
@d44 3
d117 1
a117 1
"Dest            Len Interface    Gateway          Metric  P Timer  Use\n");
d146 1
a146 1
	char private;
d152 8
d197 1
a197 1
	rt_add(dest,bits,gateway,ifp,metric,0,private);
d280 2
a281 1
	tprintf("%c ",(rp->flags & RTPRIVATE) ? 'P' : ' ');
@
