head	1.6;
access;
symbols;
locks;
comment	@ * @;


1.6
date	93.05.06.10.09.00;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.08.08.36.02;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.11.25.11.29.36;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.08.19.22.54.46;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.04.01.46;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.30.14.18.12;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.6
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* IP header conversion routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "mbuf.h"
#include "ip.h"
#include "internet.h"

/* Convert IP header in host format to network mbuf
 * If cflag != 0, take checksum from structure,
 * otherwise compute it automatically.
 */
struct mbuf *
htonip(ip,bp,cflag)
register struct ip *ip;
struct mbuf *bp;
int cflag;
{
	uint16 hdr_len;
	register char *cp;
	uint16 fl_offs;

	hdr_len = IPLEN + ip->optlen;
	if(hdr_len > IPLEN + IP_MAXOPT)
		hdr_len = IPLEN + IP_MAXOPT;
	bp = pushdown(bp,hdr_len);
	cp = bp->data;
	
	*cp++ = (ip->version << 4) | (hdr_len >> 2);
	*cp++ = ip->tos;
	cp = put16(cp,ip->length);
	cp = put16(cp,ip->id);
	fl_offs = ip->offset >> 3;
	if(ip->flags.congest)
		fl_offs |= 0x8000;
	if(ip->flags.df)
		fl_offs |= 0x4000;
	if(ip->flags.mf)
		fl_offs |= 0x2000;

	cp = put16(cp,fl_offs);
	*cp++ = ip->ttl;
	*cp++ = ip->protocol;
	if(cflag){
		/* Use checksum from host structure */
		cp = put16(cp,ip->checksum);
	} else {
		/* Clear checksum for later recalculation */
		*cp++ = 0;
		*cp++ = 0;
	}
	cp = put32(cp,ip->source);
	cp = put32(cp,ip->dest);
	if(ip->optlen != 0)
		memcpy(cp,ip->options,min(ip->optlen,IP_MAXOPT));

	/* If requested, recompute checksum and insert into header */
	if(!cflag)
		put16(&bp->data[10],cksum(NULLHEADER,bp,hdr_len));

	return bp;
}
/* Extract an IP header from mbuf */
int
ntohip(ip,bpp)
register struct ip *ip;
struct mbuf **bpp;
{
	int ihl;
	uint16 fl_offs;
	char ipbuf[IPLEN];

	if(pullup(bpp,ipbuf,IPLEN) != IPLEN)
		return -1;

	ip->version = (ipbuf[0] >> 4) & 0xf;
	ip->tos = ipbuf[1];
	ip->length = get16(&ipbuf[2]);
	ip->id = get16(&ipbuf[4]);
	fl_offs = get16(&ipbuf[6]);
	ip->offset = (fl_offs & 0x1fff) << 3;
	ip->flags.mf = (fl_offs & 0x2000) ? 1 : 0;
	ip->flags.df = (fl_offs & 0x4000) ? 1 : 0;
	ip->flags.congest = (fl_offs & 0x8000) ? 1 : 0;
	ip->ttl = ipbuf[8];
	ip->protocol = ipbuf[9];
	ip->checksum = get16(&ipbuf[10]);
	ip->source = get32(&ipbuf[12]);
	ip->dest = get32(&ipbuf[16]);

	ihl = (ipbuf[0] & 0xf) << 2;
	if(ihl < IPLEN){
		/* Bogus packet; header is too short */
		ip->optlen = 0;
		return -1;
	}
	if ( (ip->optlen = ihl - IPLEN) != 0 ) {
		if ( pullup(bpp,ip->options,ip->optlen) < ip->optlen )
			return -1;
	}
	return ihl;
}
/* Perform end-around-carry adjustment */
uint16
eac(sum)
register int32 sum;	/* Carries in high order 16 bits */
{
	register uint16 csum;

	while((csum = sum >> 16) != 0)
		sum = csum + (sum & 0xffffL);
	return (uint16) (sum & 0xffffl);	/* Chops to 16 bits */
}
/* Checksum a mbuf chain, with optional pseudo-header */
uint16
cksum(ph,m,len)
struct pseudo_header *ph;
register struct mbuf *m;
uint16 len;
{
	register uint16 cnt, total;
	register int32 sum, csum;
	register char *up;
	uint16 csum1;
	int swap = 0;

	sum = 0l;

	/* Sum pseudo-header, if present */
	if(ph != NULLHEADER){
		sum = hiword(ph->source);
		sum += loword(ph->source);
		sum += hiword(ph->dest);
		sum += loword(ph->dest);
		sum += uchar(ph->protocol);
		sum += ph->length;
	}
	/* Now do each mbuf on the chain */
	for(total = 0; m != NULLBUF && total < len; m = m->next) {
		cnt = min(m->cnt, len - total);
		up = (char *)m->data;
		csum = 0;

		if(((long)up) & 1){
			/* Handle odd leading byte */
			if(swap)
				csum = uchar(*up++);
			else
				csum = (uint16)(uchar(*up++) << 8);
			cnt--;
			swap = !swap;
		}
		if(cnt > 1){
			/* Have the primitive checksumming routine do most of
			 * the work. At this point, up is guaranteed to be on
			 * a short boundary
			 */
			csum1 = lcsum((unsigned short *)up, (uint16)(cnt >> 1));
			if(swap)
				csum1 = (csum1 << 8) | (csum1 >> 8);
			csum += csum1;
		}
		/* Handle odd trailing byte */
		if(cnt & 1){
			if(swap)
				csum += uchar(up[--cnt]);
			else
				csum += (uint16)(uchar(up[--cnt]) << 8);
			swap = !swap;
		}
		sum += csum;
		total += m->cnt;
	}
	/* Do final end-around carry, complement and return */
	return (uint16)(~eac(sum) & 0xffff);
}

@


1.5
log
@src0410
@
text
@d19 1
a19 1
	int16 hdr_len;
d21 1
a21 1
	int16 fl_offs;
d70 1
a70 1
	int16 fl_offs;
d104 1
a104 1
int16
d108 1
a108 1
	register int16 csum;
d112 1
a112 1
	return (int16) (sum & 0xffffl);	/* Chops to 16 bits */
d115 1
a115 1
int16
d119 1
a119 1
int16 len;
d121 1
a121 1
	register int16 cnt, total;
d124 1
a124 1
	int16 csum1;
d149 1
a149 1
				csum = (int16)(uchar(*up++) << 8);
d158 1
a158 1
			csum1 = lcsum((unsigned short *)up, (int16)(cnt >> 1));
d168 1
a168 1
				csum += (int16)(uchar(up[--cnt]) << 8);
d175 1
a175 1
	return (int16)(~eac(sum) & 0xffff);
@


1.4
log
@src1216
@
text
@d14 1
a14 1
htonip(ip,data,cflag)
d16 1
a16 1
struct mbuf *data;
a19 1
	struct mbuf *bp;
d26 1
a26 4
	if((bp = pushdown(data,hdr_len)) == NULLBUF){
		free_p(data);
		return NULLBUF;
	}
@


1.3
log
@src0922
@
text
@d25 2
d59 1
a59 1
		memcpy(cp,ip->options,ip->optlen);
@


1.2
log
@src0318
@
text
@d71 1
a71 1
	int16 ihl;
d83 1
a83 1
	ip->offset = fl_offs << 3;
d96 1
d99 5
a103 5
	ip->optlen = ihl - IPLEN;
	if(ip->optlen != 0)
		pullup(bpp,ip->options,ip->optlen);

	return ip->optlen + IPLEN;
@


1.1
log
@Initial revision
@
text
@d36 2
d83 1
a83 1
	ip->offset = (fl_offs & 0x1fff) << 3;
d86 1
@
