head	1.15;
access;
symbols;
locks;
comment	@ * @;


1.15
date	93.05.06.10.10.09;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.10.07.19.28.33;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.05.15.10.02.44;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.05.05.10.10.38;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.04.30.02.17.08;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.04.08.08.36.26;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.04.06.11.41.20;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.04.01.13.32.58;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.03.26.11.35.24;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	91.09.18.14.45.56;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.06.09.04.43.40;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.08.11.19.52;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.10.12.12.42;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.14.11.14;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.15
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 *  PPP.C	-- Send and receive datagrams on serial lines with
 *		   Point-to-Point Protocol
 *
 *	This implementation of PPP is declared to be in the public domain.
 *
 *	Based (in part) upon previous implementations by:
 *	1989	-- Drew Daniel Perkins		(ddp@@andrew.cmu.edu)
 *		   Carnegie Mellon University
 *	09-90	-- Katie Stevens		(dkstevens@@ucdavis.edu)
 *		   UC Davis, Computing Services
 *
 *	Jan 91	Bill_Simpson@@um.cc.umich.edu
 *		Computer Systems Consulting Services
 *
 *	Feb 91	Glenn McGregor			(ghm@@merit.edu)
 *		Testing and suggestions.
 *
 *	May 91	Bill Simpson & Glenn McGregor
 *		Update to newest LCP and IPCP draft RFCs.
 *		Add quick installation features.
 *		Add support for echo and discard message sending.
 *
 *	Jul 91	Glenn McGregor & Bill Simpson
 *		Improve PAP user interface and fix related bugs.
 *		Remove pwaits and "phase machine".
 */

#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "iface.h"
#include "internet.h"
#include "ip.h"
#include "slhc.h"
#include "n8250.h"
#include "asy.h"
#include "pktdrvr.h"
#include "socket.h"
#include "devparam.h"
#include "ppp.h"
#include "pppfsm.h"
#include "ppplcp.h"
#include "ppppap.h"
#include "pppipcp.h"
#include "trace.h"

/* Routines local to this file */
static struct mbuf *htonppp(struct ppp_hdr *ppp, struct mbuf *data);

static void ppp_log(struct ppp_s *ppp_p, char *comment);
static void ppp_error(struct ppp_s *ppp_p, struct mbuf *bp, char *comment);
static void ppp_skipped(struct ppp_s *ppp_p, struct mbuf *bp, char *comment);

static int ppp_raw(struct iface *ifp, struct mbuf *data);

static void ppp_recv(int dev, void *p1, void *p2);

static int ppp_iostatus(struct iface *ifp, int command, int32 value);
static int ppp_discard(struct iface *ifp, struct mbuf *bp);
static int ppp_echo(struct iface *ifp, struct mbuf *bp);


/*
 * FCS lookup table as generated by fcsgen.c
 */
static uint16 fcstab[256] = {
    0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf,
    0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7,
    0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e,
    0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876,
    0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd,
    0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5,
    0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c,
    0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974,
    0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb,
    0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3,
    0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
    0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72,
    0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9,
    0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1,
    0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738,
    0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70,
    0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7,
    0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff,
    0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036,
    0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e,
    0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5,
    0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
    0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134,
    0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c,
    0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3,
    0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb,
    0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232,
    0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a,
    0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1,
    0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9,
    0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330,
    0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78
};

#define pppfcs(fcs, c)		((fcs >> 8) ^ fcstab[(fcs ^ c) & 0x00ff])
#define SP_CHAR			0x20


/****************************************************************************/

/* Convert PPP header in host form to network form */
static struct mbuf *
htonppp(ppp, bp)
struct ppp_hdr *ppp;
struct mbuf *bp;
{
	register char *cp;

	/* Prepend header onto packet data */
	bp = pushdown(bp, PPP_HDR_LEN);

	/* Load header with proper values */
	cp = bp->data;
	*cp++ = ppp->addr;
	*cp++ = ppp->control;
	cp = put16(cp,ppp->protocol);

	return bp;
}


/************************************************************************/
/* General log routine */
static void
ppp_log( ppp_p, comment )
struct ppp_s *ppp_p;
char *comment;
{
	if (ppp_p->trace)
		trace_log(ppp_p->iface,"%s PPP %s",
			ppp_p->iface->name,
			comment);
}


/* Bad packet */
static void
ppp_error(ppp_p, bp, comment)
struct ppp_s *ppp_p;
struct mbuf *bp;
char *comment;
{
	free_p(bp);
	ppp_log( ppp_p, comment );
}


/* Unknown type input packet */
static void
ppp_skipped(ppp_p, bp, comment)
struct ppp_s *ppp_p;
struct mbuf *bp;
char *comment;
{
	struct ipcp_s *ipcp_p;

	if ( (ipcp_p = ppp_p->fsm[IPcp].pdv) != NULL ) {
		slhc_toss( ipcp_p->slhcp );
	}
	ppp_error( ppp_p, bp, comment );
}


/****************************************************************************/
/* Send IP datagram with Point-to-Point Protocol */
int
ppp_send(bp,ifp,gateway,tos)
struct mbuf *bp;	/* Buffer to send */
struct iface *ifp;	/* Pointer to interface control block */
int32 gateway;		/* Ignored (PPP is point-to-point) */
int tos;
{
	struct ppp_s *ppp_p;
	struct ipcp_s *ipcp_p;
	int protocol = PPP_IP_PROTOCOL;

	if (ifp == NULLIF
	 || (ppp_p = ifp->edv) == NULL) {
		free_p(bp);
		return -1;
	}

	if (ppp_p->fsm[IPcp].state != fsmOPENED) {
		ppp_error( ppp_p, bp, "not open for IP traffic" );
		ppp_p->OutError++;
		return -1;
	}

	ipcp_p = ppp_p->fsm[IPcp].pdv;
	if (ipcp_p->remote.work.negotiate & IPCP_N_COMPRESS) {
		/* Attempt IP/TCP header compression */
		switch ( slhc_compress(ipcp_p->slhcp, &bp,
			ipcp_p->remote.work.slot_compress) ) {
		case SL_TYPE_IP:
			protocol = PPP_IP_PROTOCOL;
			break;
		case SL_TYPE_COMPRESSED_TCP:
			protocol = PPP_COMPR_PROTOCOL;
			break;
		case SL_TYPE_UNCOMPRESSED_TCP:
			protocol = PPP_UNCOMP_PROTOCOL;
			break;
		default:
			ppp_error( ppp_p, bp, "bad IP packet" );
			ppp_p->OutError++;
			return -1;
		};
	}
	return (*ifp->output)(ifp,NULLCHAR,NULLCHAR,protocol,bp);
}


/* Send a packet with PPP header */
int
ppp_output(ifp,dest,source,protocol,data)
struct iface *ifp;	/* Pointer to interface control block */
char *dest;		/* Dest addr (ignored; PPP is point-to-point) */
char *source;		/* Source addr (ignored; PPP is point-to-point) */
uint16 protocol;		/* PPP Protocol Type field */
struct mbuf *data;	/* Actual data to be sent */
{
	struct ppp_s *ppp_p;
	struct mbuf *bp;
	struct ppp_hdr hdr;

	if (ifp == NULLIF
	 || (ppp_p = ifp->edv) == NULL) {
		free_p(data);
		return -1;
	}

	if (ppp_p->phase == pppDEAD) {
		ppp_error( ppp_p, data, "line not up" );
		ppp_p->OutError++;
		return -1;
	}

	hdr.addr = HDLC_ALL_ADDR;
	hdr.control = HDLC_UI;
	hdr.protocol = protocol;

	if ((bp = htonppp(&hdr, data)) == NULLBUF) {
		ppp_log( ppp_p, Nospace );
		ppp_p->OutMemory++;
		return -1;
	}

	return (*ifp->raw)(ifp,bp);
}


/* Encode a raw packet in PPP framing, put on link output queue */
static int
ppp_raw(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	struct ppp_s *ppp_p = ifp->edv;
	struct lcp_s *lcp_p = ppp_p->fsm[Lcp].pdv;
	int full_lcp, full_ac, full_p;
	uint16 calc_fcs = HDLC_FCS_START;
	int32 accm = LCP_ACCM_DEFAULT;
	struct ppp_hdr ph;
	int len = PPP_HDR_LEN;
	struct mbuf *vbp;
	register char *cp;
	register int c;

	dump(ifp,IF_TRACE_OUT,bp);
	ppp_p->OutTxOctetCount += len_p(bp) + 2;  /* count FCS bytes */
	ifp->rawsndcnt++;
	ifp->lastsent = secclock();

	/* Get the HDLC/PPP header, without actually pulling mbuf up */
	if ( bp == NULLBUF || bp->cnt < PPP_HDR_LEN ) {
		ppp_error( ppp_p, bp, "link header missing" );
		ppp_p->OutError++;
		return -1;
	}

	ph.addr = bp->data[0];
	ph.control = bp->data[1];
	ph.protocol = get16(&bp->data[2]);

	if ( ( full_lcp = (ph.protocol == PPP_LCP_PROTOCOL) ) == 0
	 && (lcp_p->remote.work.negotiate & LCP_N_ACCM) ) {
		accm = lcp_p->remote.work.accm;
	}

	if ( ( full_p = ( full_lcp
			||  !(lcp_p->remote.work.negotiate & LCP_N_PFC)
			||  ph.protocol >= 0x00ff ) )
	    == 0 ) {
		--len;
	}

	/* Discard HDLC address and control fields if possible */
	if ( ( full_ac = ( full_lcp
			||  !(lcp_p->remote.work.negotiate & LCP_N_ACFC) ) )
	    == 0 ) {
		len -= 2;
	}

	/* Load header with proper values */
	bp->cnt -= PPP_HDR_LEN - len;
	cp = (bp->data += PPP_HDR_LEN - len);

	if ( full_ac ) {
		*cp++ = ph.addr;
		*cp++ = ph.control;
	}
	if ( full_p )
		*cp++ = (ph.protocol >> 8);
	*cp++ = (ph.protocol & 0x00ff);

	/* Allocate output mbuf that's twice as long as the packet.
	 * This is a worst-case guess (consider a packet full of HDLC_FLAGs!)
	 */
	if ((vbp = alloc_mbuf((uint16)(2*len_p(bp) + HDLC_ENVLEN))) == NULLBUF) {
		ppp_error( ppp_p, bp, Nospace );
		ppp_p->OutMemory++;
		return -1;
	}
	cp = vbp->data;

	/* No need to send an opening flag if the previous packet is still
	 * being transmitted.
	 */
	if ( Asy[ifp->dev].dma.busy == 0 ) {
		/* Flush out any line garbage */
		*cp++ = HDLC_FLAG;
		ppp_p->OutOpenFlag++;
	}

	/* Copy input to output, escaping special characters */
	while ((c = PULLCHAR(&bp)) != -1) {
		/* Fold char value into FCS calculated so far */
		calc_fcs = pppfcs(calc_fcs, c);

		if ( ((c < SP_CHAR) && (accm & (1L << c)))
		    || (c == HDLC_ESC_ASYNC)
		    || (c == HDLC_FLAG)) {
			*cp++ = HDLC_ESC_ASYNC;
			*cp++ = (c ^ HDLC_ESC_COMPL);
		} else {
			*cp++ = c;
		}
	}

	/* Final FCS calculation */
	calc_fcs ^= 0xffff;
	c = (calc_fcs & 0x00ff);	/* Least significant byte first */
	if ( ((c < SP_CHAR) && (accm & (1L << c)))
	     ||(c == HDLC_ESC_ASYNC)
	     ||(c == HDLC_FLAG)) {
		*cp++ = HDLC_ESC_ASYNC;
		*cp++ = (c ^ HDLC_ESC_COMPL);
	} else {
		*cp++ = c;
	}
	c = (calc_fcs >> 8);		/* Most significant byte next */
	if ( ((c < SP_CHAR) && (accm & (1L << c)))
	     ||(c == HDLC_ESC_ASYNC)
	     ||(c == HDLC_FLAG)) {
		*cp++ = HDLC_ESC_ASYNC;
		*cp++ = (c ^ HDLC_ESC_COMPL);
	} else {
		*cp++ = c;
	}

	/* Tie off the packet */
	*cp++ = HDLC_FLAG;
	vbp->cnt = cp - vbp->data;

	if (ifp->trace & IF_TRACE_RAW)
		raw_dump(ifp,IF_TRACE_OUT,vbp);
	return asy_send(ifp->dev,vbp);
}


/****************************************************************************/
/* Packetize PPP input from device */
/* (process started by ppp_init) */
void
ppp_recv(dev,p1,p2)
int dev;
void *p1;
void *p2;
{
	struct iface *ifp = p1;
	struct ppp_s *ppp_p = ifp->edv;
	int32 accm = LCP_ACCM_DEFAULT;
	uint16 calc_fcs = HDLC_FCS_START;
	struct mbuf *raw_bp = NULLBUF;
	struct mbuf *head_bp = NULLBUF;
	register struct mbuf *tail_bp = NULLBUF;
	char *cp;			/* next byte in tail mbuf */
	register int mode = FALSE;
	register int c;

	while ( (c = get_asy(dev)) != -1 ) {
#ifdef PPP_DEBUG_RAW
		if (ifp->trace & IF_TRACE_RAW) {
			if ( raw_bp != NULLBUF
			  || (raw_bp = alloc_mbuf( LCP_MRU_HI * 2 )) != NULLBUF ) {
				*raw_bp->data++ = c;
				raw_bp->cnt++;
				if ( raw_bp->cnt != 1 && c == HDLC_FLAG ) {
					raw_bp->data = (char *)(raw_bp + 1);
					raw_dump( ifp, IF_TRACE_IN, raw_bp );
					raw_bp->cnt = 0;
				}
			}
		}
#endif
		if ( c == HDLC_FLAG ) {
			if ( mode & PPP_ESCAPED ) {
				ppp_skipped( ppp_p, head_bp,
					"deliberate cancellation" );
				ppp_p->InFrame++;
			} else if ( mode & PPP_TOSS ) {
				free_p( head_bp );
			} else if ( head_bp != NULLBUF ) {
				if ( calc_fcs != HDLC_FCS_FINAL ) {
					ppp_skipped( ppp_p, head_bp,
						"checksum error" );
					ppp_p->InChecksum++;
				} else {
					/* trim off FCS bytes */
					trim_mbuf(&head_bp, len_p(head_bp)-2);

					net_route(ifp,head_bp);
					/* Especially on slow machines, serial I/O can be quite
					 * compute intensive, so release the machine before we
					 * do the next packet.  This will allow this packet to
					 * go on toward its ultimate destination. [Karn]
					 */
					pwait(NULL);
				}
			} else {
				ppp_p->InOpenFlag++;
			}

			/* setup for next buffer */
			mode = FALSE;
			head_bp = tail_bp = NULLBUF;
			calc_fcs = HDLC_FCS_START;
			accm = LCP_ACCM_DEFAULT;

			/* Use negotiated values if LCP finished */
			if (ppp_p->fsm[Lcp].state == fsmOPENED) {
				struct lcp_s *lcp_p = ppp_p->fsm[Lcp].pdv;

				if (lcp_p->local.work.negotiate & LCP_N_ACCM) {
					accm = lcp_p->local.work.accm;
				}
			}
#ifdef PPP_DEBUG_RAW
			if (!(ifp->trace & IF_TRACE_RAW)) {
				if ( raw_bp != NULLBUF ) {
					free_p( raw_bp );
					raw_bp = NULLBUF;
				}
			}
#endif
			continue;
		}

		/* We reach here for every byte inside a frame.
		 * (The order of the following tests is important.)
		 * Discard spurious control characters.
		 * Check for escape sequence.
		 * (Allow escaped escape.)
		 */
		if ( c < SP_CHAR && (accm & (1L << c)) ) {
			continue;
		} else if ( mode & PPP_ESCAPED ) {
			mode &= ~PPP_ESCAPED;
			c ^= HDLC_ESC_COMPL;
		} else if ( c == HDLC_ESC_ASYNC ) {
			mode |= PPP_ESCAPED;
			continue;
		}

		/* We reach here with a byte for the buffer.
		 * Make sure there is room for it.
		 */
		if ( tail_bp == NULLBUF ) {
			if ((tail_bp = alloc_mbuf(PPP_ALLOC)) == NULLBUF) {
				ppp_skipped( ppp_p, tail_bp, Nospace );
				ppp_p->InMemory++;
				mode |= PPP_TOSS;
				continue;
			}
			head_bp = tail_bp;
			cp = tail_bp->data;
		} else if ( tail_bp->cnt >= tail_bp->size ) {
			/* Current mbuf is full */
			if ( (tail_bp->next = alloc_mbuf(PPP_ALLOC)) == NULLBUF ) {
				/* No memory, drop the whole packet */
				ppp_skipped( ppp_p, head_bp, Nospace );
				ppp_p->InMemory++;
				head_bp = NULLBUF;
				mode |= PPP_TOSS;
				continue;
			}
			tail_bp = tail_bp->next;
			cp = tail_bp->data;
		}

		/* Store the byte, increment counts */
		*cp++ = c;
		tail_bp->cnt++;
		calc_fcs = pppfcs(calc_fcs, c);
	}

	/* clean up afterward */
	free_p(raw_bp);
	free_p(head_bp);
	ifp->rxproc = NULLPROC;
}

#ifdef TURBOC_SWITCH_BUG
#pragma option -G-
#endif

/* Process incoming PPP packets */
/* (called from network task) */
void
ppp_proc(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	struct ppp_s *ppp_p;
	struct ipcp_s *ipcp_p;
	struct ppp_hdr ph;
	struct mbuf *hbp;
	uint16 negotiated = FALSE;

	if ( ifp == NULLIF ) {
		log(-1, "ppp_proc: missing iface" );
		return;
	}
	if ( bp == NULLBUF ) {
		trace_log(ifp, "ppp_proc: missing buffer" );
		return;
	}

	ppp_p = ifp->edv;
	ppp_p->InRxOctetCount += len_p(bp) + 2;   /* count FCS bytes */

	/* Use negotiated values if LCP finished */
	if (ppp_p->fsm[Lcp].state == fsmOPENED) {
		struct lcp_s *lcp_p = ppp_p->fsm[Lcp].pdv;

		negotiated = lcp_p->local.work.negotiate;
	}

	/* HDLC address and control fields may be compressed out */
	if ((byte_t)bp->data[0] != HDLC_ALL_ADDR) {
		if (!(negotiated & LCP_N_ACFC)) {
			ppp_skipped( ppp_p, bp, "missing ALL address" );
			ppp_p->InFrame++;
			return;
		}
	} else if ((byte_t)bp->data[1] != HDLC_UI) {
		if (!(negotiated & LCP_N_ACFC)
		 || !(negotiated & LCP_N_PFC)) {
			ppp_skipped( ppp_p, bp, "missing UI" );
			ppp_p->InFrame++;
			return;
		}
	} else {
		/* skip address/control fields */
		pull16(&bp);
	}

	/* Initialize the expected header */
	ph.addr = HDLC_ALL_ADDR;
	ph.control = HDLC_UI;
	ph.protocol = PULLCHAR(&bp);

	/* First byte of PPP protocol field may be compressed out */
	if ( ph.protocol & 0x01 ) {
		if (!(negotiated & LCP_N_PFC)) {
			ppp_skipped( ppp_p, bp, "missing upper protocol byte" );
			ppp_p->InFrame++;
			return;
		}
	} else {
		ph.protocol = (ph.protocol << 8) | PULLCHAR(&bp);

		/* Second byte of PPP protocol field must be odd */
		if ( !(ph.protocol & 0x01) ) {
			ppp_skipped( ppp_p, bp, "missing lower protocol byte" );
			ppp_p->InFrame++;
			return;
		}
	}


	switch(ph.protocol) {
	case PPP_IP_PROTOCOL:	/* Regular IP */
		if ( ppp_p->fsm[IPcp].state != fsmOPENED ) {
			ppp_error( ppp_p, bp, "not open for IP traffic" );
			ppp_p->InError++;
			break;
		}
		ip_route(ifp,bp,0);
		break;

	case PPP_COMPR_PROTOCOL:	/* Van Jacobson Compressed TCP/IP */
		if ( ppp_p->fsm[IPcp].state != fsmOPENED ) {
			ppp_skipped( ppp_p, bp, "not open for Compressed TCP/IP traffic" );
			ppp_p->InError++;
			break;
		}

		ipcp_p = ppp_p->fsm[IPcp].pdv;
		if (!(ipcp_p->local.work.negotiate & IPCP_N_COMPRESS)) {
			ppp_skipped( ppp_p, bp, "Compressed TCP/IP not enabled" );
			ppp_p->InError++;
			break;
		}

		if ( slhc_uncompress(ipcp_p->slhcp, &bp) <= 0 ) {
			ppp_error( ppp_p, bp, "Compressed TCP/IP packet error" );
			ppp_p->InError++;
			break;
		}
		ip_route(ifp,bp,0);
		break;

	case PPP_UNCOMP_PROTOCOL:	/* Van Jacobson Uncompressed TCP/IP */
		if ( ppp_p->fsm[IPcp].state != fsmOPENED ) {
			ppp_skipped( ppp_p, bp, "not open for Uncompressed TCP/IP traffic" );
			ppp_p->InError++;
			break;
		}

		ipcp_p = ppp_p->fsm[IPcp].pdv;
		if (!(ipcp_p->local.work.negotiate & IPCP_N_COMPRESS)) {
			ppp_skipped( ppp_p, bp, "Uncompressed TCP/IP not enabled" );
			ppp_p->InError++;
			break;
		}

		if ( slhc_remember(ipcp_p->slhcp, &bp) <= 0 ) {
			ppp_error( ppp_p, bp, "Uncompressed TCP/IP packet error" );
			ppp_p->InError++;
			break;
		}
		ip_route(ifp,bp,0);
		break;

	case PPP_LCP_PROTOCOL:	/* Link Control Protocol */
		ppp_p->InNCP[Lcp]++;
		fsm_proc(&(ppp_p->fsm[Lcp]),bp);
		break;

	case PPP_PAP_PROTOCOL:	/* Password Authenticate Protocol */
		if (ppp_p->phase != pppAP
		 && ppp_p->phase != pppREADY) {
			ppp_error( ppp_p, bp, "not ready for Authentication" );
			ppp_p->InError++;
			break;
		}
		ppp_p->InNCP[Pap]++;
		pap_proc(&(ppp_p->fsm[Pap]),bp);
		break;

	case PPP_IPCP_PROTOCOL:	/* IP Control Protocol */
		if (ppp_p->phase != pppREADY) {
			ppp_error( ppp_p, bp, "not ready for IPCP traffic" );
			ppp_p->InError++;
			break;
		}
		ppp_p->InNCP[IPcp]++;
		fsm_proc(&(ppp_p->fsm[IPcp]),bp);
		break;

	default:
		if ( ppp_p->trace )
			trace_log(ppp_p->iface, "%s PPP Unknown packet protocol: %x;",
				ppp_p->iface->name,
				ph.protocol);
		ppp_p->InUnknown++;

		/* Build Protocol Reject packet:
		 * put the header back on ...
		 */
		if ((hbp = htonppp(&ph,bp)) == NULLBUF){
			ppp_log( ppp_p, Nospace );
			ppp_p->InMemory++;
			return;
		}
		/* ... then pull off the address and control fields ... */
		pull16(&hbp);
		/* ... and send it as an LCP packet */
		fsm_send( &(ppp_p->fsm[Lcp]), PROT_REJ, 0, hbp );
		break;
	};
}

#ifdef TURBOC_SWITCH_BUG
#pragma option -G
#endif

/************************************************************************/

/* Keep track of changes in I-O status */
/* (called through iface iostatus vector) */
static int
ppp_iostatus( ifp, command, value )
struct iface *ifp;
int command;
int32 value;
{
	struct ppp_s *ppp_p = ifp->edv;

	switch ( command ) {
	case PARAM_UP:
		ppp_log( ppp_p, "Physical layer up" );

		if ( ppp_p->phase == pppDEAD ) {
			ppp_p->phase = pppLCP;
		}
		fsm_start( &(ppp_p->fsm[Lcp]) );
		return 0;

	case PARAM_DOWN:
		ppp_log( ppp_p, "Physical layer down" );

		fsm_down( &(ppp_p->fsm[Lcp]) );
		ppp_p->phase = pppDEAD;
		return 0;
	};
	return -1;
}


static int
ppp_discard(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	struct ppp_s *ppp_p = ifp->edv;

	return fsm_send(&(ppp_p->fsm[Lcp]), DISCARD_REQ, 0, bp);
}


static int
ppp_echo(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	struct ppp_s *ppp_p = ifp->edv;

	return fsm_send(&(ppp_p->fsm[Lcp]), ECHO_REQ, 0, bp);
}


/****************************************************************************/
/* Initialize PPP control structures for a Point-to-Point interface */
int
ppp_init(ifp)
struct iface *ifp;
{
	struct ppp_s *ppp_p;
	char *ifn;

	/* Setup for Point-to-Point Protocol */
	ifp->ioctl = asy_ioctl;

	ppp_p = callocw(1,sizeof(struct ppp_s));

	ifp->edv = ppp_p;
	ifp->iostatus = ppp_iostatus;
	ifp->raw = ppp_raw;
	ifp->show = ppp_show;
	ifp->echo = ppp_echo;
	ifp->discard = ppp_discard;

	ppp_p->iface = ifp;
	ppp_p->phase = pppDEAD;

	lcp_init(ppp_p);
	pap_init(ppp_p);
	ipcp_init(ppp_p);

	ifp->rxproc = newproc( ifn = if_name( ifp, " receive" ),
			320, ppp_recv, ifp->dev, ifp, NULL, 0);
	free(ifn);
	return 0;
}


int
ppp_free(ifp)
struct iface *ifp;
{
	struct ppp_s *ppp_p = ifp->edv;
	int fsmi;

	alert( ifp->rxproc, 1 );

	for ( fsmi = Lcp; fsmi < fsmi_Size; ) {
		fsm_free( &(ppp_p->fsm[fsmi++]) );
	}
	free( ppp_p->peername );
	free( ppp_p );
	return 0;
}

@


1.14
log
@Get rid of unused vj flag to ppp_init, remove setencap call,
reference to obsolete "flags" entry in iface struct
@
text
@d49 1
a49 1
static struct mbuf *htonppp __ARGS((struct ppp_hdr *ppp, struct mbuf *data));
d51 3
a53 3
static void ppp_log __ARGS((struct ppp_s *ppp_p, char *comment));
static void ppp_error __ARGS((struct ppp_s *ppp_p, struct mbuf *bp, char *comment));
static void ppp_skipped __ARGS((struct ppp_s *ppp_p, struct mbuf *bp, char *comment));
d55 1
a55 1
static int ppp_raw __ARGS((struct iface *ifp, struct mbuf *data));
d57 1
a57 1
static void ppp_recv __ARGS((int dev, void *p1, void *p2));
d59 3
a61 3
static int ppp_iostatus __ARGS((struct iface *ifp, int command, int32 value));
static int ppp_discard 	__ARGS((struct iface *ifp, struct mbuf *bp));
static int ppp_echo	__ARGS((struct iface *ifp, struct mbuf *bp));
d67 1
a67 1
static int16 fcstab[256] = {
d226 1
a226 1
int16 protocol;		/* PPP Protocol Type field */
d268 1
a268 1
	int16 calc_fcs = HDLC_FCS_START;
d326 1
a326 1
	if ((vbp = alloc_mbuf((int16)(2*len_p(bp) + HDLC_ENVLEN))) == NULLBUF) {
d400 1
a400 1
	int16 calc_fcs = HDLC_FCS_START;
d545 1
a545 1
	int16 negotiated = FALSE;
@


1.13
log
@src0515
@
text
@d774 1
a774 1
ppp_init(ifp,vj)
a775 1
int vj;	/* Unused */
a780 1
	setencap(ifp,"PPP");
a781 2
	ifp->flags = FALSE;

@


1.12
log
@src0505
@
text
@d36 1
a36 1
#include "8250.h"
@


1.11
log
@src0429a
@
text
@d817 1
a817 1
	alert( ifp->rxproc, -1 );
@


1.10
log
@src0410
@
text
@d276 1
a276 1
	dump(ifp,IF_TRACE_OUT,CL_PPP,bp);
d336 1
a336 1
	if ( Asy[ifp->dev].dma.flags == 0 ) {
d439 1
a439 1
					net_route(ifp,CL_PPP,head_bp);
@


1.9
log
@src0406
@
text
@d110 1
a110 1
htonppp(ppp, data)
d112 1
a112 1
struct mbuf *data;
a113 1
	struct mbuf *bp;
d117 1
a117 4
	if ((bp = pushdown(data, PPP_HDR_LEN)) == NULLBUF) {
		free_p( data );
		return NULLBUF;
	}
@


1.8
log
@src0401
@
text
@d778 1
a778 1
ppp_init(ifp)
d780 1
d784 6
@


1.7
log
@src0327
@
text
@d443 7
a449 1
					net_route( ifp, CL_PPP, head_bp );
@


1.6
log
@src0922
@
text
@d178 1
a178 1
ppp_send(bp,ifp,gateway,prec,del,tput,rel)
d182 1
a182 4
int prec;
int del;
int tput;
int rel;
@


1.5
log
@src0609
@
text
@d20 2
a21 1
 *		Update to newest draft RFCs.
d23 4
a26 1
 *		PAP prompt for password only when fails (allow missing password).
a28 2
#include <stdio.h>
#include <time.h>
a30 1
#include "timer.h"
d44 1
a45 1
#include "ppppap.h"
d52 2
a53 3
static void ppp_in_error __ARGS((struct ppp_s *ppp_p, struct mbuf *bp, char *comment));
static void ppp_out_error __ARGS((struct ppp_s *ppp_p, struct mbuf *bp, char *comment));
static void ppp_unknown __ARGS((struct ppp_s *ppp_p, struct mbuf *bp, char *comment));
d55 1
a55 1
static int ppp_raw __ARGS((struct iface *iface, struct mbuf *data));
a56 1
static void ppp_queue __ARGS((struct ppp_s *ppp_p, struct mbuf *bp, int16 negotiated));
d58 1
d60 2
a61 1
static void ppp_machine __ARGS((int dev, void *p1, void *p2));
a104 6
/* actions for incoming bytes */
enum {
	modeTOSS,
	modeESCAPED,
	modeNORMAL
};
d118 2
a119 1
	if ((bp = pushdown(data, PPP_HDR_LEN)) == NULLBUF)
d121 1
a131 12
/* Extract PPP header from incoming packet */
int
ntohppp(ppp, bpp)
struct ppp_hdr *ppp;
struct mbuf **bpp;
{
	ppp->addr = PULLCHAR(bpp);
	ppp->control = PULLCHAR(bpp);
	ppp->protocol = pull16(bpp);
	return(PPP_HDR_LEN);
}

d141 1
a141 1
		log(-1,"%s: PPP %s",
d147 1
a147 14
/* Bad Input packet */
static void
ppp_in_error(ppp_p, bp, comment)
struct ppp_s *ppp_p;
struct mbuf *bp;
char *comment;
{
	ppp_p->InError++;
	free_p(bp);
	ppp_log( ppp_p, comment );
}


/* Bad output packet */
d149 1
a149 1
ppp_out_error(ppp_p, bp, comment)
a153 1
	ppp_p->OutError++;
d161 1
a161 1
ppp_unknown(ppp_p, bp, comment)
d171 1
a171 1
	ppp_in_error( ppp_p, bp, comment );
d178 1
a178 1
ppp_send(bp,iface,gateway,prec,del,tput,rel)
d180 1
a180 1
struct iface *iface;	/* Pointer to interface control block */
d191 2
a192 2
	if (iface == NULLIF
	 || (ppp_p = iface->extension) == NULL) {
d198 2
a199 1
		ppp_out_error( ppp_p, bp, "not open for IP traffic" );
d218 2
a219 1
			ppp_out_error( ppp_p, bp, "bad IP packet" );
d223 1
a223 2
	ppp_p->OutIP++;
	return (*iface->output)(iface,NULLCHAR,NULLCHAR,protocol,bp);
d229 2
a230 2
ppp_output(iface,dest,source,protocol,data)
struct iface *iface;	/* Pointer to interface control block */
d240 2
a241 2
	if (iface == NULLIF
	 || (ppp_p = iface->extension) == NULL) {
d247 2
a248 1
		ppp_out_error( ppp_p, data, "line not up" );
d257 2
a258 1
		ppp_out_error( ppp_p, data, Nospace );
d262 1
a262 1
	return (*iface->raw)(iface,bp);
d268 2
a269 2
ppp_raw(iface,bp)
struct iface *iface;
d272 1
a272 1
	struct ppp_s *ppp_p = iface->extension;
a273 2
	struct mbuf *hbp;
	struct ppp_hdr hdr;
d277 1
d279 1
d283 11
a293 3
	dump(iface,IF_TRACE_OUT,CL_PPP,bp);
	iface->rawsndcnt++;
	iface->lastsent = secclock();
d295 3
a297 2
	/* Get the HDLC/PPP header */
	ntohppp(&hdr, &bp);
d299 1
a299 1
	if ( ( full_lcp = (hdr.protocol == PPP_LCP_PROTOCOL) ) == 0
d306 1
a306 1
			||  hdr.protocol > 0x00ff ) )
d313 1
a313 4
			||  !(lcp_p->remote.work.negotiate & LCP_N_ACFC)
			||  ( !full_p
				&&  hdr.protocol == HDLC_ALL_ADDR
				&&  *bp->data == HDLC_UI ) ) )
d318 3
a320 5
	/* Prepend header onto packet data */
	if ((hbp = pushdown(bp, len)) == NULLBUF) {
		ppp_out_error( ppp_p, bp, Nospace );
		return -1;
	}
a321 2
	/* Load header with proper values */
	cp = hbp->data;
d323 2
a324 2
		*cp++ = hdr.addr;
		*cp++ = hdr.control;
d327 2
a328 2
		*cp++ = (hdr.protocol >> 8);
	*cp++ = (hdr.protocol & 0x00ff);
d333 3
a335 2
	if ((bp = alloc_mbuf((int16)(2*len_p(hbp) + HDLC_ENVLEN))) == NULLBUF) {
		ppp_out_error( ppp_p, hbp, Nospace );
d338 1
a338 1
	cp = bp->data;
d343 1
a343 1
	if ( Asy[iface->dev].dma.flags == 0 ) {
d350 1
a350 1
	while ((c = PULLCHAR(&hbp)) != -1) {
d387 1
a387 1
	bp->cnt = cp - bp->data;
d389 3
a391 4
	if (iface->trace & IF_TRACE_RAW)
		raw_dump(iface,IF_TRACE_OUT,bp);
	ppp_p->OutTxPacketCount++;
	return asy_send(iface->dev,bp);
a395 61
/* Queue packet for ppp_proc with full header */
/* (part of ppp_recv) */
static void
ppp_queue(ppp_p,bp,negotiated)
struct ppp_s *ppp_p;
struct mbuf *bp;
int16 negotiated;
{
	struct ppp_hdr hdr;
	struct mbuf *hbp;

	/* HDLC address and control fields may be compressed out */
	if ((byte_t)bp->data[0] != HDLC_ALL_ADDR) {
		if (!(negotiated & LCP_N_ACFC)) {
			ppp_unknown( ppp_p, bp, "missing ALL address" );
			return;
		}
	} else if ((byte_t)bp->data[1] != HDLC_UI) {
		if (!(negotiated & LCP_N_ACFC)
		 || !(negotiated & LCP_N_PFC)) {
			ppp_unknown( ppp_p, bp, "missing UI" );
			return;
		}
	} else {
		/* skip address/control fields */
		pull16(&bp);
	}

	/* Initialize the expected header */
	hdr.addr = HDLC_ALL_ADDR;
	hdr.control = HDLC_UI;
	hdr.protocol = PULLCHAR(&bp);

	/* First byte of PPP protocol field may be compressed out */
	if ( hdr.protocol & 0x01 ) {
		if (!(negotiated & LCP_N_PFC)) {
			ppp_unknown( ppp_p, bp, "missing upper protocol byte" );
			return;
		}
	} else {
		hdr.protocol = (hdr.protocol << 8) | PULLCHAR(&bp);

		/* Second byte of PPP protocol field must be odd */
		if ( !(hdr.protocol & 0x01) ) {
			ppp_unknown( ppp_p, bp, "missing lower protocol byte" );
			return;
		}
	}

	/* put full-size header on packet for dump routine */
	if ((hbp = htonppp(&hdr,bp)) == NULLBUF){
		ppp_unknown( ppp_p, bp, Nospace );
		return;
	}

	if ( net_route( ppp_p->iface, CL_PPP, hbp ) != 0 ) {
		ppp_unknown( ppp_p, hbp, Nospace );
	}
}


d405 1
a405 2
	struct ppp_s *ppp_p = ifp->extension;
	int16 negotiated = FALSE;
d412 1
a412 1
	register int mode = modeTOSS;
d431 6
a436 2
			if (mode == modeESCAPED) {
				ppp_unknown( ppp_p, head_bp, "deliberate cancellation" );
d439 2
a440 1
					ppp_unknown( ppp_p, head_bp, "checksum error" );
d443 4
a446 1
					ppp_queue(ppp_p, head_bp, negotiated);
d453 1
a453 1
			mode = modeNORMAL;
d462 1
a462 2
				negotiated = lcp_p->local.work.negotiate;
				if (negotiated & LCP_N_ACCM) {
a478 1
		 * Check for discard.
d483 1
a483 1
		if ( mode == modeTOSS ) {
d485 2
a486 4
		} else if ( c < SP_CHAR && (accm & (1L << c)) ) {
			continue;
		} else if ( mode == modeESCAPED ) {
			mode = modeNORMAL;
d489 1
a489 1
			mode = modeESCAPED;
d498 3
a500 2
				ppp_unknown( ppp_p, tail_bp, Nospace );
				mode = modeTOSS;
d509 2
a510 1
				ppp_unknown( ppp_p, head_bp, Nospace );
d512 1
a512 1
				mode = modeTOSS;
d531 4
a534 1
/*#pragma option -G-*/
d538 2
a539 2
ppp_proc(iface,bp)
struct iface *iface;
d542 1
a542 1
	struct ppp_s *ppp_p = iface->extension;
d544 1
a544 1
	struct ppp_hdr hdr;
d546 1
d548 6
a553 1
	if ( bp == NULLBUF )
d555 35
d591 9
a599 1
	ppp_p->InRxPacketCount++;
d601 7
a607 2
	/* get PPP header */
	ntohppp(&hdr, &bp);
a608 2
	/* trim off FCS bytes */
	trim_mbuf(&bp, len_p(bp)-2);
d610 1
a610 1
	switch(hdr.protocol) {
d613 2
a614 1
			ppp_in_error( ppp_p, bp, "not open for IP traffic" );
d617 1
a617 2
		ppp_p->InIP++;
		ip_route(iface,bp,0);
d622 2
a623 1
			ppp_unknown( ppp_p, bp, "not open for Compressed TCP/IP traffic" );
d629 2
a630 1
			ppp_unknown( ppp_p, bp, "Compressed TCP/IP not enabled" );
d635 2
a636 1
			ppp_in_error( ppp_p, bp, "Compressed TCP/IP packet error" );
d639 1
a639 2
		ppp_p->InIP++;
		ip_route(iface,bp,0);
d644 2
a645 1
			ppp_unknown( ppp_p, bp, "not open for Uncompressed TCP/IP traffic" );
d651 2
a652 1
			ppp_unknown( ppp_p, bp, "Uncompressed TCP/IP not enabled" );
d657 2
a658 1
			ppp_in_error( ppp_p, bp, "Uncompressed TCP/IP packet error" );
d661 1
a661 2
		ppp_p->InIP++;
		ip_route(iface,bp,0);
d670 4
a673 3
		if (ppp_p->phase != pppAP) {
			ppp_in_error( ppp_p, bp, "not in Authentication phase;"
					" dropping PAP packet" );
d681 3
a683 2
		if (ppp_p->phase < pppREADY) {
			ppp_in_error( ppp_p, bp, "not ready for IPCP traffic" );
d692 1
a692 1
			log( -1, "%s: PPP Unknown packet protocol: %x;",
d694 1
a694 1
				hdr.protocol);
d700 1
a700 1
		if ((hbp = htonppp(&hdr,bp)) == NULLBUF){
d702 1
a702 1
			free_p(bp);
d712 4
a715 1
/*#pragma option -G */
d717 1
a717 1
/****************************************************************************/
d727 1
a727 1
	struct ppp_s *ppp_p = ifp->extension;
d733 4
a736 2
		ppp_p->phase = pppLCP;
		psignal(ppp_p, 0);
d738 1
a742 8

		/* This point is a little tricky.
		 * If LCP was OPEN, it has just set the phase
		 * to TERMINATE.  But we don't want to terminate
		 * if a dialer is able to bring us up again.
		 * Otherwise, we got here because of TERMINATE.
		 * In either case, we change TERMINATE to DEAD.
		 */
a743 1
		psignal(ppp_p, 0);
d750 10
d761 4
a764 11
/****************************************************************************/
/* PPP Overall Phase Machine
 *
 *	This machine is controlled by the pwait & psignal at ppp_p,
 *	whenever the overall link phase (as opposed to the LCP state) changes.
 */
void
ppp_machine(dev,p1,p2)
int dev;
void *p1;
void *p2;
d766 1
a766 37
	struct iface *ifp = p1;
	struct ppp_s *ppp_p = ifp->extension;
	struct lcp_s *lcp_p;

	for (;;) {
		switch ( ppp_p->phase ) {
		case pppDEAD:
			pwait(ppp_p);
			break;

		case pppLCP:		/* When Physical Line Up */
					/* or Open command */
			fsm_start( &(ppp_p->fsm[Lcp]) );
			pwait(ppp_p);
			break;

		case pppAP:		/* When LCP complete */
			lcp_p = ppp_p->fsm[Lcp].pdv;
			if (lcp_p->local.work.negotiate & LCP_N_AUTHENT) {
				ppp_p->flags |= PPP_AP_LOCAL;
				pap_local(ppp_p);
			}
			if (lcp_p->remote.work.negotiate & LCP_N_AUTHENT) {
				ppp_p->flags |= PPP_AP_REMOTE;
				if (pap_remote(ppp_p) != 0) {
					ppp_p->phase = pppTERMINATE;
					break;
				}
			}
			if (ppp_p->flags & (PPP_AP_LOCAL | PPP_AP_REMOTE)) {
				pwait(ppp_p);
				psignal( ppp_p->fsm[Pap].pdv, 0 );
			} else {
				ppp_p->phase = pppREADY;
				/* no waiting */
			}
			break;
d768 1
a768 19
		case pppREADY:		/* When no authentication */
					/* or AP authentication success */
			ppp_p->upsince = time(0L);
			fsm_start( &(ppp_p->fsm[IPcp]) );
			pwait(ppp_p);
			break;

		case pppTERMINATE:	/* When LCP terminating */
					/* or AP authentication failure */
			/* Tell the dialer to shut down */
			if ( ifp->supv != NULLPROC )
				alert( ifp->supv, EABORT );

			/* Close the link, if it isn't already */
			fsm_close( &(ppp_p->fsm[Lcp]) );
			ppp_p->phase = pppDEAD;
			break;
		};
	}
d781 1
a781 2
	if ((ppp_p = callocw(1,sizeof(struct ppp_s))) == NULL)
		return -1;
d783 1
a783 1
	ifp->extension = ppp_p;
d786 1
a786 1
	ifp->status = ppp_status;
d793 3
a795 4
	ppp_p->machine = newproc( ifn = if_name( ifp, " machine" ),
			512, ppp_machine, ifp->dev, ifp, NULL, 0);
	free(ifn);
	pwait(NULL);	/* give machine a chance to run */
d808 1
a808 1
	struct ppp_s *ppp_p = ifp->extension;
a811 1
	killproc( ppp_p->machine );
d816 1
@


1.4
log
@src0318
@
text
@d16 7
a22 2
 *	Feb 91	Testing and suggestions:
 *		Glenn McGregor			(ghm@@merit.edu)
d169 1
a169 3
#ifndef PPP_NO_STATS
	ppp_p->rcverr++;
#endif
d182 1
a182 3
#ifndef PPP_NO_STATS
	ppp_p->snderr++;
#endif
d226 1
a226 1
	if (ppp_p->fsm[IPcp].state != fsmOPEN) {
d250 1
a250 3
#ifndef PPP_NO_STATS
	ppp_p->sndip++;
#endif
d369 1
a369 3
#ifndef PPP_NO_STATS
		ppp_p->sndopenflag++;
#endif
d414 1
a414 3
#ifndef PPP_NO_STATS
	ppp_p->sndpkt++;
#endif
d522 1
a522 3
#ifndef PPP_NO_STATS
					ppp_p->csumerr++;
#endif
a525 1
#ifndef PPP_NO_STATS
d527 1
a527 2
				ppp_p->rcvopenflag++;
#endif
d537 1
a537 1
			if (ppp_p->fsm[Lcp].state == fsmOPEN) {
d611 1
a611 1

d627 1
a627 3
#ifndef PPP_NO_STATS
	ppp_p->rcvpkt++;
#endif
d637 1
a637 1
		if ( ppp_p->fsm[IPcp].state != fsmOPEN ) {
d641 1
a641 3
#ifndef PPP_NO_STATS
		ppp_p->rcvip++;
#endif
d646 1
a646 1
		if ( ppp_p->fsm[IPcp].state != fsmOPEN ) {
d661 1
a661 3
#ifndef PPP_NO_STATS
		ppp_p->rcvip++;
#endif
d666 1
a666 1
		if ( ppp_p->fsm[IPcp].state != fsmOPEN ) {
d681 1
a681 3
#ifndef PPP_NO_STATS
		ppp_p->rcvip++;
#endif
d686 1
a686 3
#ifndef PPP_NO_STATS
		ppp_p->rcv[Lcp]++;
#endif
d696 1
a696 3
#ifndef PPP_NO_STATS
		ppp_p->rcv[Pap]++;
#endif
d705 1
a705 3
#ifndef PPP_NO_STATS
		ppp_p->rcv[IPcp]++;
#endif
d714 2
a715 3
#ifndef PPP_NO_STATS
		ppp_p->rcvunk++;
#endif
d731 1
d801 1
a801 6
		case pppLQP:		/* When LCP Open */
			/* not implemented */
			ppp_p->phase = pppAP;
			break;

		case pppAP:		/* When LQP complete */
a824 1
#ifndef PPP_NO_STATS
a825 1
#endif
d837 2
a838 9
			fsm_close( &(ppp_p->fsm[Lcp]), TRUE );

			/* Now, tell the device to go down.
			 * It, in turn, should tell our IO status
			 * when it has gone down.
			 */
			ifp->ioctl(ifp,PARAM_DOWN,TRUE,0L);
			tprintf("%s: PPP interface closed\n", ifp->name);
			pwait(ppp_p);
d861 2
@


1.3
log
@src0308
@
text
@d5 6
a10 1
 *	12-89	-- Katie Stevens (dkstevens@@ucdavis.edu)
d12 6
a17 10
 *	PPP.08	05-90	[ks] include PPP protocol fields for VJ TCP compression
 *	PPP.09	05-90	[ks] add UPAP negotiation and processing
 *	PPP.10	07-90	[ks] make ppp open/close/reset work properly
 *	PPP.14	08-90	[ks] change UPAP to PAP for consistency with RFC1172
 *			     add RLSD link up/down signal handling
 *			     add autobaud link speed message handling
 *			     bit-shift constants must be explicitly long if shifted more than 8 bits
 *			     must use unsigned char for comparison with SP_CHAR
 *	PPP.15	09-90 	[ks] update to KA9Q NOS v900828
 *			framing routines revamped for speed - KA9Q 1/15/91
d21 1
d24 1
a26 5
#include "ax25.h"
#include "slcomp.h"
#include "ppp.h"
#include "slip.h"
#include "asy.h"
d29 11
a39 1
#include "config.h"
a40 1
#include "devparam.h"
d42 2
a43 8
/*#include "pktdrvr.h"*/
/*#include "trace.h"*/

/* In pppcmd.c */
extern int Ppptrace;

/* Counter for PPP id field */
unsigned char Pppid;
d45 11
a56 5
/* Routines local to this file */
static struct mbuf *htonppp __ARGS((struct ppphdr *ppp, struct mbuf *data,
	int accomp, int prcomp));
static struct mbuf *ppp_decode __ARGS((struct slip *sp,unsigned char c));
static struct mbuf *ppp_encode __ARGS((struct mbuf *bp,int32 ctlmap));
d61 32
a92 32
static unsigned short fcstab[256] = {
    0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf, 
    0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7, 
    0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e, 
    0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876, 
    0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd, 
    0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5, 
    0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c, 
    0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974, 
    0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb, 
    0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3, 
    0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a, 
    0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72, 
    0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9, 
    0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1, 
    0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738, 
    0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70, 
    0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7, 
    0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff, 
    0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036, 
    0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e, 
    0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5, 
    0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd, 
    0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134, 
    0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c, 
    0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3, 
    0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb, 
    0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232, 
    0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a, 
    0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1, 
    0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9, 
    0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330, 
d95 1
d99 7
d110 2
a111 2
htonppp(ppp, data, accomp, prcomp)
struct ppphdr *ppp;
a112 2
int accomp;	/* Compress address/control fields? */
int prcomp;	/* Compress protocol field? */
a115 1
	int hdrlen;
a116 4
	if(ppp->type >= 256)
		prcomp = 0;	/* Can't compress large values */
	hdrlen = accomp ? 0 : 2;
	hdrlen += prcomp ? 1 : 2;
d118 1
a118 1
	if ((bp = pushdown(data, hdrlen)) == NULLBUF)
d123 3
a125 8
	if(!accomp){
		*cp++ = ppp->addr;
		*cp++ = ppp->control;
	}
	if(prcomp)
		*cp = ppp->type;
	else
		put16(cp,ppp->type);
d130 1
a130 4
/* Extract PPP header from incoming packet. Applies a heuristic to determine
 * if address/control compression is in use: if the frame begins with 0xff,
 * compression is off, otherwise it is on.
 */
d133 1
a133 1
struct ppphdr *ppp;
d136 59
a194 1
	int c;
d196 2
a197 20
	if((c = pullchar(bpp)) == -1)
		return -1;
	if(c != HDLC_ALL_ADDR){
		/* Compressed header */
		ppp->addr = HDLC_ALL_ADDR;
		ppp->control = HDLC_UI;
	} else {
		ppp->addr = c;
		if((c = PULLCHAR(bpp)) == -1)
			return -1;
		ppp->control = c;
		if((c = pullchar(bpp)) == -1)
			return -1;
	}
	ppp->type = c;
	if((c & 1) == 0){	/* Must be another byte */
		ppp->type <<= 8;
		if((c = pullchar(bpp)) == -1)
			return -1;
		ppp->type |= c;
d199 1
a199 1
	return(PPP_HDRLEN);
d202 1
a203 1

d215 3
a217 3
	int type = PPP_IP_TYPE;
	register struct slip *sp;
	register struct slcompress *scp;
d219 2
a220 1
	if(iface == NULLIF){
d224 3
a226 4
	sp = &Slip[iface->xdev];
	if (sp->pppio->ipcpio.ipcp_state != IPCP_OPEN) {
		free_p(bp);
		sp->pppio->snderr++;
d229 3
a231 3
	if (sp->escaped & PPP_XMT_VJCOMPR) {
		/* Look for TCP packets */
		scp = sp->slcomp;
d233 2
a234 2
		type = sl_compress_tcp(&bp, scp, 1);
		switch(type) {
d236 1
a236 1
			type = PPP_IP_TYPE;
d239 1
a239 1
			type = PPP_COMPR_TYPE;
d242 1
a242 1
			type = PPP_UNCOMP_TYPE;
d245 1
d247 1
a247 1
		}
d249 4
a252 2
	sp->pppio->sndip++;
	return (*iface->output)(iface,NULLCHAR,NULLCHAR,type,bp);
d254 2
d258 1
a258 1
ppp_output(iface,dest,source,type,data)
d262 1
a262 1
int16 type;		/* PPP Protocol Type field */
d265 1
a265 2
	struct slip *sp;
	struct ppphdr ppp;
d267 1
d269 2
a270 2
	sp = &Slip[iface->xdev];
	if (sp->pppio->state == PPP_CLOSED) {
d272 5
a276 1
		sp->pppio->snderr++;
d279 7
a285 5
	ppp.addr = HDLC_ALL_ADDR;
	ppp.control = HDLC_UI;
	ppp.type = type;
	if ((bp = htonppp(&ppp,data,sp->escaped & PPP_XMT_ACCOMP,sp->escaped & PPP_XMT_PRCOMP)) == NULLBUF) {
		free_p(data);
d288 1
d291 4
a294 4
/* Encode a raw packet in PPP framing, put on link output queue, and kick
 * transmitter
 */
int
d299 10
a308 2
	register struct slip *sp;
	struct mbuf *bp1;
d310 1
a310 2
	sp = &Slip[iface->xdev];
	dump(iface,IF_TRACE_OUT,sp->type,bp);
d313 31
a343 8
	/* Queue a frame on the PPP output queue and start transmitter */
	if ((bp1 = ppp_encode(bp,sp->pppio->ctlmap)) == NULLBUF)
		return -1;	
	if (iface->trace & IF_TRACE_RAW)
		raw_dump(iface,IF_TRACE_OUT,bp1);
	sp->pppio->sndpkt++;
	return Slip[iface->xdev].send(iface->dev,bp1);
}
d345 9
a353 11
/* Encode a packet in PPP format */
static
struct mbuf *
ppp_encode(bp,ctlmap)
struct mbuf *bp;
int32 ctlmap;
{
	struct mbuf *lbp;	/* Mbuf containing line-ready packet */
	register char *cp;
	int c;
	int16 calc_fcs;
d358 3
a360 5
	lbp = alloc_mbuf((int16)(2*len_p(bp) + HDLC_ENVLEN));
	if(lbp == NULLBUF){
		/* No space; drop */
		free_p(bp);
		return NULLBUF;
d362 1
a362 1
	cp = lbp->data;
d364 10
a373 2
	/* Flush out any line garbage */
	*cp++ = HDLC_FLAG;
a374 3
	/* Initialize FCS */
	calc_fcs = HDLC_FCS_START;

d376 1
a376 1
	while ((c = PULLCHAR(&bp)) != -1) {
d380 1
a380 1
		if ( ((c < SP_CHAR) && (ctlmap & (1L << c)))
d393 1
a393 1
	if ( ((c < SP_CHAR) && (ctlmap & (1L << c)))
d402 1
a402 1
	if ( ((c < SP_CHAR) && (ctlmap & (1L << c)))
d413 8
a420 2
	lbp->cnt = cp - lbp->data;
	return lbp;
d422 10
a431 8
/* Process incoming bytes in PPP format
 * When a buffer is complete, return it; otherwise NULLBUF
 */
static
struct mbuf *
ppp_decode(sp,c)
register struct slip *sp;
unsigned char c;	/* Incoming character */
d433 2
a434 2
	struct mbuf *bp;
	register struct pppctl *pppiop;
d436 11
a446 16
	pppiop = sp->pppio;
	switch(c){
	case HDLC_FLAG:				/* Start/end of packet */
		/* Wrap it up if end of a packet */
		if (sp->rbp != NULLBUF) {
			if (pppiop->calc_fcs == HDLC_FCS_FINAL) {
				/* Good packet, trim off FCS bytes */
				trim_mbuf(&sp->rbp, (len_p(sp->rbp)-2));
			} else {
				/* FCS doesnt match; discard packet */
/*putchar('\007');*/
				free_p(sp->rbp);
				sp->rbp = NULLBUF;
				sp->rcnt = 0;
				pppiop->csumerr++;
			}
d448 3
a450 12
		/* Prepare for next packet */
		bp = sp->rbp;
		sp->escaped &= ~PPP_BIT_BUCKET;
		sp->escaped &= ~PPP_ESCAPED;
		sp->rbp = NULLBUF;
		sp->rcnt = 0;
		pppiop->calc_fcs = HDLC_FCS_START;
		return bp;	/* Will be NULLBUF if empty frame */

	case HDLC_ESC_ASYNC:			/* Async HDLC escape char */
		sp->escaped |= PPP_ESCAPED;
		return NULLBUF;
d453 13
a465 3
	if(sp->escaped & PPP_BIT_BUCKET)
		/* Eat bytes til end of packet */
		return NULLBUF;
d467 5
a471 4
	if(sp->escaped & PPP_ESCAPED){
		/* Translate 2-char escape sequence back to original char */
		sp->escaped &= ~PPP_ESCAPED;
		c ^= HDLC_ESC_COMPL;
d473 5
a477 19
	/* We reach here with a character for the buffer;
	 * make sure there's space for it
	 */
	if(sp->rbp == NULLBUF){
		/* Allocate first mbuf for new packet */
		if((sp->rbp1 = sp->rbp = alloc_mbuf(PPP_ALLOC)) == NULLBUF)
			return NULLBUF; /* No memory, drop */
		sp->rcp = sp->rbp->data;
	} else if(sp->rbp1->cnt == PPP_ALLOC){
		/* Current mbuf is full; link in another */
		if((sp->rbp1->next = alloc_mbuf(PPP_ALLOC)) == NULLBUF){
			/* No memory, drop whole thing */
			free_p(sp->rbp);
			sp->rbp = NULLBUF;
			sp->rcnt = 0;
			return NULLBUF;
		}
		sp->rbp1 = sp->rbp1->next;
		sp->rcp = sp->rbp1->data;
a478 30
	/* Store the character, increment fragment and total
	 * byte counts
	 */
	/* Now add the actual character */
	*sp->rcp++ = c;
	sp->rbp1->cnt++;
	sp->rcnt++;
	pppiop->calc_fcs = pppfcs(pppiop->calc_fcs, c);
	return NULLBUF;
}
/* Process PPP line input */
void
ppp_recv(dev,p1,p2)
int dev;
void *p1;
void *p2;
{
	unsigned char c;
	struct mbuf *bp,*nbp;
	struct phdr phdr;
	struct slip *sp;
	int cdev;

	sp = &Slip[dev];
	cdev = sp->iface->dev;

	for(;;){
		c = sp->get(cdev);
		if((bp = ppp_decode(sp,c)) == NULLBUF)
			continue;	/* More to come */
d480 2
a481 14
		if((nbp = pushdown(bp,sizeof(phdr))) == NULLBUF){
			free_p(bp);
			continue;
		}
		phdr.iface = sp->iface;
		phdr.type = sp->type;
		memcpy(&nbp->data[0],(char *)&phdr,sizeof(phdr));
		enqueue(&Hopper,nbp);
		/* Especially on slow machines, serial I/O can be quite
		 * compute intensive, so release the machine before we
		 * go for the next packet. This will allow this packet to
		 * go on to its ultimate destination, helping pipelining
		 */
		pwait(NULL);
a484 1
/****************************************************************************/
d486 2
a487 1
/* Wait for autobaud message to set line speed then switch to regular PPP */
d489 1
a489 1
ppp_autobaud(dev,p1,p2)
d494 25
a518 47
	struct slip *sp;
	struct iface *ifp;

	sp = &Slip[dev];
	ifp = sp->iface;
	/* Wait for an autobaud message */
	asy_autobaud(ifp->dev);

	/* Ready for PPP packets */
	ifp->rxproc = newproc("ppp recv", 256, ppp_recv, ifp->xdev, NULL, NULL,0);

	/* The LCP state machine has been waiting for us */
	sp->pppio->state = PPP_CLOSED;
	lcp_reset(sp->pppio);
	lcp_start(sp);

	/* Terminate this process */
	return;
}

/* Keep track of RLSD signal; if RLSD is down, physical layer is down;
 * if RLSD is asserted, physical layer is ready for traffic
 */
void
ppp_rlsd(dev,p1,p2)
int dev;
void *p1;
void *p2;
{
	int last_rlsd = 1;
	int i;
	unsigned long autospeed;
	struct slip *sp;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	autospeed = (unsigned long)p1;
	sp = &Slip[dev];
	pppiop = sp->pppio;
	for ( ; ; ) {
		/* Wait for RLSD to change */
		if (last_rlsd == 1) {
			/* Down now, wait for RSLD to be asserted */
			i = sp->get_rlsd(sp->iface->dev, 100);
		} else {
			/* Asserted now, wait for RSLD to be dropped */
			i = sp->get_rlsd(sp->iface->dev, 1);
d520 10
a529 16

		last_rlsd = i;
/*
printf("ppp_rlsd: rlsd state change: %d\n",last_rlsd);
 */
		if (last_rlsd == 100) {
			/* Physical layer now open for traffic */
			if (Ppptrace)
				log(-1,"%s: PPP/RLSD: Physical layer ready",
					sp->iface->name);
			/* RLSD signal is asserted */
			if (pppiop->state == PPP_PL_DOWN) {
				if (autospeed == 0L) {
					pppiop->state = PPP_CLOSED;
					lcp_reset(pppiop);
					lcp_start(sp);
d531 1
a531 1
					pppiop->state = PPP_AUTOBAUD;
d533 4
d538 14
a551 13
		} else {
			/* Physical layer is down */
			if (Ppptrace)
				log(-1,"%s: PPP/RLSD: Physical layer down",
					sp->iface->name);
			/* RLSD signal not asserted */
			if ((pppiop->state != PPP_CLOSED) &&
			    (pppiop->state != PPP_AUTOBAUD)) {
				ipcpiop = &(pppiop->ipcpio);
				if (ipcpiop->ipcp_state == IPCP_OPEN) {
					/* Remove routing entry from table */
					rt_drop(ipcpiop->attempt_dest,
						(unsigned int)32);
a552 4
				/* Blast any layers that are open */
				ipcp_reset(sp);
				pap_init(sp);
				lcp_reset(pppiop);
d554 6
a559 7
			/* Physical layer closed to all traffic */
			pppiop->state = PPP_PL_DOWN;
			if (autospeed != 0L) {
				killproc(sp->iface->rxproc);
				sp->iface->rxproc = NULLPROC;
				sp->iface->rxproc = newproc("ppp autobaud", 256,
							  ppp_autobaud, sp->iface->xdev, NULL, NULL,0);
d561 2
a563 2
	}
}
d565 18
a582 1
/****************************************************************************/
d584 23
a606 9
/* Initialize PPP control structures for a Point-to-Point interface */
int
ppp_init(dev,rlsd,autospeed)
int dev;
char rlsd;
long autospeed;
{
	struct slip *sp;
	struct pppctl *pppiop;
d608 5
a612 17
	sp = &Slip[dev];
	pppiop = sp->pppio;

	if (rlsd != 0)
		pppiop->state = PPP_PL_DOWN;	/* Must wait for RLSD signal */
	else if (autospeed != 0L)
		pppiop->state = PPP_AUTOBAUD;	/* Wait for link speed msg */
	else
		pppiop->state = PPP_CLOSED;	/* Ready for traffic */
	pppiop->ctlmap = DEF_CTL_MAP;	/* Overall PPP parameters */

	lcp_init(sp);			/* Link Control parameters */
	pap_init(sp);			/* Peer Authentication parameters */
	ipcp_init(sp);			/* IP Control parameters */

	return 0;
}
d614 4
a617 14
/* Close the PPP interface */
int
ppp_close(sp,pl_too)
struct slip *sp;
int pl_too;
{
	ipcp_close(sp);			/* Close IP layer */
	lcp_close(sp);			/* Close Link layer */
	if (pl_too) {			/* Close physical layer */
		sp->iface->ioctl(sp->iface,PARAM_DTR,1,0);
	}
	sp->pppio->lcpio.active = -1;	/* We are strictly closed */
	tprintf("PPP interface  %s  closed\n",sp->iface->name);
	return 0;
d622 1
d624 1
a624 1
pproc(iface,bp)
d628 13
a640 9
	struct ppphdr hdr;
	struct pppctl *pppiop;
	struct slip *sp;
	register int16 len;

	sp = &Slip[iface->xdev];
	pppiop = Slip[iface->xdev].pppio;
	pppiop->rcvpkt++;
	/* Remove PPP header and kick packet upstairs */
d642 8
a649 12
	switch(hdr.type) {
	case PPP_IP_TYPE:	/* Regular IP */
		if ((pppiop->ipcpio.ipcp_state != IPCP_OPEN) &&
		    (pppiop->ipcpio.ipcp_state != IPCP_TERMINATE)) {
			if (Ppptrace)
				log(-1,"PPP link not open for IP traffic; dropping IP packet");
			pppiop->rcverr++;
/*
printf("rcverr: link not open for IP\n");
fflush(stdout);
 */
			free_p(bp);
d652 3
a654 7
		pppiop->rcvip++;
		if (sp->escaped & PPP_RCV_VJCOMPR) {
			if(bp->data[9] == TCP_PTCL)	/* FIX THIS! */
				sp->slcomp->sls_tcpin++;
			else
				sp->slcomp->sls_nontcpin++;
		}
d657 4
a660 10
	case PPP_COMPR_TYPE:	/* Van Jacobson Compressed TCP/IP */
		if (pppiop->ipcpio.ipcp_state != IPCP_OPEN) {
			if (Ppptrace)
				log(-1,"PPP link not open for IP traffic; dropping Compressed TCP/IP packet");
			pppiop->rcverr++;
/*
printf("rcverr: link not open for VJ Compr\n");
fflush(stdout);
 */
			free_p(bp);
d663 4
a666 9
		if ((len = len_p(bp)) < 3) {
			if (Ppptrace)
				log(-1,"VJ Compressed TCP/IP packet error: short");
			free_p(bp);
			pppiop->rcverr++;
/*
printf("rcverr: short VJ Compr pkt\n");
fflush(stdout);
 */
d669 3
a671 26
		/* Got a packet at least minimum length of
		 * a compressed packet
		 */
		if ((sp->escaped & PPP_RCV_VJCOMPR) == 0) {
			if (Ppptrace)
				log(-1,"VJ Compressed TCP/IP packet error: not enabled");
			pppiop->rcverr++;
/*
printf("rcverr: VJ Compr not enabled\n");
fflush(stdout);
 */
			free_p(bp);
			break;
		}
		/* Got a packet other than regular IP */
		len = sl_uncompress_tcp(&bp, len,
			SL_TYPE_COMPRESSED_TCP,
			sp->slcomp);
		if (len <= 0) {
			free_p(bp);
			bp = NULLBUF;
			pppiop->rcverr++;
/*
printf("rcverr: VJ Compr decompr error\n");
fflush(stdout);
 */
d674 3
a676 1
		pppiop->rcvip++;
d679 4
a682 10
	case PPP_UNCOMP_TYPE:	/* Van Jacobson Uncompressed TCP/IP */
		if (pppiop->ipcpio.ipcp_state != IPCP_OPEN) {
			if (Ppptrace)
				log(-1,"PPP link not open for IP traffic; dropping Uncompressed TCP/IP packet");
			free_p(bp);
			pppiop->rcverr++;
/*
printf("rcverr: link not open for VJ uncompr\n");
fflush(stdout);
 */
d685 4
a688 9
		if ((len = len_p(bp)) < 3) {
			if (Ppptrace)
				log(-1,"VJ Uncompressed TCP/IP packet error: short");
			free_p(bp);
			pppiop->rcverr++;
/*
printf("rcverr: short VJ Uncompr pkt\n");
fflush(stdout);
 */
d691 3
a693 26
		/* Got a packet at least minimum length of
		 * a compressed packet
		 */
		if ((sp->escaped & PPP_RCV_VJCOMPR) == 0) {
			if (Ppptrace)
				log(-1,"VJ Uncompressed TCP/IP packet error: not enabled");
			free_p(bp);
			pppiop->rcverr++;
/*
printf("rcverr: VJ Uncompr not enabled\n");
fflush(stdout);
 */
			break;
		}
		/* Got a packet other than regular IP */
		len = sl_uncompress_tcp(&bp, len,
			SL_TYPE_UNCOMPRESSED_TCP,
			sp->slcomp);
		if (len <= 0) {
			free_p(bp);
			bp = NULLBUF;
			pppiop->rcverr++;
/*
printf("rcverr: VJ Uncompr decompr error\n");
fflush(stdout);
 */
d696 3
a698 1
		pppiop->rcvip++;
d701 6
a706 3
	case PPP_LCP_TYPE:	/* Link Control Protocol */
		pppiop->rcvlcp++;
		lcpproc(iface,bp);
d708 5
a712 10
	case PPP_PAP_TYPE:	/* Password Authenticate Protocol */
		if (pppiop->lcpio.lcp_state != LCP_OPEN) {
			if (Ppptrace)
				log(-1,"not in PAP phase; dropping PAP packet");
			free_p(bp);
			pppiop->rcverr++;
/*
printf("rcverr: not open for PAP\n");
fflush(stdout);
 */
d715 4
a718 2
		pppiop->rcvpap++;
		papproc(iface,bp);
d720 4
a723 10
	case PPP_IPCP_TYPE:	/* IP Control Protocol */
		if (pppiop->lcpio.lcp_state != LCP_OPEN) {
			if (Ppptrace)
				log(-1,"IPCP closed; dropping IPCP packet");
			free_p(bp);
			pppiop->rcverr++;
/*
printf("rcverr: not open for IPCP\n");
fflush(stdout);
 */
d726 4
a729 2
		pppiop->rcvipcp++;
		ipcpproc(iface,bp);
d731 1
d733 19
a751 4
		if (Ppptrace)
			log(-1,"Unknown PPP packet type: %x; dropping packet",hdr.type);
		free_p(bp);
		pppiop->rcvunk++;
d753 173
d927 2
a928 1
	return;
d930 1
@


1.2
log
@src0221
@
text
@d25 1
a25 1
#include "slcompre.h"
@


1.1
log
@Initial revision
@
text
@d33 1
a596 6
	int argc = 2;
	char *argv[] = {
		"dtr",
		"0",
	};

d600 1
a600 1
		sp->iface->ioctl(sp->iface,argc,argv);
@
