head	1.7;
access;
symbols;
locks;
comment	@ * @;


1.7
date	93.05.06.10.10.24;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	93.02.19.22.41.58;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.01.08.23.10;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.09.18.14.32.26;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.06.07.07.07.40;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	90.12.10.07.14.58;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.7
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 *  PPPLCP.C	-- negotiate data link options
 *
 *	This implementation of PPP is declared to be in the public domain.
 *
 *	Jan 91	Bill_Simpson@@um.cc.umich.edu
 *		Computer Systems Consulting Services
 *
 *	Acknowledgements and correction history may be found in PPP.C
 */

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "socket.h"
#include "ppp.h"
#include "pppfsm.h"
#include "ppplcp.h"
#include "ppppap.h"
#include "cmdparse.h"
#include "devparam.h"
#include "trace.h"


/* These defaults are defined in the PPP RFCs, and must not be changed */
static struct lcp_value_s lcp_default = {
	FALSE,		/* no need to negotiate defaults */

	LCP_MRU_DEFAULT,
	LCP_ACCM_DEFAULT,
	0,		/* no authentication */
	0,		/* no encryption */
	0L,		/* no magic number */
	0L,		/* no reporting period */
};

/* for test purposes, accept anything we understand in the NAK */
static uint16 lcp_negotiate = LCP_N_MRU | LCP_N_ACCM | LCP_N_AUTHENT
		| LCP_N_PFC | LCP_N_ACFC | LCP_N_MAGIC;

static byte_t option_length[] = {
	 0,		/* unused */
	 4,		/* MRU */
	 6,		/* ACCM */
	 4,		/* authentication */
	 4,		/* encryption */
	 6,		/* magic number */
	 6,		/* monitor reporting period */
	 2,		/* Protocol compression */
	 2		/* Address/Control compression */
};


static int dolcp_local(int argc, char *argv[], void *p);
static int dolcp_open(int argc, char *argv[], void *p);
static int dolcp_remote(int argc, char *argv[], void *p);

static int dolcp_accm(int argc, char *argv[], void *p);
static int dolcp_acfc(int argc, char *argv[], void *p);
static int dolcp_auth(int argc, char *argv[], void *p);
static int dolcp_magic(int argc, char *argv[], void *p);
static int dolcp_mru(int argc, char *argv[], void *p);
static int dolcp_pfc(int argc, char *argv[], void *p);
static int dolcp_default(int argc, char *argv[], void *p);

static void lcp_option(struct mbuf **bpp,
			struct lcp_value_s *value_p,
			byte_t o_type,
			byte_t o_length,
			struct mbuf **copy_bpp );
static void lcp_makeoptions(struct mbuf **bpp,
			struct lcp_value_s *value_p,
			uint16 negotiating);
static struct mbuf *lcp_makereq(struct fsm_s *fsm_p);

static int lcp_check(struct mbuf **bpp,
			struct lcp_s *lcp_p,
			struct lcp_side_s *side_p,
			struct option_hdr *option_p,
			int request);

static int lcp_request(struct fsm_s *fsm_p,
			struct config_hdr *config,
			struct mbuf *data);
static int lcp_ack(struct fsm_s *fsm_p,
			struct config_hdr *ackcnf,
			struct mbuf *data);
static int lcp_nak(struct fsm_s *fsm_p,
			struct config_hdr *nakcnf,
			struct mbuf *data);
static int lcp_reject(struct fsm_s *fsm_p,
			struct config_hdr *rejcnf,
			struct mbuf *data);

static void lcp_reset(struct fsm_s *fsm_p);
static void lcp_starting(struct fsm_s *fsm_p);
static void lcp_stopping(struct fsm_s *fsm_p);

static void lcp_closing(struct fsm_s *fsm_p);
static void lcp_opening(struct fsm_s *fsm_p);

static void lcp_free(struct fsm_s *fsm_p);


static struct fsm_constant_s lcp_constants = {
	"Lcp",
	PPP_LCP_PROTOCOL,
	0x0FFE,				/* codes 1-11 recognized */

	Lcp,
	LCP_REQ_TRY,
	LCP_NAK_TRY,
	LCP_TERM_TRY,
	LCP_TIMEOUT * 1000L,

	lcp_free,

	lcp_reset,
	lcp_starting,
	lcp_opening,
	lcp_closing,
	lcp_stopping,

	lcp_makereq,
	lcp_request,
	lcp_ack,
	lcp_nak,
	lcp_reject
};


/************************************************************************/

/* "ppp <iface> lcp" subcommands */
static struct cmds Lcpcmds[] = {
	"close",	doppp_close,	0,	0,	NULLCHAR,
	"listen",	doppp_passive,	0,	0,	NULLCHAR,
	"local",	dolcp_local,	0,	0,	NULLCHAR,
	"open",		dolcp_open,	0,	0,	NULLCHAR,
	"remote",	dolcp_remote,	0,	0,	NULLCHAR,
	"timeout",	doppp_timeout,	0,	0,	NULLCHAR,
	"try",		doppp_try,	0,	0,	NULLCHAR,
	NULLCHAR,
};

/* "ppp <iface> lcp [local | remote]" subcommands */
static struct cmds Lcpside_cmds[] = {
	"accm",		dolcp_accm,	0,	0,	NULLCHAR,
	"acfc",		dolcp_acfc,	0,	0,	NULLCHAR,
	"authenticate",	dolcp_auth,	0,	0,	NULLCHAR,
	"magic",	dolcp_magic,	0,	0,	NULLCHAR,
	"mru",		dolcp_mru,	0,	0,	NULLCHAR,
	"pfc",		dolcp_pfc,	0,	0,	NULLCHAR,
	"default",	dolcp_default,	0,	0,	NULLCHAR,
	NULLCHAR,
};


int
doppp_lcp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp = p;
	register struct ppp_s *ppp_p = ifp->edv;

	return subcmd(Lcpcmds, argc, argv, &(ppp_p->fsm[Lcp]));
}


static int
dolcp_local(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct lcp_s *lcp_p = fsm_p->pdv;
	return subcmd(Lcpside_cmds, argc, argv, &(lcp_p->local));
}


static int
dolcp_open(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;

	doppp_active( argc, argv, p );

	if ( fsm_p->ppp_p->phase >= pppLCP ) {
		fsm_start( fsm_p );
	}
	return 0;
}


static int
dolcp_remote(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct lcp_s *lcp_p = fsm_p->pdv;
	return subcmd(Lcpside_cmds, argc, argv, &(lcp_p->remote));
}

/************************************************************************/

static int
dolcp_accm(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	if (argc < 2) {
		printf("0x%08lx\n",side_p->want.accm);
	} else if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_ACCM,
			"Allow ACCM", --argc, &argv[1] );
	} else {
		side_p->want.accm = strtoul(argv[1], NULLCHARP, 0);
		if ( side_p->want.accm != LCP_ACCM_DEFAULT )
			side_p->want.negotiate |= LCP_N_ACCM;
		else
			side_p->want.negotiate &= ~LCP_N_ACCM;
	}
	return 0;
}


static int
dolcp_acfc(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_ACFC,
			"Allow Address/Control Field Compression", --argc, &argv[1] );
	}
	return bit16cmd( &(side_p->want.negotiate), LCP_N_ACFC,
		"Address/Control Field Compression", argc, argv );
}


static int
dolcp_auth(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	if (argc < 2) {
		if ( side_p->want.negotiate & LCP_N_AUTHENT ) {
			switch ( side_p->want.authentication ) {
			case PPP_PAP_PROTOCOL:
				printf("Pap\n");
				break;
			default:
				printf("0x%04x\n", side_p->want.authentication);
				break;
			};
		} else {
			printf("None\n");
		}
	} else if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_AUTHENT,
			"Allow Authentication", --argc, &argv[1] );
	} else if (stricmp(argv[1],"pap") == 0) {
		side_p->want.negotiate |= LCP_N_AUTHENT;
		side_p->want.authentication = PPP_PAP_PROTOCOL;
	} else if (stricmp(argv[1],"none") == 0) {
		side_p->want.negotiate &= ~LCP_N_AUTHENT;
	} else {
		printf("allow pap none\n");
		return 1;
	}
	return 0;
}


static int
dolcp_magic(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;
	int result = 0;

	if (argc < 2) {
		printf("%d\n",side_p->want.magic_number);
	} else if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_MAGIC,
			"Allow Magic Number", --argc, &argv[1] );
	} else {
		register int32 x = strtoul(argv[1], NULLCHARP, 0);

		if ( !x ) {
			int test;

			/* Check for keyword */
			result = setbool( &test, "Magic Number", argc, argv );

			if ( test ) {
				/* Make a non-zero random number */
				x = rdclock() << ((rdclock() & 0xf)+8);
			}
		}
		if ( x ) {
			side_p->want.negotiate |= LCP_N_MAGIC;
		} else {
			side_p->want.negotiate &= ~LCP_N_MAGIC;
		}
		side_p->want.magic_number = x;
	}
	return result;
}


static int
dolcp_mru(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	if (argc < 2) {
		printf("%d\n",side_p->want.mru);
	} else if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_MRU,
			"Allow MRU", --argc, &argv[1] );
	} else {
		register int x = (int)strtol( argv[1], NULLCHARP, 0 );

		if (x < LCP_MRU_LO || x > LCP_MRU_HI) {
			printf("MRU %s (%d) out of range %d thru %d\n",
				argv[1], x, LCP_MRU_LO, LCP_MRU_HI);
			return -1;
		} else if ( x != LCP_MRU_DEFAULT ) {
			side_p->want.negotiate |= LCP_N_MRU;
		} else {
			side_p->want.negotiate &= ~LCP_N_MRU;
		}
		side_p->want.mru = x;
	}
	return 0;
}


static int
dolcp_pfc(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_PFC,
			"Allow Protocol Field Compression", --argc, &argv[1] );
	}
	return bit16cmd( &(side_p->want.negotiate), LCP_N_PFC,
		"Protocol Field Compression", argc, argv );
}


static int
dolcp_default(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	ASSIGN( side_p->want, lcp_default );
	return 0;
}


/************************************************************************/
/*			E V E N T   P R O C E S S I N G			*/
/************************************************************************/

static void
lcp_option( bpp, value_p, o_type, o_length, copy_bpp )
struct mbuf **bpp;
struct lcp_value_s *value_p;
byte_t o_type;
byte_t o_length;
struct mbuf **copy_bpp;
{
	struct mbuf *bp;
	register char *cp;
	register int toss = o_length - OPTION_HDR_LEN;

	if ((bp = alloc_mbuf(o_length)) == NULLBUF) {
		return;
	}
	cp = bp->data;
	*cp++ = o_type;
	*cp++ = o_length;

	switch ( o_type ) {
	case LCP_MRU:
		put16(cp, value_p->mru);
		toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making MRU: %d", value_p->mru);
#endif
		break;

	case LCP_ACCM:
		put32(cp, value_p->accm);
		toss -= 4;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making ACCM: 0x%08lx", value_p->accm);
#endif
		break;

	case LCP_AUTHENT:
		put16(cp, value_p->authentication);
		toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making Auth Protocol: 0x%04x",
		value_p->authentication);
#endif
		break;

	case LCP_MAGIC:
		put32(cp, value_p->magic_number);
		toss -= 4;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making Magic Number: 0x%08lx",
		value_p->magic_number);
#endif
		break;

	case LCP_PFC:
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making Protocol compression");
#endif
		break;

	case LCP_ACFC:
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making Addr/Ctl compression");
#endif
		break;

	case LCP_ENCRYPT:		/* not implemented */
	case LCP_QUALITY:		/* not implemented */
	default:
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making unimplemented type %d", o_type);
#endif
		break;
	};

	while ( toss-- > 0 ) {
		*cp++ = pullchar(copy_bpp);
	}
	bp->cnt += o_length;
	append(bpp, bp);
}


/************************************************************************/
/* Build a list of options */
static void
lcp_makeoptions(bpp, value_p, negotiating)
struct mbuf **bpp;
struct lcp_value_s *value_p;
uint16 negotiating;
{
	register int o_type;

	PPP_DEBUG_ROUTINES("lcp_makeoptions()");

	for ( o_type = 1; o_type <= LCP_OPTION_LIMIT; o_type++ ) {
		if (negotiating & (1 << o_type)) {
			lcp_option( bpp, value_p,
				o_type, option_length[ o_type ], NULLBUFP);
		}
	}
}


/************************************************************************/
/* Build a request to send to remote host */
static struct mbuf *
lcp_makereq(fsm_p)
struct fsm_s *fsm_p;
{
	struct lcp_s *lcp_p = fsm_p->pdv;
	struct mbuf *req_bp = NULLBUF;

	PPP_DEBUG_ROUTINES("lcp_makereq()");

	lcp_makeoptions( &req_bp, &(lcp_p->local.work),
				lcp_p->local.work.negotiate );
	return(req_bp);
}


/************************************************************************/
/* Check the options, updating the working values.
 * Returns -1 if ran out of data, ACK/NAK/REJ as appropriate.
 */
static int
lcp_check( bpp, lcp_p, side_p, option_p, request )
struct mbuf **bpp;
struct lcp_s *lcp_p;
struct lcp_side_s *side_p;
struct option_hdr *option_p;
int request;
{
	int toss = option_p->len - OPTION_HDR_LEN;
	int option_result = CONFIG_ACK;		/* Assume good values */

	switch(option_p->type) {
	case LCP_MRU:
		side_p->work.mru = pull16(bpp);
		toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking MRU: %d", side_p->work.mru);
#endif
		/* Check if new value is appropriate */
		if (side_p->work.mru < LCP_MRU_LO) {
			side_p->work.mru = LCP_MRU_LO;
			option_result = CONFIG_NAK;
		} else if (side_p->work.mru > LCP_MRU_HI) {
			side_p->work.mru = LCP_MRU_HI;
			option_result = CONFIG_NAK;
		}
		if ( request && (side_p->want.negotiate & LCP_N_MRU)
		  && side_p->work.mru > side_p->want.mru ) {
			side_p->work.mru = side_p->want.mru;
			option_result = side_p->want.mru;
		}
		break;

	case LCP_ACCM:
		side_p->work.accm = pull32(bpp);
		toss -= 4;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking ACCM: 0x%08lx", side_p->work.accm);
#endif
		/* Remote host may ask to escape more control  */
		/* characters than we require, but must escape */
		/* at least the control chars that we require. */
		if ( (!request || (side_p->want.negotiate & LCP_N_ACCM))
		  && side_p->work.accm !=
		       (side_p->work.accm | side_p->want.accm) ) {
			side_p->work.accm |= side_p->want.accm;
			option_result = CONFIG_NAK;
		}
		break;

	case LCP_AUTHENT:
		side_p->work.authentication = pull16(bpp);
		toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking Auth Protocol: 0x%04x",
		side_p->work.authentication);
#endif
		/* Check if new value is appropriate */
		switch ( side_p->work.authentication ) {
		case PPP_PAP_PROTOCOL:
			/* Yes */
			break;
		default:
			side_p->work.authentication = PPP_PAP_PROTOCOL;
			option_result = CONFIG_NAK;
			break;
		};
		break;

	case LCP_MAGIC:
		side_p->work.magic_number = pull32(bpp);
		toss -= 4;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking Magic Number: 0x%08lx",
		side_p->work.magic_number);
#endif

		/* Ensure that magic numbers are different */
		if (side_p->work.magic_number == 0L
		 || lcp_p->remote.work.magic_number == lcp_p->local.work.magic_number) {
			side_p->work.magic_number += rdclock();
			option_result = CONFIG_NAK;
		}
		break;

	case LCP_PFC:
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking Protocol compression");
#endif
		break;

	case LCP_ACFC:
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking Addr/Ctl compression");
#endif
		break;

	case LCP_ENCRYPT:		/* not implemented */
	case LCP_QUALITY:		/* not implemented */
	default:
		option_result = CONFIG_REJ;
		break;
	};

	if (option_p->type > LCP_OPTION_LIMIT
	 || !(side_p->will_negotiate & (1 << option_p->type))) {
		option_result = CONFIG_REJ;
	}

	if ( toss < 0 )
		return -1;

	if ( !request  &&  toss > 0 ) {
		/* toss extra bytes in option */
		while( toss-- > 0 ) {
			if ( pullchar(bpp) == -1 )
				return -1;
		}
	}

	return (option_result);
}


/************************************************************************/
/* Check Link Control options requested by the remote host */
static int
lcp_request(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct lcp_s *lcp_p = fsm_p->pdv;
	int32 signed_length = config->len;
	struct mbuf *reply_bp = NULLBUF;	/* reply packet */
	int reply_result = CONFIG_ACK;		/* reply to request */
	uint16 desired;				/* desired to negotiate */
	struct option_hdr option;		/* option header storage */
	int option_result;			/* option reply */

	PPP_DEBUG_ROUTINES("lcp_request()");
	lcp_p->remote.work.negotiate = FALSE;	/* clear flags */

	/* Process options requested by remote host */
	while (signed_length > 0  &&  ntohopt(&option, &data) != -1) {
		if ((signed_length -= option.len) < 0) {
			PPP_DEBUG_CHECKS("LCP REQ: bad header length");
			free_p(data);
			free_p(reply_bp);
			return -1;
		}

		if ( ( option_result = lcp_check( &data, lcp_p,
				&(lcp_p->remote), &option, TRUE ) ) == -1 ) {
			PPP_DEBUG_CHECKS("LCP REQ: ran out of data");
			free_p(data);
			free_p(reply_bp);
			return -1;
		}

#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS) {
	trace_log(PPPiface, "LCP REQ: result %s, option %d, length %d",
		fsmCodes[option_result],
		option.type,
		option.len);
}
#endif
		if ( option_result < reply_result ) {
			continue;
		} else if ( option_result > reply_result ) {
			/* Discard current list of replies */
			free_p(reply_bp);
			reply_bp = NULLBUF;
			reply_result = option_result;
		}

		/* remember that we processed option */
		if ( option_result != CONFIG_REJ
		  && option.type <= LCP_OPTION_LIMIT ) {
			lcp_p->remote.work.negotiate |= (1 << option.type);
		}

		/* Add option response to the return list */
		lcp_option( &reply_bp, &(lcp_p->remote.work),
			option.type, option.len, &data );
	}

	/* Now check for any missing options which are desired */
	if ( fsm_p->retry_nak > 0
	 &&  (desired = lcp_p->remote.want.negotiate
		       & ~lcp_p->remote.work.negotiate) != 0 ) {
		switch ( reply_result ) {
		case CONFIG_ACK:
			free_p(reply_bp);
			reply_bp = NULLBUF;
			reply_result = CONFIG_NAK;
			/* fallthru */
		case CONFIG_NAK:
			lcp_makeoptions( &reply_bp, &(lcp_p->remote.want),
				desired );
			fsm_p->retry_nak--;
			break;
		case CONFIG_REJ:
			/* do nothing */
			break;
		};
	} else if ( reply_result == CONFIG_NAK ) {
		/* if too many NAKs, reject instead */
		if ( fsm_p->retry_nak > 0 )
			fsm_p->retry_nak--;
		else
			reply_result = CONFIG_REJ;
	}

	/* Send ACK/NAK/REJ to remote host */
	fsm_send(fsm_p, reply_result, config->id, reply_bp);
	free_p(data);
	return (reply_result != CONFIG_ACK);
}


/************************************************************************/
/* Process configuration ACK sent by remote host */
static int
lcp_ack(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct mbuf *req_bp;
	int error = FALSE;

	PPP_DEBUG_ROUTINES("lcp_ack()");

	/* ID field must match last request we sent */
	if (config->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("LCP ACK: wrong ID");
		free_p(data);
		return -1;
	}

	/* Get a copy of last request we sent */
	req_bp = lcp_makereq(fsm_p);

	/* Overall buffer length should match */
	if (config->len != len_p(req_bp)) {
		PPP_DEBUG_CHECKS("LCP ACK: buffer length mismatch");
		error = TRUE;
	} else {
		register int req_char;
		register int ack_char;

		/* Each byte should match */
		while ((req_char = pullchar(&req_bp)) != -1) {
			if ((ack_char = pullchar(&data)) == -1
			 || ack_char != req_char ) {
				PPP_DEBUG_CHECKS("LCP ACK: data mismatch");
				/*trace_log(PPPiface, "req=%02X, ack=%02X", req_char, ack_char);*/
				error = TRUE;
				break;
			}
		}
	}
	free_p(req_bp);
	free_p(data);

	if (error) {
		return -1;
	}

	PPP_DEBUG_CHECKS("LCP ACK: valid");
	return 0;
}


/************************************************************************/
/* Process configuration NAK sent by remote host */
static int
lcp_nak(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct lcp_s *lcp_p = fsm_p->pdv;
	struct lcp_side_s *local_p = &(lcp_p->local);
	int32 signed_length = config->len;
	struct option_hdr option;
	int last_option = 0;
	int result;

	PPP_DEBUG_ROUTINES("lcp_nak()");

	/* ID field must match last request we sent */
	if (config->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("LCP NAK: wrong ID");
		free_p(data);
		return -1;
	}

	/* First, process in order.  Then, process extra "important" options */
	while (signed_length > 0  &&  ntohopt(&option, &data) != -1) {
		if ((signed_length -= option.len) < 0) {
			PPP_DEBUG_CHECKS("LCP NAK: bad header length");
			free_p(data);
			return -1;
		}
		if ( option.type > LCP_OPTION_LIMIT ) {
			PPP_DEBUG_CHECKS("LCP NAK: option out of range");
		} else if ( option.type < last_option
		  || !(local_p->work.negotiate & (1 << option.type)) ) {
			if (local_p->work.negotiate & (1 << option.type)) {
				PPP_DEBUG_CHECKS("LCP NAK: option out of order");
				free_p(data);
				return -1;		/* was requested */
			}
			local_p->work.negotiate |= (1 << option.type);
			last_option = LCP_OPTION_LIMIT + 1;
		} else {
			last_option = option.type;
		}
		if ( ( result = lcp_check( &data, lcp_p,
				local_p, &option, FALSE ) ) == -1 ) {
			PPP_DEBUG_CHECKS("LCP NAK: ran out of data");
			free_p(data);
			return -1;
		}
		/* update the negotiation status */
		if ( result == CONFIG_REJ
		  && option.type <= LCP_OPTION_LIMIT ) {
			local_p->work.negotiate &= ~(1 << option.type);
		}
	}
	PPP_DEBUG_CHECKS("LCP NAK: valid");
	free_p(data);
	return 0;
}


/************************************************************************/
/* Process configuration reject sent by remote host */
static int
lcp_reject(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct lcp_s *lcp_p = fsm_p->pdv;
	struct lcp_side_s *local_p = &(lcp_p->local);
	int32 signed_length = config->len;
	struct option_hdr option;
	int last_option = 0;

	PPP_DEBUG_ROUTINES("lcp_reject()");

	/* ID field must match last request we sent */
	if (config->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("LCP REJ: wrong ID");
		free_p(data);
		return -1;
	}

	/* Process in order, checking for errors */
	while (signed_length > 0  &&  ntohopt(&option, &data) != -1) {
		register int k;

		if ((signed_length -= option.len) < 0) {
			PPP_DEBUG_CHECKS("LCP REJ: bad header length");
			free_p(data);
			return -1;
		}
		if ( option.type > LCP_OPTION_LIMIT ) {
			PPP_DEBUG_CHECKS("LCP REJ: option out of range");
		} else if ( option.type < last_option
		 || !(local_p->work.negotiate & (1 << option.type))) {
			PPP_DEBUG_CHECKS("LCP REJ: option out of order");
			free_p(data);
			return -1;
		}
		for ( k = option.len - OPTION_HDR_LEN; k-- > 0; ) {
			if ( pullchar(&data) == -1 ) {
				PPP_DEBUG_CHECKS("LCP REJ: ran out of data");
				free_p(data);
				return -1;
			}
		}
		last_option = option.type;

		if ( option.type <= LCP_OPTION_LIMIT ) {
			local_p->work.negotiate &= ~(1 << option.type);
		}
	}
	PPP_DEBUG_CHECKS("LCP REJ: valid");
	free_p(data);
	return 0;
}


/************************************************************************/
/*			I N I T I A L I Z A T I O N			*/
/************************************************************************/

/* Check for PPP Network-Layer Protocol Phase */
void
ppp_ready(ppp_p)
struct ppp_s *ppp_p;
{
	if ( !(ppp_p->flags & (PPP_AP_LOCAL | PPP_AP_REMOTE)) ) {
		/* no pending authentication */
		ppp_p->phase = pppREADY;

		ppp_p->upsince = secclock();
		fsm_start( &(ppp_p->fsm[IPcp]) );
	}
}


/****************************************************************************/
/* Reset configuration options before request */
static void
lcp_reset(fsm_p)
struct fsm_s *fsm_p;
{
	struct lcp_s *lcp_p = 	fsm_p->pdv;

	PPP_DEBUG_ROUTINES("lcp_reset()");

	if ( lcp_p->local.want.negotiate & LCP_N_MAGIC ) {
		lcp_p->local.want.magic_number += rdclock();
	}

	ASSIGN( lcp_p->local.work, lcp_p->local.want );
	lcp_p->local.will_negotiate |= lcp_p->local.want.negotiate;

	lcp_p->remote.work.negotiate = FALSE;
	lcp_p->remote.will_negotiate |= lcp_p->remote.want.negotiate;
}


/************************************************************************/
/* Prepare to begin configuration exchange */
static void
lcp_starting(fsm_p)
struct fsm_s *fsm_p;
{
	PPP_DEBUG_ROUTINES("lcp_starting()");

	fsm_p->ppp_p->phase = pppLCP;
}


/************************************************************************/
/* After termination */
static void
lcp_stopping(fsm_p)
struct fsm_s *fsm_p;
{
	struct iface *ifp = fsm_p->ppp_p->iface;

	PPP_DEBUG_ROUTINES("lcp_stopping()");

	/* Tell the dialer to shut down */
	if ( ifp->supv != NULLPROC )
		alert( ifp->supv, EABORT );

	/* Now, tell the device to go down.
	 * In turn, it should tell our IO status
	 * when it has gone down.
	 */
	ifp->ioctl(ifp,PARAM_DOWN,TRUE,0L);
}


/************************************************************************/
/* Close higher levels in preparation for link shutdown */
static void
lcp_closing(fsm_p)
struct fsm_s *fsm_p;
{
	struct ppp_s *ppp_p = fsm_p->ppp_p;

	ppp_p->phase = pppTERMINATE;

	fsm_down( &(ppp_p->fsm[IPcp]) );
	pap_down( &(ppp_p->fsm[Pap]) );
}


#ifdef TURBOC_SWITCH_BUG
#pragma option -G-
#endif

/************************************************************************/
/* configuration negotiation complete */
static void
lcp_opening(fsm_p)
struct fsm_s *fsm_p;
{
	struct lcp_s *lcp_p = 	fsm_p->pdv;
	struct iface *ifp = 	fsm_p->ppp_p->iface;

	if (ifp->mtu != lcp_p->remote.work.mru) {
		/* Set new Max Transmission Unit for outgoing packets */
		ifp->mtu = lcp_p->remote.work.mru;
		if (PPPtrace > 1)
			trace_log(PPPiface,"    Set new MTU for outgoing packets: %d",
				ifp->mtu);
	}

	/* check for authentication */
	fsm_p->ppp_p->phase = pppAP;
	fsm_p->ppp_p->flags &= ~(PPP_AP_LOCAL | PPP_AP_REMOTE);
	free(fsm_p->ppp_p->peername);
	fsm_p->ppp_p->peername = NULLCHAR;

	if (lcp_p->local.work.negotiate & LCP_N_AUTHENT) {
		switch (lcp_p->local.work.authentication) {
		case PPP_PAP_PROTOCOL:
			pap_local(fsm_p->ppp_p);
			break;
		};
	}
	if (lcp_p->remote.work.negotiate & LCP_N_AUTHENT) {
		switch (lcp_p->remote.work.authentication) {
		case PPP_PAP_PROTOCOL:
			pap_remote(fsm_p->ppp_p);
			break;
		};
	}

	/* re-check for authentication */
	ppp_ready(fsm_p->ppp_p);
}

#ifdef TURBOC_SWITCH_BUG
#pragma option -G
#endif


/************************************************************************/
static void
lcp_free(fsm_p)
struct fsm_s *fsm_p;
{
	/* nothing to do */
}


/* Initialize configuration structure */
void
lcp_init(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[Lcp]);
	struct lcp_s *lcp_p;

	PPPtrace = ppp_p->trace;
	PPPiface = ppp_p->iface;

	PPP_DEBUG_ROUTINES("lcp_init()");

	fsm_p->ppp_p = ppp_p;
	fsm_p->pdc = &lcp_constants;
	fsm_p->pdv =
	lcp_p = callocw(1,sizeof(struct lcp_s));

	/* Set option parameters to first request defaults */
	ASSIGN( lcp_p->local.want, lcp_default );
	lcp_p->local.will_negotiate = lcp_negotiate;

	ASSIGN( lcp_p->remote.want, lcp_default );
	ASSIGN( lcp_p->remote.work, lcp_default );
	lcp_p->remote.will_negotiate = lcp_negotiate;

	fsm_init(fsm_p);
}


@


1.6
log
@Change Clock references to rdclock()
@
text
@d39 1
a39 1
static int16 lcp_negotiate = LCP_N_MRU | LCP_N_ACCM | LCP_N_AUTHENT
d55 11
a65 11
static int dolcp_local		__ARGS((int argc, char *argv[], void *p));
static int dolcp_open		__ARGS((int argc, char *argv[], void *p));
static int dolcp_remote		__ARGS((int argc, char *argv[], void *p));

static int dolcp_accm		__ARGS((int argc, char *argv[], void *p));
static int dolcp_acfc		__ARGS((int argc, char *argv[], void *p));
static int dolcp_auth		__ARGS((int argc, char *argv[], void *p));
static int dolcp_magic		__ARGS((int argc, char *argv[], void *p));
static int dolcp_mru		__ARGS((int argc, char *argv[], void *p));
static int dolcp_pfc		__ARGS((int argc, char *argv[], void *p));
static int dolcp_default	__ARGS((int argc, char *argv[], void *p));
d67 1
a67 1
static void lcp_option __ARGS((struct mbuf **bpp,
d71 2
a72 2
			struct mbuf **copy_bpp ));
static void lcp_makeoptions __ARGS((struct mbuf **bpp,
d74 2
a75 2
			int16 negotiating));
static struct mbuf *lcp_makereq __ARGS((struct fsm_s *fsm_p));
d77 1
a77 1
static int lcp_check __ARGS((struct mbuf **bpp,
d81 1
a81 1
			int request));
d83 1
a83 1
static int lcp_request	__ARGS((struct fsm_s *fsm_p,
d85 2
a86 2
			struct mbuf *data));
static int lcp_ack	__ARGS((struct fsm_s *fsm_p,
d88 2
a89 2
			struct mbuf *data));
static int lcp_nak	__ARGS((struct fsm_s *fsm_p,
d91 2
a92 2
			struct mbuf *data));
static int lcp_reject	__ARGS((struct fsm_s *fsm_p,
d94 1
a94 1
			struct mbuf *data));
d96 3
a98 3
static void lcp_reset	__ARGS((struct fsm_s *fsm_p));
static void lcp_starting __ARGS((struct fsm_s *fsm_p));
static void lcp_stopping __ARGS((struct fsm_s *fsm_p));
d100 2
a101 2
static void lcp_closing __ARGS((struct fsm_s *fsm_p));
static void lcp_opening __ARGS((struct fsm_s *fsm_p));
d103 1
a103 1
static void lcp_free	__ARGS((struct fsm_s *fsm_p));
d493 1
a493 1
int16 negotiating;
d671 1
a671 1
	int16 desired;				/* desired to negotiate */
@


1.5
log
@src0501
@
text
@d318 1
a318 1
				x = Clock << ((Clock & 0xf)+8);
d613 1
a613 1
			side_p->work.magic_number += Clock;
d963 1
a963 1
		lcp_p->local.want.magic_number += Clock;
@


1.4
log
@src0922
@
text
@d224 1
a224 1
		tprintf("0x%08lx\n",side_p->want.accm);
d268 1
a268 1
				tprintf("Pap\n");
d271 1
a271 1
				tprintf("0x%04x\n", side_p->want.authentication);
d275 1
a275 1
			tprintf("None\n");
d286 1
a286 1
		tprintf("allow pap none\n");
d303 1
a303 1
		tprintf("%d\n",side_p->want.magic_number);
d341 1
a341 1
		tprintf("%d\n",side_p->want.mru);
d349 1
a349 1
			tprintf("MRU %s (%d) out of range %d thru %d\n",
@


1.3
log
@src0609
@
text
@d16 1
d23 1
a103 1
static void lcp_init	__ARGS((struct ppp_s *ppp_p));
d167 1
a167 1
	register struct ppp_s *ppp_p = ifp->extension;
a168 1
	lcp_init(ppp_p);
d318 1
a318 1
				x = Clock | 0x80000000L;
d422 1
a422 1
	log(-1, "    making MRU: 0x%02x", value_p->mru);
d431 1
a431 1
	log(-1, "    making ACCM: 0x%08lx", value_p->accm);
d440 1
a440 1
	log(-1, "    making Auth Protocol: 0x%04x",
d450 1
a450 1
	log(-1, "    making Magic Number: 0x%08lx",
d458 1
a458 1
	log(-1, "    making Protocol compression");
d465 1
a465 1
	log(-1, "    making Addr/Ctl compression");
d474 1
a474 1
	log(-1, "    making unimplemented type %d", o_type);
d546 1
a546 1
	log(-1, "    checking MRU: 0x%02x", side_p->work.mru);
d568 1
a568 1
	log(-1, "    checking ACCM: 0x%08lx", side_p->work.accm);
d586 1
a586 1
	log(-1, "    checking Auth Protocol: 0x%04x",
d606 1
a606 1
	log(-1, "    checking Magic Number: 0x%08lx",
d621 1
a621 1
	log(-1, "    checking Protocol compression");
d628 1
a628 1
	log(-1, "    checking Addr/Ctl compression");
d697 1
a697 1
	log(-1, "LCP REQ: result %s, option %d, length %d",
d793 1
a793 1
				log (-1, "req=%02X, ack=%02X", req_char, ack_char);
d937 16
d981 2
d996 4
d1016 1
a1016 11
	switch ( ppp_p->phase ) {
	case pppREADY:
		fsm_down( &(ppp_p->fsm[IPcp]) );
		break;
	case pppAP:
		pap_down( &(ppp_p->fsm[Pap]) );
		break;
	default:
		/* nothing to do */
		break;
	};
d1018 2
a1019 2
	ppp_p->phase = pppTERMINATE;
	psignal(ppp_p, 0);
d1023 4
d1036 1
a1036 1
	if (ifp->mtu > lcp_p->remote.work.mru) {
d1040 1
a1040 1
			log(-1,"    Set new MTU for outgoing packets: %d",
d1044 1
d1046 21
a1066 1
	psignal(fsm_p->ppp_p, 0);
d1069 4
d1084 1
a1084 1
static void
d1088 1
a1088 1
	struct fsm_s *fsm_p;
d1092 1
a1095 4
	if (ppp_p->fsm[Lcp].pdv != NULL)
		return;		/* already initialized */

	fsm_p = &(ppp_p->fsm[Lcp]);
@


1.2
log
@src0318
@
text
@d21 1
d58 1
a59 2
static int dolcp_compress	__ARGS((int argc, char *argv[], void *p));
static int dolcp_default	__ARGS((int argc, char *argv[], void *p));
a61 2

static int dolcp_acfc	__ARGS((int argc, char *argv[], void *p));
d63 1
d95 2
a96 1
static void lcp_start	__ARGS((struct fsm_s *fsm_p));
d98 2
a99 2
static void lcp_closing	__ARGS((struct fsm_s *fsm_p));
static void lcp_opening	__ARGS((struct fsm_s *fsm_p));
d119 2
a120 1
	lcp_start,
d122 1
a122 1
	lcp_opening,
d132 1
a132 1
/****************************************************************************/
d137 1
d149 1
a150 1
	"compress",	dolcp_compress,	0,	2,	NULLCHAR,
d153 1
a157 7
/* "ppp <iface> lcp [local | remote] compress" subcommands */
static struct cmds Lcpcompresscmds[] = {
	"address/control", dolcp_acfc,	0,	0,	NULLCHAR,
	"protocol",	dolcp_pfc,	0,	0,	NULLCHAR,
	NULLCHAR,
};

d173 1
a173 1
int
d185 1
a185 1
int
d193 1
a193 1
	doppp_open( argc, argv, p );
d202 1
a202 1
int
d213 1
a213 2

/*******************************************/
d240 17
a293 23
dolcp_compress(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Lcpcompresscmds, argc, argv, p);
}


static int
dolcp_default(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct lcp_side_s *side_p = p;

	ASSIGN( side_p->want, lcp_default );
	return 0;
}


static int
a362 2
/*******************************************/

d364 1
a364 1
dolcp_acfc(argc,argv,p)
d372 2
a373 2
		return bit16cmd(&(side_p->will_negotiate),LCP_N_ACFC,
			"Allow Address/Control Field Compression", --argc, &argv[1] );
d375 2
a376 2
	return bit16cmd( &(side_p->want.negotiate), LCP_N_ACFC,
		"Address/Control Field Compression", argc, argv );
d381 1
a381 1
dolcp_pfc(argc,argv,p)
d388 2
a389 6
	if (stricmp(argv[1],"allow") == 0) {
		return bit16cmd(&(side_p->will_negotiate),LCP_N_PFC,
			"Allow Protocol Field Compression", --argc, &argv[1] );
	}
	return bit16cmd( &(side_p->want.negotiate), LCP_N_PFC,
		"Protocol Field Compression", argc, argv );
d961 11
a971 1
lcp_start(fsm_p)
d974 9
a982 1
	PPP_DEBUG_ROUTINES("lcp_start()");
d1028 1
a1028 1
	fsm_p->ppp_p->phase = pppLQP;
@


1.1
log
@Initial revision
@
text
@d4 6
a9 11
 *	REVISIONS:
 *	12-89	-- Katie Stevens (dkstevens@@ucdavis.edu)
 *		   UC Davis, Computing Services
 *	PPP.01	01-90	[ks] must echo requested magic# in REJ
 *	PPP.08	05-90	[ks] improve PPP trace reporting
 *	PPP.09	05-90	[ks] add auth type negotiation
 *	PPP.10	07-90	[ks] make ppp open/close/reset work properly
 *	PPP.14	08-90	[ks] change UPAP to PAP for consistency
 *			     with RFC1172
 *			     make LCP timeout configurable
 *	PPP.15	09-90	[ks] update to KA9Q NOS v900828
a14 1
#include "proc.h"
a15 1
#include "slip.h"
d17 17
d35 15
a49 2
/* Counter for PPP id field */
extern unsigned char Pppid;
a50 2
/* PPP tracing */
extern int Ppptrace;
d52 29
a80 1
static void lcp_open __ARGS((struct slip *sp));
d82 2
a83 4
static int lcp_sendreq __ARGS((struct slip *sp));
static struct mbuf *lcp_makereq __ARGS((struct lcpparm *localp));

static void lcp_rcvack __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d85 2
a86 1
static void lcp_rcvnak __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d88 2
a89 1
static void lcp_rcvrej __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d91 2
a92 1
static void lcp_rcvreq __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d94 3
a96 2
static void lcp_rcvtermack __ARGS((struct slip *sp));
static void lcp_rcvtermreq __ARGS((struct slip *sp, struct cnfhdr *rcnf));
d98 2
a99 8
static int lcp_chkack __ARGS((struct slip *sp, struct cnfhdr *ackcnf,
			struct mbuf *data));
static int lcp_chknak __ARGS((struct slip *sp, struct cnfhdr *nakcnf,
			struct mbuf *data));
static int lcp_chkrej __ARGS((struct slip *sp, struct cnfhdr *rejcnf,
			struct mbuf *data));
static void lcp_chkreq __ARGS((struct slip *sp, struct cnfhdr *reqcnf,
			struct mbuf *data));
d101 2
a102 2
static void lcp_timeout __ARGS((void *vp));
static void lcp_timer __ARGS((struct slip *sp));
a103 2
static int lcp_sendreply __ARGS((struct slip *sp, char code,
			unsigned char id, struct mbuf *data));
d105 23
a127 9
/* Possible LCP states */
char *LCPStates[] = {
	"Closed",
	"Listen",
	"Req Sent",
	"Ack Rcvd",
	"Ack Sent",
	"Open",
	"Terminate"
d130 11
a140 2
/* Possible LCP/IPCP packet types */
char *LCPCodes[] = {
a141 11
	"Config Req",
	"Config Ack",
	"Config Nak",
	"Config Rej",
	"Terminate Req",
	"Terminate Ack",
	"Code Rej",
	"Protocol Rej",
	"Echo Req",
	"Echo Reply",
	"Discard Req",
d144 9
a152 14
/* LCP default options, local */
/* Attempt: 0=dont negotiate; 1=attempt negotiation */
/* NOTE: this sructure is used to initialize the local parameter side */
/* of PPP connections; options which will not be negotiated must be   */
/* initialized to default LCP values specified in the PPP RFC         */
static struct lcpparm attempt_parms = {
	0, DEF_MRU,
	0, DEF_CTL_MAP,
	0, DEF_AUTH_TYPE,
	0, DEF_ENCR_TYPE,
	0, DEF_MAGIC_NUM,
	0, DEF_LINK_QUAL,
	0, DEF_PROT_COMPR,
	0, DEF_AC_COMPR
d154 6
a159 11
/* LCP default options, remote */
/* Accept: 0=reject negotiation; 1=negotiation okay */
static struct lcpparm accept_parms = {
	1, DEF_MRU,
	1, DEF_CTL_MAP,
	1, DEF_AUTH_TYPE,
	0, DEF_ENCR_TYPE,
	0, DEF_MAGIC_NUM,
	0, DEF_LINK_QUAL,
	1, DEF_PROT_COMPR,
	1, DEF_AC_COMPR
a161 1
/****************************************************************************/
d163 5
a167 5
/* Convert LCP/IPCP header in host form to network form */
struct mbuf *
htoncnf(cnf, data)
struct cnfhdr *cnf;
struct mbuf *data;
d169 2
a170 2
    struct mbuf *bp;
    register char *cp;
d172 3
a174 9
    /* Prepend bytes for LCP/IPCP header */
    if ((bp = pushdown(data, CNF_HDRLEN)) == NULLBUF)
	return NULLBUF;

    /* Load header with proper values */
    cp = bp->data;
    *cp++ = cnf->code;
    *cp++ = cnf->id;
    put16(cp, cnf->len);
a175 2
    return bp;
}
a176 1
/* Extract LCP/IPCP header from incoming packet */
d178 8
a185 8
ntohcnf(cnf, bpp)
struct cnfhdr *cnf;
struct mbuf **bpp;
{
    cnf->code = pullchar(bpp);
    cnf->id = pullchar(bpp);
    cnf->len = pull16(bpp);
    return(CNF_HDRLEN);
a187 1
/*******************************************/
d189 5
a193 4
/* Convert LCP/IPCP configuration option header in host form to network mbuf */
struct mbuf *
htonopt(opt)
struct opthdr *opt;
d195 1
a195 2
	struct mbuf *bp;
	register char *cp;
d197 1
a197 2
	if((bp = alloc_mbuf(OPT_HDRLEN)) == NULLBUF)
		return NULLBUF;
d199 3
a201 21
	/* Load data into LCP/IPCP configuration option header */
	cp = bp->data;
	*cp++ = opt->type;
	*cp++ = opt->len;

	bp->cnt = cp - bp->data;
	return bp;
}
/* Extract LCP/IPCP configuration option header */
int
ntohopt(opt,bpp)
struct opthdr *opt;
struct mbuf **bpp;
{
	if (opt== NULLOPTHDR || bpp == NULLBUFP)
		return -1;
	if (*bpp == NULLBUF)
		return -1;

	opt->type = pullchar(bpp);
	opt->len = pullchar(bpp);
a204 1
/****************************************************************************/
a205 1
/* Initialize Link Control Protocol state machine for config exchange */
d207 9
a215 5
lcp_start(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
a216 2
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
d218 1
a218 2
	if (Ppptrace > 5)
		log(-1, "lcp_start()");
d220 19
a238 4
	/* Leave things alone if not strictly closed */
	if ((pppiop->state != PPP_CLOSED)&&(lcpiop->lcp_state != LCP_LISTEN)
					 &&(lcpiop->lcp_state != LCP_CLOSED)) {
		return 0;
d240 2
a242 2
	/* Prepare for Link Control negotiations */
	lcp_reset(pppiop);
d244 32
a275 3
	if (lcpiop->active == -1) {
		/* We have been strictly closed with 'ppp close' command */
		return 0;
d277 2
a279 7
	/* Ready for Link Control negotiations */
	pppiop->state = PPP_LCP;
	if (lcpiop->active == 0) {
		/* Passive open; wait until remote host attempts connection */
		lcpiop->lcp_state = LCP_LISTEN;
		return 0;
	}
d281 7
a287 3
	/* Active open; begin LCP configuration negotiation */
	lcpiop->lcp_state = LCP_CLOSED;	
	return(lcp_sendreq(sp));
a289 1
/*******************************************/
d291 5
a295 4
/* Close the PPP connection from local side */
int
lcp_close(sp)
struct slip *sp;
d297 1
a297 34
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1,"lcp_close()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	ipcpiop = &(pppiop->ipcpio);
	if ((lcpiop->lcp_state == LCP_CLOSED) ||
	    (lcpiop->lcp_state == LCP_LISTEN))   {
		/* Already closed */
		return 0;
	}

	/* Need to shutdown PAP session if waiting for password */
	psignal(&(lcpiop->pap_user),0);

	/* Need to inform upper layers */
	if ((ipcpiop->ipcp_state != IPCP_CLOSED) &&
	    (ipcpiop->ipcp_state != IPCP_LISTEN))   {
		/* Wait for the IP layer to close */
		ipcp_close(sp);
		pwait(ipcpiop);
	}

	/* Set a timer against our request to shutdown */
	lcp_timer(sp);
	/* Ask remote host to shutdown */
	lcpiop->lcp_state = LCP_TERMINATE;
	lcpiop->ack_retry = 0;
	if (lcp_sendreply(sp, TERMINATE_REQ, 0, NULLBUF) == 0)
		pwait(lcpiop);
d299 1
a299 1
	pppiop->state = PPP_CLOSED;
d303 17
a319 28
/* Initialize our LCP configuration options to compiled default options */
void
lcp_init(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct timer *t;

	if (Ppptrace > 5)
		log(-1, "lcp_init()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	t = &(lcpiop->lcp_tm);

	/* One time initialization */
	lcpiop->lcp_state = LCP_CLOSED;
	lcpiop->active = 0;
	memcpy(&(lcpiop->initparm), &attempt_parms, sizeof(struct lcpparm));
	set_timer(t,LCP_TIMEOUT*1000L);
	lcp_timer(sp);			/* Set timer strictly OFF */
	stop_timer(&(lcpiop->lcp_tm));

	/* Initialization for each LCP open/close */
	lcp_reset(pppiop);
	return;
}
d321 2
a322 7
/* Link Control configuration negotiation complete */
static void
lcp_open(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d324 2
a325 2
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
d327 9
a335 9
	/* Check on Auth Protocol */
	if (lcpiop->initparm.auth_type != 0x0000) {
		/* We require authentication from the remote host */
		if (lcpiop->lclparm.auth_type != lcpiop->initparm.auth_type) {
			/* Couldnt agree on auth, shut down the link */
			if (Ppptrace)
				log(-1,"%s: Couldn't negotiate Authenticate Protocol type",sp->iface->name);
			lcp_shutdown(sp);
			return;
d337 1
d339 2
a341 4
	/* Mark LCP layer as open */
	if (Ppptrace)
		log(-1,"%s: PPP/LCP Connection Open",sp->iface->name);
	lcpiop->lcp_state = LCP_OPEN;
d343 15
a357 8
	/* Set flags in PPP control struct to reflect accepted LCP options */
	if (sp->iface->mtu > lcpiop->remparm.mru) {
		/* Set new Max Transmission Unit for outgoing packets */
		sp->iface->mtu = lcpiop->remparm.mru;
		if (Ppptrace > 1)
			log(-1,"    Set new MTU for outgoing packets: %d",
				sp->iface->mtu);
	}
d359 10
a368 40
	/* Update async control character map for outgoing packets */
	if (pppiop->ctlmap != lcpiop->remparm.ctl_map) {
		pppiop->ctlmap = lcpiop->remparm.ctl_map;
		if (Ppptrace > 1)
			log(-1,"    Set new control map for outgoing packets: 0x%08lx",
				pppiop->ctlmap);
	}

	/* Update for protocol compression for outgoing/incoming packets */
	if (lcpiop->remparm.prot_compress) {
		sp->escaped |= PPP_XMT_PRCOMP;
		if (Ppptrace > 1)
			log(-1,"    Begin protocol compression on outgoing packets");
	}
	if (lcpiop->lclparm.prot_compress) {
		sp->escaped |= PPP_RCV_PRCOMP;
		if (Ppptrace > 1)
			log(-1,"    Begin protocol compression on incoming packets");
	}

	/* Update for addr/ctl compression for outgoing/incoming packets */
	if (lcpiop->remparm.ac_compress) {
		sp->escaped |= PPP_XMT_ACCOMP;
		if (Ppptrace > 1)
			log(-1,"    Begin addr/ctl compression on outgoing packets");
	}
	if (lcpiop->lclparm.ac_compress) {
		sp->escaped |= PPP_RCV_ACCOMP;
		if (Ppptrace > 1)
			log(-1,"    Begin addr/ctl compression on incoming packets");
	}

	/* LCP is open; switch to next phase */
	if ((lcpiop->lclparm.auth_type == PAP_AUTH_TYPE) ||
	    (lcpiop->remparm.auth_type == PAP_AUTH_TYPE))  {
		/* Startup PAP negotiations (do IPCP when done with PAP) */
		pap_start(sp);
	} else {
		/* Startup IPCP negotiations */
		ipcp_start(sp);
d370 1
a370 1
	return;
a372 9
/* Reset LCP configuration options for initial request */
int
lcp_reset(pppiop)
struct pppctl *pppiop;
{
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "lcp_reset()");
d374 1
a374 13
	lcpiop = &(pppiop->lcpio);
	pppiop->ctlmap = DEF_CTL_MAP;
	if (lcpiop->active == 0)
		lcpiop->lcp_state = LCP_LISTEN;
	else
		lcpiop->lcp_state = LCP_CLOSED;
	lcpiop->ack_retry = 0;

	/* Reset our config request prarmeters to our preferred values */
	memcpy(&(lcpiop->lclparm),&(lcpiop->initparm),
				sizeof(struct lcpparm));
	memcpy(&(lcpiop->remparm),&accept_parms,
				sizeof(struct lcpparm));
d376 14
a389 4
	/* Need to shutdown PAP session if waiting for password */
	psignal(&(lcpiop->pap_user),0);

	return 0;
a391 1
/****************************************************************************/
a392 1
/* Send our LCP configuration request */
d394 4
a397 2
lcp_sendreq(sp)
struct slip *sp;
d399 1
a399 3
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct mbuf *bp;
d401 7
a407 2
	if (Ppptrace > 5)
		log(-1,"lcp_sendreq()");
a408 2
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
d410 3
a412 2
	/* Get a packet with our configuration request */
	bp = lcp_makereq(&(lcpiop->lclparm));
d414 7
a420 15
	/* Start timer against wait for reply to our config request */
	lcp_timer(sp);

	/* Send LCP configuration request to remote host */
	pppiop->state = PPP_LCP;
	if (lcpiop->lcp_state != LCP_ACK_SENT)
		lcpiop->lcp_state = LCP_REQ_SENT;
	return(lcp_sendreply(sp, CONFIG_REQ, 0, bp));
}

/*******************************************/

static struct mbuf *
lcp_makereq(localp)
struct lcpparm *localp;
d422 1
d424 1
a424 5
	struct mbuf *bp;
	struct mbuf *req_bp = NULLBUF;

	if (Ppptrace > 5)
		log(-1,"    lcp_makereq()");
d426 2
a427 90
	/* Maximum Receive Unit */
	if (localp->neg_mru) {
		if (Ppptrace > 5)
			log(-1,"    asking for MRU: %d (0x%02x)",
				localp->mru,localp->mru);

		/* Attempt to negotiate Maximum Receive Unit */
		if ((bp = alloc_mbuf(4)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = MAX_RCV_UNIT;
		*cp++ = 4;
		put16(cp, localp->mru);
		bp->cnt += 4;
		append(&req_bp, bp);
	}
	/* Async Control Map */
	if (localp->neg_ctl_map) {
		if (Ppptrace > 5)
			log(-1,"    asking for Async Control Map: 0x%08lx",
				localp->ctl_map);

		/* Attempt to negotiate Async Control Map */
		if ((bp = alloc_mbuf(6)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = ASYNC_CTL_MAP;
		*cp++ = 6;
		put32(cp, localp->ctl_map);
		bp->cnt += 6;
		append(&req_bp, bp);
	}
	/* Authentication type */
	if ((localp->neg_auth_type)&&(localp->auth_type != 0x0000)) {
		if (Ppptrace > 5)
			log(-1,"    asking for Auth Protocol: 0x%04x",
				localp->auth_type);
		/* Attempt to negotiate Authentication Protocol */
		if ((bp = alloc_mbuf(4)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = AUTH_TYPE;
		*cp++ = 4;
		put16(cp, localp->auth_type);
		bp->cnt += 4;
		append(&req_bp, bp);
	}
	/* Magic Number */
	if (localp->neg_magic_num) {
		if (Ppptrace > 5)
			log(-1,"    asking for Magic Number: %0x08lx",
				localp->magic_num);

		/* Attempt to negotiate Magic Number */
		if ((bp = alloc_mbuf(6)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = MAGIC_NUMBER;
		*cp++ = 6;
		put32(cp, localp->magic_num);
		bp->cnt += 6;
		append(&req_bp, bp);
	}
	/* Protocol Field Compression */
	if (localp->neg_prot_compress) {
		if (Ppptrace > 5)
			log(-1,"    asking for Protcol compression");

		/* Attempt to negotiate protocol field compression */
		if ((bp = alloc_mbuf(2)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = PROT_COMPRESS;
		*cp++ = 2;
		bp->cnt += 2;
		append(&req_bp, bp);
	}
	/* Address and Control Field Compression */
	if (localp->neg_ac_compress) {
		if (Ppptrace > 5)
			log(-1,"    asking for Addr/Ctl compression");

		/* Attempt to negotiate protocol field compression */
		if ((bp = alloc_mbuf(2)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = AC_COMPRESS;
		*cp++ = 2;
		bp->cnt += 2;
		append(&req_bp, bp);
d429 3
a431 32
	/* Encryption type not implemented */
	/* Link Quality Monitoring not implemented */

	return(req_bp);
}

/****************************************************************************/

/* Remote host ACKed our configuration request */
static void
lcp_rcvack(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "lcp_rcvack()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	stop_timer(&lcpiop->lcp_tm);

	switch(lcpiop->lcp_state) {
	case LCP_REQ_SENT:
		/* Make sure ACK is proper */
		if (lcp_chkack(sp, rcnf, data) != -1) {
			/* Remote host accepted our request */
			lcpiop->lcp_state = LCP_ACK_RCVD;
		}
d433 51
a483 2
		/* Still need to settle request from remote host */
		lcp_timer(sp);
d486 7
a492 10
	case LCP_ACK_SENT:
		/* Make sure ACK is proper */
		if (lcp_chkack(sp, rcnf, data) == -1) {
			/* Error in ACK from remote host */
			/* Wait for another ACK, then send another request */
			lcp_timer(sp);
		} else {
			/* LCP negotiation complete */
			lcp_open(sp);
		}
d494 1
d496 2
a497 19
	case LCP_ACK_RCVD:
	case LCP_OPEN:
		/* Something went wrong; restart negotiations */
		free_p(data);	
		lcp_reset(pppiop);
		lcp_sendreq(sp);
		break;
	case LCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request */
		free_p(data);
		break;
	case LCP_CLOSED:
	case LCP_LISTEN:
	default:
		/* Confusion; shutdown the connection */
		free_p(data);
		lcp_shutdown(sp);
		break;
d499 2
a500 1
	return;
d503 3
a505 1
/* Remote host NAKed our configuration request */
d507 4
a510 4
lcp_rcvnak(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
d512 1
a512 2
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d514 1
a514 2
	if (Ppptrace > 5)
		log(-1, "lcp_rcvnak()");
d516 4
a519 15
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	stop_timer(&lcpiop->lcp_tm);

	switch(lcpiop->lcp_state) {
	case LCP_REQ_SENT:
	case LCP_ACK_SENT:
		/* Update our config request to reflect NAKed options */
		if (lcp_chknak(sp, rcnf, data) == -1) {
			/* Bad NAK packet */
			/* Wait for another; resend request on timeout */
			lcp_timer(sp);
		} else {
			/* Send updated config request */
			lcp_sendreq(sp);
a520 21
		break;

	case LCP_ACK_RCVD:
	case LCP_OPEN:
		/* Something went wrong; restart negotiations */
		free_p(data);	
		lcp_reset(pppiop);
		lcp_sendreq(sp);
		break;
	case LCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request */
		free_p(data);
		break;
	case LCP_CLOSED:
	case LCP_LISTEN:
	default:
		/* Confusion; shutdown the connection */
		free_p(data);
		lcp_shutdown(sp);
		break;
a521 1
	return;
d524 6
a529 6
/* Remote host rejected our configuration request */
static void
lcp_rcvrej(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
d531 2
a532 2
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d534 1
a534 2
	if (Ppptrace > 5)
		log(-1, "lcp_rcvrej()");
d536 111
a646 16
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	stop_timer(&lcpiop->lcp_tm);

	switch(lcpiop->lcp_state) {
	case LCP_REQ_SENT:
	case LCP_ACK_SENT:
		/* Update our config request to reflect rejected options */
		if (lcp_chkrej(sp, rcnf, data) == -1) {
			/* Bad reject packet */
			/* Wait for another; resend request on timeout */
			lcp_timer(sp);
		} else {
			/* Send updated config request */
			lcp_sendreq(sp);
		}
d649 2
a650 14
	case LCP_ACK_RCVD:
	case LCP_OPEN:
		/* Something went wrong; restart negotiations */
		free_p(data);	
		lcp_reset(pppiop);
		lcp_sendreq(sp);
		break;
	case LCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request */
		free_p(data);
		break;
	case LCP_CLOSED:
	case LCP_LISTEN:
d652 1
a652 3
		/* Confusion; shutdown the connection */
		free_p(data);
		lcp_shutdown(sp);
d654 5
a659 2
	return;
}
d661 2
a662 9
/* Process configuration request sent by remote host */
static void
lcp_rcvreq(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d664 7
a670 2
	if (Ppptrace > 5)
		log(-1, "lcp_rcvreq()");
d672 2
a673 2
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
a674 11
	switch(lcpiop->lcp_state) {
	case LCP_LISTEN:	/* Normal event */
	case LCP_ACK_SENT:	/* Unexpected event */
	case LCP_OPEN:		/* Unexpected event */
		/* Reset LCP state machine for configuration negotiation */
		lcp_reset(pppiop);
		/* Send our configuration request */	
		lcp_sendreq(sp);
		/* Evaluate configuration request from remote host */
		lcp_chkreq(sp, rcnf, data);
		break;
d676 15
a690 7
	case LCP_ACK_RCVD:
		/* Stop timer against wait for config request */
		stop_timer(&(lcpiop->lcp_tm));
	case LCP_REQ_SENT:
		/* Evaluate configuration request from remote host */
		lcp_chkreq(sp, rcnf, data);
		break;
d692 2
a693 5
	case LCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request   */
		free_p(data);
		break;
d695 23
a717 8
	case LCP_CLOSED:
	default:
		/* We are closed; dont accept any connections */
		free_p(data);
		lcp_shutdown(sp);
		break;
	}
	return;
d719 9
d729 5
a733 7
/* Remote host closed connection */
static void
lcp_rcvtermack(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d735 4
a738 2
	if (Ppptrace > 5)
		log(-1,"lcp_rcvtermack()");
d740 23
a762 15
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	stop_timer(&(lcpiop->lcp_tm));

	switch(lcpiop->lcp_state) {
	case LCP_OPEN:
		/* Remote host has abruptly closed connection */
/* Need to inform upper levels */
	case LCP_TERMINATE:
		/* Remote host has responded to our terminate request */
		if (Ppptrace)
			log(-1,"%s: PPP/LCP Connection Closed",sp->iface->name);
		pppiop->state = PPP_CLOSED;
		if (lcpiop->active == 0)
			lcpiop->lcp_state = LCP_LISTEN;
d764 1
a764 19
			lcpiop->lcp_state = LCP_CLOSED;
		/* Prepare for next open */
		lcp_reset(pppiop);
		psignal(lcpiop,0);
		break;
	case LCP_REQ_SENT:
		/* Wait for timeout to restart attempt */
		break;
	case LCP_ACK_SENT:
	case LCP_ACK_RCVD:
		/* Something went wrong; restart negotiations */
		lcp_reset(pppiop);
		lcp_sendreq(sp);
		break;
	case LCP_CLOSED:
	case LCP_LISTEN:
	default:
		/* Unexpected, but no action needed */
		break;
d767 4
a770 56
	return;
}

/* Remote peer requested that we close the PPP connection */
void
lcp_rcvtermreq(sp, rcnf)
struct slip *sp;
struct cnfhdr *rcnf;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "lcp_termreq()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	if (Ppptrace)
		log(-1,"%s: PPP/LCP Peer requested close",sp->iface->name);
	lcpiop->active = 0;
	lcpiop->lcp_state = LCP_LISTEN;
/* Need to inform upper layers */

	lcp_sendreply(sp, TERMINATE_ACK, rcnf->id, NULLBUF);
	lcp_reset(pppiop);
	pppiop->state = PPP_CLOSED;
	return;
}

/* Shutdown the LCP connection */
void
lcp_shutdown(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "lcp_shutdown()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	if (Ppptrace)
		log(-1,"%s: PPP/LCP Connection Shutdown",sp->iface->name);
	if (lcpiop->active == 0)
		lcpiop->lcp_state = LCP_LISTEN;
	else
		lcpiop->lcp_state = LCP_CLOSED;
/* Need to inform upper layers */

	lcp_sendreply(sp,TERMINATE_ACK,0,NULLBUF);
	lcp_reset(pppiop);
	pppiop->state = PPP_CLOSED;
	return;
a772 1
/*******************************************/
d774 2
a775 1
/* Process configuration ACK send by remote host */
d777 3
a779 3
lcp_chkack(sp, ackcnf, data)
struct slip *sp;
struct cnfhdr *ackcnf;
a781 3
	int ackerr = 0;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d783 7
a789 15
	struct opthdr reqopt;
	struct opthdr ackopt;
	int16 reqi16, acki16;
	int32 reqi32, acki32;

	if (Ppptrace > 5)
		log(-1,"lcp_chkack()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* LCP ID field must match last request we sent */
	if (ackcnf->id != lcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper LCP ACK; bad ID");
d795 1
a795 1
	req_bp = lcp_makereq(&(lcpiop->lclparm));
d798 6
a803 3
	if (ackcnf->len != len_p(req_bp)) {
		ackerr = 1;
	}
d805 8
a812 32
	/* ACK must echo all options we requested in the order requested */
	while ((ntohopt(&reqopt, &req_bp) != -1) && (!ackerr)) {
		/* Get config option from ACK packet */
		if (ntohopt(&ackopt, &data) == -1) {
			/* Must have as many acked options as requested */
			ackerr = 1;
			break;
		}

		/* Config option headers must match */
		if ((ackopt.type != reqopt.type)
		   ||(ackopt.len != reqopt.len)) {
			ackerr = 1;
			break;
		}

		/* Config option values must match */
		switch(reqopt.type) {
		case MAX_RCV_UNIT:	/* Maximum Receive Unit */
		case AUTH_TYPE:		/* Authentication Protocol Type */
			acki16 = pull16(&data);
			reqi16 = pull16(&req_bp);
			if (acki16 != reqi16) {
				ackerr = 1;
			}
			break;
		case MAGIC_NUMBER:	/* Magic Number */
		case ASYNC_CTL_MAP:	/* Async Control Map */
			acki32 = pull32(&data);
			reqi32 = pull32(&req_bp);
			if (acki32 != reqi32) {
				ackerr = 1;
a813 11
			break;
		case PROT_COMPRESS:	/* Protocol Compression */
		case AC_COMPRESS:	/* Addr/Control Compression */
			/* Option ON if requested */
			break;

		case ENCR_TYPE:		/* Encryption type not implemented */
		case LINK_QUALITY:	/* Link Qual Monitor not implemented */
		default:		/* Shouldnt happen */
			ackerr = 1;
			break;
a815 1

d819 1
a819 4
	if (ackerr) {
		/* Error in configuration ACK */
		if (Ppptrace > 5)
			log(-1,"improper LCP ACK echo");
d823 1
a823 3
	/* ACK matches last request we made */
	if (Ppptrace > 5)
		log(-1,"valid LCP ACK echo");
d827 3
a829 1
/* Process configuration NAK send by remote host */
d831 3
a833 3
lcp_chknak(sp, nakcnf, data)
struct slip *sp;
struct cnfhdr *nakcnf;
d836 12
a847 21
	int nakerr = 0;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
	struct mbuf *req_bp;
	struct opthdr reqopt;
	struct opthdr nakopt;
	int16 naki16;
	int32 naki32;

	if (Ppptrace > 5)
		log(-1,"lcp_chknak()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->lclparm);

	/* LCP ID field must match last request we sent */
	if (nakcnf->id != lcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper LCP NAK; bad ID");
d852 15
a866 33
	/* Get a copy of last request we sent */
	req_bp = lcp_makereq(&(lcpiop->lclparm));

	/* Check overall buffer length */
	if (nakcnf->len > len_p(req_bp)) {
		/* Remote cant NAK more options than we requested */
		nakerr = 1;
	}

	/* NAKed options must be same order as our original request */
	while ((ntohopt(&nakopt, &data) != -1) && (!nakerr)) {
		/* Get config option from our request */
		if (ntohopt(&reqopt, &req_bp) == -1) {
			/* Must find match to each NAKed option */
			nakerr = 1;
			break;
		}

		/* Maybe not all options were NAKed; look */
		/* for matching option in our request     */
		while (reqopt.type != nakopt.type) {
			/* This option not NAKed; eat rest   */
			/* of option from the request packet */
			reqopt.len -= 2;
			while (reqopt.len--)
				pullchar(&req_bp);

			/* Get next config option from our request */
			if (ntohopt(&reqopt, &req_bp) == -1) {
				/* Must find match to each NAKed option */
				reqopt.type = 0;
				nakerr = 1;
				break;
d868 4
d873 5
a877 6

		/* Config option headers must match */
		if ((nakopt.type != reqopt.type)
		   ||(nakopt.len != reqopt.len)) {
			nakerr = 1;
			break;
d879 4
a882 73

		/* Remote host replaced our request with new suggestion */
		switch(reqopt.type) {
		case MAX_RCV_UNIT:	/* Maximum Receive Unit */
			/* Get suggested MRU */
			naki16 = pull16(&data);
			/* Eat MRU from our request packet */
			pull16(&req_bp);

			if ((naki16 < MIN_MRU)||(naki16 > DEF_MRU))
				naki16 = DEF_MRU;

			/* Save new request value */
			localp->mru = naki16;
			break;
		case ASYNC_CTL_MAP:	/* Async Control Map */
			/* Get suggested control map */
			naki32 = pull32(&data);
			/* Eat control map from our request packet */
			pull32(&req_bp);

			/* Remote host may ask to escape more control  */
			/* characters than we require, but must escape */
			/* at least the control chars that we require. */
			if (naki32 != (naki32 | lcpiop->initparm.ctl_map))
				naki32 = lcpiop->initparm.ctl_map;

			/* Save new request value */
			localp->ctl_map = naki32;
			break;
		case AUTH_TYPE:		/* Authentication Protocol Type */
			/* Get suggested Auth Protocol */
			naki16 = pull16(&data);
			/* Eat auth type from our request packet */
			pull16(&req_bp);

			/* Can only accept auth protocols we know */
			if (naki16 != PAP_AUTH_TYPE) {
				/* Abandon request for auth type */
				/* Wont open LCP layer without auth protocol */
				naki16 = DEF_AUTH_TYPE;
			}

			/* Save new request value */
			localp->mru = naki16;
			break;
		case MAGIC_NUMBER:	/* Magic Number */
			/* Get suggested magic number */
			naki32 = pull32(&data);
			/* Eat magic number from our request packet */
			pull32(&req_bp);

/* Try to prevent matching magic numbers */

			/* Save new request value */
			localp->magic_num = naki32;
			break;
		case PROT_COMPRESS:
			/* Remote host says no protocol compression */
			localp->neg_prot_compress = 0;
			localp->prot_compress = DEF_PROT_COMPR;
			break;
		case AC_COMPRESS:
			/* Remote host says no addr/ctl compression */
			localp->neg_ac_compress = 0;
			localp->ac_compress = DEF_AC_COMPR;
			break;

		case ENCR_TYPE:		/* Encryption type not implemented */
		case LINK_QUALITY:	/* Link Qual Monitor not implemented */
		default:		/* Shouldnt happen */
			nakerr = 1;
			break;
d885 1
a885 2

	free_p(req_bp);
a886 11

	if (nakerr) {
		/* Error in configuration NAK */
		if (Ppptrace > 5)
			log(-1,"improper LCP NAK echo");
		return -1;
	}

	/* NAK matches last request we made */
	if (Ppptrace > 5)
		log(-1,"valid LCP NAK echo");
d890 3
a892 1
/* Process configuration reject send by remote host */
d894 3
a896 3
lcp_chkrej(sp, rejcnf, data)
struct slip *sp;
struct cnfhdr *rejcnf;
d899 11
a909 19
	int rejerr = 0;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
	struct mbuf *req_bp;
	struct opthdr reqopt;
	struct opthdr rejopt;

	if (Ppptrace > 5)
		log(-1,"lcp_chkrej()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->lclparm);

	/* LCP ID field must match last request we sent */
	if (rejcnf->id != lcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper LCP REJ; bad ID");
d914 3
a916 2
	/* Get a copy of last request we sent */
	req_bp = lcp_makereq(&(lcpiop->lclparm));
d918 12
a929 13
	/* Check overall buffer length */
	if (rejcnf->len > len_p(req_bp)) {
		/* Remote cant NAK more options than we requested */
		rejerr = 1;
	}

	/* Rejected options must be same order as our original request */
	while ((ntohopt(&rejopt, &data) != -1) && (!rejerr)) {
		/* Get config option from our request */
		if (ntohopt(&reqopt, &req_bp) == -1) {
			/* Must find match to each NAKed option */
			rejerr = 1;
			break;
d931 5
a935 16

		/* Maybe not all options were NAKed; look */
		/* for matching option in our request     */
		while (reqopt.type != rejopt.type) {
			/* This option not NAKed; eat rest   */
			/* of option from the request packet */
			reqopt.len -= 2;
			while (reqopt.len--)
				pullchar(&req_bp);

			/* Get next config option from our request */
			if (ntohopt(&reqopt, &req_bp) == -1) {
				/* Must find match to each NAKed option */
				reqopt.type = 0;
				rejerr = 1;
				break;
d938 1
a938 57

		/* Config option headers must match */
		if ((rejopt.type != reqopt.type)
		   ||(rejopt.len != reqopt.len)) {
			rejerr = 1;
			break;
		}

		/* Remote host wont negotiate this option */
		switch(reqopt.type) {
		case MAX_RCV_UNIT:	/* Maximum Receive Unit */
			/* Eat MRU value from config packets */
			pull16(&data);
			pull16(&req_bp);

			/* Dont attempt to negotiate MRU */
			localp->neg_mru = 0;
			localp->mru = DEF_MRU;
			break;
		case ASYNC_CTL_MAP:	/* Async Control Map */
			/* Eat control map value from config packets */
			pull32(&data);
			pull32(&req_bp);

			/* Dont attempt to negotiate control map */
			localp->neg_ctl_map = 0;
			localp->ctl_map = DEF_CTL_MAP;
			break;
		case AUTH_TYPE:		/* Authentication Protocol Type */
			/* Eat auth type value from config packets */
			pull16(&data);
			pull16(&req_bp);

			/* Dont attempt to negotiate auth type */
			/* Wont open LCP layer without auth protocol */
			localp->neg_auth_type = 0;
			localp->auth_type = DEF_AUTH_TYPE;
			break;
		case MAGIC_NUMBER:	/* Magic Number */
			/* Eat magic number value from config packets */
			pull32(&data);
			pull32(&req_bp);

			/* Dont attempt to negotiate control map */
			localp->neg_magic_num = 0;
			localp->magic_num = DEF_MAGIC_NUM;
			break;
		case PROT_COMPRESS:	/* Protocol Compression */
			/* Abandon attempt to use protocol compression */
			localp->neg_prot_compress = 0;
			localp->prot_compress = DEF_PROT_COMPR;
			break;
		case AC_COMPRESS:	/* Addr/Ctl Compression */
			/* Abandon attempt to use addr/ctl compression */
			localp->neg_ac_compress = 0;
			localp->ac_compress = DEF_AC_COMPR;
			break;
d940 2
a941 5
		case ENCR_TYPE:		/* Encryption type not implemented */
		case LINK_QUALITY:	/* Link Qual Monitor not implemented */
		default:		/* Shouldnt happen */
			rejerr = 1;
			break;
d944 1
a944 2

	free_p(req_bp);
d946 2
a948 6
	if (rejerr) {
		/* Error in configuration reject */
		if (Ppptrace > 5)
			log(-1,"improper LCP REJ echo");
		return -1;
	}
d950 3
a952 5
	/* Reject matches last request we made */
	if (Ppptrace > 5)
		log(-1,"valid LCP REJ echo");
	return 0;
}
d954 1
a954 1
/* Check Link Control options requested by the remote host */
d956 2
a957 4
lcp_chkreq(sp, reqcnf, data)
struct slip *sp;
struct cnfhdr *reqcnf;
struct mbuf *data;
d959 1
a959 27
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	int ilen;
	int16 i16;
	int32 i32;
	register char *cp;
	char cnf_accept = CONFIG_ACK;		/* Overall reply to request */
	char opt_accept;			/* Per option reply */
	struct opthdr reqopt;			/* Per option header storage */
	struct opthdr replyopt;			/* For building reply */
	struct lcpparm *remotep;		/* Ptr to remote options */
	struct lcpparm *initp;			/* Ptr to initial lcl opts */
	struct mbuf *bp;			/* Ptr for building reply */
	struct mbuf *reply_bp = NULLBUF;	/* Actual reply packet */

	if (Ppptrace > 5)
		log(-1, "lcp_chkreq()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	remotep = &(lcpiop->remparm);
	initp = &(lcpiop->initparm);

	/* Make sure length in LCP config header is realistic */
	i16 = len_p(data);
	if (i16 < reqcnf->len)
		reqcnf->len = i16;
d961 1
a961 5
	/* Process options requested by remote host */
	while (reqcnf->len > 0) {
		/* Get header for next option */
		if (ntohopt(&reqopt, &data) == -1)
			break;
d963 3
a965 58
		reqcnf->len -= reqopt.len;	/* Count bytes this option */
		reqopt.len -= 2;		/* Get data len this option */
		opt_accept = CONFIG_ACK;	/* Assume will accept option */

		switch(reqopt.type) {
		case MAX_RCV_UNIT:
			if (Ppptrace > 5)
				log(-1, "remote asking for MRU");

			/* Max Receive Unit is a 16bit field */
			ilen = 2;
			if (reqopt.len < ilen) {
				/* Short option data; reject packet */
				opt_accept = CONFIG_REJ;
				i16 = DEF_MRU;
				break;
			}
			/* Get proposed value from packet */
			i16 = pull16(&data);
			if ((remotep->neg_mru == 0) && (i16 != DEF_MRU)) {
				/* Not open for negotiation */
				opt_accept = CONFIG_REJ;
				break;
			}
			/* Check if new value is appropriate */
			if (i16 < MIN_MRU) {
				/* Too small, ask for minimum instead */
				opt_accept = CONFIG_NAK;
				i16 = MIN_MRU;
			} else if (i16 > DEF_MRU) {
				/* Too big, tell largest value we can use */
				opt_accept = CONFIG_NAK;
				i16 = DEF_MRU;
			} else {
				/* Value is acceptable */
				opt_accept = CONFIG_ACK;
			}
			remotep->mru = i16;
			break;
		case ASYNC_CTL_MAP:	/* Async Control Map */
			if (Ppptrace > 5)
				log(-1, "remote asking for async control map");
			/* Async control map is a 32bit field */
			ilen = 4;
			if (reqopt.len < ilen) {
				/* Short option data; reject packet */
				opt_accept = CONFIG_REJ;
				i32 = DEF_CTL_MAP;
				break;
			}
			/* Get proposed value from packet */
			i32 = pull32(&data);
			if ((remotep->neg_ctl_map == 0)
			    && (i32 != DEF_CTL_MAP)) {
				/* Not open for negotiation */
				opt_accept = CONFIG_REJ;
				break;
			}
d967 2
a968 62
			/* Record new async control character map */
			opt_accept = CONFIG_ACK;
			remotep->ctl_map = i32;
			break;
		case AUTH_TYPE:
			if (Ppptrace > 5)
				log(-1, "remote asking for Auth Protocol type");

			/* Auth Protocol Type is a 16bit field */
			ilen = 2;
			if (reqopt.len < ilen) {
				/* Short option data; reject packet */
				opt_accept = CONFIG_REJ;
				i16 = DEF_MRU;
				break;
			}
			/* Get proposed value from packet */
			i16 = pull16(&data);
			if ((initp->neg_auth_type == 1)
				&& (initp->auth_type != DEF_AUTH_TYPE)) {
				/* We are requesting auth too;               */
				/* we only know PAP auth protocol           */
				/* PAP is a one-way authentication protocol */
				opt_accept = CONFIG_REJ;
				break;
			}
			if ((remotep->neg_auth_type == 0)
				&& (i16 != DEF_AUTH_TYPE)) {
				/* Not open for negotiation */
				opt_accept = CONFIG_REJ;
				break;
			}
			/* Check if new value is appropriate */
			if (i16 == PAP_AUTH_TYPE) {
				/* Yes, we know Password Auth Protocol */
				opt_accept = CONFIG_ACK;
			} else {
				/* We dont know this protocol */
				opt_accept = CONFIG_NAK;
				i16 = PAP_AUTH_TYPE;
			}
			remotep->auth_type = i16;
			break;
		case MAGIC_NUMBER:	/* Magic Number */
			if (Ppptrace > 5)
				log(-1, "remote asking for magic number");
			/* Magic number is a 32bit field */
			ilen = 4;
			if (reqopt.len < ilen) {
				/* Short option data; reject packet */
				opt_accept = CONFIG_REJ;
				i32 = 0L;
				break;
			}
			/* Get proposed value from packet */
			i32 = pull32(&data);
			if ((remotep->neg_magic_num == 0)
			    || (i32 == 0L)) {
				/* Not open for negotiation */
				opt_accept = CONFIG_REJ;
				break;
			}
d970 3
a972 6
			/* Remote host cant use same magic number as us */
			if (i32 == lcpiop->lclparm.magic_num) {
				opt_accept = CONFIG_NAK;
				++i32;
				break;
			}
a973 15
			/* Record new async control character map */
			opt_accept = CONFIG_ACK;
			remotep->magic_num = i32;
			break;
		case PROT_COMPRESS:
			if (Ppptrace > 5)
				log(-1, "remote asking for protocol compression");
			/* Presence of option means do protcol compression */
			ilen = 0;
			if ((remotep->neg_prot_compress == 0)
			    && (!DEF_PROT_COMPR)) {
				/* We wont do protocol compression */
				opt_accept = CONFIG_REJ;
				break;
			}
d975 8
a982 15
			/* Accept request for protocol compression */
			opt_accept = CONFIG_ACK;
			remotep->prot_compress = 1;
			break;
		case AC_COMPRESS:
			if (Ppptrace > 5)
				log(-1, "remote asking for addr/ctl compression");
			/* Presence of option means do addr/ctl compression */
			ilen = 0;
			if ((remotep->neg_ac_compress == 0)
			    && (!DEF_AC_COMPR)) {
				/* We wont do addr/ctl compression */
				opt_accept = CONFIG_REJ;
				break;
			}
a983 4
			/* Accept request for addr/ctl compression */
			opt_accept = CONFIG_ACK;
			remotep->ac_compress = 1;
			break;
d985 7
a991 17
		case ENCR_TYPE:		/* Encryption type not implemented */
		case LINK_QUALITY:	/* Link Qual Monitor not implemented */
		default:		/* Unknown option */
			if (Ppptrace > 5)
				log(-1, "remote asking for unimplemented option: %x   len: %d",
					reqopt.type, reqopt.len);
			opt_accept = CONFIG_REJ;
			ilen = reqopt.len;
			if (len_p(data) < ilen)
				ilen = len_p(data);
			/* Look for standard sizes */
			if (ilen == 2)
				i16 = pull16(&data);
			else if (ilen == 4) {
				i32 = pull32(&data);
			}
			/* Other lengths dequeued at echo time */
d993 11
a1003 59
			break;
		}
		if ((opt_accept == CONFIG_ACK) &&
		    (cnf_accept != CONFIG_ACK))
			/* This option was good, but a previous      */
			/* option was not. Return only those options */
			/* which are being nacked/rejected.          */
			continue;

		if (opt_accept == CONFIG_NAK) {
			if (cnf_accept == CONFIG_REJ)
				/* Return only those options */
				/* which are being rejected. */
				continue;
			if (cnf_accept == CONFIG_ACK) {
				/* Discard current list of good options */
				free_p(reply_bp);
				reply_bp = NULLBUF;
				/* Send a list of nacked options */
				cnf_accept = CONFIG_NAK;
			}
		}

		if (opt_accept == CONFIG_REJ) {
			if (cnf_accept != CONFIG_REJ) {
				/* Discard current list of good options */
				free_p(reply_bp);
				reply_bp = NULLBUF;
				/* Send a list of rejected options */
				cnf_accept = CONFIG_REJ;
			}
		}

		/* Add option response to the return list */
		replyopt.type = reqopt.type;
		replyopt.len = ilen + OPT_HDRLEN;
		if ((bp = htonopt(&replyopt)) == NULLBUF)
			break;
		append(&reply_bp,bp);
		if (ilen) {
			if ((bp = alloc_mbuf(ilen)) == NULLBUF)
				break;
			cp = bp->data;
			switch(ilen) {
			case 2:
				put16(cp,i16);
				bp->cnt += 2;
				break;
			case 4:
				put32(cp,i32);
				bp->cnt += 4;
				break;
			default:
				while (ilen--)
					bp->data[bp->cnt++] = pullchar(&data);
			}
			append(&reply_bp,bp);
		}
	}
d1005 2
a1006 27
	/* Send ACK/NAK/REJ to remote host */
	if (cnf_accept == CONFIG_ACK) {
		if (Ppptrace > 1)
			log(-1, "accept all options requested by remote peer");

		/* Accept configuration requested by remote host */
		lcp_sendreply(sp, CONFIG_ACK, reqcnf->id, reply_bp);
		if (lcpiop->lcp_state == LCP_REQ_SENT) {
			lcpiop->lcp_state = LCP_ACK_SENT;
		} else {
			/* LCP link now open */
			lcp_open(sp);
		}
	} else {
		if (Ppptrace > 1)
			log(-1,"options requested by remote peer not accepted: %s",
				((cnf_accept==CONFIG_NAK) ? "NAK" : "REJ"));

		/* NAK/REJ config request made by remote host */
		lcp_sendreply(sp, cnf_accept, reqcnf->id, reply_bp);

		/* Start timer against wait for amended config request */
		if (lcpiop->lcp_state == LCP_ACK_RCVD)
			lcp_timer(sp);
	}
	free_p(data);
	return;
a1008 1
/****************************************************************************/
d1010 2
a1011 1
/* Timeout while waiting for reply from remote host */
d1013 2
a1014 2
lcp_timeout(vp)
void *vp;
d1016 2
a1017 32
	struct slip *sp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 1)
		log(-1, "lcp_timeout()");

	/* Load pointers to interface that timed-out */
	sp = (struct slip *)vp;
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* Attempt to get things going again */
	switch(lcpiop->lcp_state) {
	case LCP_ACK_SENT:
		/* Remote host isnt listening to our request */
		lcp_reset(pppiop);
	case LCP_REQ_SENT:
	case LCP_ACK_RCVD:
		if (lcpiop->active == 0) {
			/* If passive open, we got a CONFIG_REQ from remote */
			/* host but no ACK in response to our CONFIG_REQ    */
			if (++lcpiop->ack_retry > LCP_RETRY_MAX) {
				/* Remote host doesnt seem to be listening */
				lcp_shutdown(sp);
				break;
			}
		}
		/* Timeout waiting for ACK to our request,         */
		/* or timeout waiting for request from remote host */
		lcp_sendreq(sp);
		break;
d1019 7
a1025 24
	case LCP_TERMINATE:
		/* Timeout waiting for terminate ACK; send another request */
		if (++lcpiop->ack_retry > LCP_TERM_RETRY) {
			/* No response to our polite request; give it up */

			if (Ppptrace)
				log(-1,"%s: PPP/LCP Connection Closed without reply from remote peer",sp->iface->name);
			if (lcpiop->active == 0)
				lcpiop->lcp_state = LCP_LISTEN;
			else
				lcpiop->lcp_state = LCP_CLOSED;

			lcp_sendreply(sp,TERMINATE_ACK,0,NULLBUF);
			lcp_reset(pppiop);
			tprintf("Still no response; marking LCP layer as closed\n");
			pppiop->state = PPP_CLOSED;
			psignal(lcpiop,0);
		} else {
			/* Request remote host to close data link */
			tprintf("Timeout waiting for response to our LCP terminate request\n");
			lcp_timer(sp);
			lcp_sendreply(sp, TERMINATE_REQ, 0, NULLBUF);
		}
		break;
d1027 2
a1028 9
	case LCP_CLOSED:
	case LCP_LISTEN:
	case LCP_OPEN:
	default:
		/* Confusion; shutdown the connection */
		lcp_shutdown(sp);
		break;
	}
	return;
d1031 2
a1032 1
/* Set a timer in case an expected event does not occur */
d1034 2
a1035 2
lcp_timer(sp)
struct slip *sp;
d1037 1
a1037 14
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct timer *t;

	if (Ppptrace > 5)
		log(-1,"lcp_timer()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	t = &(lcpiop->lcp_tm);
	t->func = (void (*)())lcp_timeout;
	t->arg = (void *)sp;
	start_timer(t);
	return;
a1039 1
/****************************************************************************/
d1041 4
a1044 7
/* Send an LCP packet to the remote host */
static int
lcp_sendreply(sp,code,id,data)
struct slip *sp;
char code;
unsigned char id;
struct mbuf *data;
d1046 4
a1049 2
	struct iface *iface;
	struct cnfhdr hdr;
d1051 1
a1051 13
	/* Load LCP header values */
	hdr.code = code;
	switch(code) {
	case CONFIG_REQ:
	case TERMINATE_REQ:
	case ECHO_REQ:
		/* Save ID field for match aginst replies from remote host */
		sp->pppio->lcpio.lastid = Pppid;
	case PROT_REJ:
	case DISCARD_REQ:
		/* Use a unique ID field value */
		hdr.id = Pppid++;
		break;
d1053 2
a1054 9
	case CONFIG_ACK:
	case CONFIG_NAK:
	case CONFIG_REJ:
	case TERMINATE_ACK:
	case CODE_REJ:
	case ECHO_REPLY:
		/* Use ID sent by remote host */
		hdr.id = id;
		break;
d1056 5
a1060 13
	default:
		/* Shouldnt happen */
		if (Ppptrace)
			log(-1, "bogus code: %x", code);
		return -1;
	}
	hdr.len = len_p(data) + CNF_HDRLEN;
	if (Ppptrace > 1) {
		log(-1, "%s: PPP/LCP Send: current state: %s   LCP option: %s   id: %d   len: %d",
			sp->iface->name,
			LCPStates[sp->pppio->lcpio.lcp_state],
			LCPCodes[code],hdr.id,hdr.len);
	}
d1062 3
a1064 3
	/* Prepend LCP header to packet data */
	if ((data = htoncnf(&hdr,data)) == NULLBUF)
		return -1;
d1066 3
a1068 49
	/* Send LCP packet to remote host */
	sp->pppio->sndlcp++;
	iface = sp->iface;
	return( (*iface->output)
		(iface, NULLCHAR, NULLCHAR, PPP_LCP_TYPE, data) );
}

/* Process incoming LCP packet */
void
lcpproc(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	struct slip *sp;
	struct cnfhdr hdr;

	sp = &Slip[iface->xdev];

	/* Extract LCP header */
	ntohcnf(&hdr, &bp);
	hdr.len -= CNF_HDRLEN;			/* Length includes envelope */
	trim_mbuf(&bp, hdr.len);		/* Trim off FCS bytes */

	if (Ppptrace > 1)
		log(-1,	"%s: PPP/LCP Recv: current state: %s:   LCP option: %s  id: %d len: %d",
			iface->name,
			LCPStates[sp->pppio->lcpio.lcp_state],
			LCPCodes[hdr.code], hdr.id, hdr.len);

	/* Process LCP packet data */
	switch(hdr.code) {
	case CONFIG_REQ:			/* Request of remote host */
		lcp_rcvreq(sp, &hdr, bp);
		break;
	case CONFIG_ACK:			/* Remote accepted our req */
		lcp_rcvack(sp, &hdr, bp);
		break;
	case CONFIG_NAK:			/* Remote adjusted our req */
		lcp_rcvnak(sp, &hdr, bp);
		break;
	case CONFIG_REJ:			/* Remote rejected our req */
		lcp_rcvrej(sp, &hdr, bp);
		break;
	case TERMINATE_REQ:			/* Remote request to close */
		lcp_rcvtermreq(sp, &hdr);
		break;
	case TERMINATE_ACK:			/* Remote closed on request */
		lcp_rcvtermack(sp);
		break;
d1070 1
a1070 16
	case CODE_REJ:
	case PROT_REJ:
	case ECHO_REQ:
	case ECHO_REPLY:
	case DISCARD_REQ:
		if (Ppptrace)
			log(-1,"Unimplemented LCP packet type: %x; dropping packet",hdr.code);
		free_p(bp);
		break;
	default:
		if (Ppptrace)
			log(-1,"Unknown LCP packet type: %x; dropping packet",hdr.code);
		free_p(bp);
		break;
	}
	return;
d1072 2
@
