head	1.8;
access;
symbols;
locks;
comment	@ * @;


1.8
date	93.05.06.10.10.28;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.02.08.39.08;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.01.08.23.14;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.03.29.03.32.04;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.09.18.14.32.24;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.06.07.05.19.46;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	90.11.11.13.58.30;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.8
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 *  PPPPAP.C	-- Password Authentication Protocol for PPP
 *
 *	This implementation of PPP is declared to be in the public domain.
 *
 *	Jan 91	Bill_Simpson@@um.cc.umich.edu
 *		Computer Systems Consulting Services
 *
 *	Acknowledgements and correction history may be found in PPP.C
 */

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "iface.h"
#include "session.h"
#include "socket.h"
#include "ppp.h"
#include "pppfsm.h"
#include "ppplcp.h"
#include "ppppap.h"
#include "cmdparse.h"
#include "files.h"
#include "trace.h"
#include "main.h"

static int dopap_user(int argc, char *argv[], void *p);

static void pap_monitor(int mustask, void *v1, void *v2);
static void pap_pwdlookup(struct pap_s *pap_p);

static struct mbuf *pap_makereq(struct fsm_s *fsm_p);

static int pap_verify(char *username, char *password);
static void pap_shutdown(struct fsm_s *fsm_p);
static void pap_opening(struct fsm_s *fsm_p, int flag);

static int pap_request(struct fsm_s *fsm_p,
			struct config_hdr *hdr,
			struct mbuf *data);
static int pap_check(struct fsm_s *fsm_p,
			struct config_hdr *hdr,
			struct mbuf *data);
static void pap_timeout(void *vp);

static void pap_free(struct fsm_s *fsm_p);


static struct fsm_constant_s pap_constants = {
	"Pap",
	PPP_PAP_PROTOCOL,
	0x000E,				/* codes 1-3 recognized */

	Pap,
	PAP_REQ_TRY,
	PAP_FAIL_MAX,
	0,
	PAP_TIMEOUT * 1000L,

	pap_free,

	fsm_no_action,		/* pap_reset, */
	fsm_no_action,		/* pap_starting, */
	fsm_no_action,		/* pap_opening, */
	fsm_no_action,		/* pap_closing, */
	fsm_no_action,		/* pap_stopping, */

	pap_makereq,
	fsm_no_check,		/* pap_request, */
	fsm_no_check,		/* pap_ack, */
	fsm_no_check,		/* pap_nak, */
	fsm_no_check,		/* pap_reject */
};


/****************************************************************************/

/* "ppp <iface> pap" subcommands */
static struct cmds Papcmds[] = {
	"timeout",	doppp_timeout,	0,	0,	NULLCHAR,
	"try",		doppp_try,	0,	0,	NULLCHAR,
	"user",		dopap_user,	0,	0,	NULLCHAR,
	NULLCHAR,
};


int
doppp_pap(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp = p;
	register struct ppp_s *ppp_p = ifp->edv;

	return subcmd(Papcmds, argc, argv, &(ppp_p->fsm[Pap]));
}


/* Set user/password */
int
dopap_user(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct fsm_s *fsm_p = p;
	register struct pap_s *pap_p = fsm_p->pdv;

	if (argc < 2) {
		printf("%s\n",
			(pap_p->username == NULLCHAR) ? "None" : pap_p->username);
		return 0;
	}
	free(pap_p->username);
	pap_p->username = NULLCHAR;
	free(pap_p->password);
	pap_p->password = NULLCHAR;

	if (stricmp(argv[1],"none") != 0) {
		pap_p->username = strdup(argv[1]);
		if (argc > 2) {
			pap_p->password = strdup(argv[2]);
		} else {
			pap_pwdlookup( pap_p );
		}
	}
	return 0;
}


/****************************************************************************/
/* Bring up a session on the console for for the username/password.
 * Return a NULLCHAR in either username or password if aborted.
 */
static void
pap_monitor(unused, v1, v2)
int unused;
void *v1;
void *v2;
{
	struct iface *iface = v1;
	struct fsm_s *fsm_p = v2;
	struct pap_s *pap_p = fsm_p->pdv;
	char buf[21];
	struct session *sp;
	int wait_code = 0;

	/* Allocate a session control block */
	if((sp = newsession("PPP/PAP",PPPPASS,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return;
	}

	while ( !main_exit && wait_code == 0 ) {
		/* get user name */
		if (pap_p->username == NULLCHAR) {
			printf ("%s: PPP/PAP  Username: ", iface->name);
			fflush(sp->output);
			if (fgets(buf,20,sp->input) != NULLCHAR) {
				rip(buf);
				if (strlen(buf) > 0) {
					pap_p->username = strdup(buf);
				}
			}
		} else {
			printf ("%s: PPP/PAP  Username: %s\n",
				iface->name, pap_p->username);
			fflush(sp->output);
		}

		/* get pass word */
		if (pap_p->username != NULLCHAR
		 && pap_p->password == NULLCHAR) {
			/* turn off echo */
			sp->ttystate.echo = 0;
			printf("%s: PPP/PAP  Password: ",iface->name);
			fflush(sp->output);
			if (fgets(buf,20,sp->input) != NULLCHAR) {
				rip(buf);
				if ( strlen(buf) > 0 ) {
					pap_p->password = strdup(buf);
				}
			}
			printf("\n");
			fflush(sp->output);
			/* Turn echo back on */
			sp->ttystate.echo = 1;
		}

		/* send pap request */
		fsm_sendreq(fsm_p);
		wait_code = pwait ( pap_p );

		/* show ack/nak reply */
		if ( wait_code != EABORT && pap_p->message != NULLCHAR ) {
			printf ("%s: PPP/PAP  %s\n",
				iface->name, pap_p->message );
		}
		printf ( "\n" );
		fflush(sp->output);

	}

	/* clean up */
	if ( wait_code != EABORT ) {
		pause ( 10000L );
	}
	freesession(sp);
	pap_p->pp = NULLPROC;
}


/* Check the FTP userfile for this user; get password if available */
static void
pap_pwdlookup(pap_p)
struct pap_s *pap_p;
{
	char *buf;
	char *password;
	int permission;

	if ( pap_p->username == NULLCHAR )
		return;

	if ( (buf = userlookup( pap_p->username, &password, NULLCHARP,
			&permission, NULL )) == NULLCHAR )
		return;

	/* Check permissions for this user */
	if ( (permission & PPP_PWD_LOOKUP) == 0 ) {
		/* Not in ftpuser file for password lookup */
		free(buf);
		return;
	}

	/* Save the password from this userfile record */
	if ( strlen(password) != 0 )
		pap_p->password = strdup(password);
	free(buf);
}


/*******************************************/
/* Verify user and password sent by remote host */
static int
pap_verify(username,password)
char *username;
char *password;
{
	int privs;
	char *path;
	int anony = 0;

	/* Use same login as FTP server */
	path = mallocw(128);
	privs = userlogin(username,password,&path,128,&anony);
	free(path);

	/* Check privs for this user */
	if (privs == -1) {
		trace_log(PPPiface,"PAP: username/password incorrect or not found: %s",
				username);
		return -1;
	}

	if ((privs & PPP_ACCESS_PRIV) == 0) {
		trace_log(PPPiface,"PAP: no permission for PPP access: %s",
				username);
		return -1;
	}
	return 0;
}


/****************************************************************************/
/* Build a request to send to remote host */
static struct mbuf *
pap_makereq(fsm_p)
struct fsm_s *fsm_p;
{
	struct pap_s *pap_p = fsm_p->pdv;
	struct mbuf *req_bp = NULLBUF;
	register char *cp;
	int len;

	PPP_DEBUG_ROUTINES("pap_makereq()");

	if ( pap_p->username == NULLCHAR
	 ||  pap_p->password == NULLCHAR ) {
		fsm_log( fsm_p, "NULL username or password" );
		return NULLBUF;
	}

#ifdef PPP_DEBUG_OPTIONS
	if (PPPtrace & PPP_DEBUG_OPTIONS)
		trace_log(PPPiface, "    making user id %s", pap_p->username);
#endif

	/* Get buffer for authenticate request packet */
	len = 2 + strlen(pap_p->username) + strlen(pap_p->password);
	if ((req_bp = alloc_mbuf(len)) == NULLBUF)
		return NULLBUF;

	/* Load user id and password for authenticate packet */
	cp = req_bp->data;
	*cp++ = (char)strlen(pap_p->username);
	if ( strlen(pap_p->username) > 0 )
		cp = stpcpy(cp, pap_p->username);

	*cp++ = (char)strlen(pap_p->password);
	if ( strlen(pap_p->password) > 0 )
		cp = stpcpy(cp, pap_p->password);

	req_bp->cnt += len;
	return(req_bp);
}


/****************************************************************************/

/* abandon PAP attempt; shutdown LCP layer */
static void
pap_shutdown(fsm_p)
struct fsm_s *fsm_p;
{
	struct ppp_s *ppp_p = fsm_p->ppp_p;

	PPP_DEBUG_ROUTINES("pap_shutdown()");

	if (PPPtrace > 1)
		fsm_log( fsm_p, "Failed; close connection" );

	fsm_close( &(ppp_p->fsm[Lcp]) );
}


/* Configuration negotiation complete */
static void
pap_opening(fsm_p, flag)
struct fsm_s *fsm_p;
int flag;
{
	register struct ppp_s *ppp_p = fsm_p->ppp_p;

	fsm_log(fsm_p, "Open");

	stop_timer(&(fsm_p->timer));

	if ( !((fsm_p->flags &= ~flag) & (PPP_AP_LOCAL | PPP_AP_REMOTE)) ) {
		fsm_p->state = fsmOPENED;
	}
	ppp_p->flags &= ~flag;
	ppp_ready(ppp_p);
}


/****************************************************************************/
/* Check request from remote host */
static int
pap_request(fsm_p, hdr, data)
struct fsm_s *fsm_p;
struct config_hdr *hdr;
struct mbuf *data;
{
	struct mbuf *reply_bp;
	int result;
	char *message;
	int mess_length;
	char *username = NULLCHAR;
	int userlen;
	char *password = NULLCHAR;
	int passwordlen;

	PPP_DEBUG_ROUTINES("pap_request()");

	/* Extract userID/password sent by remote host */
	if ( (userlen = pullchar(&data)) != -1 ) {
		register int i;
		register char *cp;

		cp = username = mallocw(userlen+1);
		for ( i = userlen; i-- > 0; ) {
			*cp++ = PULLCHAR(&data);
		}
		*cp = '\0';
	}

#ifdef PPP_DEBUG_OPTIONS
	if (PPPtrace & PPP_DEBUG_OPTIONS)
		trace_log(PPPiface,"    checking user: %s", username);
#endif

	if ( (passwordlen = pullchar(&data)) != -1 ) {
		register int i;
		register char *cp;

		cp = password = mallocw(passwordlen+1);
		for ( i = passwordlen; i-- > 0; ) {
			*cp++ = PULLCHAR(&data);
		}
		*cp = '\0';
	}

#ifdef PPP_DEBUG_OPTIONS
	if (PPPtrace & PPP_DEBUG_OPTIONS)
		trace_log(PPPiface,"    checking password: %s", password);
#endif

	if (pap_verify(username,password) == 0) {
		free( fsm_p->ppp_p->peername );
		fsm_p->ppp_p->peername = strdup(username);
		result = CONFIG_ACK;
		message = " Welcome";
	} else {
		result = CONFIG_NAK;
		message = " Invalid username or password";
	}

	/* the space at the beginning of the message is crucial */
	/* it is replaced with the length of the message */
	mess_length = strlen(message);
	reply_bp = qdata(message,mess_length);
	reply_bp->data[0] = (char)(mess_length - 1);

	fsm_send(fsm_p, result, hdr->id, reply_bp);

	if (result == CONFIG_NAK) {
		if ( fsm_p->retry_nak > 0 ) {
			fsm_p->retry_nak--;
		} else {
			pap_shutdown(fsm_p);
		}
	}
	free_p(data);
	free(username);
	free(password);
	return (result != CONFIG_ACK);
}


/* Check acknowledgement from remote host */
static int
pap_check(fsm_p, hdr, data)
struct fsm_s *fsm_p;
struct config_hdr *hdr;
struct mbuf *data;
{
	struct pap_s *pap_p = fsm_p->pdv;
	char *message;
	int mess_length;
	int full_length;
	int len;

	PPP_DEBUG_ROUTINES("pap_check()");

	/* ID field must match last request we sent */
	if (hdr->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("PAP: wrong ID");
		printf ("id mismatch hdrid=%d, lastid=%d\n",
			hdr->id, fsm_p->lastid);
		free_p(data);
		return -1;
	}

	/* Log ASCII message from remote host, if any */
	if ( (mess_length = pullchar(&data)) != -1 ) {
		message = mallocw( mess_length+1 );
		full_length = len_p(data);
		len = dqdata(data, message, mess_length);
		message[len] = '\0';

		free( pap_p->message );
		pap_p->message = message;

		if (PPPtrace) {
			trace_log(PPPiface,"%s PPP/PAP %s %s: %s",
				fsm_p->ppp_p->iface->name,
				(len < mess_length) ? "Short"
				   : (mess_length < full_length) ? "Long"
					: "Valid",
				(hdr->code == CONFIG_ACK) ? "Ack" : "Nak",
				message);
		}
		return (len < mess_length  ||  mess_length < full_length);
	}
	free_p(data);
	PPP_DEBUG_CHECKS( "PAP: missing message count" );
	return -1;
}


/************************************************************************/
/*			E V E N T   P R O C E S S I N G			*/
/************************************************************************/

/* Process incoming packet */
void
pap_proc(fsm_p,bp)
struct fsm_s *fsm_p;
struct mbuf *bp;
{
	struct pap_s *pap_p = fsm_p->pdv;
	struct config_hdr hdr;

	PPPtrace = fsm_p->ppp_p->trace;
	PPPiface = fsm_p->ppp_p->iface;

	if ( ntohcnf(&hdr, &bp) == -1 )
		fsm_log( fsm_p, "short authentication packet" );

	if (PPPtrace > 1)
		trace_log(PPPiface, "%s PPP/%s Recv,"
			"  option: %s, id: %d, len: %d",
			fsm_p->ppp_p->iface->name,
			fsm_p->pdc->name,
			fsmCodes[hdr.code],
			hdr.id,	hdr.len);

	hdr.len -= CONFIG_HDR_LEN;		/* Length includes envelope */
	trim_mbuf(&bp, hdr.len);		/* Trim off padding */

	switch(hdr.code) {
	case CONFIG_REQ:
		if ( pap_request(fsm_p, &hdr, bp) == 0) {
			pap_opening(fsm_p, PPP_AP_LOCAL);
		}
		break;

	case CONFIG_ACK:
		if (pap_check(fsm_p, &hdr, bp) == 0) {
			alert ( pap_p->pp, -1 );
			pap_opening(fsm_p, PPP_AP_REMOTE);
		}
		break;

	case CONFIG_NAK:
		if (pap_check(fsm_p, &hdr, bp) == 0) {
			stop_timer(&(fsm_p->timer));

			/* Must have sent a bad username or password */
			free ( pap_p->username );
			pap_p->username = NULLCHAR;
			free ( pap_p->password );
			pap_p->password = NULLCHAR;

			psignal ( pap_p, 1 );
		}
		break;

	default:
		if (PPPtrace)
			trace_log(PPPiface, "%s PPP/Pap Unknown packet type: %d;"
				" dropping packet",
				fsm_p->ppp_p->iface->name,
				hdr.code);
		free_p(bp);
		break;
	}
}


/* Timeout while waiting for reply from remote host */
static void
pap_timeout(vp)
void *vp;
{
	struct fsm_s *fsm_p = (struct fsm_s *)vp;
	struct pap_s *pap_p = fsm_p->pdv;

	PPPtrace = fsm_p->ppp_p->trace;
	PPPiface = fsm_p->ppp_p->iface;

	fsm_log( fsm_p, "Timeout" );

	if (fsm_p->retry > 0) {
		free ( pap_p->message );
		pap_p->message = strdup("Request timeout");
		psignal ( pap_p, 1 );
	} else {
		free ( pap_p->message );
		pap_p->message = strdup("Request retry exceeded");
		psignal ( pap_p, 1 );
		pwait ( NULL );
		fsm_log(fsm_p, "Request retry exceeded");
		pap_shutdown(fsm_p);
	}
}


/************************************************************************/
/*			I N I T I A L I Z A T I O N			*/
/************************************************************************/

void
pap_down(fsm_p)
struct fsm_s *fsm_p;
{
	struct pap_s *pap_p = fsm_p->pdv;

	if ( pap_p == NULL )
		return;

	PPPtrace = fsm_p->ppp_p->trace;
	PPPiface = fsm_p->ppp_p->iface;

	fsm_log(fsm_p, "Down");

	fsm_p->flags = FALSE;

	switch ( fsm_p->state ) {
	case fsmREQ_Sent:
		stop_timer(&(fsm_p->timer));
		alert ( pap_p->pp, EABORT );
		/* fallthru */
	case fsmOPENED:
	case fsmLISTEN:
	case fsmTERM_Sent:
		fsm_p->state = fsmCLOSED;
		break;

	case fsmCLOSED:
		/* Already closed; nothing to do */
		break;
	};
}


static void
pap_free(fsm_p)
struct fsm_s *fsm_p;
{
	struct pap_s *pap_p = fsm_p->pdv;

	free( pap_p->username );
	free( pap_p->password );
	free( pap_p->message );
}


/* Initialize configuration structure */
void
pap_init(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[Pap]);
	struct timer *t;

	PPPtrace = ppp_p->trace;
	PPPiface = ppp_p->iface;

	PPP_DEBUG_ROUTINES("pap_init()");

	if (fsm_p->pdv != NULL)
		return;		/* already initialized */

	fsm_p->ppp_p = ppp_p;
	fsm_p->pdc = &pap_constants;
	fsm_p->pdv = callocw(1,sizeof(struct pap_s));

	fsm_p->try_req = fsm_p->pdc->try_req;
	fsm_p->try_nak = fsm_p->pdc->try_nak;
	fsm_p->try_terminate = fsm_p->pdc->try_terminate;

	fsm_p->state = fsmCLOSED;
	fsm_p->retry = fsm_p->try_req;
	fsm_p->retry_nak = fsm_p->try_nak;

	/* Initialize timer */
	t = &(fsm_p->timer);
	t->func = (void (*)())pap_timeout;
	t->arg = (void *)fsm_p;
	set_timer(t, fsm_p->pdc->timeout);
	fsm_timer(fsm_p);
	stop_timer(t);
}


/* Initialize state machine for local */
int
pap_local(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[Pap]);

	PPPtrace = ppp_p->trace;

	PPP_DEBUG_ROUTINES("pap_local()");

	fsm_p->state = fsmLISTEN;
	fsm_p->flags |= PPP_AP_LOCAL;
	ppp_p->flags |= PPP_AP_LOCAL;
	fsm_p->retry = fsm_p->try_req;
	return 0;
}


/* Initialize state machine for remote */
int
pap_remote(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[Pap]);
	struct pap_s *pap_p = fsm_p->pdv;
	char *ifn;

	PPPtrace = ppp_p->trace;

	PPP_DEBUG_ROUTINES("pap_remote()");

	fsm_p->state = fsmREQ_Sent;
	fsm_p->flags |= PPP_AP_REMOTE;
	ppp_p->flags |= PPP_AP_REMOTE;

	/* build a process/session to monitor user/password progress */
	ifn = if_name( ppp_p->iface, " PAP" );
	pap_p->pp = newproc( ifn,
		512, pap_monitor, 0, ppp_p->iface, fsm_p, 0);
	free( ifn );

	return 0;
}


@


1.7
log
@src0503
@
text
@d28 1
a28 1
static int dopap_user		__ARGS((int argc, char *argv[], void *p));
d30 2
a31 2
static void pap_monitor __ARGS((int mustask, void *v1, void *v2));
static void pap_pwdlookup __ARGS((struct pap_s *pap_p));
d33 1
a33 1
static struct mbuf *pap_makereq __ARGS((struct fsm_s *fsm_p));
d35 3
a37 3
static int pap_verify __ARGS((char *username, char *password));
static void pap_shutdown __ARGS((struct fsm_s *fsm_p));
static void pap_opening __ARGS((struct fsm_s *fsm_p, int flag));
d39 1
a39 1
static int pap_request	__ARGS((struct fsm_s *fsm_p,
d41 2
a42 2
			struct mbuf *data));
static int pap_check	__ARGS((struct fsm_s *fsm_p,
d44 2
a45 2
			struct mbuf *data));
static void pap_timeout	__ARGS((void *vp));
d47 1
a47 1
static void pap_free	__ARGS((struct fsm_s *fsm_p));
@


1.6
log
@src0501
@
text
@d160 2
a161 2
			usflush(sp->output);
			if (recvline(sp->input,buf,20) > 0) {
d170 1
a170 1
			usflush(sp->output);
d179 2
a180 2
			usflush(sp->output);
			if (recvline(sp->input,buf,20) > 0) {
d187 1
a187 1
			usflush(sp->output);
d202 1
a202 1
		usflush(sp->output);
@


1.5
log
@src0331
@
text
@d112 1
a112 1
		tprintf("%s\n",
d152 1
a152 1
		tprintf("Too many sessions\n");
d159 1
a159 1
			tprintf ("%s: PPP/PAP  Username: ", iface->name);
d168 1
a168 1
			tprintf ("%s: PPP/PAP  Username: %s\n",
d178 1
a178 1
			tprintf("%s: PPP/PAP  Password: ",iface->name);
d186 1
a186 1
			tprintf("\n");
d198 1
a198 1
			tprintf ("%s: PPP/PAP  %s\n",
d201 1
a201 1
		tprintf ( "\n" );
d461 1
a461 1
		tprintf ("id mismatch hdrid=%d, lastid=%d\n",
@


1.4
log
@src0922
@
text
@d151 1
a151 1
	if((sp = newsession("PPP/PAP",PPPPASS)) == NULLSESSION){
@


1.3
log
@src0609
@
text
@d21 1
d25 2
d30 1
a30 1
static void pap_input __ARGS((int mustask, void *v1, void *v2));
a31 1
static void pap_getpassword __ARGS((struct fsm_s *fsm_p, int mustask));
a46 1
static void pap_reset	__ARGS((struct fsm_s *fsm_p));
a47 1
static void pap_init	__ARGS((struct ppp_s *ppp_p));
d95 1
a95 1
	register struct ppp_s *ppp_p = ifp->extension;
a96 1
	pap_init(ppp_p);
d126 1
a126 1
			pap_getpassword( fsm_p, FALSE);
d138 2
a139 2
pap_input(mustask, v1, v2)
int mustask;
d144 2
a145 1
	struct pap_s *pap_p = v2;
d148 1
d151 1
a151 1
	if((sp = newsession("PPP/PAP Auth",PPPPASS)) == NULLSESSION){
d156 11
a166 14
	if (mustask)
		tprintf("\n%s: PPP/PAP Password Authentication Failed;"
			" enter ID and password again\n",
			iface->name);
	else
		tprintf("\n%s: PPP/PAP Password Authentication Required\n",
			iface->name);
	tprintf("%s: PPP/PAP  user: ",iface->name);
	usflush(sp->output);

	/* Only ask for the user if it is unknown */
	if (pap_p->username == NULLCHAR) {
		if (recvline(sp->input,buf,20) < 0) {
			pap_p->username = NULLCHAR;
d168 22
a189 2
			rip(buf);
			pap_p->username = strdup(buf);
d191 4
a194 3
	} else {
		tprintf("%s\n",pap_p->username);
	}
d196 6
a201 4
	if (pap_p->username != NULLCHAR) {
		/* turn off echo */
		sp->ttystate.echo = 0;
		tprintf("%s: PPP/PAP Password: ",iface->name);
d203 1
a203 9
		if (recvline(sp->input,buf,20) < 0)
			pap_p->password = NULLCHAR;
		else {
			rip(buf);
			pap_p->password = strdup(buf);
		}
		tprintf("\n");
		/* Turn echo back on */
		sp->ttystate.echo = 1;
d206 4
d211 1
a211 1
	psignal(pap_p,0);
d239 2
a240 1
	pap_p->password = strdup(password);
a244 30
/* Get user ID and password
 * Return a NULLCHAR in either username or password if undefined
 */
static void
pap_getpassword(fsm_p,mustask)
struct fsm_s *fsm_p;
int mustask;
{
	struct pap_s *pap_p = fsm_p->pdv;

	if (mustask) {
		free(pap_p->username);
		pap_p->username = NULLCHAR;
		free(pap_p->password);
		pap_p->password = NULLCHAR;
	} else if ( pap_p->username != NULLCHAR
		 && pap_p->password == NULLCHAR) {
		pap_pwdlookup(pap_p);
	}

	if ((pap_p->username == NULLCHAR)
	 || (pap_p->password == NULLCHAR)) {
		char *ifn = if_name( fsm_p->ppp_p->iface, " PAP" );
		newproc( ifn,
			256, pap_input, mustask, fsm_p->ppp_p->iface, pap_p, 0);
		free( ifn );
		pwait( fsm_p->pdv );
	}
}

d263 1
a263 1
		log(-1,"PAP: username/password incorrect or not found: %s",
d269 1
a269 1
		log(-1,"PAP: no permission for PPP access: %s",
d298 1
a298 1
		log(-1, "    making user id %s", pap_p->username);
d333 1
a333 1
		fsm_log( fsm_p, "Failed; close PPP connection" );
d335 1
a335 2
	ppp_p->phase = pppTERMINATE;
	psignal(ppp_p, 0);
d354 2
a355 4
	if ( !((ppp_p->flags &= ~flag) & (PPP_AP_LOCAL | PPP_AP_REMOTE)) ) {
		ppp_p->phase = pppREADY;
		psignal(ppp_p, 0);
	}
a366 1
	struct pap_s *pap_p = fsm_p->pdv;
d392 1
a392 1
		log(-1,"    checking user: %s", username);
d408 1
a408 1
		log(-1,"    checking password: %s", password);
d412 2
a413 2
		free( pap_p->peername );
		pap_p->peername = strdup(username);
d422 1
d478 1
a478 1
			log(-1,"%s: PPP/PAP %s %s: %s",
d508 4
a512 1
	ntohcnf(&hdr, &bp);
d514 1
a514 1
		log(-1,	"%s: PPP/%s Recv,"
d533 1
d540 9
a548 10
			/* Must have sent a bad user or password */
			/* Get the password again */
			pap_getpassword(fsm_p, TRUE);

			if (pap_p->username == NULLCHAR
			 || pap_p->password == NULLCHAR) {
				pap_shutdown(fsm_p);
			} else {
				fsm_sendreq(fsm_p);
			}
d554 1
a554 1
			log(-1, "%s: PPP/Pap: Unknown packet type: %d;"
d570 1
d573 1
d578 3
a580 1
		fsm_sendreq(fsm_p);
d582 4
d596 2
a597 3
/* Reset state machine */
static void
pap_reset(fsm_p)
a599 35
	PPP_DEBUG_ROUTINES("pap_reset()");

	fsm_p->state = fsmCLOSED;
	fsm_p->retry = fsm_p->try_req;
	fsm_p->retry_nak = fsm_p->try_nak;
}


/* Initialize state machine for local */
int
pap_local(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[Pap]);

	if (ppp_p->fsm[Pap].pdv == NULL)
		pap_init(ppp_p);

	PPPtrace = fsm_p->ppp_p->trace;

	PPP_DEBUG_ROUTINES("pap_local()");

	pap_reset(fsm_p);
	fsm_p->state = fsmLISTEN;
	fsm_p->flags |= PPP_AP_LOCAL;
	return 0;
}


/* Initialize state machine for remote */
int
pap_remote(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[Pap]);
d602 1
a602 31
	if (ppp_p->fsm[Pap].pdv == NULL)
		pap_init(ppp_p);

	PPPtrace = fsm_p->ppp_p->trace;

	PPP_DEBUG_ROUTINES("pap_remote()");

	/* We need to send REQ to remote host */
	/* Get the user and password we will send */
	if ((pap_p->username == NULLCHAR)
	 || (pap_p->password == NULLCHAR)) {
		pap_getpassword(fsm_p, FALSE);

		if ((pap_p->username == NULLCHAR)
		 || (pap_p->password == NULLCHAR)) {
			return -1;
		}
	}

	pap_reset(fsm_p);
	fsm_p->state = fsmREQ_Sent;
	fsm_p->flags |= PPP_AP_REMOTE;
	return(fsm_sendreq(fsm_p));
}


void
pap_down(fsm_p)
struct fsm_s *fsm_p;
{
	if ( fsm_p->pdv == NULL )
d606 1
d615 1
d626 1
a626 1
	}
a637 1
	free( pap_p->peername );
d643 1
a643 1
static void
d647 1
a647 1
	struct fsm_s *fsm_p;
d651 1
d655 1
a655 1
	if (ppp_p->fsm[Pap].pdv != NULL)
a657 1
	fsm_p = &(ppp_p->fsm[Pap]);
d666 3
a668 1
	pap_reset(fsm_p);
d677 46
@


1.2
log
@src0318
@
text
@a26 5
static void do_nothing		__ARGS((struct fsm_s *fsm_p));
static int do_notpassgo		__ARGS((struct fsm_s *fsm_p,
				struct config_hdr *hdr,
				struct mbuf *bp));

d63 5
a67 4
	do_nothing,		/* pap_reset, */
	do_nothing,		/* pap_start, */
	do_nothing,		/* pap_closing, */
	do_nothing,		/* pap_opening, */
d70 4
a73 4
	do_notpassgo,		/* pap_request, */
	do_notpassgo,		/* pap_ack, */
	do_notpassgo,		/* pap_nak, */
	do_notpassgo,		/* pap_reject */
a132 16
static void
do_nothing(fsm_p)
struct fsm_s *fsm_p;
{
	PPP_DEBUG_ROUTINES("do_nothing()");
}
static int
do_notpassgo(fsm_p, hdr, bp)
struct fsm_s *fsm_p;
struct config_hdr *hdr;
struct mbuf *bp;
{
	PPP_DEBUG_ROUTINES("do_notpassgo()");
	return 0;
}

d309 2
a310 2
if (PPPtrace & PPP_DEBUG_OPTIONS)
	log(-1, "    making user id %s", pap_p->username);
d365 1
a365 1
		fsm_p->state = fsmOPEN;
d685 1
a685 1
	case fsmOPEN:
@


1.1
log
@Initial revision
@
text
@d2 1
a2 1
 *  PPPPAP.C	-- Password Authenticate Protocol for PPP
d4 6
a9 7
 *	12-89	-- Katie Stevens (dkstevens@@ucdavis.edu)
 *		   UC Davis, Computing Services
 *	PPP.09	05-90	[ks] add authentication phase
 *	PPP.10	06-90	[ks] improve keybd input of PAP password
 *			     make ppp open/close/reset work properly
 *	PPP.14	08-90	[ks] change PAP to PPP for consistency with RFC1172
 *	PPP.15	09-90	[ks] update to KA9Q NOS v900828
a13 1
#include "files.h"
d17 1
d20 4
a23 3
#include "slip.h"
#include "session.h"
#include "ftpserv.h"
d25 1
a25 2
/* Counter for PPP id field */
extern unsigned char Pppid;
d27 4
a30 2
/* PPP tracing */
extern int Ppptrace;
d32 3
a34 1
static void pap_open __ARGS((struct slip *sp));
d36 1
a36 3
static int pap_authen __ARGS((char *peerid, char *pass));
void pap_input __ARGS((int mustask, void *v1, void *v2));
static void pap_pwdlookup __ARGS((struct lcpctl *lcpiop));
d38 3
a40 2
static int pap_sendreq __ARGS((struct slip *sp));
static struct mbuf *pap_makereq __ARGS((struct lcpctl *lcpiop));
d42 2
a43 3
static void pap_rcvack __ARGS((struct slip *sp, struct cnfhdr *rcnf,
			struct mbuf *data));
static void pap_rcvnak __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d45 2
a46 1
static void pap_rcvreq __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d48 1
a48 1
static void pap_shutdown __ARGS((struct slip *sp));
d50 29
a78 6
static int pap_chkack __ARGS((struct slip *sp, struct cnfhdr *ackcnf,
			struct mbuf *data));
static int pap_chknak __ARGS((struct slip *sp, struct cnfhdr *nakcnf,
			struct mbuf *data));
static void pap_chkreq __ARGS((struct slip *sp, struct cnfhdr *reqcnf,
			struct mbuf *data));
a79 2
static void pap_timeout __ARGS((void *vp));
static void pap_timer __ARGS((struct slip *sp));
d81 1
a81 11
static int pap_sendreply __ARGS((struct slip *sp, char code,
			unsigned char id, struct mbuf *data));

/* Possible PAP states */
static char *PAPStates[] = {
	"Closed",
	"Listen",
	"Req Sent",
	"Req Rcvd",
	"Open",
};
d83 5
a87 2
/* Possible PAP packet types */
static char *PAPCodes[] = {
a88 3
	"Auth Req",
	"Auth Ack",
	"Auth Nak",
a90 1
/****************************************************************************/
a91 1
/* Initialize Password Auth Protocol state machine for config exchange */
d93 4
a96 2
pap_start(sp)
struct slip *sp;
d98 6
a103 2
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
a104 2
	if (Ppptrace > 5)
		log(-1, "pap_start()");
d106 13
a118 11
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* Ready for PAP phase */
	pppiop->state = PPP_PAP;
	pap_reset(pppiop);

	/* Just finished LCP negotiation; prepare for PAP negotiation */
	if (lcpiop->lclparm.auth_type == PAP_AUTH_TYPE) {
		/* We asked remote to send AUTH_REQ; wait for that packet */
		lcpiop->pap_state = PAP_LISTEN;
d121 12
a132 11

	/* Remote host asked us to send AUTH_REQ */
	lcpiop->pap_state = PAP_CLOSED;
	/* We need to send AUTH_REQ to remote host */
	/* Get the peer ID and password we will send */
	if ((lcpiop->pap_user == NULLCHAR)||(lcpiop->pap_pass == NULLCHAR)) {
		pap_getpass(sp,0);
		pwait(&(lcpiop->pap_user));
		if ((lcpiop->pap_user == NULLCHAR) ||
		    (lcpiop->pap_pass == NULLCHAR))
			return -1;
d134 1
a134 24
	return(pap_sendreq(sp));
}

/*******************************************/

/* Initialize our PAP configuration options */
void
pap_init(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "pap_init()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* PAP layer closed; dont know local peerID/password values */
	lcpiop->pap_state = PAP_CLOSED;
	lcpiop->pap_user = NULLCHAR;
	lcpiop->pap_pass = NULLCHAR;
	return;
a136 1
/* IP Control configuration negotiation complete */
d138 2
a139 24
pap_open(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* Mark PAP as completed */
	if (Ppptrace)
		log(-1,"%s: PPP/PAP: peer ID verified %s",
			sp->iface->name,lcpiop->pap_user);
	lcpiop->pap_state = PAP_OPEN;

	/* Ready for IPCP negotiation phase */
	ipcp_start(sp);
	return;
}

/* Reset PAP configuration options for initial request */
int
pap_reset(pppiop)
struct pppctl *pppiop;
d141 1
a141 10
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "pap_reset()");

	lcpiop = &(pppiop->lcpio);
	lcpiop->pap_state = PAP_CLOSED;
	lcpiop->ack_retry = 0;

	return 0;
a142 4

/*******************************************/

/* Verify peer ID and password sent by remote host with PAP AUTH_REQ */
d144 4
a147 3
pap_authen(peerid,pass)
char *peerid;
char *pass;
d149 1
a149 22
	int privs;
	char *path;
	int anony = 0;

	/* Use same login as FTP server */
	path = mallocw(128);
	privs = userlogin(peerid,pass,&path,128,&anony);
	free(path);

	/* Check privs for this peer ID */
	if (privs == -1) {
		if (Ppptrace > 2)
			log(-1,
			   "PAP peerID/password incorrect or not found: %s",
			   peerid);
		return -1;
	}
	if ((privs & PPP_ACCESS_PRIV) == 0) {
		if (Ppptrace > 2)
			log(-1,"PAP no permission for PPP access: %s",peerid);
		return -1;
	}
a152 8
/* Get peerID and password to send to remote host with PAP AUTH_REQ */
int
pap_getpass(sp,mustask)
struct slip *sp;
int mustask;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d154 5
a158 24
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	if (mustask) {
		if (lcpiop->pap_user != NULLCHAR) {
			free(lcpiop->pap_user);
			lcpiop->pap_user = NULLCHAR;
		}
		if (lcpiop->pap_pass != NULLCHAR) {
			free(lcpiop->pap_pass);
			lcpiop->pap_pass = NULLCHAR;
		}
	} else if ((lcpiop->pap_user != NULLCHAR)
			&&(lcpiop->pap_pass == NULLCHAR)) {
		pap_pwdlookup(lcpiop);
	}
	if ((lcpiop->pap_user == NULLCHAR)||(lcpiop->pap_pass == NULLCHAR)) {
		newproc("PAP Input",256,pap_input,mustask,
			 (void *)sp->iface,
			 (void *)lcpiop,0);
	}
	return 0;
}

void
d164 2
a165 2
	struct iface *iface;
	struct lcpctl *lcpiop;
a168 3
	iface = (struct iface *)v1;
	lcpiop = (struct lcpctl *)v2;

d176 2
a177 1
		tprintf("\n%s: PPP/PAP Password Authentication Failed; enter peer ID and password again\n",
d182 1
a182 1
	tprintf("%s: PPP/PAP  Peer ID: ",iface->name);
d185 5
a189 9
	/* Only ask for the peer ID if it is unknown */
	if (lcpiop->pap_user == NULLCHAR) {
		recvline(sp->input,buf,20);
		/* Send the command only if the user response
		 * was non-null
		 */
		if (buf[0] == '\n')
			lcpiop->pap_user = NULLCHAR;
		else {
d191 1
a191 2
			lcpiop->pap_user = mallocw(strlen(buf)+1);
			strcpy(lcpiop->pap_user,buf);
d194 1
a194 1
		tprintf("%s\n",lcpiop->pap_user);
d197 14
a210 16
	/* Always ask for the password */
	/* turn off echo */
	sp->ttystate.echo = 0;
	tprintf("%s: PPP/PAP Password: ",iface->name);
	usflush(sp->output);
	recvline(sp->input,buf,20);
	tprintf("\n");
	/* Turn echo back on */
	sp->ttystate.echo = 1;
	/* Save the password only if the user response was non-null */
	if (buf[0] == '\n')
		lcpiop->pap_pass = NULLCHAR;
	else {
		rip(buf);
		lcpiop->pap_pass = mallocw(strlen(buf)+1);
		strcpy(lcpiop->pap_pass,buf);
d213 3
a215 2
	if (sp != NULLSESSION)
		freesession(sp);
a216 3
	psignal(&(lcpiop->pap_user),0);
	return;	
}
d218 1
a218 1
/* Check the FTP userfile for this peer ID; get password if available */
d220 2
a221 2
pap_pwdlookup(lcpiop)
struct lcpctl *lcpiop;
d224 2
a225 4
	char *cp, *cp1;
	char *svp;
	FILE *fp;
	int perm;
d227 1
a227 2
	if((fp = fopen(Userfile,READ_TEXT)) == NULLFILE)
		/* Userfile doesn't exist */
d230 2
a231 30
	/* Locate user name in password file */
	buf = mallocw(128);
	while(fgets(buf,128,fp),!feof(fp)){
		if(buf[0] == '#')
			continue;	/* Comment */
		if((cp = strchr(buf,' ')) == NULLCHAR)
			/* Bogus entry */
			continue;
		*cp++ = '\0';		/* Now points to password */
		svp = cp;		/* Save ptr to password */
		if(stricmp(lcpiop->pap_user,buf) == 0)
			break;		/* Found peer ID */
	}
	if(feof(fp)){
		/* Peer ID not found in file */
		fclose(fp);
		free(buf);
		return;
	}
	fclose(fp);
	/* Look for space after password field in file */
	if((cp1 = strchr(cp,' ')) == NULLCHAR) {
		/* Invalid file entry */
		free(buf);
		return;
	}
	*cp1++ = '\0';	/* Now points to path field */
	if((cp = strchr(cp1,' ')) == NULLCHAR) {
		/* Permission field missing */
		free(buf);
a232 3
	}
	*cp++ = '\0';	/* now points to permission field */
	perm = atoi(cp);
d234 2
a235 2
	/* Check permissions for this peer ID */
	if ((perm & PPP_PWD_LOOKUP) == 0) {
d242 2
a243 3
	lcpiop->pap_pass = malloc(strlen(svp)+1);
	strcpy(lcpiop->pap_pass,svp);
	return;
d246 30
a275 1
/****************************************************************************/
d277 2
a278 1
/* Send our PAP configuration request */
d280 3
a282 2
pap_sendreq(sp)
struct slip *sp;
d284 22
a305 21
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct mbuf *bp;

	if (Ppptrace > 5)
		log(-1,"pap_sendreq()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* Get a packet with our configuration request */
	bp = pap_makereq(lcpiop);

	/* Start timer against wait for reply to our config request */
	pap_timer(sp);

	/* Send PAP configuration request to remote host */
	pppiop->state = PPP_PAP;
	if (lcpiop->pap_state != PAP_REQ_SENT)
		lcpiop->pap_state = PAP_REQ_SENT;
	return(pap_sendreply(sp, AUTH_REQ, 0, bp));
a307 1
/*******************************************/
d309 2
d312 2
a313 2
pap_makereq(lcpiop)
struct lcpctl *lcpiop;
d315 2
a317 1
	struct mbuf *req_bp = NULLBUF;
d320 1
a320 2
	if (Ppptrace > 5)
		log(-1,"    pap_makereq()   peer ID: %s",lcpiop->pap_user);
d322 11
d334 1
a334 1
	len = strlen(lcpiop->pap_user)+strlen(lcpiop->pap_pass)+2;
d338 1
a338 1
	/* Load peer ID and password for authenticate packet */
d340 8
a347 5
	*cp++ = (char)strlen(lcpiop->pap_user);
	memcpy(cp, lcpiop->pap_user, strlen(lcpiop->pap_user));
	cp += strlen(lcpiop->pap_user);
	*cp++ = (char)strlen(lcpiop->pap_pass);
	memcpy(cp, lcpiop->pap_pass, strlen(lcpiop->pap_pass));
a348 2

	/* Return our config request */
d352 1
d355 1
a355 1
/* Remote host ACKed our configuration request */
d357 2
a358 4
pap_rcvack(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
d360 1
a360 5
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 5)
		log(-1, "pap_rcvack()");
d362 1
a362 12
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	stop_timer(&lcpiop->lcp_tm);

	switch(lcpiop->pap_state) {
	case PAP_REQ_SENT:
		/* Make sure ACK is proper */
		if (pap_chkack(sp, rcnf, data) != -1) {
			/* Remote host accepted our request */
			pap_open(sp);
			break;
		}
d364 2
a365 3
		/* Still need to settle request from remote host */
		pap_timer(sp);
		break;
d367 2
a368 11
	case PAP_REQ_RCVD:
	case PAP_CLOSED:
	case PAP_LISTEN:
	case PAP_OPEN:
	default:
		/* Confusion; shutdown the connection */
		free_p(data);
		pap_shutdown(sp);
		break;
	}
	return;
d371 2
a372 1
/* Remote host NAKed our configuration request */
d374 3
a376 4
pap_rcvnak(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
d378 1
a378 2
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d380 1
a380 2
	if (Ppptrace > 5)
		log(-1, "pap_rcvnak()");
d382 8
a389 33
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	stop_timer(&lcpiop->lcp_tm);

	switch(lcpiop->pap_state) {
	case PAP_REQ_SENT:
		/* Remote host NAKd our AUTH_REQ */
		if (pap_chknak(sp, rcnf, data) == -1) {
			/* Bad NAK packet */
			/* Wait for another; resend request on timeout */
			pap_timer(sp);
			break;
		}
		/* Must have sent a bad peer ID or password */
		/* Get the password again */
		pap_getpass(sp,1);
		pwait(&(lcpiop->pap_user));
		if (lcpiop->pap_pass == NULLCHAR)
			/* No password entered, close PPP link */
			pap_shutdown(sp);
		else
			/* Send AUTH_REQ again with new password */
			pap_sendreq(sp);
		break;
	case PAP_REQ_RCVD:
	case PAP_OPEN:
	case PAP_CLOSED:
	case PAP_LISTEN:
	default:
		/* Confusion; shutdown the connection */
		free_p(data);
		pap_shutdown(sp);
		break;
a390 1
	return;
d393 7
a399 5
/* Process configuration request sent by remote host */
static void
pap_rcvreq(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
d402 23
a424 2
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d426 4
a429 2
	if (Ppptrace > 5)
		log(-1, "pap_rcvreq()");
d431 3
a433 2
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
d435 6
a440 6
	switch(lcpiop->pap_state) {
	case PAP_LISTEN:	/* Normal event */
	case PAP_REQ_RCVD:	/* Normal event */
		/* Evaluate configuration request from remote host */
		pap_chkreq(sp, rcnf, data);
		break;
d442 13
a454 8
	case PAP_CLOSED:
	case PAP_REQ_SENT:
	case PAP_OPEN:
	default:
		/* We are closed; dont accept any connections */
		free_p(data);
		pap_shutdown(sp);
		break;
a455 2
	return;
}
d457 4
a460 6
/* PAP failure, abandon PAP attempt; shutdown LCP layer */
static void
pap_shutdown(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
d462 1
a462 2
	if (Ppptrace > 5)
		log(-1, "pap_shutdown()");
d464 11
a474 9
	pppiop = sp->pppio;

	if (Ppptrace > 1)
		log(-1,"%s: PPP/PAP: Failed; close PPP connection",sp->iface->name);
	pap_reset(pppiop);

	/* Shut the link down completely */
	lcp_shutdown(sp);
	return;
a476 1
/*******************************************/
d478 1
a478 1
/* Process configuration ACK send by remote host */
d480 3
a482 3
pap_chkack(sp, ackcnf, data)
struct slip *sp;
struct cnfhdr *ackcnf;
d485 4
a488 4
	int ackerr = 0;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	char *pap_msg;
d491 1
a491 5
	if (Ppptrace > 5)
		log(-1,"pap_chkack()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
d493 5
a497 4
	/* PAP ID field must match last request we sent */
	if (ackcnf->id != lcpiop->lastid) {
		if (Ppptrace > 5)
			log(-1,"improper PAP ACK; bad ID");
d502 20
a521 10
	if ((Ppptrace > 1) && (len_p(data) != 0)) {
		/* Log ASCII message from remote host, if any */
		len = pullchar(&data);
		pap_msg = mallocw(len+1);
		len = dqdata(data,pap_msg,len);
		pap_msg[len] = '\0';
		log(-1,"%s: PPP/PAP: ACK msg: %s",sp->iface->name,pap_msg);
		free(pap_msg);
	} else {
		free_p(data);
d523 4
a527 6
	if (ackerr) {
		/* Error in configuration ACK */
		if (Ppptrace > 5)
			log(-1,"improper PAP ACK");
		return -1;
	}
d529 3
a531 5
	/* ACK is acceptable */
	if (Ppptrace > 5)
		log(-1,"valid PAP ACK");
	return 0;
}
d533 5
a537 6
/* Process configuration NAK send by remote host */
static int
pap_chknak(sp, nakcnf, data)
struct slip *sp;
struct cnfhdr *nakcnf;
struct mbuf *data;
d539 2
a540 5
	int nakerr = 0;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	int len;
	char *pap_msg;
d542 1
a542 2
	if (Ppptrace > 5)
		log(-1,"pap_chknak()");
d544 8
a551 2
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
d553 2
a554 7
	/* PAP ID field must match last request we sent */
	if (nakcnf->id != lcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper PAP NAK; bad ID");
		free_p(data);
		return -1;
	}
d556 6
a561 11
	if ((Ppptrace > 1) && (len_p(data) != 0)) {
		/* Log ASCII message from remote host, if any */
		len = pullchar(&data);
		pap_msg = mallocw(len+1);
		len = dqdata(data,pap_msg,len);
		pap_msg[len] = '\0';
		log(-1,"%s: PPP/PAP: NAK msg: %s",sp->iface->name,pap_msg);
		free(pap_msg);
	} else {
		free_p(data);
	}
d563 5
a567 6
	if (nakerr) {
		/* Error in configuration NAK */
		if (Ppptrace > 5)
			log(-1,"improper PAP NAK");
		return -1;
	}
d569 14
a582 5
	/* NAK packet was properly constructed */
	if (Ppptrace > 5)
		log(-1,"valid PAP NAK");
	return 0;
}
d584 8
a591 90
/* Check IP Control options requested by the remote host */
static void
pap_chkreq(sp, reqcnf, data)
struct slip *sp;
struct cnfhdr *reqcnf;
struct mbuf *data;
{
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	int ilen,ulen,plen;
	char cnf_accept = CONFIG_ACK;		/* Overall reply to request */
	struct mbuf *reply_bp = NULLBUF;	/* Actual reply packet */
	char userpass[48];			/* Storage for peerID/pass */
	char *pap_msg = NULLCHAR;		/* Message for remote host */

	if (Ppptrace > 5)
		log(-1, "pap_chkreq()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	lcpiop->pap_state = PAP_REQ_RCVD;

	/* Make sure length in PAP config header is realistic */
	ilen = len_p(data);
	if (ilen < reqcnf->len)
		reqcnf->len = ilen;

	/* Extract peerID/password sent by remote host */
	plen = dqdata(data,userpass,48);
	ulen = (int)userpass[0];
	if (ulen >= 48) {
		strcpy(userpass,"foo");
	} else {
		++ulen;
		plen = (int)userpass[ulen];
		userpass[ulen] = '\0';
		++ulen;
		plen += ulen;
		if (plen >= 48)
			plen = 47;
		userpass[plen] = '\0';
	}
	if (Ppptrace > 5)
		log(-1,"PAP peer ID: %s",&(userpass[1]));

	/* Verify peerID/pass sent by remote host */
	if (lcpiop->pap_user != NULLCHAR) {
		free(lcpiop->pap_user);
		lcpiop->pap_user = NULLCHAR;
	}
	if (pap_authen(&(userpass[1]),&(userpass[ulen])) == -1) {
		cnf_accept = AUTH_NAK;
		pap_msg = " Invalid peer ID or password";
	} else {
		cnf_accept = AUTH_ACK;
		pap_msg = " Welcome to the Internet";
		lcpiop->pap_user = mallocw(strlen(&(userpass[1]))+1);
		strcpy(lcpiop->pap_user,&(userpass[1]));
	}
	ilen = strlen(pap_msg);
	reply_bp = qdata(pap_msg,ilen);
	reply_bp->data[0] = (char)(ilen - 1);

	/* Send ACK/NAK to remote host */
	if (cnf_accept == AUTH_ACK) {
		if (Ppptrace > 1)
			log(-1, "%s: PPP/PAP: peerID (%s) from remote host has been verified",
				sp->iface->name,&(userpass[1]));

		/* Accept configuration requested by remote host */
		pap_sendreply(sp, AUTH_ACK, reqcnf->id, reply_bp);
		/* PPP data link now ready for next phase */
		pap_open(sp);
	} else {
		/* NAK config request made by remote host */
		if (Ppptrace)
			log(-1,"%s: PPP/PAP: invalid peerID (%s) from remote host",
				sp->iface->name,&(userpass[1]));
		pap_sendreply(sp, AUTH_NAK, reqcnf->id, reply_bp);
		if (++lcpiop->ack_retry > PAP_FAIL_MAX) {
			/* Shut the link down after too many failed auth */
			if (Ppptrace)
				log(-1,"%s: PPP/PAP: Failed; too many failed attempts; close PPP link",
					sp->iface->name);
			pap_shutdown(sp);
		} else {
			if (Ppptrace > 1)
				log(-1,"%s: PPP/PAP: not verified; wait for another attempt",
					sp->iface->name);
		}
a592 1
	return;
a594 1
/****************************************************************************/
d601 5
a605 24
	struct slip *sp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if (Ppptrace > 1)
		log(-1, "pap_timeout()");

	/* Load pointers to interface that timed-out */
	sp = (struct slip *)vp;
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);

	/* Attempt to get things going again */
	switch(lcpiop->pap_state) {
	case PAP_REQ_SENT:
		/* Timeout waiting for ACK to our request */
		if (++lcpiop->ack_retry > PAP_RETRY_MAX) {
			/* Remote host doesnt seem to be listening */
			pap_shutdown(sp);
			break;
		}
		/* Resend the request */
		pap_sendreq(sp);
		break;
d607 5
a611 8
	case PAP_REQ_RCVD:
	case PAP_CLOSED:
	case PAP_LISTEN:
	case PAP_OPEN:
	default:
		/* Confusion; shutdown the connection */
		pap_shutdown(sp);
		break;
a612 1
	return;
d615 6
a620 1
/* Set a timer in case an expected event does not occur */
d622 15
a636 2
pap_timer(sp)
struct slip *sp;
d638 6
a643 3
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct timer *t;
d645 1
a645 2
	if (Ppptrace > 5)
		log(-1,"pap_timer()");
d647 4
a650 7
	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	t = &(lcpiop->lcp_tm);
	t->func = (void (*)())pap_timeout;
	t->arg = (void *)sp;
	start_timer(t);
	return;
a652 1
/****************************************************************************/
d654 4
a657 7
/* Send an PAP packet to the remote host */
static int
pap_sendreply(sp,code,id,data)
struct slip *sp;
char code;
unsigned char id;
struct mbuf *data;
d659 2
a660 2
	struct iface *iface;
	struct cnfhdr hdr;
d662 6
a667 9
	/* Load PAP header values */
	hdr.code = code;
	switch(code) {
	case AUTH_REQ:
		/* Save ID field for match aginst replies from remote host */
		sp->pppio->lcpio.lastid = Pppid;
		/* Use a unique ID field value */
		hdr.id = Pppid++;
		break;
d669 5
a673 5
	case AUTH_ACK:
	case AUTH_NAK:
		/* Use ID sent by remote host */
		hdr.id = id;
		break;
d675 4
a678 6
	default:
		/* Shouldnt happen */
		if (Ppptrace)
			log(-1, "%s: PPP/PAP: bogus code: %x\n",
				sp->iface->name, code);
		return -1;
a679 1
	hdr.len = len_p(data) + CNF_HDRLEN;
d681 5
a685 3
	/* Prepend PAP header to packet data */
	if ((data = htoncnf(&hdr,data)) == NULLBUF)
		return -1;
a686 12
	if (Ppptrace > 1)
		log(-1, "%s: PPP/PAP Send: current state: %s   PAP option: %s  id: %d  len: %d",
			sp->iface->name,
			PAPStates[sp->pppio->lcpio.pap_state],
			PAPCodes[code],hdr.id,hdr.len);

	/* Send PAP packet to remote host */
	sp->pppio->sndpap++;
	iface = sp->iface;
	return( (*iface->output)
		(iface, NULLCHAR, NULLCHAR, PPP_PAP_TYPE, data) );
}
a687 1
/* Process incoming PAP packet */
d689 2
a690 3
papproc(iface,bp)
struct iface *iface;
struct mbuf *bp;
d692 2
a693 2
	struct slip *sp;
	struct cnfhdr hdr;
d695 1
a695 1
	sp = &Slip[iface->xdev];
d697 1
a697 4
	/* Extract PAP header */
	ntohcnf(&hdr, &bp);
	hdr.len -= CNF_HDRLEN;			/* Length includes envelope */
	trim_mbuf(&bp, hdr.len);		/* Trim off FCS bytes */
d699 1
a699 5
	if (Ppptrace > 1)
		log(-1,	"%s: PPP/PAP Recv: current state: %s   PAP option: %s    id: %d   len: %d",
			iface->name,
			PAPStates[sp->pppio->lcpio.pap_state],
			PAPCodes[hdr.code], hdr.id, hdr.len);
d701 8
a708 4
	/* Process PAP packet data */
	switch(hdr.code) {
	case AUTH_REQ:				/* Request of remote host */
		pap_rcvreq(sp, &hdr, bp);
d710 3
a712 5
	case AUTH_ACK:				/* Remote accepted our req */
		pap_rcvack(sp, &hdr, bp);
		break;
	case AUTH_NAK:				/* Remote declined our req */
		pap_rcvnak(sp, &hdr, bp);
a713 6
	default:
		if (Ppptrace)
			log(-1,"%s: PPP/PAP: Unknown packet type: %x; dropping packet",
				sp->iface->name,hdr.code);
		free_p(bp);
		break;
d715 49
a763 1
	return;
d765 2
@
