head	1.8;
access;
symbols;
locks;
comment	@ * @;


1.8
date	93.05.06.10.11.20;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	93.01.27.10.07.52;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	93.01.19.08.15.18;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.09.14.09.11.07;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.04.15.23.03.18;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.12.18.10.56.56;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.05.07.06;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.26.40;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.8
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* TCP output segment processing
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "timer.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "tcp.h"
#include "ip.h"

/* Send a segment on the specified connection. One gets sent only
 * if there is data to be sent or if "force" is non zero
 */
void
tcp_output(tcb)
register struct tcb *tcb;
{
	struct pseudo_header ph;/* Pseudo-header for checksum calcs */
	struct mbuf *hbp,*dbp;	/* Header and data buffer pointers */
	uint16 hsize;		/* Size of header */
	struct tcp seg;		/* Local working copy of header */
	uint16 ssize;		/* Size of current segment being sent,
				 * including SYN and FIN flags */
	uint16 dsize;		/* Size of segment less SYN and FIN */
	int32 usable;		/* Usable window */
	int32 sent;		/* Sequence count (incl SYN/FIN) already
				 * in the pipe but not yet acked */
	int32 rto;		/* Retransmit timeout setting */

	if(tcb == NULLTCB)
		return;

	switch(tcb->state){
	case TCP_LISTEN:
	case TCP_CLOSED:
		return;	/* Don't send anything */
	}
	for(;;){
		/* Compute data already in flight */
		sent = tcb->snd.ptr - tcb->snd.una;

		/* Compute usable send window as minimum of offered
		 * and congestion windows, minus data already in flight.
		 * Be careful that the window hasn't shrunk --
		 * these are unsigned vars.
		 */
		usable = min(tcb->snd.wnd,tcb->cwind);
		if(usable > sent)
			usable -= sent;	/* Most common case */
		else if(usable == 0 && sent == 0)
			usable = 1;	/* Closed window probe */
		else
			usable = 0;	/* Window closed or shrunken */

		/* Compute size of segment we *could* send. This is the
		 * smallest of the usable window, the mss, or the amount
		 * we have on hand. (I don't like optimistic windows)
		 */
		ssize = min(tcb->sndcnt - sent,usable);
		ssize = min(ssize,tcb->mss);

		/* Now we decide if we actually want to send it.
		 * Apply John Nagle's "single outstanding segment" rule.
		 * If data is already in the pipeline, don't send
		 * more unless it is MSS-sized, the very last packet,
		 * or we're being forced to transmit anyway (e.g., to
		 * ack incoming data).
		 */
		if(!tcb->flags.force && sent != 0 && ssize < tcb->mss
		 && !(tcb->state == TCP_FINWAIT1 && ssize == tcb->sndcnt-sent)){
			ssize = 0;
		}
	 	/* Unless the tcp syndata option is on, inhibit data until
		 * our SYN has been acked. This ought to be OK, but some
		 * old TCPs have problems with data piggybacked on SYNs.
		 */
		if(!tcb->flags.synack && !Tcp_syndata){
			if(tcb->snd.ptr == tcb->iss)
				ssize = min(1,ssize);	/* Send only SYN */
			else
				ssize = 0;	/* Don't send anything */
		}
		if(ssize == 0 && !tcb->flags.force)
			break;		/* No need to send anything */

		tcb->flags.force = 0;	/* Only one forced segment! */

		seg.source = tcb->conn.local.port;
		seg.dest = tcb->conn.remote.port;

		/* Set the flags according to the state we're in. It is
		 * assumed that if this segment is associated with a state
		 * transition, then the state change will already have been
		 * made. This allows this routine to be called from a
		 * retransmission timeout with force=1.
		 */
		seg.flags.urg = 0; /* Not used in this implementation */
		seg.flags.rst = 0;
		seg.flags.ack = 1; /* Every state except TCP_SYN_SENT */
		seg.flags.syn = 0; /* syn/fin/psh set later if needed */
		seg.flags.fin = 0;
		seg.flags.psh = 0;
		seg.flags.congest = tcb->flags.congest;

		hsize = TCPLEN;	/* Except when SYN being sent */
		seg.mss = 0;
		seg.optlen = 0;

		if(tcb->state == TCP_SYN_SENT)
			seg.flags.ack = 0; /* Haven't seen anything yet */

		dsize = ssize;
		if(!tcb->flags.synack && tcb->snd.ptr == tcb->iss){
			/* Send SYN */
			seg.flags.syn = 1;
			dsize--;	/* SYN isn't really in snd queue */
			/* Also send MSS */
			seg.mss = Tcp_mss;
			seg.optlen = 0;
			hsize = TCPLEN + MSS_LENGTH;
		}
		seg.seq = tcb->snd.ptr;
		seg.ack = tcb->rcv.nxt;
		seg.wnd = tcb->rcv.wnd;
		seg.up = 0;

		/* Now try to extract some data from the send queue. Since
		 * SYN and FIN occupy sequence space and are reflected in
		 * sndcnt but don't actually sit in the send queue, extract
		 * will return one less than dsize if a FIN needs to be sent.
		 */
		dbp = ambufw(TCP_HDR_PAD+dsize);
		dbp->data += TCP_HDR_PAD;	/* Allow room for other hdrs */
		if(dsize != 0){
			int32 offset;

			/* SYN doesn't actually take up space on the sndq,
			 * so take it out of the sent count
			 */
			offset = sent;
			if(!tcb->flags.synack && sent != 0)
				offset--;

			dbp->cnt = extract(tcb->sndq,(uint16)offset,dbp->data,dsize);
			if(dbp->cnt != dsize){
				/* We ran past the end of the send queue;
				 * send a FIN
				 */
				seg.flags.fin = 1;
				dsize--;
			}
		}
		/* If the entire send queue will now be in the pipe, set the
		 * push flag
		 */
		if(dsize != 0 && sent + ssize == tcb->sndcnt)
			seg.flags.psh = 1;

		/* If this transmission includes previously transmitted data,
		 * snd.nxt will already be past snd.ptr. In this case,
		 * compute the amount of retransmitted data and keep score
		 */
		if(tcb->snd.ptr < tcb->snd.nxt)
			tcb->resent += min(tcb->snd.nxt - tcb->snd.ptr,ssize);

		tcb->snd.ptr += ssize;
		/* If this is the first transmission of a range of sequence
		 * numbers, record it so we'll accept acknowledgments
		 * for it later
		 */
		if(seq_gt(tcb->snd.ptr,tcb->snd.nxt))
			tcb->snd.nxt = tcb->snd.ptr;

		/* Fill in fields of pseudo IP header */
		ph.source = tcb->conn.local.address;
		ph.dest = tcb->conn.remote.address;
		ph.protocol = TCP_PTCL;
		ph.length = hsize + dsize;

		/* Generate TCP header, compute checksum, and link in data */
		if((hbp = htontcp(&seg,dbp,&ph)) == NULLBUF){
			free_p(dbp);
			return;
		}
		/* If we're sending some data or flags, start retransmission
		 * and round trip timers if they aren't already running.
		 */
		if(ssize != 0){
			/* Set round trip timer. */
			rto = backoff(tcb->backoff) * (4 * tcb->mdev + tcb->srtt);
			set_timer(&tcb->timer,max(MIN_RTO,rto));
			if(!run_timer(&tcb->timer))
				start_timer(&tcb->timer);

			/* If round trip timer isn't running, start it */
			if(!tcb->flags.rtt_run){
				tcb->flags.rtt_run = 1;
				tcb->rtt_time = msclock();
				tcb->rttseq = tcb->snd.ptr;
				tcb->rttack = tcb->snd.una;
			}
		}
		if(tcb->flags.retran)
			tcpRetransSegs++;
		else
			tcpOutSegs++;

		ip_send(tcb->conn.local.address,tcb->conn.remote.address,
		 TCP_PTCL,tcb->tos,0,hbp,ph.length,0,0);
	}
}
@


1.7
log
@Bypass Nagle algorithm when forced to send a packet (e.g., to ack
data). No reason not to include data if you've gotta send a header
anyway.
@
text
@d21 1
a21 1
	int16 hsize;		/* Size of header */
d23 1
a23 1
	int16 ssize;		/* Size of current segment being sent,
d25 1
a25 1
	int16 dsize;		/* Size of segment less SYN and FIN */
d145 1
a145 1
			dbp->cnt = extract(tcb->sndq,(int16)offset,dbp->data,dsize);
@


1.6
log
@Use new extract() function instead of dup_p() to copy data from
the send queue when forming a packet. This avoids the possibility that
data may be acked and removed from the tcp send queue even before
a packet (re)transmitting that data has gone out. This was causing
some free errors, especially in a mput ftp transfer.
@
text
@d66 3
a68 1
		 * more unless it is MSS-sized or the very last packet.
d70 1
a70 1
		if(sent != 0 && ssize < tcb->mss
@


1.5
log
@Support 32-bit send window arithmetic. Eliminate idle connection
shrinking of cwind (obsoleted by cwind limiting in tcpin.c).
Keep track of last received ack when we start a round trip timing
cycle, for use in computing send throughput.
@
text
@d128 1
a128 1
		 * sndcnt but don't actually sit in the send queue, dup_p
d131 2
d143 2
a144 1
			if(dup_p(&dbp,tcb->sndq,(int16)offset,dsize) != dsize){
a150 2
		} else {
			dbp = NULLBUF;
a151 8
		/* Allocate enough space for headers to avoid lots of
		 * little calls to malloc by pushdown()
		 */
		hbp = ambufw(TCP_HDR_PAD);
		hbp->data += TCP_HDR_PAD;
		hbp->next = dbp;
		dbp = hbp;

@


1.4
log
@src0415
@
text
@d26 2
a27 2
	int16 usable;		/* Usable window */
	int16 sent;		/* Sequence count (incl SYN/FIN) already
a42 7
		/* If transmitter has been idle for more than a RTT,
		 * take the congestion window back down to one packet.
		 */
		if(!run_timer(&tcb->timer)
		 && (msclock() - tcb->lastactive) > tcb->srtt)
			tcb->cwind = tcb->mss;

d132 1
a132 1
			int16 offset;
d141 1
a141 1
			if(dup_p(&dbp,tcb->sndq,offset,dsize) != dsize){
d206 1
@


1.3
log
@src1217
@
text
@d158 8
@


1.2
log
@src0318
@
text
@d29 1
d195 2
a196 2
			set_timer(&tcb->timer,backoff(tcb->backoff)
			 * (4 * tcb->mdev + tcb->srtt));
@


1.1
log
@Initial revision
@
text
@d108 1
@
